/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\f\u001a\u0019\u0010\t\u001a\u0004\u0018\u00010\r*\u00020\f2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000e\u001a\u0011\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u000b\u00a2\u0006\u0002\u0010\u0011\u001a\u0011\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\f\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u000f\u001a\u00020\r*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0010\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u000b\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\f\u001a\u0012\u0010\u0014\u001a\u00020\r*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0015\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\f\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u0005*\u00020\u000b\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u0005*\u00020\f\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0007*\u00020\u000b\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0007*\u00020\f\u001a\u0012\u0010\u001c\u001a\u00020\r*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u001d\u001a\u00020\r*\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0005\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u0007*\u00020\u000b\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u0007*\u00020\f\u001a\u0012\u0010 \u001a\u00020\r*\u00020\f2\u0006\u0010!\u001a\u00020\u0010\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\u000b\u001a\u0012\u0010#\u001a\u00020\r*\u00020\f2\u0006\u0010$\u001a\u00020\u0005\u001a\u0012\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0018*\u00020\u000b\u001a\u0012\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0018*\u00020\f\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006&"}, d2={"HTTP_DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "getHTTP_DATE_FORMAT", "()Ljava/text/SimpleDateFormat;", "formatHttpDate", "", "date", "Ljava/util/Date;", "parseHttpDate", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/http/HttpMessage;", "Lio/ktor/http/HttpMessageBuilder;", "", "(Lio/ktor/http/HttpMessageBuilder;Ljava/nio/charset/Charset;)Lkotlin/Unit;", "contentLength", "", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Integer;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Integer;", "length", "contentType", "Lio/ktor/http/ContentType;", "type", "cookies", "", "Lio/ktor/http/Cookie;", "etag", "expires", "ifModifiedSince", "ifNoneMatch", "value", "lastModified", "maxAge", "seconds", "setCookie", "userAgent", "content", "vary", "ktor-http"})
public final class HttpMessagePropertiesKt {
    private static final SimpleDateFormat getHTTP_DATE_FORMAT() {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat $receiver = simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        $receiver.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    private static final Date parseHttpDate(String date) {
        Date date2 = HttpMessagePropertiesKt.getHTTP_DATE_FORMAT().parse(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"HTTP_DATE_FORMAT.parse(date)");
        return date2;
    }

    private static final String formatHttpDate(Date date) {
        String string = HttpMessagePropertiesKt.getHTTP_DATE_FORMAT().format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HTTP_DATE_FORMAT.format(date)");
        return string;
    }

    public static final void contentType(@NotNull HttpMessageBuilder $receiver, @NotNull ContentType type) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), type.toString());
    }

    public static final void contentLength(@NotNull HttpMessageBuilder $receiver, int length) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getContentLength(), String.valueOf(length));
    }

    @Nullable
    public static final Unit charset(@NotNull HttpMessageBuilder $receiver, @NotNull Charset charset) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($receiver);
        if (contentType2 != null) {
            ContentType contentType3;
            ContentType it = contentType3 = contentType2;
            HttpMessagePropertiesKt.contentType($receiver, ContentTypesKt.withCharset(it, charset));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final void maxAge(@NotNull HttpMessageBuilder $receiver, int seconds) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), "max-age:" + seconds);
    }

    public static final void ifModifiedSince(@NotNull HttpMessageBuilder $receiver, @NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getIfModifiedSince(), HttpMessagePropertiesKt.formatHttpDate(date));
    }

    public static final void ifNoneMatch(@NotNull HttpMessageBuilder $receiver, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), value);
    }

    public static final void userAgent(@NotNull HttpMessageBuilder $receiver, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), content);
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessageBuilder $receiver) {
        ContentType contentType2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2;
            String it = string2 = string;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessageBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($receiver);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessageBuilder $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessageBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessageBuilder $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessageBuilder $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                void var7_7;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = var7_7 = it;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string2);
            }
            list = (List)var3_3;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Integer contentLength(@NotNull HttpMessageBuilder $receiver) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            String string2 = string;
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessage $receiver) {
        ContentType contentType2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2;
            String it = string2 = string;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessage $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($receiver);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessage $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessage $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessage $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessage $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                void var7_7;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = var7_7 = it;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string2);
            }
            list = (List)var3_3;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Integer contentLength(@NotNull HttpMessage $receiver) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            String string2 = string;
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> setCookie(@NotNull HttpMessage $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List list2 = $receiver.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                Cookie cookie = CookieKt.parseServerSetCookieHeader((String)it);
                collection.add(cookie);
            }
            list = (List)var3_3;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull HttpMessageBuilder $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List list2 = $receiver.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                Cookie cookie = CookieKt.parseServerSetCookieHeader((String)it);
                collection.add(cookie);
            }
            list = (List)var3_3;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

