/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.CipherSuitesKt;
import io.ktor.network.tls.SecretExchangeType;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/ktor/network/tls/CIOCipherSuites;", "", "()V", "ECDHE_ECDSA_AES128_SHA256", "Lio/ktor/network/tls/CipherSuite;", "getECDHE_ECDSA_AES128_SHA256", "()Lio/ktor/network/tls/CipherSuite;", "ECDHE_ECDSA_AES256_SHA384", "getECDHE_ECDSA_AES256_SHA384", "ECDHE_RSA_AES128_SHA256", "getECDHE_RSA_AES128_SHA256", "ECDHE_RSA_AES256_SHA384", "getECDHE_RSA_AES256_SHA384", "SupportedSuites", "", "getSupportedSuites", "()Ljava/util/List;", "TLS_RSA_WITH_AES_128_GCM_SHA256", "getTLS_RSA_WITH_AES_128_GCM_SHA256", "ktor-network-tls"})
public final class CIOCipherSuites {
    @NotNull
    private static final CipherSuite TLS_RSA_WITH_AES_128_GCM_SHA256;
    @NotNull
    private static final CipherSuite ECDHE_ECDSA_AES256_SHA384;
    @NotNull
    private static final CipherSuite ECDHE_ECDSA_AES128_SHA256;
    @NotNull
    private static final CipherSuite ECDHE_RSA_AES256_SHA384;
    @NotNull
    private static final CipherSuite ECDHE_RSA_AES128_SHA256;
    @NotNull
    private static final List<CipherSuite> SupportedSuites;
    public static final CIOCipherSuites INSTANCE;

    @NotNull
    public final CipherSuite getTLS_RSA_WITH_AES_128_GCM_SHA256() {
        return TLS_RSA_WITH_AES_128_GCM_SHA256;
    }

    @NotNull
    public final CipherSuite getECDHE_ECDSA_AES256_SHA384() {
        return ECDHE_ECDSA_AES256_SHA384;
    }

    @NotNull
    public final CipherSuite getECDHE_ECDSA_AES128_SHA256() {
        return ECDHE_ECDSA_AES128_SHA256;
    }

    @NotNull
    public final CipherSuite getECDHE_RSA_AES256_SHA384() {
        return ECDHE_RSA_AES256_SHA384;
    }

    @NotNull
    public final CipherSuite getECDHE_RSA_AES128_SHA256() {
        return ECDHE_RSA_AES128_SHA256;
    }

    @NotNull
    public final List<CipherSuite> getSupportedSuites() {
        return SupportedSuites;
    }

    private CIOCipherSuites() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $receiver$iv$iv;
        CIOCipherSuites cIOCipherSuites;
        INSTANCE = cIOCipherSuites = new CIOCipherSuites();
        TLS_RSA_WITH_AES_128_GCM_SHA256 = new CipherSuite(156, "TLS_RSA_WITH_AES_128_GCM_SHA256", "AES128-GCM-SHA256", SecretExchangeType.RSA, "AES/GCM/NoPadding", 128, 4, 12, 16, "HmacSHA256", 0, HashAlgorithm.SHA256, SignatureAlgorithm.RSA);
        ECDHE_ECDSA_AES256_SHA384 = new CipherSuite((short)49196, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "ECDHE-ECDSA-AES256-GCM-SHA384", SecretExchangeType.ECDHE, "AES/GCM/NoPadding", 256, 4, 12, 16, "HmacSHA384", 0, HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA);
        ECDHE_ECDSA_AES128_SHA256 = new CipherSuite((short)49195, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "ECDHE-ECDSA-AES128-GCM-SHA256", SecretExchangeType.ECDHE, "AES/GCM/NoPadding", 128, 4, 12, 16, "HmacSHA256", 0, HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA);
        ECDHE_RSA_AES256_SHA384 = new CipherSuite((short)49200, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "ECDHE-RSA-AES256-GCM-SHA384", SecretExchangeType.ECDHE, "AES/GCM/NoPadding", 256, 4, 12, 16, "HmacSHA384", 0, HashAlgorithm.SHA384, SignatureAlgorithm.RSA);
        ECDHE_RSA_AES128_SHA256 = new CipherSuite((short)49199, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "ECDHE-RSA-AES128-GCM-SHA256", SecretExchangeType.ECDHE, "AES/GCM/NoPadding", 128, 4, 12, 16, "HmacSHA256", 0, HashAlgorithm.SHA256, SignatureAlgorithm.RSA);
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new CipherSuite[]{ECDHE_ECDSA_AES256_SHA384, ECDHE_RSA_AES256_SHA384, ECDHE_ECDSA_AES128_SHA256, ECDHE_RSA_AES128_SHA256, TLS_RSA_WITH_AES_128_GCM_SHA256});
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CipherSuite it = (CipherSuite)element$iv$iv;
            if (!CipherSuitesKt.isSupported(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        SupportedSuites = (List)var3_3;
    }
}

