/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.http.cio.internals.HttpByteBufferPoolKt;
import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.util.PoolsKt;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.ByteBuffersKt;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a8\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0011\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a8\u0006\u0017"}, d2={"decryptCipher", "Ljavax/crypto/Cipher;", "suite", "Lio/ktor/network/tls/CipherSuite;", "keyMaterial", "", "recordType", "Lio/ktor/network/tls/TLSRecordType;", "recordLength", "", "recordIv", "", "recordId", "encryptCipher", "decrypted", "Lkotlinx/io/core/ByteReadPacket;", "cipher", "encrypted", "set", "", "offset", "data", "", "ktor-network-tls"})
public final class CipherKt {
    @NotNull
    public static final Cipher encryptCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial, @NotNull TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        byte[] byArray;
        byte[] fixedIv;
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        Intrinsics.checkParameterIsNotNull((Object)keyMaterial, (String)"keyMaterial");
        Intrinsics.checkParameterIsNotNull((Object)((Object)recordType), (String)"recordType");
        Cipher cipher = Cipher.getInstance(suite.getJdkCipherName());
        SecretKeySpec key2 = KeysKt.clientKey(keyMaterial, suite);
        byte[] byArray2 = fixedIv = KeysKt.clientIV(keyMaterial, suite);
        int n = suite.getIvLength();
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        byte[] iv = byArray3;
        CipherKt.set(iv, suite.getFixedIvLength(), recordIv);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(suite.getCipherTagSizeInBytes() * 8, iv);
        cipher.init(1, (Key)key2, gcmSpec);
        byte[] it = byArray = new byte[13];
        CipherKt.set(it, 0, recordId);
        it[8] = (byte)recordType.getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)recordLength);
        byte[] aad = byArray;
        cipher.updateAAD(aad);
        Cipher cipher2 = cipher;
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher2, (String)"cipher");
        return cipher2;
    }

    @NotNull
    public static final Cipher decryptCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial, @NotNull TLSRecordType recordType, int recordLength, long recordIv, long recordId) {
        byte[] byArray;
        boolean bl;
        byte[] fixedIv;
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        Intrinsics.checkParameterIsNotNull((Object)keyMaterial, (String)"keyMaterial");
        Intrinsics.checkParameterIsNotNull((Object)((Object)recordType), (String)"recordType");
        Cipher cipher = Cipher.getInstance(suite.getJdkCipherName());
        SecretKeySpec key2 = KeysKt.serverKey(keyMaterial, suite);
        byte[] byArray2 = fixedIv = KeysKt.serverIV(keyMaterial, suite);
        int n = suite.getIvLength();
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        byte[] iv = byArray3;
        CipherKt.set(iv, suite.getFixedIvLength(), recordIv);
        GCMParameterSpec gcmSpec = new GCMParameterSpec(suite.getCipherTagSizeInBytes() * 8, iv);
        cipher.init(2, (Key)key2, gcmSpec);
        int contentSize = recordLength - (suite.getIvLength() - suite.getFixedIvLength()) - suite.getCipherTagSizeInBytes();
        boolean bl2 = bl = contentSize < 65536;
        if (!bl) {
            String string = "Content size should fit in 2 bytes, actual: " + contentSize;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] it = byArray = new byte[13];
        CipherKt.set(it, 0, recordId);
        it[8] = (byte)recordType.getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)contentSize);
        byte[] aad = byArray;
        cipher.updateAAD(aad);
        Cipher cipher2 = cipher;
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher2, (String)"cipher");
        return cipher2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteReadPacket encrypted(@NotNull ByteReadPacket $receiver, @NotNull Cipher cipher, long recordIv) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)cipher, (String)"cipher");
        ByteBuffer buffer = (ByteBuffer)HttpByteBufferPoolKt.getDefaultByteBufferPool().borrow();
        ObjectPool encryptedPool = HttpByteBufferPoolKt.getDefaultByteBufferPool();
        ByteBuffer encrypted = (ByteBuffer)encryptedPool.borrow();
        try {
            ByteReadPacket byteReadPacket;
            int headerSizeHint$iv = 0;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
            try {
                BytePacketBuilder $receiver2 = builder$iv;
                buffer.clear();
                $receiver2.writeLong(recordIv);
                while (true) {
                    int rc;
                    int n = rc = buffer.hasRemaining() ? ByteBuffersKt.readAvailable((ByteReadPacket)$receiver, (ByteBuffer)buffer) : 0;
                    if (rc == -1) break;
                    buffer.flip();
                    if (!buffer.hasRemaining() && $receiver.isEmpty()) break;
                    encrypted.clear();
                    if (cipher.getOutputSize(buffer.remaining()) > encrypted.remaining()) {
                        encryptedPool.recycle((Object)encrypted);
                        encryptedPool = PoolsKt.getDefaultDatagramByteBufferPool();
                        encrypted = (ByteBuffer)encryptedPool.borrow();
                    }
                    cipher.update(buffer, encrypted);
                    encrypted.flip();
                    ByteBuffersKt.writeFully((BytePacketBuilder)$receiver2, (ByteBuffer)encrypted);
                    buffer.compact();
                }
                byte[] byArray = cipher.doFinal();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal()");
                $receiver2.writeFully(byArray);
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            return byteReadPacket2;
        }
        finally {
            HttpByteBufferPoolKt.getDefaultByteBufferPool().recycle((Object)buffer);
            encryptedPool.recycle((Object)encrypted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteReadPacket decrypted(@NotNull ByteReadPacket $receiver, @NotNull Cipher cipher) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)cipher, (String)"cipher");
        ByteBuffer buffer = (ByteBuffer)HttpByteBufferPoolKt.getDefaultByteBufferPool().borrow();
        ByteBuffer decrypted = (ByteBuffer)HttpByteBufferPoolKt.getDefaultByteBufferPool().borrow();
        ObjectPool decryptedPool = HttpByteBufferPoolKt.getDefaultByteBufferPool();
        try {
            ByteReadPacket byteReadPacket;
            int headerSizeHint$iv = 0;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
            try {
                BytePacketBuilder $receiver2 = builder$iv;
                buffer.clear();
                while (true) {
                    int rc;
                    int n = rc = buffer.hasRemaining() ? ByteBuffersKt.readAvailable((ByteReadPacket)$receiver, (ByteBuffer)buffer) : 0;
                    if (rc == -1) break;
                    buffer.flip();
                    if (!buffer.hasRemaining() && $receiver.isEmpty()) break;
                    decrypted.clear();
                    if (cipher.getOutputSize(buffer.remaining()) > decrypted.remaining() && buffer.capacity() < 65536) {
                        decryptedPool.recycle((Object)decrypted);
                        decryptedPool = PoolsKt.getDefaultDatagramByteBufferPool();
                        decrypted = (ByteBuffer)decryptedPool.borrow();
                        decrypted.clear();
                    }
                    cipher.update(buffer, decrypted);
                    decrypted.flip();
                    ByteBuffersKt.writeFully((BytePacketBuilder)$receiver2, (ByteBuffer)decrypted);
                    buffer.compact();
                }
                byte[] byArray = cipher.doFinal();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal()");
                $receiver2.writeFully(byArray);
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            return byteReadPacket2;
        }
        finally {
            HttpByteBufferPoolKt.getDefaultByteBufferPool().recycle((Object)buffer);
            decryptedPool.recycle((Object)decrypted);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void set(@NotNull byte[] $receiver, int offset, long data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = 0;
        int n2 = 7;
        while (n <= n2) {
            void idx;
            $receiver[idx + offset] = (byte)(data >>> (7 - idx) * 8);
            ++idx;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void set(@NotNull byte[] $receiver, int offset, int data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void idx;
            $receiver[idx + offset] = (byte)(data >>> (3 - idx) * 8);
            ++idx;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void set(@NotNull byte[] $receiver, int offset, short data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = false;
        boolean bl2 = true;
        while (bl <= bl2) {
            void idx;
            $receiver[idx + offset] = (byte)(data >>> (1 - idx) * 8);
            ++idx;
        }
    }
}

