/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.Digest;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.SecretExchangeType;
import io.ktor.network.tls.ServerKeyExchangeType;
import io.ktor.network.tls.TLSClientHandshake;
import io.ktor.network.tls.TLSClientHandshake$WhenMappings;
import io.ktor.network.tls.TLSClientHandshakeKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.UtilsKt;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.coroutines.experimental.jvm.internal.CoroutineImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.experimental.channels.ActorKt;
import kotlinx.coroutines.experimental.channels.ActorScope;
import kotlinx.coroutines.experimental.channels.ProduceKt;
import kotlinx.coroutines.experimental.channels.ProducerScope;
import kotlinx.coroutines.experimental.channels.ReceiveChannel;
import kotlinx.coroutines.experimental.channels.SendChannel;
import kotlinx.coroutines.experimental.io.ByteReadChannel;
import kotlinx.coroutines.experimental.io.ByteWriteChannel;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.PacketJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010+\u001a\u00020\u00122\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0019\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J3\u00103\u001a\u00020/2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\u0010,\u001a\u0004\u0018\u00010-H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0011\u0010;\u001a\u00020/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0011\u0010=\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0011\u0010>\u001a\u00020*H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0010\u0010?\u001a\u0002012\u0006\u0010)\u001a\u00020*H\u0002J\u0011\u0010@\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\b\u0010A\u001a\u00020/H\u0002J\b\u0010B\u001a\u00020/H\u0002J\u0019\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020\"H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010EJ\u0011\u0010F\u001a\u00020/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J;\u0010G\u001a\u00020/2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010H\u001a\u00020\u00122\u0006\u00108\u001a\u0002092\b\u0010,\u001a\u0004\u0018\u00010-H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010IJ2\u0010J\u001a\u00020/2\u0006\u0010K\u001a\u00020L2\u0017\u0010M\u001a\u0013\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020/0N\u00a2\u0006\u0002\bPH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010!\u001a\u00020\"8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020*8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\t\u00a8\u0006R"}, d2={"Lio/ktor/network/tls/TLSClientHandshake;", "", "rawInput", "Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "rawOutput", "Lkotlinx/coroutines/experimental/io/ByteWriteChannel;", "coroutineContext", "Lkotlin/coroutines/experimental/CoroutineContext;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "randomAlgorithm", "", "cipherSuites", "", "Lio/ktor/network/tls/CipherSuite;", "serverName", "(Lkotlinx/coroutines/experimental/io/ByteReadChannel;Lkotlinx/coroutines/experimental/io/ByteWriteChannel;Lkotlin/coroutines/experimental/CoroutineContext;Ljavax/net/ssl/X509TrustManager;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "clientSeed", "", "digest", "Lio/ktor/network/tls/Digest;", "handshakes", "Lkotlinx/coroutines/experimental/channels/ReceiveChannel;", "Lio/ktor/network/tls/TLSHandshake;", "input", "Lio/ktor/network/tls/TLSRecord;", "getInput", "()Lkotlinx/coroutines/experimental/channels/ReceiveChannel;", "key", "getKey", "()[B", "key$delegate", "Lkotlin/Lazy;", "masterSecret", "Ljavax/crypto/spec/SecretKeySpec;", "output", "Lkotlinx/coroutines/experimental/channels/SendChannel;", "getOutput", "()Lkotlinx/coroutines/experimental/channels/SendChannel;", "random", "Ljava/security/SecureRandom;", "serverHello", "Lio/ktor/network/tls/TLSServerHello;", "generatePreSecret", "encryptionInfo", "Lio/ktor/network/tls/EncryptionInfo;", "handleCertificatesAndKeys", "", "signatureAlgorithm", "Lio/ktor/network/tls/extensions/HashAndSign;", "(Lio/ktor/network/tls/extensions/HashAndSign;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "handleServerDone", "exchangeType", "Lio/ktor/network/tls/SecretExchangeType;", "serverCertificate", "Ljava/security/cert/Certificate;", "certificateRequested", "", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;ZLio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "negotiate", "(Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "receiveServerFinished", "receiveServerHello", "selectAndVerifyAlgorithm", "sendChangeCipherSpec", "sendClientCertificate", "sendClientCertificateVerify", "sendClientFinished", "masterKey", "(Ljavax/crypto/spec/SecretKeySpec;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "sendClientHello", "sendClientKeyExchange", "preSecret", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;[BZLio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "sendHandshakeRecord", "handshakeType", "Lio/ktor/network/tls/TLSHandshakeType;", "block", "Lkotlin/Function1;", "Lkotlinx/io/core/BytePacketBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/network/tls/TLSHandshakeType;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "ktor-network-tls"})
public final class TLSClientHandshake {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Digest digest;
    private final SecureRandom random;
    private final byte[] clientSeed;
    private volatile TLSServerHello serverHello;
    private volatile SecretKeySpec masterSecret;
    private final Lazy key$delegate;
    @NotNull
    private final ReceiveChannel<TLSRecord> input;
    @NotNull
    private final SendChannel<TLSRecord> output;
    private final ReceiveChannel<TLSHandshake> handshakes;
    private final X509TrustManager trustManager;
    private final List<CipherSuite> cipherSuites;
    private final String serverName;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TLSClientHandshake.class), "key", "getKey()[B"))};
    }

    private final byte[] getKey() {
        Lazy lazy = this.key$delegate;
        TLSClientHandshake tLSClientHandshake = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (byte[])lazy.getValue();
    }

    @NotNull
    public final ReceiveChannel<TLSRecord> getInput() {
        return this.input;
    }

    @NotNull
    public final SendChannel<TLSRecord> getOutput() {
        return this.output;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object negotiate(@NotNull Continuation<? super Unit> var1_1) {
        if (var1_1 instanceof negotiate.1 && ((var7_2 = var1_1).getLabel() & -2147483648) != 0) {
            v0 = var7_2;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var7_2 = new CoroutineImpl(this, var1_1){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.negotiate((Continuation<? super Unit>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(0, continuation);
                }
            };
        }
        var5_3 = var7_2.data;
        var6_4 = var7_2.exception;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var7_2.getLabel()) {
            case 0: {
                v1 = var6_4;
                if (v1 != null) {
                    throw v1;
                }
                var7_2.L$0 = this;
                var7_2.setLabel(1);
                v2 = this.sendClientHello((Continuation<? super Unit>)var7_2);
                if (v2 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                this = (TLSClientHandshake)var7_2.L$0;
                v3 = var6_4;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var5_3;
lbl26:
                // 2 sources

                var7_2.L$0 = this;
                var7_2.setLabel(2);
                v4 = this.receiveServerHello((Continuation<? super TLSServerHello>)var7_2);
                if (v4 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                this = (TLSClientHandshake)var7_2.L$0;
                v5 = var6_4;
                if (v5 != null) {
                    throw v5;
                }
                v4 = var5_3;
lbl38:
                // 2 sources

                var4_6 = v4;
                v6 = this.serverHello = (TLSServerHello)var4_6;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                }
                signatureAlgorithm = this.selectAndVerifyAlgorithm(v6);
                var7_2.L$0 = this;
                var7_2.L$1 = signatureAlgorithm;
                var7_2.setLabel(3);
                v7 = this.handleCertificatesAndKeys(signatureAlgorithm, (Continuation<? super Unit>)var7_2);
                if (v7 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl57
            }
            case 3: {
                signatureAlgorithm = (HashAndSign)var7_2.L$1;
                this = (TLSClientHandshake)var7_2.L$0;
                v8 = var6_4;
                if (v8 != null) {
                    throw v8;
                }
                v7 = var5_3;
lbl57:
                // 2 sources

                var7_2.L$0 = this;
                var7_2.L$1 = signatureAlgorithm;
                var7_2.setLabel(4);
                v9 = this.receiveServerFinished((Continuation<? super Unit>)var7_2);
                if (v9 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl71
            }
            case 4: {
                signatureAlgorithm = (HashAndSign)var7_2.L$1;
                this = (TLSClientHandshake)var7_2.L$0;
                v10 = var6_4;
                if (v10 != null) {
                    throw v10;
                }
                v9 = var5_3;
lbl71:
                // 2 sources

                return v9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final HashAndSign selectAndVerifyAlgorithm(TLSServerHello serverHello) {
        Object v0;
        List<HashAndSign> serverExchanges;
        List clientExchanges;
        block6: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            CipherSuite suite = serverHello.getCipherSuite();
            boolean bl = this.cipherSuites.contains(suite);
            if (!bl) {
                String string = "Unsupported cipher suite " + suite.getName() + " in SERVER_HELLO";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable iterable = $receiver$iv = (Iterable)SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                HashAndSign it = (HashAndSign)element$iv$iv;
                if (!(it.getHash() == suite.getHash() && it.getSign() == suite.getSignatureAlgorithm())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            clientExchanges = (List)destination$iv$iv;
            if (clientExchanges.isEmpty()) {
                throw (Throwable)new TLSException("No appropriate hash algorithm for suite: " + suite, null, 2, null);
            }
            serverExchanges = serverHello.getHashAndSignAlgorithms();
            if (serverExchanges.isEmpty()) {
                return (HashAndSign)CollectionsKt.first((List)clientExchanges);
            }
            Iterable $receiver$iv2 = clientExchanges;
            for (Object element$iv : $receiver$iv2) {
                HashAndSign it = (HashAndSign)element$iv;
                if (!serverExchanges.contains(it)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        HashAndSign hashAndSign = v0;
        if (hashAndSign == null) {
            throw (Throwable)new TLSException("No sign algorithms in common. \n" + "Server candidates: " + serverExchanges + " \n" + "Client candidates: " + clientExchanges, null, 2, null);
        }
        return hashAndSign;
    }

    @Nullable
    final /* synthetic */ Object sendClientHello(@NotNull Continuation<? super Unit> continuation) {
        return this.sendHandshakeRecord(TLSHandshakeType.ClientHello, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ TLSClientHandshake this$0;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                RenderKt.writeTLSClientHello($receiver, TLSVersion.TLS12, TLSClientHandshake.access$getCipherSuites$p(this.this$0), TLSClientHandshake.access$getClientSeed$p(this.this$0), new byte[32], TLSClientHandshake.access$getServerName$p(this.this$0));
            }
            {
                this.this$0 = tLSClientHandshake;
                super(1);
            }
        }), continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object receiveServerHello(@NotNull Continuation<? super TLSServerHello> var1_1) {
        if (var1_1 instanceof receiveServerHello.1 && ((var8_2 = var1_1).getLabel() & -2147483648) != 0) {
            v0 = var8_2;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var8_2 = new CoroutineImpl(this, var1_1){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.receiveServerHello((Continuation<? super TLSServerHello>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(0, continuation);
                }
            };
        }
        var6_3 = var8_2.data;
        var7_4 = var8_2.exception;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var8_2.getLabel()) {
            case 0: {
                v1 = var7_4;
                if (v1 != null) {
                    throw v1;
                }
                var8_2.L$0 = this;
                var8_2.setLabel(1);
                v2 = this.handshakes.receive((Continuation)var8_2);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                this = (TLSClientHandshake)var8_2.L$0;
                v3 = var7_4;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var6_3;
lbl26:
                // 2 sources

                v4 = var3_7 = (handshake = (TLSHandshake)v2).getType() == TLSHandshakeType.ServerHello;
                if (!var3_7) {
                    var5_8 = "Expected TLS handshake ServerHello but got " + (Object)handshake.getType();
                    throw (Throwable)new IllegalStateException(var5_8.toString());
                }
                return ParserKt.readTLSServerHello(handshake.getPacket());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    final /* synthetic */ Object handleCertificatesAndKeys(@NotNull HashAndSign var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (var2_2 instanceof handleCertificatesAndKeys.1 && ((var29_3 = var2_2).getLabel() & -2147483648) != 0) {
            v0 = var29_3;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var29_3 = new CoroutineImpl(this, var2_2){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleCertificatesAndKeys(null, (Continuation<? super Unit>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(0, continuation);
                }
            };
        }
        var27_4 = var29_3.data;
        var28_5 = var29_3.exception;
        var30_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var29_3.getLabel()) {
            case 0: {
                v1 = var28_5;
                if (v1 != null) {
                    throw v1;
                }
                v2 = this.serverHello;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                }
                exchangeType = v2.getCipherSuite().getExchangeType();
                v3 = this.serverHello;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                }
                signatureType = v3.getCipherSuite().getSignatureAlgorithm();
                var5_11 = new Ref.ObjectRef();
                var5_11.element = null;
                certificateRequested = false;
                encryptionInfo = null;
                break;
            }
            case 1: {
                encryptionInfo = (EncryptionInfo)var29_3.L$5;
                certificateRequested = var29_3.Z$0;
                serverCertificate = (Ref.ObjectRef)var29_3.L$4;
                signatureType = (SignatureAlgorithm)var29_3.L$3;
                exchangeType = (SecretExchangeType)var29_3.L$2;
                signatureAlgorithm = (HashAndSign)var29_3.L$1;
                this = (TLSClientHandshake)var29_3.L$0;
                v4 = var28_5;
                if (v4 != null) {
                    throw v4;
                }
                v5 = var27_4;
                ** GOTO lbl69
            }
            case 2: {
                packet = (ByteReadPacket)var29_3.L$7;
                handshake = (TLSHandshake)var29_3.L$6;
                encryptionInfo = (EncryptionInfo)var29_3.L$5;
                serverCertificate = (Ref.ObjectRef)var29_3.L$4;
                signatureType = (SignatureAlgorithm)var29_3.L$3;
                exchangeType = (SecretExchangeType)var29_3.L$2;
                signatureAlgorithm = (HashAndSign)var29_3.L$1;
                this = (TLSClientHandshake)var29_3.L$0;
                v6 = var28_5;
                if (v6 != null) {
                    throw v6;
                }
                v7 = var27_4;
                return v7;
            }
            default: {
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        }
        block20: while (true) {
            var29_3.L$0 = this;
            var29_3.L$1 = signatureAlgorithm;
            var29_3.L$2 = exchangeType;
            var29_3.L$3 = signatureType;
            var29_3.L$4 = serverCertificate;
            var29_3.Z$0 = certificateRequested;
            var29_3.L$5 = encryptionInfo;
            var29_3.setLabel(1);
            v5 = this.handshakes.receive((Continuation)var29_3);
            if (v5 == var30_6) {
                return var30_6;
            }
lbl69:
            // 3 sources

            handshake = (TLSHandshake)v5;
            packet = handshake.getPacket();
            switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$2[handshake.getType().ordinal()]) {
                case 1: {
                    certs = ParserKt.readTLSCertificate(packet);
                    var13_24 = $receiver$iv = (Iterable)certs;
                    destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        if (!(element$iv$iv instanceof X509Certificate)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    x509s = (List)destination$iv$iv;
                    v8 = this.trustManager;
                    if (v8 == null) {
                        v8 = TLSClientHandshakeKt.access$findTrustManager();
                    }
                    manager = v8;
                    $receiver$iv$iv = (Iterable)x509s;
                    var25_39 = serverCertificate;
                    for (E element$iv : $receiver$iv) {
                        certificate = (X509Certificate)element$iv;
                        $receiver$iv = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
                        if (!($receiver$iv instanceof Collection) || !((Collection)$receiver$iv).isEmpty()) ** GOTO lbl94
                        v9 = false;
                        ** GOTO lbl101
lbl94:
                        // 2 sources

                        for (T element$iv : $receiver$iv) {
                            it = (HashAndSign)element$iv;
                            if (!StringsKt.equals((String)it.getName(), (String)certificate.getSigAlgName(), (boolean)true)) continue;
                            v9 = true;
                            ** GOTO lbl101
                        }
                        v9 = false;
lbl101:
                        // 3 sources

                        if (!v9) continue;
                        v10 = element$iv;
                        ** GOTO lbl105
                    }
                    v10 = null;
lbl105:
                    // 2 sources

                    var26_40 = v10;
                    v11 = var26_40;
                    if (v11 == null) {
                        throw (Throwable)new TLSException("No suitable server certificate received: " + certs, null, 2, null);
                    }
                    var25_39.element = v11;
                    continue block20;
                }
                case 2: {
                    certificateRequested = true;
                    certs = packet.getRemaining() == 0;
                    if (certs) continue block20;
                    x509s = "Check failed.";
                    throw (Throwable)new IllegalStateException(x509s.toString());
                }
                case 3: {
                    switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$1[exchangeType.ordinal()]) {
                        case 1: {
                            curve = ParserKt.readCurveParams(packet);
                            point = ParserKt.readECPoint(packet, curve.getFieldSize());
                            hashAndSign = SignatureAlgorithmKt.readHashAndSign(packet);
                            if (SignatureAlgorithmKt.getSupportedSignatureAlgorithms().indexOf(hashAndSign) > SignatureAlgorithmKt.getSupportedSignatureAlgorithms().indexOf(signatureAlgorithm)) {
                                throw (Throwable)new TLSException("Selected algorithms doesn't match with server previously negotiated:" + " expected " + signatureAlgorithm + ',' + " actual " + hashAndSign, null, 2, null);
                            }
                            headerSizeHint$iv = 0;
                            builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                            try {
                                $receiver = builder$iv;
                                $receiver.writeByte((byte)ServerKeyExchangeType.NamedCurve.getCode());
                                $receiver.writeShort(curve.getCode());
                                RenderKt.writeECPoint($receiver, point, curve.getFieldSize());
                                v12 = builder$iv.build();
                            }
                            catch (Throwable t$iv) {
                                builder$iv.release();
                                throw t$iv;
                            }
                            params = v12;
                            if (Signature.getInstance(hashAndSign.getName()) == null) {
                                Intrinsics.throwNpe();
                            }
                            $receiver = $i$f$buildPacket;
                            $receiver.initVerify((Certificate)serverCertificate.element);
                            var17_31 = $receiver;
                            headerSizeHint$iv = 0;
                            builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                            try {
                                $receiver = builder$iv;
                                $receiver.writeFully(this.clientSeed);
                                v13 = this.serverHello;
                                if (v13 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                                }
                                $receiver.writeFully(v13.getServerSeed());
                                $receiver.writePacket(params);
                                v14 = builder$iv.build();
                            }
                            catch (Throwable t$iv) {
                                builder$iv.release();
                                throw t$iv;
                            }
                            var21_38 = v14;
                            var17_31.update(kotlinx.io.core.StringsKt.readBytes$default((ByteReadPacket)var21_38, (int)0, (int)1, null));
                            signature = $i$f$buildPacket;
                            signSize = packet.readShort() & 65535;
                            signedMessage = kotlinx.io.core.StringsKt.readBytes((ByteReadPacket)packet, (int)signSize);
                            if (!signature.verify(signedMessage)) {
                                throw (Throwable)new TLSException("Failed to verify signed message", null, 2, null);
                            }
                            encryptionInfo = TLSClientHandshakeKt.access$generateECKeys(curve, point);
                            continue block20;
                        }
                        case 2: {
                            packet.release();
                            var10_20 = "Server key exchange handshake doesn't expected in RCA exchange type";
                            throw (Throwable)new IllegalStateException(var10_20.toString());
                        }
                    }
                    continue block20;
                }
                case 4: {
                    v15 = (Certificate)serverCertificate.element;
                    if (v15 == null) {
                        Intrinsics.throwNpe();
                    }
                    var29_3.L$0 = this;
                    var29_3.L$1 = signatureAlgorithm;
                    var29_3.L$2 = exchangeType;
                    var29_3.L$3 = signatureType;
                    var29_3.L$4 = serverCertificate;
                    var29_3.L$5 = encryptionInfo;
                    var29_3.L$6 = handshake;
                    var29_3.L$7 = packet;
                    var29_3.setLabel(2);
                    if ((v7 = this.handleServerDone(exchangeType, v15, certificateRequested, encryptionInfo, (Continuation<? super Unit>)var29_3)) != var30_6) ** continue;
                    return var30_6;
                }
            }
            throw (Throwable)new TLSException("Unsupported message type during handshake: " + (Object)handshake.getType(), null, 2, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object handleServerDone(@NotNull SecretExchangeType var1_1, @NotNull Certificate var2_2, boolean var3_3, @Nullable EncryptionInfo var4_4, @NotNull Continuation<? super Unit> var5_5) {
        if (var5_5 instanceof handleServerDone.1 && ((var9_6 = var5_5).getLabel() & -2147483648) != 0) {
            v0 = var9_6;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var9_6 = new CoroutineImpl(this, var5_5){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleServerDone(null, null, false, null, (Continuation<? super Unit>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(0, continuation);
                }
            };
        }
        var7_7 = var9_6.data;
        var8_8 = var9_6.exception;
        var10_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var9_6.getLabel()) {
            case 0: {
                v1 = var8_8;
                if (v1 != null) {
                    throw v1;
                }
                if (certificateRequested) {
                    this.sendClientCertificate();
                }
                preSecret = this.generatePreSecret(encryptionInfo);
                var9_6.L$0 = this;
                var9_6.L$1 = exchangeType;
                var9_6.L$2 = serverCertificate;
                var9_6.Z$0 = certificateRequested;
                var9_6.L$3 = encryptionInfo;
                var9_6.L$4 = preSecret;
                var9_6.setLabel(1);
                v2 = this.sendClientKeyExchange(exchangeType, serverCertificate, preSecret, certificateRequested, encryptionInfo, (Continuation<? super Unit>)var9_6);
                if (v2 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl39
            }
            case 1: {
                preSecret = (byte[])var9_6.L$4;
                encryptionInfo = (EncryptionInfo)var9_6.L$3;
                certificateRequested = var9_6.Z$0;
                serverCertificate = (Certificate)var9_6.L$2;
                exchangeType = (SecretExchangeType)var9_6.L$1;
                this = (TLSClientHandshake)var9_6.L$0;
                v3 = var8_8;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var7_7;
lbl39:
                // 2 sources

                v4 = this.serverHello;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                }
                v5 = new SecretKeySpec(preSecret, v4.getCipherSuite().getMacName());
                v6 = this.serverHello;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                }
                this.masterSecret = KeysKt.masterSecret(v5, this.clientSeed, v6.getServerSeed());
                ArraysKt.fill$default((byte[])preSecret, (byte)0, (int)0, (int)0, (int)6, null);
                if (certificateRequested) {
                    this.sendClientCertificateVerify();
                }
                var9_6.L$0 = this;
                var9_6.L$1 = exchangeType;
                var9_6.L$2 = serverCertificate;
                var9_6.Z$0 = certificateRequested;
                var9_6.L$3 = encryptionInfo;
                var9_6.L$4 = preSecret;
                var9_6.setLabel(2);
                v7 = this.sendChangeCipherSpec((Continuation<? super Unit>)var9_6);
                if (v7 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl72
            }
            case 2: {
                preSecret = (byte[])var9_6.L$4;
                encryptionInfo = (EncryptionInfo)var9_6.L$3;
                certificateRequested = var9_6.Z$0;
                serverCertificate = (Certificate)var9_6.L$2;
                exchangeType = (SecretExchangeType)var9_6.L$1;
                this = (TLSClientHandshake)var9_6.L$0;
                v8 = var8_8;
                if (v8 != null) {
                    throw v8;
                }
                v7 = var7_7;
lbl72:
                // 2 sources

                v9 = this.masterSecret;
                if (v9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"masterSecret");
                }
                var9_6.L$0 = this;
                var9_6.L$1 = exchangeType;
                var9_6.L$2 = serverCertificate;
                var9_6.Z$0 = certificateRequested;
                var9_6.L$3 = encryptionInfo;
                var9_6.L$4 = preSecret;
                var9_6.setLabel(3);
                v10 = this.sendClientFinished(v9, (Continuation<? super Unit>)var9_6);
                if (v10 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl97
            }
            case 3: {
                preSecret = (byte[])var9_6.L$4;
                encryptionInfo = (EncryptionInfo)var9_6.L$3;
                certificateRequested = var9_6.Z$0;
                serverCertificate = (Certificate)var9_6.L$2;
                exchangeType = (SecretExchangeType)var9_6.L$1;
                this = (TLSClientHandshake)var9_6.L$0;
                v11 = var8_8;
                if (v11 != null) {
                    throw v11;
                }
                v10 = var7_7;
lbl97:
                // 2 sources

                return v10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final byte[] generatePreSecret(EncryptionInfo encryptionInfo) {
        byte[] byArray;
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
        }
        switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$3[tLSServerHello.getCipherSuite().getExchangeType().ordinal()]) {
            case 1: {
                byte[] byArray2;
                byte[] byArray3 = this.random.generateSeed(48);
                if (byArray3 == null) {
                    Intrinsics.throwNpe();
                }
                byte[] it = byArray2 = byArray3;
                it[0] = 3;
                it[1] = 3;
                byArray = byArray2;
                break;
            }
            case 2: {
                KeyAgreement keyAgreement;
                KeyAgreement keyAgreement2 = KeyAgreement.getInstance("ECDH");
                if (keyAgreement2 == null) {
                    Intrinsics.throwNpe();
                }
                KeyAgreement $receiver = keyAgreement = keyAgreement2;
                if (encryptionInfo == null) {
                    throw (Throwable)new TLSException("ECDHE_ECDSA: Encryption info should be provided", null, 2, null);
                }
                $receiver.init(encryptionInfo.getClientPrivate());
                $receiver.doPhase(encryptionInfo.getServerPublic(), true);
                byArray = $receiver.generateSecret();
                if (byArray != null) break;
                Intrinsics.throwNpe();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    @Nullable
    final /* synthetic */ Object sendClientKeyExchange(@NotNull SecretExchangeType exchangeType, @NotNull Certificate serverCertificate, @NotNull byte[] preSecret, boolean certificateRequested, @Nullable EncryptionInfo encryptionInfo, @NotNull Continuation<? super Unit> continuation) {
        ByteReadPacket byteReadPacket;
        switch (TLSClientHandshake$WhenMappings.$EnumSwitchMapping$4[exchangeType.ordinal()]) {
            case 1: {
                BytePacketBuilder $receiver;
                int headerSizeHint$iv = 0;
                BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    $receiver = builder$iv;
                    PublicKey publicKey = serverCertificate.getPublicKey();
                    Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"serverCertificate.publicKey");
                    RenderKt.writeEncryptedPreMasterSecret($receiver, preSecret, publicKey, this.random);
                    byteReadPacket = builder$iv.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
            }
            case 2: {
                BytePacketBuilder $receiver;
                int headerSizeHint$iv = 0;
                BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    $receiver = builder$iv;
                    if (!certificateRequested) {
                        if (encryptionInfo == null) {
                            throw (Throwable)new TLSException("ECDHE: Encryption info should be provided", null, 2, null);
                        }
                        RenderKt.writePublicKeyUncompressed($receiver, encryptionInfo.getClientPublic());
                    }
                    byteReadPacket = builder$iv.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ByteReadPacket packet = byteReadPacket;
        return this.sendHandshakeRecord(TLSHandshakeType.ClientKeyExchange, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(packet){
            final /* synthetic */ ByteReadPacket $packet;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.writePacket(this.$packet);
            }
            {
                this.$packet = byteReadPacket;
                super(1);
            }
        }), continuation);
    }

    private final void sendClientCertificate() {
        throw (Throwable)new TLSException("Client certificates unsupported", null, 2, null);
    }

    private final void sendClientCertificateVerify() {
        throw (Throwable)new TLSException("Client certificates unsupported", null, 2, null);
    }

    @Nullable
    final /* synthetic */ Object sendChangeCipherSpec(@NotNull Continuation<? super Unit> continuation) {
        ByteReadPacket byteReadPacket;
        TLSRecord tLSRecord;
        TLSRecordType tLSRecordType = TLSRecordType.ChangeCipherSpec;
        TLSRecord tLSRecord2 = tLSRecord;
        TLSRecord tLSRecord3 = tLSRecord;
        SendChannel<TLSRecord> sendChannel = this.output;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver = builder$iv;
            $receiver.writeByte((byte)1);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket byteReadPacket2 = byteReadPacket;
        tLSRecord2(tLSRecordType, null, byteReadPacket2, 2, null);
        return sendChannel.send((Object)tLSRecord3, continuation);
    }

    @Nullable
    final /* synthetic */ Object sendClientFinished(@NotNull SecretKeySpec masterKey, @NotNull Continuation<? super Unit> continuation) {
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
        }
        byte[] checksum = this.digest.doHash(tLSServerHello.getCipherSuite().getHash().getOpenSSLName());
        ByteReadPacket finished = RenderKt.finished(checksum, masterKey);
        return this.sendHandshakeRecord(TLSHandshakeType.Finished, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(finished){
            final /* synthetic */ ByteReadPacket $finished;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.writePacket(this.$finished);
            }
            {
                this.$finished = byteReadPacket;
                super(1);
            }
        }), continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object receiveServerFinished(@NotNull Continuation<? super Unit> var1_1) {
        if (var1_1 instanceof receiveServerFinished.1 && ((var8_2 = var1_1).getLabel() & -2147483648) != 0) {
            v0 = var8_2;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var8_2 = new CoroutineImpl(this, var1_1){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                final /* synthetic */ TLSClientHandshake this$0;
                Object L$0;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.receiveServerFinished((Continuation<? super Unit>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
                {
                    this.this$0 = tLSClientHandshake;
                    super(0, continuation);
                }
            };
        }
        var6_3 = var8_2.data;
        var7_4 = var8_2.exception;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var8_2.getLabel()) {
            case 0: {
                v1 = var7_4;
                if (v1 != null) {
                    throw v1;
                }
                var8_2.L$0 = this;
                var8_2.setLabel(1);
                v2 = this.handshakes.receive((Continuation)var8_2);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                this = (TLSClientHandshake)var8_2.L$0;
                v3 = var7_4;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var6_3;
lbl26:
                // 2 sources

                if ((finished = (TLSHandshake)v2).getType() != TLSHandshakeType.Finished) {
                    throw (Throwable)new TLSException("Finished handshake expected, received: " + finished, null, 2, null);
                }
                receivedChecksum = kotlinx.io.core.StringsKt.readBytes$default((ByteReadPacket)finished.getPacket(), (int)0, (int)1, null);
                v4 = this.serverHello;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
                }
                v5 = this.digest.doHash(v4.getCipherSuite().getHash().getOpenSSLName());
                v6 = this.masterSecret;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"masterSecret");
                }
                if (!Arrays.equals(receivedChecksum, expectedChecksum = RenderKt.serverFinished(v5, v6, receivedChecksum.length))) {
                    throw (Throwable)new TLSException(StringsKt.trimMargin$default((String)("Handshake: ServerFinished verification failed:\n                |Expected: " + ArraysKt.joinToString$default((byte[])expectedChecksum, null, null, null, (int)0, null, null, (int)63, null) + "\n                |Actual: " + ArraysKt.joinToString$default((byte[])receivedChecksum, null, null, null, (int)0, null, null, (int)63, null) + "\n            "), null, (int)1, null), null, 2, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    final /* synthetic */ Object sendHandshakeRecord(@NotNull TLSHandshakeType handshakeType, @NotNull Function1<? super BytePacketBuilder, Unit> block, @NotNull Continuation<? super Unit> continuation) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            block.invoke((Object)builder$iv);
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket handshakeBody = byteReadPacket2;
        int headerSizeHint$iv2 = 0;
        BytePacketBuilder builder$iv2 = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv2);
        try {
            BytePacketBuilder $receiver = builder$iv2;
            RenderKt.writeTLSHandshakeType($receiver, handshakeType, handshakeBody.getRemaining());
            $receiver.writePacket(handshakeBody);
            byteReadPacket = builder$iv2.build();
        }
        catch (Throwable t$iv) {
            builder$iv2.release();
            throw t$iv;
        }
        ByteReadPacket recordBody = byteReadPacket;
        this.digest.update(recordBody);
        return this.output.send((Object)new TLSRecord(TLSRecordType.Handshake, null, recordBody, 2, null), continuation);
    }

    public TLSClientHandshake(@NotNull ByteReadChannel rawInput, @NotNull ByteWriteChannel rawOutput, @NotNull CoroutineContext coroutineContext, @Nullable X509TrustManager trustManager, @NotNull String randomAlgorithm, @NotNull List<CipherSuite> cipherSuites, @Nullable String serverName) {
        Intrinsics.checkParameterIsNotNull((Object)rawInput, (String)"rawInput");
        Intrinsics.checkParameterIsNotNull((Object)rawOutput, (String)"rawOutput");
        Intrinsics.checkParameterIsNotNull((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkParameterIsNotNull((Object)randomAlgorithm, (String)"randomAlgorithm");
        Intrinsics.checkParameterIsNotNull(cipherSuites, (String)"cipherSuites");
        this.trustManager = trustManager;
        this.cipherSuites = cipherSuites;
        this.serverName = serverName;
        this.digest = new Digest();
        SecureRandom secureRandom = SecureRandom.getInstance(randomAlgorithm);
        if (secureRandom == null) {
            Intrinsics.throwNpe();
        }
        this.random = secureRandom;
        this.clientSeed = TLSClientHandshakeKt.access$generateClientSeed(this.random);
        this.key$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ TLSClientHandshake this$0;

            @NotNull
            public final byte[] invoke() {
                CipherSuite cipherSuite;
                CipherSuite $receiver = cipherSuite = TLSClientHandshake.access$getServerHello$p(this.this$0).getCipherSuite();
                return KeysKt.keyMaterial(TLSClientHandshake.access$getMasterSecret$p(this.this$0), ArraysKt.plus((byte[])TLSClientHandshake.access$getServerHello$p(this.this$0).getServerSeed(), (byte[])TLSClientHandshake.access$getClientSeed$p(this.this$0)), $receiver.getKeyStrengthInBytes(), $receiver.getMacStrengthInBytes(), $receiver.getFixedIvLength());
            }
            {
                this.this$0 = tLSClientHandshake;
                super(0);
            }
        }));
        this.input = ProduceKt.produce$default((CoroutineContext)coroutineContext, (int)0, null, null, (Function2)((Function2)new Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object>(this, rawInput, null){
            private ProducerScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            long J$0;
            int I$0;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ ByteReadChannel $rawInput;

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object doResume(@Nullable Object var1_1, @Nullable Throwable var2_2) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
            {
                this.this$0 = tLSClientHandshake;
                this.$rawInput = byteReadChannel;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull ProducerScope<? super TLSRecord> $receiver, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ProducerScope<? super TLSRecord> producerScope = function2.p$ = $receiver;
                return function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super TLSRecord> $receiver, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                return (this.create($receiver, continuation)).doResume(Unit.INSTANCE, null);
            }
        }), (int)14, null);
        this.output = ActorKt.actor$default((CoroutineContext)coroutineContext, (int)0, null, null, null, (Function2)((Function2)new Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object>(this, rawOutput, null){
            private ActorScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            Object L$10;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ ByteWriteChannel $rawOutput;

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object doResume(@Nullable Object var1_1, @Nullable Throwable var2_2) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
            {
                this.this$0 = tLSClientHandshake;
                this.$rawOutput = byteWriteChannel;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull ActorScope<TLSRecord> $receiver, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ActorScope<TLSRecord> actorScope = function2.p$ = $receiver;
                return function2;
            }

            @Nullable
            public final Object invoke(@NotNull ActorScope<TLSRecord> $receiver, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                return (this.create($receiver, continuation)).doResume(Unit.INSTANCE, null);
            }
        }), (int)30, null);
        this.handshakes = ProduceKt.produce$default((CoroutineContext)coroutineContext, (int)0, null, null, (Function2)((Function2)new Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object>(this, null){
            private ProducerScope p$;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            final /* synthetic */ TLSClientHandshake this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object doResume(@Nullable Object var1_1, @Nullable Throwable var2_2) {
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        v0 = var2_2;
                        if (v0 != null) {
                            throw v0;
                        }
                        var3_4 = this.p$;
                        while (true) {
                            this.L$0 = var3_4;
                            this.label = 1;
                            v1 = this.this$0.getInput().receive((Continuation)this);
                            if (v1 == var7_3) {
                                return var7_3;
                            }
                            ** GOTO lbl21
                            break;
                        }
                    }
                    case 1: {
                        var3_4 = (ProducerScope)this.L$0;
                        v2 = throwable;
                        if (v2 != null) {
                            throw v2;
                        }
                        v1 = data;
lbl21:
                        // 2 sources

                        record = (TLSRecord)v1;
                        packet = record.getPacket();
lbl23:
                        // 2 sources

                        while (true) {
                            if (packet.getRemaining() <= 0) ** continue;
                            handshake = ParserKt.readTLSHandshake(packet);
                            if (handshake.getType() == TLSHandshakeType.HelloRequest) ** continue;
                            if (handshake.getType() != TLSHandshakeType.Finished) {
                                UtilsKt.plusAssign(TLSClientHandshake.access$getDigest$p(this.this$0), handshake);
                            }
                            this.L$0 = var3_4;
                            this.L$1 = record;
                            this.L$2 = packet;
                            this.L$3 = handshake;
                            this.label = 2;
                            v3 = var3_4.getChannel().send((Object)handshake, (Continuation)this);
                            if (v3 == var7_3) {
                                return var7_3;
                            }
                            ** GOTO lbl47
                            break;
                        }
                    }
                    case 2: {
                        handshake = (TLSHandshake)this.L$3;
                        packet = (ByteReadPacket)this.L$2;
                        record = (TLSRecord)this.L$1;
                        var3_4 = (ProducerScope)this.L$0;
                        v4 = throwable;
                        if (v4 != null) {
                            throw v4;
                        }
                        v3 = data;
lbl47:
                        // 2 sources

                        if (handshake.getType() == TLSHandshakeType.Finished) ** break;
                        ** continue;
                        packet.release();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = tLSClientHandshake;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull ProducerScope<? super TLSHandshake> $receiver, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ProducerScope<? super TLSHandshake> producerScope = function2.p$ = $receiver;
                return function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super TLSHandshake> $receiver, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                return (this.create($receiver, continuation)).doResume(Unit.INSTANCE, null);
            }
        }), (int)14, null);
    }

    public /* synthetic */ TLSClientHandshake(ByteReadChannel byteReadChannel, ByteWriteChannel byteWriteChannel, CoroutineContext coroutineContext, X509TrustManager x509TrustManager, String string, List list, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            x509TrustManager = null;
        }
        if ((n & 0x10) != 0) {
            string = "NativePRNGNonBlocking";
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        this(byteReadChannel, byteWriteChannel, coroutineContext, x509TrustManager, string, list, string2);
    }

    @NotNull
    public static final /* synthetic */ List access$getCipherSuites$p(TLSClientHandshake $this) {
        return $this.cipherSuites;
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getClientSeed$p(TLSClientHandshake $this) {
        return $this.clientSeed;
    }

    @Nullable
    public static final /* synthetic */ String access$getServerName$p(TLSClientHandshake $this) {
        return $this.serverName;
    }

    @NotNull
    public static final /* synthetic */ TLSServerHello access$getServerHello$p(TLSClientHandshake $this) {
        TLSServerHello tLSServerHello = $this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverHello");
        }
        return tLSServerHello;
    }

    public static final /* synthetic */ void access$setServerHello$p(TLSClientHandshake $this, @NotNull TLSServerHello tLSServerHello) {
        $this.serverHello = tLSServerHello;
    }

    @NotNull
    public static final /* synthetic */ SecretKeySpec access$getMasterSecret$p(TLSClientHandshake $this) {
        SecretKeySpec secretKeySpec = $this.masterSecret;
        if (secretKeySpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"masterSecret");
        }
        return secretKeySpec;
    }

    public static final /* synthetic */ void access$setMasterSecret$p(TLSClientHandshake $this, @NotNull SecretKeySpec secretKeySpec) {
        $this.masterSecret = secretKeySpec;
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getKey$p(TLSClientHandshake $this) {
        return $this.getKey();
    }

    @NotNull
    public static final /* synthetic */ Digest access$getDigest$p(TLSClientHandshake $this) {
        return $this.digest;
    }
}

