/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a0\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0000\u001a \u0010\t\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u001a"}, d2={"CLIENT_FINISHED_LABEL", "", "getCLIENT_FINISHED_LABEL", "()[B", "KEY_EXPANSION_LABEL", "MASTER_SECRET_LABEL", "SERVER_FINISHED_LABEL", "getSERVER_FINISHED_LABEL", "keyMaterial", "masterSecret", "Ljavax/crypto/SecretKey;", "seed", "keySize", "", "macSize", "ivSize", "Ljavax/crypto/spec/SecretKeySpec;", "preMasterSecret", "clientRandom", "serverRandom", "clientIV", "suite", "Lio/ktor/network/tls/CipherSuite;", "clientKey", "serverIV", "serverKey", "ktor-network-tls"})
public final class KeysKt {
    private static final byte[] MASTER_SECRET_LABEL;
    private static final byte[] KEY_EXPANSION_LABEL;
    @NotNull
    private static final byte[] CLIENT_FINISHED_LABEL;
    @NotNull
    private static final byte[] SERVER_FINISHED_LABEL;

    @NotNull
    public static final byte[] getCLIENT_FINISHED_LABEL() {
        return CLIENT_FINISHED_LABEL;
    }

    @NotNull
    public static final byte[] getSERVER_FINISHED_LABEL() {
        return SERVER_FINISHED_LABEL;
    }

    @NotNull
    public static final SecretKeySpec clientKey(@NotNull byte[] $receiver, @NotNull CipherSuite suite) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        return new SecretKeySpec($receiver, 2 * suite.getMacStrengthInBytes(), suite.getKeyStrengthInBytes(), StringsKt.substringBefore$default((String)suite.getJdkCipherName(), (String)"/", null, (int)2, null));
    }

    @NotNull
    public static final SecretKeySpec serverKey(@NotNull byte[] $receiver, @NotNull CipherSuite suite) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        return new SecretKeySpec($receiver, 2 * suite.getMacStrengthInBytes() + suite.getKeyStrengthInBytes(), suite.getKeyStrengthInBytes(), StringsKt.substringBefore$default((String)suite.getJdkCipherName(), (String)"/", null, (int)2, null));
    }

    @NotNull
    public static final byte[] clientIV(@NotNull byte[] $receiver, @NotNull CipherSuite suite) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        byte[] byArray = $receiver;
        int n = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes();
        int n2 = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes() + suite.getFixedIvLength();
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOfR\u2026this, fromIndex, toIndex)");
        return byArray2;
    }

    @NotNull
    public static final byte[] serverIV(@NotNull byte[] $receiver, @NotNull CipherSuite suite) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        byte[] byArray = $receiver;
        int n = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes() + suite.getFixedIvLength();
        int n2 = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes() + 2 * suite.getFixedIvLength();
        byte[] byArray2 = Arrays.copyOfRange(byArray, n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOfR\u2026this, fromIndex, toIndex)");
        return byArray2;
    }

    @NotNull
    public static final byte[] keyMaterial(@NotNull SecretKey masterSecret, @NotNull byte[] seed, int keySize, int macSize, int ivSize) {
        Intrinsics.checkParameterIsNotNull((Object)masterSecret, (String)"masterSecret");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        int materialSize = 2 * macSize + 2 * keySize + 2 * ivSize;
        return HashesKt.PRF(masterSecret, KEY_EXPANSION_LABEL, seed, materialSize);
    }

    @NotNull
    public static final SecretKeySpec masterSecret(@NotNull SecretKey preMasterSecret, @NotNull byte[] clientRandom, @NotNull byte[] serverRandom) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)preMasterSecret, (String)"preMasterSecret");
        Intrinsics.checkParameterIsNotNull((Object)clientRandom, (String)"clientRandom");
        Intrinsics.checkParameterIsNotNull((Object)serverRandom, (String)"serverRandom");
        byte[] it = byArray = HashesKt.PRF(preMasterSecret, MASTER_SECRET_LABEL, ArraysKt.plus((byte[])clientRandom, (byte[])serverRandom), 48);
        return new SecretKeySpec(it, preMasterSecret.getAlgorithm());
    }

    static {
        String string = "master secret";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        MASTER_SECRET_LABEL = byArray;
        string = "key expansion";
        charset = Charsets.UTF_8;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        KEY_EXPANSION_LABEL = byArray2;
        string = "client finished";
        charset = Charsets.UTF_8;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        CLIENT_FINISHED_LABEL = byArray3;
        string = "server finished";
        charset = Charsets.UTF_8;
        byte[] byArray4 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
        SERVER_FINISHED_LABEL = byArray4;
    }
}

