/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.ParserKt$WhenMappings;
import io.ktor.network.tls.ServerKeyExchangeType;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.TLSExtension;
import io.ktor.network.tls.extensions.TLSExtensionType;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.coroutines.experimental.jvm.internal.CoroutineImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.io.ByteReadChannel;
import kotlinx.coroutines.experimental.io.ByteReadChannelKt;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\tH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u0004H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0000\u001a\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\tH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0004H\u0000\u001a\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0004H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\t\u00a8\u0006\u0017"}, d2={"MAX_TLS_FRAME_SIZE", "", "readCurveParams", "Lio/ktor/network/tls/extensions/NamedCurve;", "Lkotlinx/io/core/ByteReadPacket;", "readECPoint", "Ljava/security/spec/ECPoint;", "fieldSize", "readShortCompatible", "Lkotlinx/coroutines/experimental/io/ByteReadChannel;", "(Lkotlinx/coroutines/experimental/io/ByteReadChannel;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "readTLSCertificate", "", "Ljava/security/cert/Certificate;", "readTLSHandshake", "Lio/ktor/network/tls/TLSHandshake;", "readTLSRecord", "Lio/ktor/network/tls/TLSRecord;", "readTLSServerHello", "Lio/ktor/network/tls/TLSServerHello;", "readTLSVersion", "Lio/ktor/network/tls/TLSVersion;", "readTripleByteLength", "ktor-network-tls"})
public final class ParserKt {
    private static final int MAX_TLS_FRAME_SIZE = 18432;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readTLSRecord(@NotNull ByteReadChannel var0, @NotNull Continuation<? super TLSRecord> var1_1) {
        if (var1_1 instanceof readTLSRecord.1 && ((var10_2 = var1_1).getLabel() & -2147483648) != 0) {
            v0 = var10_2;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var10_2 = new CoroutineImpl(var1_1){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readTLSRecord(null, (Continuation<? super TLSRecord>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
            };
        }
        var8_3 = var10_2.data;
        var9_4 = var10_2.exception;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var10_2.getLabel()) {
            case 0: {
                v1 = var9_4;
                if (v1 != null) {
                    throw v1;
                }
                var6_6 = TLSRecordType.Companion;
                var10_2.L$0 = $receiver;
                var10_2.L$1 = var6_6;
                var10_2.setLabel(1);
                v2 = $receiver.readByte((Continuation)var10_2);
                if (v2 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                var6_6 = (TLSRecordType.Companion)var10_2.L$1;
                $receiver = (ByteReadChannel)var10_2.L$0;
                v3 = var9_4;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var8_3;
lbl29:
                // 2 sources

                var7_7 = v2;
                type = var6_6.byCode(((Number)var7_7).byteValue() & 255);
                var10_2.L$0 = $receiver;
                var10_2.L$1 = type;
                var10_2.setLabel(2);
                v4 = ParserKt.readTLSVersion($receiver, (Continuation<? super TLSVersion>)var10_2);
                if (v4 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl45
            }
            case 2: {
                type = (TLSRecordType)var10_2.L$1;
                $receiver = (ByteReadChannel)var10_2.L$0;
                v5 = var9_4;
                if (v5 != null) {
                    throw v5;
                }
                v4 = var8_3;
lbl45:
                // 2 sources

                version = (TLSVersion)v4;
                var10_2.L$0 = $receiver;
                var10_2.L$1 = type;
                var10_2.L$2 = version;
                var10_2.setLabel(3);
                v6 = ParserKt.readShortCompatible($receiver, (Continuation<? super Integer>)var10_2);
                if (v6 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl62
            }
            case 3: {
                version = (TLSVersion)var10_2.L$2;
                type = (TLSRecordType)var10_2.L$1;
                $receiver = (ByteReadChannel)var10_2.L$0;
                v7 = var9_4;
                if (v7 != null) {
                    throw v7;
                }
                v6 = var8_3;
lbl62:
                // 2 sources

                if ((length = ((Number)v6).intValue() & 65535) > 18432) {
                    throw (Throwable)new TLSException("Illegal TLS frame size: " + length, null, 2, null);
                }
                var10_2.L$0 = $receiver;
                var10_2.L$1 = type;
                var10_2.L$2 = version;
                var10_2.I$0 = length;
                var10_2.setLabel(4);
                v8 = ByteReadChannelKt.readPacket((ByteReadChannel)$receiver, (int)length, (Continuation)var10_2);
                if (v8 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl82
            }
            case 4: {
                length = var10_2.I$0;
                version = (TLSVersion)var10_2.L$2;
                type = (TLSRecordType)var10_2.L$1;
                $receiver = (ByteReadChannel)var10_2.L$0;
                v9 = var9_4;
                if (v9 != null) {
                    throw v9;
                }
                v8 = var8_3;
lbl82:
                // 2 sources

                packet = (ByteReadPacket)v8;
                return new TLSRecord(type, version, packet);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final TLSHandshake readTLSHandshake(@NotNull ByteReadPacket $receiver) {
        ByteReadPacket byteReadPacket;
        TLSHandshake tLSHandshake;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        TLSHandshake $receiver2 = tLSHandshake = new TLSHandshake();
        int typeAndVersion = $receiver.readInt();
        $receiver2.setType(TLSHandshakeType.Companion.byCode(typeAndVersion >>> 24));
        int length = typeAndVersion & 0xFFFFFF;
        TLSHandshake tLSHandshake2 = $receiver2;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver3 = builder$iv;
            OutputKt.writeFully$default((Output)((Output)$receiver3), (byte[])StringsKt.readBytes((ByteReadPacket)$receiver, (int)length), (int)0, (int)0, (int)6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket byteReadPacket2 = byteReadPacket;
        tLSHandshake2.setPacket(byteReadPacket2);
        return tLSHandshake;
    }

    @NotNull
    public static final TLSServerHello readTLSServerHello(@NotNull ByteReadPacket $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        TLSVersion version = ParserKt.readTLSVersion($receiver);
        byte[] random = new byte[32];
        InputKt.readFully$default((Input)((Input)$receiver), (byte[])random, (int)0, (int)0, (int)6, null);
        int sessionIdLength = $receiver.readByte() & 0xFF;
        if (sessionIdLength > 32) {
            throw (Throwable)new TLSException("sessionId length limit of 32 bytes exceeded: " + sessionIdLength + " specified", null, 2, null);
        }
        byte[] sessionId = new byte[32];
        $receiver.readFully(sessionId, 0, sessionIdLength);
        short suite = $receiver.readShort();
        short s = $receiver.readByte();
        int n = 255;
        short compressionMethod = (short)(s & n);
        if (compressionMethod != 0) {
            throw (Throwable)new TLSException("Unsupported TLS compression method " + compressionMethod + " (only null 0 compression method is supported)", null, 2, null);
        }
        if ((int)$receiver.getRemaining() == 0) {
            return new TLSServerHello(version, random, sessionId, suite, compressionMethod, null, 32, null);
        }
        int extensionSize = $receiver.readShort() & 0xFFFF;
        if ((int)$receiver.getRemaining() != extensionSize) {
            throw (Throwable)new TLSException("Invalid extensions size: requested " + extensionSize + ", available " + $receiver.getRemaining(), null, 2, null);
        }
        List extensions = new ArrayList();
        while ($receiver.getRemaining() > 0L) {
            ByteReadPacket byteReadPacket;
            TLSExtension tLSExtension;
            int type = $receiver.readShort() & 0xFFFF;
            int length = $receiver.readShort() & 0xFFFF;
            Collection collection = extensions;
            int n2 = length;
            TLSExtensionType tLSExtensionType = TLSExtensionType.Companion.byCode(type);
            TLSExtension tLSExtension2 = tLSExtension;
            TLSExtension tLSExtension3 = tLSExtension;
            int headerSizeHint$iv = 0;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
            try {
                BytePacketBuilder $receiver2 = builder$iv;
                OutputKt.writeFully$default((Output)((Output)$receiver2), (byte[])StringsKt.readBytes((ByteReadPacket)$receiver, (int)length), (int)0, (int)0, (int)6, null);
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            tLSExtension2(tLSExtensionType, n2, byteReadPacket2);
            TLSExtension tLSExtension4 = tLSExtension3;
            collection.add(tLSExtension4);
        }
        return new TLSServerHello(version, random, sessionId, suite, compressionMethod, extensions);
    }

    @NotNull
    public static final NamedCurve readCurveParams(@NotNull ByteReadPacket $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int type = $receiver.readByte() & 0xFF;
        switch (ParserKt$WhenMappings.$EnumSwitchMapping$0[ServerKeyExchangeType.Companion.byCode(type).ordinal()]) {
            case 1: {
                short curveId = $receiver.readShort();
                NamedCurve namedCurve = NamedCurve.Companion.fromCode(curveId);
                if (namedCurve == null) {
                    throw (Throwable)new TLSException("Unknown EC id", null, 2, null);
                }
                return namedCurve;
            }
            case 2: {
                String string = "ExplicitPrime server key exchange type is not yet supported";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            case 3: {
                String string = "ExplicitChar server key exchange type is not yet supported";
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final List<Certificate> readTLSCertificate(@NotNull ByteReadPacket $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int certificatesChainLength = ParserKt.readTripleByteLength($receiver);
        int certificateBase = 0;
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        if (certificateFactory == null) {
            Intrinsics.throwNpe();
        }
        CertificateFactory factory = certificateFactory;
        while (certificateBase < certificatesChainLength) {
            int certificateLength = ParserKt.readTripleByteLength($receiver);
            if (certificateLength > certificatesChainLength - certificateBase) {
                throw (Throwable)new TLSException("Certificate length is too big", null, 2, null);
            }
            if ((long)certificateLength > $receiver.getRemaining()) {
                throw (Throwable)new TLSException("Certificate length is too big", null, 2, null);
            }
            byte[] certificate = new byte[certificateLength];
            InputKt.readFully$default((Input)((Input)$receiver), (byte[])certificate, (int)0, (int)0, (int)6, null);
            certificateBase += certificateLength + 3;
            byte[] byArray = certificate;
            CertificateFactory certificateFactory2 = factory;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Certificate x509 = certificateFactory2.generateCertificate(byteArrayInputStream);
            result.add(x509);
        }
        return result;
    }

    @NotNull
    public static final ECPoint readECPoint(@NotNull ByteReadPacket $receiver, int fieldSize) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int pointSize = $receiver.readByte() & 0xFF;
        byte tag = $receiver.readByte();
        if (tag != (byte)4) {
            throw (Throwable)new TLSException("Point should be uncompressed", null, 2, null);
        }
        int componentLength = (pointSize - 1) / 2;
        if (fieldSize + 7 >>> 3 != componentLength) {
            throw (Throwable)new TLSException("Invalid point component length", null, 2, null);
        }
        return new ECPoint(new BigInteger(1, StringsKt.readBytes((ByteReadPacket)$receiver, (int)componentLength)), new BigInteger(1, StringsKt.readBytes((ByteReadPacket)$receiver, (int)componentLength)));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    static final /* synthetic */ Object readTLSVersion(@NotNull ByteReadChannel var0, @NotNull Continuation<? super TLSVersion> var1_1) {
        if (var1_1 instanceof readTLSVersion.1 && ((var6_2 = var1_1).getLabel() & -2147483648) != 0) {
            v0 = var6_2;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var6_2 = new CoroutineImpl(var1_1){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readTLSVersion(null, (Continuation<? super TLSVersion>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
            };
        }
        var4_3 = var6_2.data;
        var5_4 = var6_2.exception;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var6_2.getLabel()) {
            case 0: {
                v1 = var5_4;
                if (v1 != null) {
                    throw v1;
                }
                var2_6 = TLSVersion.Companion;
                var6_2.L$0 = $receiver;
                var6_2.L$1 = var2_6;
                var6_2.setLabel(1);
                v2 = ParserKt.readShortCompatible($receiver, (Continuation<? super Integer>)var6_2);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                var2_6 = (TLSVersion.Companion)var6_2.L$1;
                $receiver = (ByteReadChannel)var6_2.L$0;
                v3 = var5_4;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var4_3;
lbl29:
                // 2 sources

                var3_7 = v2;
                return var2_6.byCode(((Number)var3_7).intValue() & 65535);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final TLSVersion readTLSVersion(@NotNull ByteReadPacket $receiver) {
        return TLSVersion.Companion.byCode($receiver.readShort() & 0xFFFF);
    }

    private static final int readTripleByteLength(@NotNull ByteReadPacket $receiver) {
        return ($receiver.readByte() & 0xFF) << 16 | $receiver.readShort() & 0xFFFF;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readShortCompatible(@NotNull ByteReadChannel var0, @NotNull Continuation<? super Integer> var1_1) {
        if (var1_1 instanceof readShortCompatible.1 && ((var6_2 = var1_1).getLabel() & -2147483648) != 0) {
            v0 = var6_2;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var6_2 = new CoroutineImpl(var1_1){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                Object L$0;
                int I$0;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readShortCompatible(null, (Continuation<? super Integer>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
            };
        }
        var4_3 = var6_2.data;
        var5_4 = var6_2.exception;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var6_2.getLabel()) {
            case 0: {
                v1 = var5_4;
                if (v1 != null) {
                    throw v1;
                }
                var6_2.L$0 = $receiver;
                var6_2.setLabel(1);
                v2 = $receiver.readByte((Continuation)var6_2);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                $receiver = (ByteReadChannel)var6_2.L$0;
                v3 = var5_4;
                if (v3 != null) {
                    throw v3;
                }
                v2 = var4_3;
lbl26:
                // 2 sources

                first = ((Number)v2).byteValue() & 255;
                var6_2.L$0 = $receiver;
                var6_2.I$0 = first;
                var6_2.setLabel(2);
                v4 = $receiver.readByte((Continuation)var6_2);
                if (v4 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                first = var6_2.I$0;
                $receiver = (ByteReadChannel)var6_2.L$0;
                v5 = var5_4;
                if (v5 != null) {
                    throw v5;
                }
                v4 = var4_3;
lbl41:
                // 2 sources

                second = ((Number)v4).byteValue() & 255;
                return (first << 8) + second;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

