/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.NamedCurvesKt;
import io.ktor.network.tls.extensions.PointFormat;
import io.ktor.network.tls.extensions.PointFormatKt;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.network.tls.extensions.TLSExtensionType;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.intrinsics.IntrinsicsKt;
import kotlin.coroutines.experimental.jvm.internal.CoroutineImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.io.ByteWriteChannel;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00042\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\"\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0001H\u0000\u001a$\u0010!\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\u001a\u0014\u0010'\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010(\u001a\u00020$H\u0000\u001a\u001d\u0010)\u001a\u00020\u001a*\u00020*2\u0006\u0010+\u001a\u00020,H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-\u001a>\u0010.\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00062\u0006\u0010%\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00132\n\b\u0002\u00104\u001a\u0004\u0018\u00010\rH\u0000\u001a\u001c\u00105\u001a\u00020\u001a*\u00020\u001b2\u0006\u00106\u001a\u0002072\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\t\u00a8\u00068"}, d2={"MAX_CURVES_QUANTITY", "", "MAX_SERVER_NAME_LENGTH", "buildECCurvesExtension", "Lkotlinx/io/core/ByteReadPacket;", "curves", "", "Lio/ktor/network/tls/extensions/NamedCurve;", "buildECPointFormatExtension", "formats", "Lio/ktor/network/tls/extensions/PointFormat;", "buildServerNameExtension", "name", "", "buildSignatureAlgorithmsExtension", "algorithms", "Lio/ktor/network/tls/extensions/HashAndSign;", "finished", "digest", "", "secretKey", "Ljavax/crypto/SecretKey;", "serverFinished", "handshakeHash", "length", "writeAligned", "", "Lkotlinx/io/core/BytePacketBuilder;", "src", "fieldSize", "writeECPoint", "point", "Ljava/security/spec/ECPoint;", "writeEncryptedPreMasterSecret", "preSecret", "publicKey", "Ljava/security/PublicKey;", "random", "Ljava/security/SecureRandom;", "writePublicKeyUncompressed", "key", "writeRecord", "Lkotlinx/coroutines/experimental/io/ByteWriteChannel;", "record", "Lio/ktor/network/tls/TLSRecord;", "(Lkotlinx/coroutines/experimental/io/ByteWriteChannel;Lio/ktor/network/tls/TLSRecord;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "writeTLSClientHello", "version", "Lio/ktor/network/tls/TLSVersion;", "suites", "Lio/ktor/network/tls/CipherSuite;", "sessionId", "serverName", "writeTLSHandshakeType", "type", "Lio/ktor/network/tls/TLSHandshakeType;", "ktor-network-tls"})
public final class RenderKt {
    private static final int MAX_SERVER_NAME_LENGTH = 32762;
    private static final int MAX_CURVES_QUANTITY = 16382;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object writeRecord(@NotNull ByteWriteChannel var0, @NotNull TLSRecord var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (var2_2 instanceof writeRecord.1 && ((var7_3 = var2_2).getLabel() & -2147483648) != 0) {
            v0 = var7_3;
            v0.setLabel(v0.getLabel() - -2147483648);
        } else {
            var7_3 = new CoroutineImpl(var2_2){
                /* synthetic */ Object data;
                /* synthetic */ Throwable exception;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object doResume(@Nullable Object data, @Nullable Throwable throwable) {
                    this.data = data;
                    this.exception = throwable;
                    this.label |= Integer.MIN_VALUE;
                    return RenderKt.writeRecord(null, null, (Continuation<? super Unit>)this);
                }

                final /* synthetic */ int getLabel() {
                    return this.label;
                }

                final /* synthetic */ void setLabel(int n) {
                    this.label = n;
                }
            };
        }
        var5_4 = var7_3.data;
        var6_5 = var7_3.exception;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var7_3.getLabel()) {
            case 0: {
                v1 = var6_5;
                if (v1 != null) {
                    throw v1;
                }
                $receiver = record;
                v2 = (byte)$receiver.getType().getCode();
                var7_3.L$0 = $receiver;
                var7_3.L$1 = record;
                var7_3.L$2 = $receiver;
                var7_3.setLabel(1);
                v3 = $receiver.writeByte(v2, (Continuation)var7_3);
                if (v3 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                $receiver = (TLSRecord)var7_3.L$2;
                record = (TLSRecord)var7_3.L$1;
                $receiver = (ByteWriteChannel)var7_3.L$0;
                v4 = var6_5;
                if (v4 != null) {
                    throw v4;
                }
                v3 = var5_4;
lbl32:
                // 2 sources

                v5 = (byte)($receiver.getVersion().getCode() >> 8);
                var7_3.L$0 = $receiver;
                var7_3.L$1 = record;
                var7_3.L$2 = $receiver;
                var7_3.setLabel(2);
                v6 = $receiver.writeByte(v5, (Continuation)var7_3);
                if (v6 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl49
            }
            case 2: {
                $receiver = (TLSRecord)var7_3.L$2;
                record = (TLSRecord)var7_3.L$1;
                $receiver = (ByteWriteChannel)var7_3.L$0;
                v7 = var6_5;
                if (v7 != null) {
                    throw v7;
                }
                v6 = var5_4;
lbl49:
                // 2 sources

                v8 = (byte)$receiver.getVersion().getCode();
                var7_3.L$0 = $receiver;
                var7_3.L$1 = record;
                var7_3.L$2 = $receiver;
                var7_3.setLabel(3);
                v9 = $receiver.writeByte(v8, (Continuation)var7_3);
                if (v9 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl66
            }
            case 3: {
                $receiver = (TLSRecord)var7_3.L$2;
                record = (TLSRecord)var7_3.L$1;
                $receiver = (ByteWriteChannel)var7_3.L$0;
                v10 = var6_5;
                if (v10 != null) {
                    throw v10;
                }
                v9 = var5_4;
lbl66:
                // 2 sources

                v11 = (short)$receiver.getPacket().getRemaining();
                var7_3.L$0 = $receiver;
                var7_3.L$1 = record;
                var7_3.L$2 = $receiver;
                var7_3.setLabel(4);
                v12 = $receiver.writeShort(v11, (Continuation)var7_3);
                if (v12 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl83
            }
            case 4: {
                $receiver = (TLSRecord)var7_3.L$2;
                record = (TLSRecord)var7_3.L$1;
                $receiver = (ByteWriteChannel)var7_3.L$0;
                v13 = var6_5;
                if (v13 != null) {
                    throw v13;
                }
                v12 = var5_4;
lbl83:
                // 2 sources

                v14 = $receiver.getPacket();
                var7_3.L$0 = $receiver;
                var7_3.L$1 = record;
                var7_3.L$2 = $receiver;
                var7_3.setLabel(5);
                v15 = $receiver.writePacket(v14, (Continuation)var7_3);
                if (v15 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl100
            }
            case 5: {
                $receiver = (TLSRecord)var7_3.L$2;
                record = (TLSRecord)var7_3.L$1;
                $receiver = (ByteWriteChannel)var7_3.L$0;
                v16 = var6_5;
                if (v16 != null) {
                    throw v16;
                }
                v15 = var5_4;
lbl100:
                // 2 sources

                $receiver.flush();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final void writeTLSHandshakeType(@NotNull BytePacketBuilder $receiver, @NotNull TLSHandshakeType type, int length) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (length > 0xFFFFFF) {
            throw (Throwable)new TLSException("TLS handshake size limit exceeded: " + length, null, 2, null);
        }
        int v = type.getCode() << 24 | length;
        $receiver.writeInt(v);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeTLSClientHello(@NotNull BytePacketBuilder $receiver, @NotNull TLSVersion version, @NotNull List<CipherSuite> suites, @NotNull byte[] random, @NotNull byte[] sessionId, @Nullable String serverName) {
        int n;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        Intrinsics.checkParameterIsNotNull(suites, (String)"suites");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        $receiver.writeShort((short)version.getCode());
        OutputKt.writeFully$default((Output)((Output)$receiver), (byte[])random, (int)0, (int)0, (int)6, null);
        int sessionIdLength = sessionId.length;
        if (sessionIdLength < 0 || sessionIdLength > 255 || sessionIdLength > sessionId.length) {
            throw (Throwable)new TLSException("Illegal sessionIdLength", null, 2, null);
        }
        $receiver.writeByte((byte)sessionIdLength);
        $receiver.writeFully(sessionId, 0, sessionIdLength);
        $receiver.writeShort((short)(suites.size() * 2));
        for (CipherSuite suite : suites) {
            $receiver.writeShort(suite.getCode());
        }
        $receiver.writeByte((byte)1);
        $receiver.writeByte((byte)0);
        ArrayList extensions = new ArrayList();
        Object object = extensions;
        ByteReadPacket byteReadPacket = RenderKt.buildSignatureAlgorithmsExtension$default(null, 1, null);
        object.add(byteReadPacket);
        object = extensions;
        byteReadPacket = RenderKt.buildECCurvesExtension$default(null, 1, null);
        object.add(byteReadPacket);
        object = extensions;
        byteReadPacket = RenderKt.buildECPointFormatExtension$default(null, 1, null);
        object.add(byteReadPacket);
        String string = serverName;
        if (string != null) {
            Object name = object = string;
            Collection collection = extensions;
            ByteReadPacket byteReadPacket2 = RenderKt.buildServerNameExtension((String)name);
            collection.add(byteReadPacket2);
        }
        object = extensions;
        BytePacketBuilder bytePacketBuilder = $receiver;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            ByteReadPacket $i$a$1$let = (ByteReadPacket)element$iv;
            n = sum$iv;
            int n2 = (int)it.getRemaining();
            sum$iv = n + n2;
        }
        n = sum$iv;
        bytePacketBuilder.writeShort((short)n);
        Iterator iterator = extensions.iterator();
        while (iterator.hasNext()) {
            ByteReadPacket e;
            ByteReadPacket byteReadPacket3 = e = (ByteReadPacket)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)byteReadPacket3, (String)"e");
            $receiver.writePacket(byteReadPacket3);
        }
    }

    public static /* bridge */ /* synthetic */ void writeTLSClientHello$default(BytePacketBuilder bytePacketBuilder, TLSVersion tLSVersion, List list, byte[] byArray, byte[] byArray2, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        RenderKt.writeTLSClientHello(bytePacketBuilder, tLSVersion, list, byArray, byArray2, string);
    }

    public static final void writeEncryptedPreMasterSecret(@NotNull BytePacketBuilder $receiver, @NotNull byte[] preSecret, @NotNull PublicKey publicKey, @NotNull SecureRandom random) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)preSecret, (String)"preSecret");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        boolean bl2 = bl = preSecret.length == 48;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        if (cipher == null) {
            Intrinsics.throwNpe();
        }
        Cipher rsaCipher = cipher;
        rsaCipher.init(1, (Key)publicKey, random);
        byte[] encryptedSecret = rsaCipher.doFinal(preSecret);
        if (encryptedSecret.length > 65535) {
            throw (Throwable)new TLSException("Encrypted premaster secret is too long", null, 2, null);
        }
        $receiver.writeShort((short)encryptedSecret.length);
        Output output2 = (Output)$receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)encryptedSecret, (String)"encryptedSecret");
        OutputKt.writeFully$default((Output)output2, (byte[])encryptedSecret, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public static final ByteReadPacket finished(@NotNull byte[] digest2, @NotNull SecretKey secretKey) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)digest2, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver = builder$iv;
            byte[] prf = HashesKt.PRF(secretKey, KeysKt.getCLIENT_FINISHED_LABEL(), digest2, 12);
            OutputKt.writeFully$default((Output)((Output)$receiver), (byte[])prf, (int)0, (int)0, (int)6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    @NotNull
    public static final byte[] serverFinished(@NotNull byte[] handshakeHash, @NotNull SecretKey secretKey, int length) {
        Intrinsics.checkParameterIsNotNull((Object)handshakeHash, (String)"handshakeHash");
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        return HashesKt.PRF(secretKey, KeysKt.getSERVER_FINISHED_LABEL(), handshakeHash, length);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ byte[] serverFinished$default(byte[] byArray, SecretKey secretKey, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 12;
        }
        return RenderKt.serverFinished(byArray, secretKey, n);
    }

    public static final void writePublicKeyUncompressed(@NotNull BytePacketBuilder $receiver, @NotNull PublicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        PublicKey publicKey = key2;
        if (!(publicKey instanceof ECPublicKey)) {
            throw (Throwable)new TLSException("Unsupported public key type: " + key2, null, 2, null);
        }
        ECParameterSpec eCParameterSpec = ((ECPublicKey)key2).getParams();
        Intrinsics.checkExpressionValueIsNotNull((Object)eCParameterSpec, (String)"key.params");
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        Intrinsics.checkExpressionValueIsNotNull((Object)ellipticCurve, (String)"key.params.curve");
        ECField eCField = ellipticCurve.getField();
        Intrinsics.checkExpressionValueIsNotNull((Object)eCField, (String)"key.params.curve.field");
        int fieldSize = eCField.getFieldSize();
        ECPoint eCPoint = ((ECPublicKey)key2).getW();
        Intrinsics.checkExpressionValueIsNotNull((Object)eCPoint, (String)"key.w");
        RenderKt.writeECPoint($receiver, eCPoint, fieldSize);
    }

    public static final void writeECPoint(@NotNull BytePacketBuilder $receiver, @NotNull ECPoint point, int fieldSize) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            $receiver2.writeByte((byte)4);
            byte[] byArray = point.getAffineX().toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"point.affineX.toByteArray()");
            RenderKt.writeAligned($receiver2, byArray, fieldSize);
            byte[] byArray2 = point.getAffineY().toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"point.affineY.toByteArray()");
            RenderKt.writeAligned($receiver2, byArray2, fieldSize);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket pointData = byteReadPacket;
        $receiver.writeByte((byte)pointData.getRemaining());
        $receiver.writePacket(pointData);
    }

    private static final ByteReadPacket buildSignatureAlgorithmsExtension(List<HashAndSign> algorithms) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver = builder$iv;
            $receiver.writeShort(TLSExtensionType.SIGNATURE_ALGORITHMS.getCode());
            int size = algorithms.size();
            $receiver.writeShort((short)(2 + size * 2));
            $receiver.writeShort((short)(size * 2));
            Iterable $receiver$iv = algorithms;
            for (Object element$iv : $receiver$iv) {
                HashAndSign it = (HashAndSign)element$iv;
                $receiver.writeByte(it.getHash().getCode());
                $receiver.writeByte(it.getSign().getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* bridge */ /* synthetic */ ByteReadPacket buildSignatureAlgorithmsExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
        }
        return RenderKt.buildSignatureAlgorithmsExtension(list);
    }

    private static final ByteReadPacket buildServerNameExtension(String name) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            boolean bl;
            BytePacketBuilder $receiver = builder$iv;
            boolean bl2 = bl = name.length() < 32762;
            if (!bl) {
                String string = "Server name length limit exceeded: at most 32762 characters allowed";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $receiver.writeShort(TLSExtensionType.SERVER_NAME.getCode());
            $receiver.writeShort((short)(name.length() + 2 + 1 + 2));
            $receiver.writeShort((short)(name.length() + 2 + 1));
            $receiver.writeByte((byte)0);
            $receiver.writeShort((short)name.length());
            $receiver.writeStringUtf8(name);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    private static final ByteReadPacket buildECCurvesExtension(List<? extends NamedCurve> curves) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            boolean bl;
            BytePacketBuilder $receiver = builder$iv;
            boolean bl2 = bl = curves.size() <= 16382;
            if (!bl) {
                String string = "Too many named curves provided: at most 16382 could be provided";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $receiver.writeShort(TLSExtensionType.ELLIPTIC_CURVES.getCode());
            int size = curves.size() * 2;
            $receiver.writeShort((short)(2 + size));
            $receiver.writeShort((short)size);
            Iterable $receiver$iv = curves;
            for (Object element$iv : $receiver$iv) {
                NamedCurve it = (NamedCurve)((Object)element$iv);
                $receiver.writeShort(it.getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* bridge */ /* synthetic */ ByteReadPacket buildECCurvesExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = NamedCurvesKt.getSupportedNamedCurves();
        }
        return RenderKt.buildECCurvesExtension(list);
    }

    private static final ByteReadPacket buildECPointFormatExtension(List<? extends PointFormat> formats) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver = builder$iv;
            $receiver.writeShort(TLSExtensionType.EC_POINT_FORMAT.getCode());
            int size = formats.size();
            $receiver.writeShort((short)(1 + size));
            $receiver.writeByte((byte)size);
            Iterable $receiver$iv = formats;
            for (Object element$iv : $receiver$iv) {
                PointFormat it = (PointFormat)((Object)element$iv);
                $receiver.writeByte(it.getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* bridge */ /* synthetic */ ByteReadPacket buildECPointFormatExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = PointFormatKt.getSupportedPointFormats();
        }
        return RenderKt.buildECPointFormatExtension(list);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeAligned(@NotNull BytePacketBuilder $receiver, byte[] src, int fieldSize) {
        int n;
        int expectedSize;
        block3: {
            expectedSize = fieldSize + 7 >>> 3;
            byte[] $receiver$iv = src;
            int n2 = 0;
            int n3 = $receiver$iv.length;
            while (n2 < n3) {
                void index$iv;
                byte it = $receiver$iv[index$iv];
                if (it != (byte)0) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        int padding = expectedSize - (src.length - index);
        if (padding > 0) {
            OutputKt.writeFully$default((Output)((Output)$receiver), (byte[])new byte[padding], (int)0, (int)0, (int)6, null);
        }
        $receiver.writeFully(src, index, src.length - index);
    }
}

