/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.extensions.NamedCurve;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.NoSuchElementException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"findTrustManager", "Ljavax/net/ssl/X509TrustManager;", "generateECKeys", "Lio/ktor/network/tls/EncryptionInfo;", "curve", "Lio/ktor/network/tls/extensions/NamedCurve;", "serverPoint", "Ljava/security/spec/ECPoint;", "generateClientSeed", "", "Ljava/security/SecureRandom;", "ktor-network-tls"})
public final class TLSClientHandshakeKt {
    private static final X509TrustManager findTrustManager() {
        TrustManager element$iv2;
        block3: {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            TrustManagerFactory trustManagerFactory = factory;
            Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory, (String)"factory");
            TrustManager[] manager = trustManagerFactory.getTrustManagers();
            Intrinsics.checkExpressionValueIsNotNull((Object)manager, (String)"manager");
            for (TrustManager element$iv2 : manager) {
                TrustManager it = element$iv2;
                if (!(it instanceof X509TrustManager)) {
                    continue;
                }
                break block3;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        TrustManager trustManager = element$iv2;
        if (trustManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        return (X509TrustManager)trustManager;
    }

    private static final byte[] generateClientSeed(@NotNull SecureRandom $receiver) {
        byte[] byArray;
        byte[] byArray2 = $receiver.generateSeed(32);
        if (byArray2 == null) {
            Intrinsics.throwNpe();
        }
        byte[] it = byArray = byArray2;
        long unixTime = System.currentTimeMillis() / 1000L;
        it[0] = (byte)(unixTime >> 24);
        it[1] = (byte)(unixTime >> 16);
        it[2] = (byte)(unixTime >> 8);
        it[3] = (byte)(unixTime >> 0);
        return byArray;
    }

    private static final EncryptionInfo generateECKeys(NamedCurve curve, ECPoint serverPoint) {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator keyPairGenerator2 = KeyPairGenerator.getInstance("EC");
        if (keyPairGenerator2 == null) {
            Intrinsics.throwNpe();
        }
        KeyPairGenerator $receiver = keyPairGenerator = keyPairGenerator2;
        $receiver.initialize(new ECGenParameterSpec(curve.name()));
        KeyPair keyPair = $receiver.generateKeyPair();
        if (keyPair == null) {
            Intrinsics.throwNpe();
        }
        KeyPair clientKeys = keyPair;
        PublicKey publicKey = clientKeys.getPublic();
        if (publicKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        }
        ECPublicKey publicKey2 = (ECPublicKey)publicKey;
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        if (keyFactory == null) {
            Intrinsics.throwNpe();
        }
        KeyFactory factory = keyFactory;
        ECParameterSpec eCParameterSpec = publicKey2.getParams();
        if (eCParameterSpec == null) {
            Intrinsics.throwNpe();
        }
        PublicKey publicKey3 = factory.generatePublic(new ECPublicKeySpec(serverPoint, eCParameterSpec));
        if (publicKey3 == null) {
            Intrinsics.throwNpe();
        }
        PublicKey serverPublic = publicKey3;
        PublicKey publicKey4 = clientKeys.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey4, (String)"clientKeys.public");
        PrivateKey privateKey = clientKeys.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"clientKeys.private");
        return new EncryptionInfo(serverPublic, publicKey4, privateKey);
    }

    @NotNull
    public static final /* synthetic */ X509TrustManager access$findTrustManager() {
        return TLSClientHandshakeKt.findTrustManager();
    }

    @NotNull
    public static final /* synthetic */ EncryptionInfo access$generateECKeys(@NotNull NamedCurve curve, @NotNull ECPoint serverPoint) {
        return TLSClientHandshakeKt.generateECKeys(curve, serverPoint);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$generateClientSeed(@NotNull SecureRandom $receiver) {
        return TLSClientHandshakeKt.generateClientSeed($receiver);
    }
}

