/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.OIDKt;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.CertificatesKt$writeX509Info$1$$special$;
import io.ktor.network.tls.certificates.Counterparty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.charsets.CharsetJVMKt;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.CloseableJVMKt;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u001a\f\u0010\u000b\u001a\u00020\n*\u00020\nH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u001aX\u0010\u0012\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cH\u0000\u001a\u001e\u0010\u001f\u001a\u00020\r*\u00020\u000e2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\nH\u0002\u001a%\u0010\u001f\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a\u0014\u0010&\u001a\u00020\r*\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0002\u001a\u0014\u0010(\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u001a\u0014\u0010)\u001a\u00020\r*\u00020\u000e2\u0006\u0010*\u001a\u00020\nH\u0002\u001a\f\u0010+\u001a\u00020\r*\u00020\u000eH\u0002\u001a\u0014\u0010,\u001a\u00020\r*\u00020\u000e2\u0006\u0010-\u001a\u00020.H\u0002\u001a\u0014\u0010,\u001a\u00020\r*\u00020\u000e2\u0006\u0010-\u001a\u00020/H\u0002\u001a%\u00100\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a%\u00101\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a%\u00102\u001a\u00020\r*\u00020\u000e2\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001a$\u00103\u001a\u00020\r*\u00020\u000e2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u000207H\u0002\u001a\u0014\u00108\u001a\u00020\r*\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0002\u001a\u001e\u00109\u001a\u00020\r*\u00020\u000e2\u0006\u0010:\u001a\u00020\u00052\b\b\u0002\u0010;\u001a\u00020\nH\u0002\u001a\u0016\u0010<\u001a\u00020\r*\u00020\u000e2\b\b\u0002\u0010=\u001a\u00020\nH\u0002\u001a\u0014\u0010>\u001a\u00020\r*\u00020\u000e2\u0006\u0010?\u001a\u00020\u0014H\u0002\u001a-\u0010@\u001a\u00020\r*\u00020\u000e2\u0006\u0010A\u001a\u00020\n2\u0017\u0010B\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0$\u00a2\u0006\u0002\b%H\u0002\u001aX\u0010C\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010D\u001a\u00020E2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cH\u0000\u001a\u001c\u0010F\u001a\u00020\r*\u00020\u000e2\u0006\u0010A\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006G"}, d2={"generateCertificate", "Ljava/security/KeyStore;", "file", "Ljava/io/File;", "algorithm", "", "keyAlias", "keyPassword", "jksPassword", "keySizeInBits", "", "derLength", "writeAlgorithmIdentifier", "", "Lkotlinx/io/core/BytePacketBuilder;", "writeAsnInt", "value", "Ljava/math/BigInteger;", "writeCertificate", "issuer", "Lio/ktor/network/tls/certificates/Counterparty;", "subject", "keyPair", "Ljava/security/KeyPair;", "from", "Ljava/util/Date;", "to", "domains", "", "ipAddresses", "Ljava/net/InetAddress;", "writeDerBitString", "array", "", "unused", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeDerGeneralizedTime", "date", "writeDerInt", "writeDerLength", "length", "writeDerNull", "writeDerObjectIdentifier", "identifier", "Lio/ktor/network/tls/OID;", "", "writeDerOctetString", "writeDerSequence", "writeDerSet", "writeDerType", "kind", "typeIdentifier", "simpleType", "", "writeDerUTCTime", "writeDerUTF8String", "s", "type", "writeVersion", "v", "writeX509Counterparty", "counterparty", "writeX509Extension", "id", "builder", "writeX509Info", "publicKey", "Ljava/security/PublicKey;", "writeX509NamePart", "ktor-network-tls"})
public final class CertificatesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KeyStore generateCertificate(@NotNull File file, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits) {
        void $receiver$iv;
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull((Object)keyAlias, (String)"keyAlias");
        Intrinsics.checkParameterIsNotNull((Object)keyPassword, (String)"keyPassword");
        Intrinsics.checkParameterIsNotNull((Object)jksPassword, (String)"jksPassword");
        long daysValid = 3L;
        KeyStore keyStore = KeyStore.getInstance("JKS");
        if (keyStore == null) {
            Intrinsics.throwNpe();
        }
        KeyStore keyStore2 = keyStore;
        keyStore2.load(null, null);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm(algorithm));
        if (keyPairGenerator == null) {
            Intrinsics.throwNpe();
        }
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        keyPairGenerator2.initialize(keySizeInBits);
        KeyPair keyPair = keyPairGenerator2.genKeyPair();
        if (keyPair == null) {
            Intrinsics.throwNpe();
        }
        KeyPair keyPair2 = keyPair;
        Counterparty id = new Counterparty("RU", "JetBrains", "Kotlin", "localhost");
        Date from = new Date();
        Date to = Date.from(LocalDateTime.now().plusDays(daysValid).atZone(ZoneId.systemDefault()).toInstant());
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver = builder$iv;
            Date date = to;
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"to");
            CertificatesKt.writeCertificate($receiver, id, id, keyPair2, algorithm, from, date, CollectionsKt.listOf((Object[])new String[]{"127.0.0.1", "localhost"}), CollectionsKt.listOf((Object)Inet4Address.getByName("127.0.0.1")));
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        byte[] certificateBytes = StringsKt.readBytes$default((ByteReadPacket)byteReadPacket, (int)0, (int)1, null);
        Object $i$f$buildPacket = certificateBytes;
        Object object = CertificateFactory.getInstance("X.509");
        Object object2 = new ByteArrayInputStream((byte[])$i$f$buildPacket);
        Certificate cert = ((CertificateFactory)object).generateCertificate((InputStream)object2);
        cert.verify(keyPair2.getPublic());
        keyStore2.setCertificateEntry(keyAlias, cert);
        $i$f$buildPacket = keyPassword;
        Key key2 = keyPair2.getPrivate();
        object2 = keyAlias;
        object = keyStore2;
        char[] cArray = ((String)$i$f$buildPacket).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        ((KeyStore)object).setKeyEntry((String)object2, key2, cArray2, new Certificate[]{cert});
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        $i$f$buildPacket = file;
        $i$f$buildPacket = new FileOutputStream((File)$i$f$buildPacket);
        try {
            FileOutputStream it = (FileOutputStream)$receiver$iv;
            String string = jksPassword;
            OutputStream outputStream = it;
            KeyStore keyStore3 = keyStore2;
            char[] cArray3 = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray3, (String)"(this as java.lang.String).toCharArray()");
            char[] cArray4 = cArray3;
            keyStore3.store(outputStream, cArray4);
            Unit result$iv = Unit.INSTANCE;
            $receiver$iv.close();
        }
        catch (Throwable first$iv) {
            try {
                $receiver$iv.close();
            }
            catch (Throwable second$iv) {
                CloseableJVMKt.addSuppressedInt((Throwable)first$iv, (Throwable)second$iv);
            }
            throw first$iv;
        }
        return keyStore2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KeyStore generateCertificate$default(File file, String string, String string2, String string3, String string4, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        return CertificatesKt.generateCertificate(file, string, string2, string3, string4, n);
    }

    public static final void writeX509Info(@NotNull BytePacketBuilder $receiver, @NotNull String algorithm, @NotNull Counterparty issuer, @NotNull Counterparty subject, @NotNull PublicKey publicKey, @NotNull Date from, @NotNull Date to, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull(domains, (String)"domains");
        Intrinsics.checkParameterIsNotNull(ipAddresses, (String)"ipAddresses");
        BigInteger version = new BigInteger(64, new SecureRandom());
        CertificatesKt.writeDerSequence($receiver, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(version, algorithm, issuer, from, to, subject, publicKey, domains, ipAddresses){
            final /* synthetic */ BigInteger $version;
            final /* synthetic */ String $algorithm;
            final /* synthetic */ Counterparty $issuer;
            final /* synthetic */ Date $from;
            final /* synthetic */ Date $to;
            final /* synthetic */ Counterparty $subject;
            final /* synthetic */ PublicKey $publicKey;
            final /* synthetic */ List $domains;
            final /* synthetic */ List $ipAddresses;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                ByteReadPacket byteReadPacket;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                CertificatesKt.access$writeVersion($receiver, 2);
                CertificatesKt.access$writeAsnInt($receiver, this.$version);
                CertificatesKt.access$writeAlgorithmIdentifier($receiver, this.$algorithm);
                CertificatesKt.access$writeX509Counterparty($receiver, this.$issuer);
                CertificatesKt.access$writeDerSequence($receiver, (Function1)new Function1<BytePacketBuilder, Unit>(this){
                    final /* synthetic */ writeX509Info.1 this$0;

                    public final void invoke(@NotNull BytePacketBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        CertificatesKt.access$writeDerUTCTime($receiver, this.this$0.$from);
                        CertificatesKt.access$writeDerGeneralizedTime($receiver, this.this$0.$to);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                CertificatesKt.access$writeX509Counterparty($receiver, this.$subject);
                Output output2 = (Output)$receiver;
                byte[] byArray = this.$publicKey.getEncoded();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"publicKey.encoded");
                OutputKt.writeFully$default((Output)output2, (byte[])byArray, (int)0, (int)0, (int)6, null);
                $receiver.writeByte((byte)163);
                int headerSizeHint$iv = 0;
                BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
                try {
                    BytePacketBuilder $receiver2 = builder$iv;
                    CertificatesKt.access$writeDerSequence($receiver2, (Function1)new Function1<BytePacketBuilder, Unit>(this){
                        final /* synthetic */ writeX509Info.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull BytePacketBuilder $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            CertificatesKt.access$writeDerSequence($receiver, (Function1)new Function1<BytePacketBuilder, Unit>(this){
                                final /* synthetic */ writeX509Info$1$$special$$inlined$buildPacket$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }

                                public final void invoke(@NotNull BytePacketBuilder $receiver) {
                                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                    CertificatesKt.access$writeDerObjectIdentifier($receiver, OID.Companion.getSubjectAltName());
                                    CertificatesKt.access$writeDerOctetString($receiver, (Function1)new Function1<BytePacketBuilder, Unit>(this){
                                        final /* synthetic */ writeX509Info$1$$special$$inlined$buildPacket$lambda$1$1 this$0;
                                        {
                                            this.this$0 = var1_1;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull BytePacketBuilder $receiver) {
                                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                            CertificatesKt.access$writeDerSequence($receiver, (Function1)new Function1<BytePacketBuilder, Unit>(this){
                                                final /* synthetic */ writeX509Info$1$$special$$inlined$buildPacket$lambda$1$1$1 this$0;
                                                {
                                                    this.this$0 = var1_1;
                                                    super(1);
                                                }

                                                public final void invoke(@NotNull BytePacketBuilder $receiver) {
                                                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                                    for (String domain : this.this$0.this$0.this$0.this$0.$domains) {
                                                        CertificatesKt.access$writeX509Extension($receiver, 2, (Function1)new Function1<BytePacketBuilder, Unit>(domain){
                                                            final /* synthetic */ String $domain;
                                                            {
                                                                this.$domain = string;
                                                                super(1);
                                                            }

                                                            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                                                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                                                String $receiver$iv = this.$domain;
                                                                Output output2 = (Output)$receiver;
                                                                Charset charset$iv = Charsets.UTF_8;
                                                                CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                                                                Intrinsics.checkExpressionValueIsNotNull((Object)charsetEncoder, (String)"charset.newEncoder()");
                                                                byte[] byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$receiver$iv, (int)0, (int)$receiver$iv.length());
                                                                OutputKt.writeFully$default((Output)output2, (byte[])byArray, (int)0, (int)0, (int)6, null);
                                                            }
                                                        });
                                                    }
                                                    for (InetAddress ip : this.this$0.this$0.this$0.this$0.$ipAddresses) {
                                                        CertificatesKt.access$writeX509Extension($receiver, 7, (Function1)new Function1<BytePacketBuilder, Unit>(ip){
                                                            final /* synthetic */ InetAddress $ip;
                                                            {
                                                                this.$ip = inetAddress;
                                                                super(1);
                                                            }

                                                            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                                                                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                                                Output output2 = (Output)$receiver;
                                                                byte[] byArray = this.$ip.getAddress();
                                                                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ip.address");
                                                                OutputKt.writeFully$default((Output)output2, (byte[])byArray, (int)0, (int)0, (int)6, null);
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    });
                    byteReadPacket = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                ByteReadPacket extensions = byteReadPacket;
                CertificatesKt.access$writeDerLength($receiver, (int)extensions.getRemaining());
                $receiver.writePacket(extensions);
            }
            {
                this.$version = bigInteger;
                this.$algorithm = string;
                this.$issuer = counterparty;
                this.$from = date;
                this.$to = date2;
                this.$subject = counterparty2;
                this.$publicKey = publicKey;
                this.$domains = list;
                this.$ipAddresses = list2;
                super(1);
            }
        }));
    }

    private static final void writeAlgorithmIdentifier(@NotNull BytePacketBuilder $receiver, String algorithm) {
        CertificatesKt.writeDerSequence($receiver, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(algorithm){
            final /* synthetic */ String $algorithm;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                OID oid = OID.Companion.fromAlgorithm(this.$algorithm);
                CertificatesKt.access$writeDerObjectIdentifier($receiver, oid);
                CertificatesKt.access$writeDerNull($receiver);
            }
            {
                this.$algorithm = string;
                super(1);
            }
        }));
    }

    private static final void writeX509Extension(@NotNull BytePacketBuilder $receiver, int id, Function1<? super BytePacketBuilder, Unit> builder) {
        ByteReadPacket byteReadPacket;
        $receiver.writeByte((byte)(0x80 | id));
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            builder.invoke((Object)$receiver2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet = byteReadPacket;
        CertificatesKt.writeDerLength($receiver, (int)packet.getRemaining());
        $receiver.writePacket(packet);
    }

    private static final void writeX509NamePart(@NotNull BytePacketBuilder $receiver, OID id, String value) {
        CertificatesKt.writeDerSet($receiver, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(id, value){
            final /* synthetic */ OID $id;
            final /* synthetic */ String $value;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                CertificatesKt.access$writeDerSequence($receiver, (Function1)new Function1<BytePacketBuilder, Unit>(this){
                    final /* synthetic */ writeX509NamePart.1 this$0;

                    public final void invoke(@NotNull BytePacketBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        CertificatesKt.access$writeDerObjectIdentifier($receiver, this.this$0.$id);
                        CertificatesKt.writeDerUTF8String$default($receiver, this.this$0.$value, 0, 2, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$id = oID;
                this.$value = string;
                super(1);
            }
        }));
    }

    private static final void writeX509Counterparty(@NotNull BytePacketBuilder $receiver, Counterparty counterparty) {
        CertificatesKt.writeDerSequence($receiver, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(counterparty){
            final /* synthetic */ Counterparty $counterparty;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                CharSequence charSequence = this.$counterparty.getCountry();
                if (charSequence.length() > 0) {
                    CertificatesKt.access$writeX509NamePart($receiver, OID.Companion.getCountryName(), this.$counterparty.getCountry());
                }
                if ((charSequence = (CharSequence)this.$counterparty.getOrganization()).length() > 0) {
                    CertificatesKt.access$writeX509NamePart($receiver, OID.Companion.getOrganizationName(), this.$counterparty.getOrganization());
                }
                if ((charSequence = (CharSequence)this.$counterparty.getOrganizationUnit()).length() > 0) {
                    CertificatesKt.access$writeX509NamePart($receiver, OID.Companion.getOrganizationalUnitName(), this.$counterparty.getOrganizationUnit());
                }
                if ((charSequence = (CharSequence)this.$counterparty.getCommonName()).length() > 0) {
                    CertificatesKt.access$writeX509NamePart($receiver, OID.Companion.getCommonName(), this.$counterparty.getCommonName());
                }
            }
            {
                this.$counterparty = counterparty;
                super(1);
            }
        }));
    }

    public static final void writeCertificate(@NotNull BytePacketBuilder $receiver, @NotNull Counterparty issuer, @NotNull Counterparty subject, @NotNull KeyPair keyPair, @NotNull String algorithm, @NotNull Date from, @NotNull Date to, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)issuer, (String)"issuer");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull(domains, (String)"domains");
        Intrinsics.checkParameterIsNotNull(ipAddresses, (String)"ipAddresses");
        boolean bl = to.after(from);
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            PublicKey publicKey = keyPair.getPublic();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
            CertificatesKt.writeX509Info($receiver2, algorithm, issuer, subject, publicKey, from, to, domains, ipAddresses);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket certInfo = byteReadPacket;
        byte[] certInfoBytes = StringsKt.readBytes$default((ByteReadPacket)certInfo, (int)0, (int)1, null);
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(keyPair.getPrivate());
        signature.update(certInfoBytes);
        byte[] signed = signature.sign();
        CertificatesKt.writeDerSequence($receiver, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(certInfoBytes, algorithm, signed){
            final /* synthetic */ byte[] $certInfoBytes;
            final /* synthetic */ String $algorithm;
            final /* synthetic */ byte[] $signed;

            public final void invoke(@NotNull BytePacketBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                OutputKt.writeFully$default((Output)((Output)$receiver), (byte[])this.$certInfoBytes, (int)0, (int)0, (int)6, null);
                CertificatesKt.access$writeDerSequence($receiver, (Function1)new Function1<BytePacketBuilder, Unit>(this){
                    final /* synthetic */ writeCertificate.1 this$0;

                    public final void invoke(@NotNull BytePacketBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        CertificatesKt.access$writeDerObjectIdentifier($receiver, OID.Companion.fromAlgorithm(this.this$0.$algorithm));
                        CertificatesKt.access$writeDerNull($receiver);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)this.$signed, (String)"signed");
                CertificatesKt.writeDerBitString$default($receiver, this.$signed, 0, 2, null);
            }
            {
                this.$certInfoBytes = byArray;
                this.$algorithm = string;
                this.$signed = byArray2;
                super(1);
            }
        }));
    }

    private static final void writeVersion(@NotNull BytePacketBuilder $receiver, int v) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($receiver, 2, 0, false);
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            CertificatesKt.writeAsnInt($receiver2, v);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded = byteReadPacket;
        CertificatesKt.writeDerLength($receiver, (int)encoded.getRemaining());
        $receiver.writePacket(encoded);
    }

    static /* bridge */ /* synthetic */ void writeVersion$default(BytePacketBuilder bytePacketBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        CertificatesKt.writeVersion(bytePacketBuilder, n);
    }

    private static final void writeDerOctetString(@NotNull BytePacketBuilder $receiver, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            block.invoke((Object)$receiver2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($receiver, 0, 4, true);
        CertificatesKt.writeDerLength($receiver, (int)sub.getRemaining());
        $receiver.writePacket(sub);
    }

    private static final void writeDerBitString(@NotNull BytePacketBuilder $receiver, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            block.invoke((Object)$receiver2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($receiver, 0, 3, true);
        CertificatesKt.writeDerLength($receiver, (int)sub.getRemaining() + 1);
        $receiver.writeByte((byte)0);
        $receiver.writePacket(sub);
    }

    private static final void writeDerBitString(@NotNull BytePacketBuilder $receiver, byte[] array, int unused) {
        int n = unused;
        int n2 = n = 0 <= n && 7 >= n ? 1 : 0;
        if (n == 0) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CertificatesKt.writeDerType($receiver, 0, 3, true);
        CertificatesKt.writeDerLength($receiver, array.length + 1);
        $receiver.writeByte((byte)unused);
        OutputKt.writeFully$default((Output)((Output)$receiver), (byte[])array, (int)0, (int)0, (int)6, null);
    }

    static /* bridge */ /* synthetic */ void writeDerBitString$default(BytePacketBuilder bytePacketBuilder, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        CertificatesKt.writeDerBitString(bytePacketBuilder, byArray, n);
    }

    private static final void writeDerUTCTime(@NotNull BytePacketBuilder $receiver, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        BytePacketBuilder bytePacketBuilder = $receiver;
        SimpleDateFormat $receiver2 = simpleDateFormat;
        $receiver2.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        String string = simpleDateFormat2.format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SimpleDateFormat(\"yyMMdd\u2026\"UTC\")\n    }.format(date)");
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, 23);
    }

    private static final void writeDerGeneralizedTime(@NotNull BytePacketBuilder $receiver, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        BytePacketBuilder bytePacketBuilder = $receiver;
        SimpleDateFormat $receiver2 = simpleDateFormat;
        $receiver2.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        String string = simpleDateFormat2.format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SimpleDateFormat(\"yyyyMM\u2026           date\n        )");
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, 24);
    }

    private static final void writeDerUTF8String(@NotNull BytePacketBuilder $receiver, String s, int type) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            $receiver2.writeStringUtf8(s);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($receiver, 0, type, true);
        CertificatesKt.writeDerLength($receiver, (int)sub.getRemaining());
        $receiver.writePacket(sub);
    }

    static /* bridge */ /* synthetic */ void writeDerUTF8String$default(BytePacketBuilder bytePacketBuilder, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 12;
        }
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, n);
    }

    private static final void writeDerNull(@NotNull BytePacketBuilder $receiver) {
        $receiver.writeShort((short)1280);
    }

    private static final void writeDerSequence(@NotNull BytePacketBuilder $receiver, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            block.invoke((Object)$receiver2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($receiver, 0, 16, false);
        CertificatesKt.writeDerLength($receiver, (int)sub.getRemaining());
        $receiver.writePacket(sub);
    }

    private static final void writeDerSet(@NotNull BytePacketBuilder $receiver, Function1<? super BytePacketBuilder, Unit> block) {
        ByteReadPacket byteReadPacket;
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            block.invoke((Object)$receiver2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($receiver, 0, 17, false);
        CertificatesKt.writeDerLength($receiver, (int)sub.getRemaining());
        $receiver.writePacket(sub);
    }

    private static final void writeDerObjectIdentifier(@NotNull BytePacketBuilder $receiver, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($receiver, identifier.getAsArray());
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDerObjectIdentifier(@NotNull BytePacketBuilder $receiver, int[] identifier) {
        ByteReadPacket byteReadPacket;
        int n;
        int n2 = n = identifier.length >= 2 ? 1 : 0;
        if (n == 0) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = identifier[0];
        int n3 = n = 0 <= n && 2 >= n ? 1 : 0;
        if (n == 0) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n4 = n = identifier[0] == 2 || 0 <= (n = identifier[1]) && 39 >= n ? 1 : 0;
        if (n == 0) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            CertificatesKt.writeDerInt($receiver2, identifier[0] * 40 + identifier[1]);
            int n5 = 2;
            int n6 = ArraysKt.getLastIndex((int[])identifier);
            if (n5 <= n6) {
                while (true) {
                    void i;
                    CertificatesKt.writeDerInt($receiver2, identifier[i]);
                    if (i == n6) break;
                    ++i;
                }
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($receiver, 0, 6, true);
        CertificatesKt.writeDerLength($receiver, (int)sub.getRemaining());
        $receiver.writePacket(sub);
    }

    private static final void writeAsnInt(@NotNull BytePacketBuilder $receiver, BigInteger value) {
        CertificatesKt.writeDerType($receiver, 0, 2, true);
        byte[] encoded = value.toByteArray();
        CertificatesKt.writeDerLength($receiver, encoded.length);
        Output output2 = (Output)$receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)encoded, (String)"encoded");
        OutputKt.writeFully$default((Output)output2, (byte[])encoded, (int)0, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeAsnInt(@NotNull BytePacketBuilder $receiver, int value) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($receiver, 0, 2, true);
        int headerSizeHint$iv = 0;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            boolean skip = true;
            int n = 0;
            int n2 = 3;
            while (n <= n2) {
                void idx;
                int part = value >>> (4 - idx - 1) * 8 & 0xFF;
                if (part != 0 || !skip) {
                    skip = false;
                    $receiver2.writeByte((byte)part);
                }
                ++idx;
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded = byteReadPacket;
        CertificatesKt.writeDerLength($receiver, (int)encoded.getRemaining());
        $receiver.writePacket(encoded);
    }

    private static final void writeDerLength(@NotNull BytePacketBuilder $receiver, int length) {
        boolean bl;
        boolean bl2 = bl = length >= 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (length <= 127) {
            $receiver.writeByte((byte)length);
        } else if (length <= 255) {
            $receiver.writeByte((byte)129);
            $receiver.writeByte((byte)length);
        } else if (length <= 65535) {
            $receiver.writeByte((byte)130);
            $receiver.writeByte((byte)(length >>> 8));
            $receiver.writeByte((byte)length);
        } else if (length <= 0xFFFFFF) {
            $receiver.writeByte((byte)131);
            $receiver.writeByte((byte)(length >>> 16));
            $receiver.writeByte((byte)(length >>> 8 & 0xFF));
            $receiver.writeByte((byte)length);
        } else {
            $receiver.writeByte((byte)132);
            $receiver.writeByte((byte)(length >>> 24));
            $receiver.writeByte((byte)(length >>> 16 & 0xFF));
            $receiver.writeByte((byte)(length >>> 8 & 0xFF));
            $receiver.writeByte((byte)length);
        }
    }

    private static final void writeDerType(@NotNull BytePacketBuilder $receiver, int kind, int typeIdentifier, boolean simpleType) {
        int n = kind;
        int n2 = n = 0 <= n && 3 >= n ? 1 : 0;
        if (n == 0) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n3 = n = typeIdentifier >= 0 ? 1 : 0;
        if (n == 0) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = typeIdentifier;
        if (0 <= n && 30 >= n) {
            int singleByte = kind << 6 | typeIdentifier | (simpleType ? 0 : 32);
            byte byteValue = (byte)singleByte;
            $receiver.writeByte(byteValue);
        } else {
            int firstByte = kind << 6 | 0x1F | (simpleType ? 0 : 32);
            $receiver.writeByte((byte)firstByte);
            CertificatesKt.writeDerInt($receiver, typeIdentifier);
        }
    }

    private static final int derLength(int $receiver) {
        boolean bl;
        boolean bl2 = bl = $receiver >= 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if ($receiver == 0) {
            return 0;
        }
        int mask = 127;
        int byteCount = 1;
        while (($receiver & mask) != $receiver) {
            mask |= mask << 7;
            ++byteCount;
        }
        return byteCount;
    }

    private static final void writeDerInt(@NotNull BytePacketBuilder $receiver, int value) {
        boolean bl;
        boolean bl2 = bl = value >= 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int byteCount = CertificatesKt.derLength(value);
        int n = byteCount;
        for (int i = 0; i < n; ++i) {
            int idx = i;
            int part = value >> (byteCount - idx - 1) * 7 & 0x7F;
            if (idx == byteCount - 1) {
                $receiver.writeByte((byte)part);
                continue;
            }
            $receiver.writeByte((byte)(part | 0x80));
        }
    }

    public static final /* synthetic */ void access$writeVersion(@NotNull BytePacketBuilder $receiver, int v) {
        CertificatesKt.writeVersion($receiver, v);
    }

    public static final /* synthetic */ void access$writeAsnInt(@NotNull BytePacketBuilder $receiver, @NotNull BigInteger value) {
        CertificatesKt.writeAsnInt($receiver, value);
    }

    public static final /* synthetic */ void access$writeAlgorithmIdentifier(@NotNull BytePacketBuilder $receiver, @NotNull String algorithm) {
        CertificatesKt.writeAlgorithmIdentifier($receiver, algorithm);
    }

    public static final /* synthetic */ void access$writeX509Counterparty(@NotNull BytePacketBuilder $receiver, @NotNull Counterparty counterparty) {
        CertificatesKt.writeX509Counterparty($receiver, counterparty);
    }

    public static final /* synthetic */ void access$writeDerSequence(@NotNull BytePacketBuilder $receiver, @NotNull Function1 block) {
        CertificatesKt.writeDerSequence($receiver, (Function1<? super BytePacketBuilder, Unit>)block);
    }

    public static final /* synthetic */ void access$writeDerUTCTime(@NotNull BytePacketBuilder $receiver, @NotNull Date date) {
        CertificatesKt.writeDerUTCTime($receiver, date);
    }

    public static final /* synthetic */ void access$writeDerGeneralizedTime(@NotNull BytePacketBuilder $receiver, @NotNull Date date) {
        CertificatesKt.writeDerGeneralizedTime($receiver, date);
    }

    public static final /* synthetic */ void access$writeDerObjectIdentifier(@NotNull BytePacketBuilder $receiver, @NotNull OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($receiver, identifier);
    }

    public static final /* synthetic */ void access$writeDerOctetString(@NotNull BytePacketBuilder $receiver, @NotNull Function1 block) {
        CertificatesKt.writeDerOctetString($receiver, (Function1<? super BytePacketBuilder, Unit>)block);
    }

    public static final /* synthetic */ void access$writeX509Extension(@NotNull BytePacketBuilder $receiver, int id, @NotNull Function1 builder) {
        CertificatesKt.writeX509Extension($receiver, id, (Function1<? super BytePacketBuilder, Unit>)builder);
    }

    public static final /* synthetic */ void access$writeDerLength(@NotNull BytePacketBuilder $receiver, int length) {
        CertificatesKt.writeDerLength($receiver, length);
    }

    public static final /* synthetic */ void access$writeDerNull(@NotNull BytePacketBuilder $receiver) {
        CertificatesKt.writeDerNull($receiver);
    }

    public static final /* synthetic */ void access$writeX509NamePart(@NotNull BytePacketBuilder $receiver, @NotNull OID id, @NotNull String value) {
        CertificatesKt.writeX509NamePart($receiver, id, value);
    }
}

