/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.ParserKt$WhenMappings;
import io.ktor.network.tls.ServerKeyExchangeType;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.TLSExtension;
import io.ktor.network.tls.extensions.TLSExtensionType;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputArraysKt;
import io.ktor.utils.io.core.InputPrimitivesKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\tH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u0004H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0000\u001a\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\tH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0004H\u0000\u001a\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0004H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"MAX_TLS_FRAME_SIZE", "", "readCurveParams", "Lio/ktor/network/tls/extensions/NamedCurve;", "Lio/ktor/utils/io/core/ByteReadPacket;", "readECPoint", "Ljava/security/spec/ECPoint;", "fieldSize", "readShortCompatible", "Lio/ktor/utils/io/ByteReadChannel;", "(Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readTLSCertificate", "", "Ljava/security/cert/Certificate;", "readTLSHandshake", "Lio/ktor/network/tls/TLSHandshake;", "readTLSRecord", "Lio/ktor/network/tls/TLSRecord;", "readTLSServerHello", "Lio/ktor/network/tls/TLSServerHello;", "readTLSVersion", "Lio/ktor/network/tls/TLSVersion;", "readTripleByteLength", "ktor-network-tls"})
public final class ParserKt {
    private static final int MAX_TLS_FRAME_SIZE = 18432;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readTLSRecord(@NotNull ByteReadChannel $this$readTLSRecord, @NotNull Continuation<? super TLSRecord> $completion) {
        if (!($completion instanceof readTLSRecord.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readTLSRecord(null, (Continuation<? super TLSRecord>)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_5 = TLSRecordType.Companion;
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = var6_5;
                $continuation.label = 1;
                v0 = $this$readTLSRecord.readByte((Continuation)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                var6_5 = (TLSRecordType.Companion)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                var7_6 = v0;
                type = var6_5.byCode(((Number)var7_6).byteValue() & 255);
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = type;
                $continuation.label = 2;
                v1 = ParserKt.readTLSVersion($this$readTLSRecord, (Continuation<? super TLSVersion>)$continuation);
                if (v1 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl39
            }
            case 2: {
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                version = (TLSVersion)v1;
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = type;
                $continuation.L$2 = version;
                $continuation.label = 3;
                v2 = ParserKt.readShortCompatible($this$readTLSRecord, (Continuation<? super Integer>)$continuation);
                if (v2 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl54
            }
            case 3: {
                version = (TLSVersion)$continuation.L$2;
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl54:
                // 2 sources

                if ((length = ((Number)v2).intValue() & 65535) > 18432) {
                    throw (Throwable)new TLSException("Illegal TLS frame size: " + length, null, 2, null);
                }
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = type;
                $continuation.L$2 = version;
                $continuation.I$0 = length;
                $continuation.label = 4;
                v3 = ByteReadChannelKt.readPacket((ByteReadChannel)$this$readTLSRecord, (int)length, (Continuation)$continuation);
                if (v3 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl72
            }
            case 4: {
                length = $continuation.I$0;
                version = (TLSVersion)$continuation.L$2;
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl72:
                // 2 sources

                packet = (ByteReadPacket)v3;
                return new TLSRecord(type, version, packet);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final TLSHandshake readTLSHandshake(@NotNull ByteReadPacket $this$readTLSHandshake) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)$this$readTLSHandshake, (String)"$this$readTLSHandshake");
        TLSHandshake tLSHandshake = new TLSHandshake();
        boolean bl = false;
        boolean bl2 = false;
        TLSHandshake $this$apply = tLSHandshake;
        boolean bl3 = false;
        int typeAndVersion = InputPrimitivesKt.readInt((Input)((Input)$this$readTLSHandshake));
        $this$apply.setType(TLSHandshakeType.Companion.byCode(typeAndVersion >>> 24));
        int length = typeAndVersion & 0xFFFFFF;
        TLSHandshake tLSHandshake2 = $this$apply;
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl4 = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl5 = false;
            OutputKt.writeFully$default((Output)((Output)$this$buildPacket), (byte[])StringsKt.readBytes((ByteReadPacket)$this$readTLSHandshake, (int)length), (int)0, (int)0, (int)6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket byteReadPacket2 = byteReadPacket;
        tLSHandshake2.setPacket(byteReadPacket2);
        return tLSHandshake;
    }

    @NotNull
    public static final TLSServerHello readTLSServerHello(@NotNull ByteReadPacket $this$readTLSServerHello) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readTLSServerHello, (String)"$this$readTLSServerHello");
        TLSVersion version = ParserKt.readTLSVersion($this$readTLSServerHello);
        byte[] random = new byte[32];
        InputArraysKt.readFully$default((Input)((Input)$this$readTLSServerHello), (byte[])random, (int)0, (int)0, (int)6, null);
        int sessionIdLength = $this$readTLSServerHello.readByte() & 0xFF;
        if (sessionIdLength > 32) {
            throw (Throwable)new TLSException("sessionId length limit of 32 bytes exceeded: " + sessionIdLength + " specified", null, 2, null);
        }
        byte[] sessionId = new byte[32];
        InputArraysKt.readFully((Input)((Input)$this$readTLSServerHello), (byte[])sessionId, (int)0, (int)sessionIdLength);
        short suite = InputPrimitivesKt.readShort((Input)((Input)$this$readTLSServerHello));
        short s = $this$readTLSServerHello.readByte();
        int n = 255;
        boolean bl = false;
        short compressionMethod = (short)(s & n);
        if (compressionMethod != 0) {
            throw (Throwable)new TLSException("Unsupported TLS compression method " + compressionMethod + " (only null 0 compression method is supported)", null, 2, null);
        }
        if ((int)$this$readTLSServerHello.getRemaining() == 0) {
            return new TLSServerHello(version, random, sessionId, suite, compressionMethod, null, 32, null);
        }
        int extensionSize = InputPrimitivesKt.readShort((Input)((Input)$this$readTLSServerHello)) & 0xFFFF;
        if ((int)$this$readTLSServerHello.getRemaining() != extensionSize) {
            throw (Throwable)new TLSException("Invalid extensions size: requested " + extensionSize + ", available " + $this$readTLSServerHello.getRemaining(), null, 2, null);
        }
        bl = false;
        List extensions = new ArrayList();
        while ($this$readTLSServerHello.getRemaining() > 0L) {
            ByteReadPacket byteReadPacket;
            ByteReadPacket byteReadPacket2;
            int type = InputPrimitivesKt.readShort((Input)((Input)$this$readTLSServerHello)) & 0xFFFF;
            int length = InputPrimitivesKt.readShort((Input)((Input)$this$readTLSServerHello)) & 0xFFFF;
            Collection collection = extensions;
            int n2 = length;
            TLSExtensionType tLSExtensionType = TLSExtensionType.Companion.byCode(type);
            int headerSizeHint$iv = 0;
            boolean $i$f$buildPacket = false;
            boolean bl2 = false;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
            try {
                BytePacketBuilder $this$buildPacket = builder$iv;
                boolean bl3 = false;
                OutputKt.writeFully$default((Output)((Output)$this$buildPacket), (byte[])StringsKt.readBytes((ByteReadPacket)$this$readTLSServerHello, (int)length), (int)0, (int)0, (int)6, null);
                byteReadPacket2 = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket3 = byteReadPacket = byteReadPacket2;
            int n3 = n2;
            TLSExtensionType tLSExtensionType2 = tLSExtensionType;
            TLSExtension tLSExtension = new TLSExtension(tLSExtensionType2, n3, byteReadPacket3);
            boolean bl4 = false;
            collection.add(tLSExtension);
        }
        return new TLSServerHello(version, random, sessionId, suite, compressionMethod, extensions);
    }

    @NotNull
    public static final NamedCurve readCurveParams(@NotNull ByteReadPacket $this$readCurveParams) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readCurveParams, (String)"$this$readCurveParams");
        int type = $this$readCurveParams.readByte() & 0xFF;
        switch (ParserKt$WhenMappings.$EnumSwitchMapping$0[ServerKeyExchangeType.Companion.byCode(type).ordinal()]) {
            case 1: {
                short curveId = InputPrimitivesKt.readShort((Input)((Input)$this$readCurveParams));
                NamedCurve namedCurve = NamedCurve.Companion.fromCode(curveId);
                if (namedCurve == null) {
                    throw (Throwable)new TLSException("Unknown EC id", null, 2, null);
                }
                return namedCurve;
            }
            case 2: {
                String string = "ExplicitPrime server key exchange type is not yet supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            case 3: {
                String string = "ExplicitChar server key exchange type is not yet supported";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final List<Certificate> readTLSCertificate(@NotNull ByteReadPacket $this$readTLSCertificate) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readTLSCertificate, (String)"$this$readTLSCertificate");
        int certificatesChainLength = ParserKt.readTripleByteLength($this$readTLSCertificate);
        int certificateBase = 0;
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        if (certificateFactory == null) {
            Intrinsics.throwNpe();
        }
        CertificateFactory factory = certificateFactory;
        while (certificateBase < certificatesChainLength) {
            int certificateLength = ParserKt.readTripleByteLength($this$readTLSCertificate);
            if (certificateLength > certificatesChainLength - certificateBase) {
                throw (Throwable)new TLSException("Certificate length is too big", null, 2, null);
            }
            if ((long)certificateLength > $this$readTLSCertificate.getRemaining()) {
                throw (Throwable)new TLSException("Certificate length is too big", null, 2, null);
            }
            byte[] certificate = new byte[certificateLength];
            InputArraysKt.readFully$default((Input)((Input)$this$readTLSCertificate), (byte[])certificate, (int)0, (int)0, (int)6, null);
            certificateBase += certificateLength + 3;
            byte[] byArray = certificate;
            CertificateFactory certificateFactory2 = factory;
            boolean bl = false;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Certificate x509 = certificateFactory2.generateCertificate(byteArrayInputStream);
            result.add(x509);
        }
        return result;
    }

    @NotNull
    public static final ECPoint readECPoint(@NotNull ByteReadPacket $this$readECPoint, int fieldSize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readECPoint, (String)"$this$readECPoint");
        int pointSize = $this$readECPoint.readByte() & 0xFF;
        byte tag = $this$readECPoint.readByte();
        if (tag != (byte)4) {
            throw (Throwable)new TLSException("Point should be uncompressed", null, 2, null);
        }
        int componentLength = (pointSize - 1) / 2;
        if (fieldSize + 7 >>> 3 != componentLength) {
            throw (Throwable)new TLSException("Invalid point component length", null, 2, null);
        }
        return new ECPoint(new BigInteger(1, StringsKt.readBytes((ByteReadPacket)$this$readECPoint, (int)componentLength)), new BigInteger(1, StringsKt.readBytes((ByteReadPacket)$this$readECPoint, (int)componentLength)));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    static final /* synthetic */ Object readTLSVersion(@NotNull ByteReadChannel $this$readTLSVersion, @NotNull Continuation<? super TLSVersion> $completion) {
        if (!($completion instanceof readTLSVersion.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readTLSVersion(null, (Continuation<? super TLSVersion>)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = TLSVersion.Companion;
                $continuation.L$0 = $this$readTLSVersion;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = ParserKt.readShortCompatible($this$readTLSVersion, (Continuation<? super Integer>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                var2_5 = (TLSVersion.Companion)$continuation.L$1;
                $this$readTLSVersion = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                var3_6 = v0;
                return var2_5.byCode(((Number)var3_6).intValue() & 65535);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final TLSVersion readTLSVersion(@NotNull ByteReadPacket $this$readTLSVersion) {
        return TLSVersion.Companion.byCode(InputPrimitivesKt.readShort((Input)((Input)$this$readTLSVersion)) & 0xFFFF);
    }

    public static final int readTripleByteLength(@NotNull ByteReadPacket $this$readTripleByteLength) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readTripleByteLength, (String)"$this$readTripleByteLength");
        return ($this$readTripleByteLength.readByte() & 0xFF) << 16 | InputPrimitivesKt.readShort((Input)((Input)$this$readTripleByteLength)) & 0xFFFF;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readShortCompatible(@NotNull ByteReadChannel $this$readShortCompatible, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof readShortCompatible.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;
                Object L$0;
                int I$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readShortCompatible(null, (Continuation<? super Integer>)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$readShortCompatible;
                $continuation.label = 1;
                v0 = $this$readShortCompatible.readByte((Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this$readShortCompatible = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                first = ((Number)v0).byteValue() & 255;
                $continuation.L$0 = $this$readShortCompatible;
                $continuation.I$0 = first;
                $continuation.label = 2;
                v1 = $this$readShortCompatible.readByte((Continuation)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl35
            }
            case 2: {
                first = $continuation.I$0;
                $this$readShortCompatible = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                second = ((Number)v1).byteValue() & 255;
                return Boxing.boxInt((int)((first << 8) + second));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

