/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.NoPrivateKeyException;
import io.ktor.network.tls.TLSConfigBuilder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a%\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"findTrustManager", "Ljavax/net/ssl/X509TrustManager;", "addCertificateChain", "", "Lio/ktor/network/tls/TLSConfigBuilder;", "chain", "", "Ljava/security/cert/X509Certificate;", "key", "Ljava/security/PrivateKey;", "(Lio/ktor/network/tls/TLSConfigBuilder;[Ljava/security/cert/X509Certificate;Ljava/security/PrivateKey;)V", "addKeyStore", "store", "Ljava/security/KeyStore;", "password", "", "ktor-network-tls"})
public final class TLSConfigBuilderKt {
    public static final void addCertificateChain(@NotNull TLSConfigBuilder $this$addCertificateChain, @NotNull X509Certificate[] chain, @NotNull PrivateKey key) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addCertificateChain, (String)"$this$addCertificateChain");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Collection collection = $this$addCertificateChain.getCertificates();
        CertificateAndKey certificateAndKey = new CertificateAndKey(chain, key);
        boolean bl = false;
        collection.add(certificateAndKey);
    }

    /*
     * WARNING - void declaration
     */
    public static final void addKeyStore(@NotNull TLSConfigBuilder $this$addKeyStore, @NotNull KeyStore store, @NotNull char[] password) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$addKeyStore, (String)"$this$addKeyStore");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        String string = KeyManagerFactory.getDefaultAlgorithm();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String keyManagerAlgorithm = string;
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        if (keyManagerFactory == null) {
            Intrinsics.throwNpe();
        }
        KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
        keyManagerFactory2.init(store, password);
        KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyManagerArray, (String)"keyManagerFactory.keyManagers");
        KeyManager[] $this$filterIsInstance$iv = keyManagerArray;
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof X509KeyManager)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List managers = (List)destination$iv$iv;
        Enumeration<String> enumeration = store.aliases();
        if (enumeration == null) {
            Intrinsics.throwNpe();
        }
        Enumeration<String> aliases = enumeration;
        object = CollectionsKt.iterator(aliases);
        block1: while (object.hasNext()) {
            boolean bl;
            Certificate[] it;
            Certificate[] chain;
            String alias;
            block12: {
                alias = (String)object.next();
                chain = store.getCertificateChain(alias);
                Intrinsics.checkExpressionValueIsNotNull((Object)chain, (String)"chain");
                Certificate[] $this$all$iv = chain;
                boolean $i$f$all = false;
                Certificate[] certificateArray = $this$all$iv;
                int element$iv$iv = certificateArray.length;
                for (int i = 0; i < element$iv$iv; ++i) {
                    Certificate[] element$iv;
                    it = element$iv = certificateArray[i];
                    boolean bl2 = false;
                    if (it instanceof X509Certificate) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
            boolean allX509 = bl;
            boolean $this$all$iv = false;
            int n = 0;
            if (!allX509) {
                boolean bl3 = false;
                String string2 = "Fail to add key store " + store + ". Only X509 certificate format supported.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            for (X509KeyManager manager : managers) {
                PrivateKey key;
                void $this$toTypedArray$iv;
                X509Certificate[] x509CertificateArray;
                Object object2;
                void $this$mapTo$iv$iv;
                if (manager.getPrivateKey(alias) == null) {
                    continue;
                }
                Object $this$map$iv = chain;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(((Certificate[])$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var20_30 = $this$mapTo$iv$iv;
                int n2 = ((void)var20_30).length;
                for (int i = 0; i < n2; ++i) {
                    void it2;
                    void item$iv$iv;
                    void var24_34 = item$iv$iv = var20_30[i];
                    object2 = destination$iv$iv2;
                    boolean bl4 = false;
                    void v5 = it2;
                    if (v5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                    }
                    x509CertificateArray = (X509Certificate[])v5;
                    object2.add(x509CertificateArray);
                }
                List map = (List)destination$iv$iv2;
                $this$map$iv = map;
                object2 = $this$addKeyStore;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new X509Certificate[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                TLSConfigBuilderKt.addCertificateChain((TLSConfigBuilder)object2, x509CertificateArray, key);
                continue block1;
            }
            String string3 = alias;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"alias");
            throw (Throwable)new NoPrivateKeyException(string3, store);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final X509TrustManager findTrustManager() {
        void $this$filterIsInstanceTo$iv$iv;
        TrustManager[] manager;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (trustManagerFactory == null) {
            Intrinsics.throwNpe();
        }
        TrustManagerFactory factory = trustManagerFactory;
        factory.init((KeyStore)null);
        TrustManager[] trustManagerArray = factory.getTrustManagers();
        if (trustManagerArray == null) {
            Intrinsics.throwNpe();
        }
        TrustManager[] $this$filterIsInstance$iv = manager = trustManagerArray;
        boolean $i$f$filterIsInstance = false;
        TrustManager[] trustManagerArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof X509TrustManager)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (X509TrustManager)CollectionsKt.first((List)((List)destination$iv$iv));
    }

    public static final /* synthetic */ X509TrustManager access$findTrustManager() {
        return TLSConfigBuilderKt.findTrustManager();
    }
}

