/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.util.CryptoKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\f\u0010\u001f\u001a\u00020\u001a*\u00020 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/ktor/network/tls/cipher/CBCCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "suite", "Lio/ktor/network/tls/CipherSuite;", "keyMaterial", "", "(Lio/ktor/network/tls/CipherSuite;[B)V", "inputCounter", "", "outputCounter", "receiveCipher", "Ljavax/crypto/Cipher;", "receiveKey", "Ljavax/crypto/spec/SecretKeySpec;", "receiveMac", "Ljavax/crypto/Mac;", "sendCipher", "sendKey", "sendMac", "decrypt", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "prepareMac", "content", "validateMac", "", "macOffset", "", "validatePadding", "paddingStart", "writePadding", "Lio/ktor/utils/io/core/BytePacketBuilder;", "ktor-network-tls"})
public final class CBCCipher
implements TLSCipher {
    private final Cipher sendCipher;
    private final SecretKeySpec sendKey;
    private final Mac sendMac;
    private final Cipher receiveCipher;
    private final SecretKeySpec receiveKey;
    private final Mac receiveMac;
    private long inputCounter;
    private long outputCounter;
    private final CipherSuite suite;
    private final byte[] keyMaterial;

    @Override
    @NotNull
    public TLSRecord encrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        this.sendCipher.init(1, (Key)this.sendKey, new IvParameterSpec(CryptoKt.generateNonce((int)this.suite.getFixedIvLength())));
        byte[] content = StringsKt.readBytes$default((ByteReadPacket)record.getPacket(), (int)0, (int)1, null);
        byte[] macBytes = this.prepareMac(record, content);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully$default((Output)((Output)$this$buildPacket), (byte[])content, (int)0, (int)0, (int)6, null);
            OutputKt.writeFully$default((Output)((Output)$this$buildPacket), (byte[])macBytes, (int)0, (int)0, (int)6, null);
            this.writePadding($this$buildPacket);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encryptionData = byteReadPacket;
        ByteReadPacket packet2 = CipherUtilsKt.cipherLoop(encryptionData, this.sendCipher, (Function1<? super BytePacketBuilder, Unit>)((Function1)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ CBCCipher this$0;

            public final void invoke(@NotNull BytePacketBuilder $this$cipherLoop) {
                Intrinsics.checkParameterIsNotNull((Object)$this$cipherLoop, (String)"$receiver");
                Output output2 = (Output)$this$cipherLoop;
                byte[] byArray = CBCCipher.access$getSendCipher$p(this.this$0).getIV();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sendCipher.iv");
                OutputKt.writeFully$default((Output)output2, (byte[])byArray, (int)0, (int)0, (int)6, null);
            }
            {
                this.this$0 = cBCCipher;
                super(1);
            }
        }));
        return new TLSRecord(record.getType(), null, packet2, 2, null);
    }

    @Override
    @NotNull
    public TLSRecord decrypt(@NotNull TLSRecord record) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        ByteReadPacket packet2 = record.getPacket();
        byte[] serverIV = StringsKt.readBytes((ByteReadPacket)packet2, (int)this.suite.getFixedIvLength());
        this.receiveCipher.init(2, (Key)this.receiveKey, new IvParameterSpec(serverIV));
        byte[] content = StringsKt.readBytes$default((ByteReadPacket)CipherUtilsKt.cipherLoop$default(packet2, this.receiveCipher, null, 2, null), (int)0, (int)1, null);
        int paddingLength = content[content.length - 1] & 0xFF;
        int paddingStart = content.length - paddingLength - 1;
        int macStart = paddingStart - this.suite.getMacStrengthInBytes();
        this.validatePadding(content, paddingStart);
        this.validateMac(record, content, macStart);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully((Output)((Output)$this$buildPacket), (byte[])content, (int)0, (int)macStart);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket decryptedContent = byteReadPacket;
        return new TLSRecord(record.getType(), record.getVersion(), decryptedContent);
    }

    private final byte[] prepareMac(TLSRecord record, byte[] content) {
        this.sendMac.reset();
        this.sendMac.init(KeysKt.clientMacKey(this.keyMaterial, this.suite));
        byte[] byArray = new byte[13];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        CipherKt.set(it, 0, this.outputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)content.length);
        byte[] header = byArray;
        ++this.outputCounter;
        this.sendMac.update(header);
        byte[] byArray2 = this.sendMac.doFinal(content);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"sendMac.doFinal(content)");
        return byArray2;
    }

    private final void writePadding(@NotNull BytePacketBuilder $this$writePadding) {
        int lastBlockSize = ($this$writePadding.getSize() + 1) % this.sendCipher.getBlockSize();
        byte paddingSize = (byte)(this.sendCipher.getBlockSize() - lastBlockSize);
        int n = paddingSize + 1;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            $this$writePadding.writeByte(paddingSize);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePadding(byte[] content, int paddingStart) {
        int padding = content[content.length - 1] & 0xFF;
        int n = paddingStart;
        int n2 = content.length;
        while (n < n2) {
            void i;
            int n3 = content[i] & 0xFF;
            if (padding != n3) {
                throw (Throwable)new TLSException("Padding invalid: expected " + padding + ", actual " + n3, null, 2, null);
            }
            ++i;
        }
    }

    private final void validateMac(TLSRecord record, byte[] content, int macOffset) {
        byte[] actual;
        byte[] expectedMac;
        this.receiveMac.reset();
        this.receiveMac.init(KeysKt.serverMacKey(this.keyMaterial, this.suite));
        byte[] byArray = new byte[13];
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        CipherKt.set(it, 0, this.inputCounter);
        it[8] = (byte)record.getType().getCode();
        it[9] = 3;
        it[10] = 3;
        CipherKt.set(it, 11, (short)macOffset);
        byte[] header = byArray;
        long l = this.inputCounter;
        this.inputCounter = l + 1L;
        this.receiveMac.update(header);
        this.receiveMac.update(content, 0, macOffset);
        byte[] byArray2 = this.receiveMac.doFinal();
        if (byArray2 == null) {
            Intrinsics.throwNpe();
        }
        if (!MessageDigest.isEqual(expectedMac = byArray2, actual = ArraysKt.sliceArray((byte[])content, (IntRange)RangesKt.until((int)macOffset, (int)(macOffset + this.suite.getMacStrengthInBytes()))))) {
            throw (Throwable)new TLSException("Failed to verify MAC content", null, 2, null);
        }
    }

    public CBCCipher(@NotNull CipherSuite suite, @NotNull byte[] keyMaterial2) {
        Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
        Intrinsics.checkParameterIsNotNull((Object)keyMaterial2, (String)"keyMaterial");
        this.suite = suite;
        this.keyMaterial = keyMaterial2;
        Cipher cipher2 = Cipher.getInstance(this.suite.getJdkCipherName());
        if (cipher2 == null) {
            Intrinsics.throwNpe();
        }
        this.sendCipher = cipher2;
        this.sendKey = KeysKt.clientKey(this.keyMaterial, this.suite);
        Mac mac = Mac.getInstance(this.suite.getMacName());
        if (mac == null) {
            Intrinsics.throwNpe();
        }
        this.sendMac = mac;
        Cipher cipher3 = Cipher.getInstance(this.suite.getJdkCipherName());
        if (cipher3 == null) {
            Intrinsics.throwNpe();
        }
        this.receiveCipher = cipher3;
        this.receiveKey = KeysKt.serverKey(this.keyMaterial, this.suite);
        Mac mac2 = Mac.getInstance(this.suite.getMacName());
        if (mac2 == null) {
            Intrinsics.throwNpe();
        }
        this.receiveMac = mac2;
    }

    public static final /* synthetic */ Cipher access$getSendCipher$p(CBCCipher $this) {
        return $this.sendCipher;
    }
}

