/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.util;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.pool.DefaultPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00060\u0002j\u0002`\u00032\n\u0010\u000b\u001a\u00060\u0002j\u0002`\u0003H\u0014J\f\u0010\f\u001a\u00060\u0002j\u0002`\u0003H\u0014J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000b\u001a\u00060\u0002j\u0002`\u0003H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/ktor/network/util/DirectByteBufferPool;", "Lkotlinx/io/pool/DefaultPool;", "Ljava/nio/ByteBuffer;", "Lkotlinx/coroutines/experimental/io/ByteBuffer;", "bufferSize", "", "size", "(II)V", "getBufferSize", "()I", "clearInstance", "instance", "produceInstance", "validateInstance", "", "ktor-network"})
public final class DirectByteBufferPool
extends DefaultPool<ByteBuffer> {
    private final int bufferSize;

    @NotNull
    protected ByteBuffer produceInstance() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"java.nio.ByteBuffer.allocateDirect(bufferSize)");
        return byteBuffer;
    }

    @NotNull
    protected ByteBuffer clearInstance(@NotNull ByteBuffer instance) {
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        instance.clear();
        return instance;
    }

    protected void validateInstance(@NotNull ByteBuffer instance) {
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        boolean bl = instance.isDirect();
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl2 = bl = instance.capacity() == this.bufferSize;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public DirectByteBufferPool(int bufferSize, int size) {
        super(size);
        this.bufferSize = bufferSize;
    }
}

