/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.Configurable;
import io.ktor.network.sockets.SocketOptions;
import io.ktor.network.sockets.TcpSocketBuilder;
import io.ktor.network.sockets.UDPSocketBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/ktor/network/sockets/SocketBuilder;", "Lio/ktor/network/sockets/Configurable;", "selector", "Lio/ktor/network/selector/SelectorManager;", "options", "Lio/ktor/network/sockets/SocketOptions;", "(Lio/ktor/network/selector/SelectorManager;Lio/ktor/network/sockets/SocketOptions;)V", "getOptions", "()Lio/ktor/network/sockets/SocketOptions;", "setOptions", "(Lio/ktor/network/sockets/SocketOptions;)V", "getSelector", "()Lio/ktor/network/selector/SelectorManager;", "tcp", "Lio/ktor/network/sockets/TcpSocketBuilder;", "udp", "Lio/ktor/network/sockets/UDPSocketBuilder;", "ktor-network"})
public final class SocketBuilder
implements Configurable<SocketBuilder> {
    @NotNull
    private final SelectorManager selector;
    @NotNull
    private SocketOptions options;

    @NotNull
    public final TcpSocketBuilder tcp() {
        return new TcpSocketBuilder(this.selector, this.getOptions());
    }

    @NotNull
    public final UDPSocketBuilder udp() {
        return new UDPSocketBuilder(this.selector, this.getOptions());
    }

    @NotNull
    public final SelectorManager getSelector() {
        return this.selector;
    }

    @Override
    @NotNull
    public SocketOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(@NotNull SocketOptions socketOptions) {
        Intrinsics.checkParameterIsNotNull((Object)socketOptions, (String)"<set-?>");
        this.options = socketOptions;
    }

    public SocketBuilder(@NotNull SelectorManager selector, @NotNull SocketOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.selector = selector;
        this.options = options;
    }

    @Override
    @NotNull
    public SocketBuilder configure(@NotNull Function1<? super SocketOptions, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        return Configurable.DefaultImpls.configure(this, block);
    }
}

