/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.KTypesJvm;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PlatformUtilsKt;
import kotlinx.serialization.SerializerResolvingKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.builtins.CollectionSerializersKt;
import kotlinx.serialization.builtins.PrimitiveSerializersKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u0014\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0001*\u0006\u0012\u0002\b\u00030\tH\u0002\u00a8\u0006\n"}, d2={"arraySerializer", "Lkotlinx/serialization/KSerializer;", "type", "Lkotlin/reflect/KType;", "serializerByTypeInfo", "serializerForSending", "value", "", "elementSerializer", "", "ktor-serialization"})
public final class SerializerLookupKt {
    @NotNull
    public static final KSerializer<?> serializerByTypeInfo(@NotNull KType type) {
        KClass classifierClass;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        if (!(kClassifier instanceof KClass)) {
            kClassifier = null;
        }
        if ((classifierClass = (KClass)kClassifier) != null && JvmClassMappingKt.getJavaClass((KClass)classifierClass).isArray()) {
            return SerializerLookupKt.arraySerializer(type);
        }
        return SerializerResolvingKt.serializer((KType)type);
    }

    private static final KSerializer<?> arraySerializer(KType type) {
        KType kType = ((KTypeProjection)type.getArguments().get(0)).getType();
        if (kType == null) {
            String string = "Array<*> is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KType elementType = kType;
        KSerializer<?> elementSerializer = SerializerLookupKt.serializerByTypeInfo(elementType);
        KClass kClass = KTypesJvm.getJvmErasure((KType)elementType);
        if (kClass == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
        }
        KSerializer<?> kSerializer = elementSerializer;
        if (kSerializer == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        }
        return PrimitiveSerializersKt.ArraySerializer((KClass)kClass, kSerializer);
    }

    @NotNull
    public static final KSerializer<?> serializerForSending(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof JsonElement) {
            return (KSerializer)JsonElementSerializer.INSTANCE;
        }
        if (value instanceof List) {
            return CollectionSerializersKt.ListSerializer(SerializerLookupKt.elementSerializer((Collection)value));
        }
        if (value instanceof Set) {
            return CollectionSerializersKt.SetSerializer(SerializerLookupKt.elementSerializer((Collection)value));
        }
        if (value instanceof Map) {
            return CollectionSerializersKt.MapSerializer(SerializerLookupKt.elementSerializer(((Map)value).keySet()), SerializerLookupKt.elementSerializer(((Map)value).values()));
        }
        if (value instanceof Map.Entry) {
            Object k = ((Map.Entry)value).getKey();
            if (k == null) {
                String string = "Map.Entry(null, ...) is not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KSerializer<?> kSerializer = SerializerLookupKt.serializerForSending(k);
            Object v = ((Map.Entry)value).getValue();
            if (v == null) {
                String string = "Map.Entry(..., null) is not supported)";
                KSerializer<?> kSerializer2 = kSerializer;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return BuiltinSerializersKt.MapEntrySerializer(kSerializer, SerializerLookupKt.serializerForSending(v));
        }
        if (value instanceof Object[]) {
            KClass componentClass;
            KType componentType = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)JvmClassMappingKt.getKotlinClass(((Object[])value).getClass().getComponentType())));
            KClassifier kClassifier = componentType.getClassifier();
            if (!(kClassifier instanceof KClass)) {
                kClassifier = null;
            }
            KClass kClass = (KClass)kClassifier;
            if (kClass == null) {
                String string = "Unsupported component type " + componentType;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KClass kClass2 = componentClass = kClass;
            if (kClass2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
            }
            KSerializer<?> kSerializer = SerializerLookupKt.serializerByTypeInfo(componentType);
            if (kSerializer == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
            }
            return PrimitiveSerializersKt.ArraySerializer((KClass)kClass2, kSerializer);
        }
        return PlatformUtilsKt.serializer((KClass)Reflection.getOrCreateKotlinClass(value.getClass()));
    }

    /*
     * WARNING - void declaration
     */
    private static final KSerializer<?> elementSerializer(@NotNull Collection<?> $this$elementSerializer) {
        boolean bl;
        KSerializer selected;
        block13: {
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$elementSerializer;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KSerializer<?> kSerializer;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object value = element$iv$iv;
                boolean bl3 = false;
                if (value != null) {
                    Object t;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = t;
                    boolean bl6 = false;
                    kSerializer = SerializerLookupKt.serializerForSending(it);
                } else {
                    kSerializer = null;
                }
                if (kSerializer == null) continue;
                KSerializer<?> kSerializer2 = kSerializer;
                boolean bl7 = false;
                boolean bl8 = false;
                KSerializer<?> it$iv$iv = kSerializer2;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy2 = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                KSerializer it = (KSerializer)e$iv;
                boolean bl10 = false;
                String key$iv = it.getDescriptor().getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List serializers = list$iv;
            if (serializers.size() > 1) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv22;
                Iterable $i$f$distinctBy2 = serializers;
                StringBuilder stringBuilder = new StringBuilder().append("Serializing collections of different element types is not yet supported. ").append("Selected serializers: ");
                boolean $i$f$map = false;
                list$iv = $this$map$iv22;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    element$iv$iv$iv = (KSerializer)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl11 = false;
                    String string = it.getDescriptor().getName();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv2;
                String message = stringBuilder.append(collection).toString();
                boolean $this$map$iv22 = false;
                throw (Throwable)new IllegalStateException(message.toString());
            }
            KSerializer kSerializer = (KSerializer)CollectionsKt.singleOrNull((List)serializers);
            if (kSerializer == null) {
                kSerializer = selected = PrimitiveSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE);
            }
            if (selected.getDescriptor().isNullable()) {
                return selected;
            }
            if (selected == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
            }
            Iterable $this$any$iv = $this$elementSerializer;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl12 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return BuiltinSerializersKt.getNullable((KSerializer)selected);
        }
        return selected;
    }
}

