/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class GeneratorOutput {
    final Filer filer;
    final File outDirFile;

    public static GeneratorOutput create(String outDir) throws IOException {
        return GeneratorOutput.create(GeneratorOutput.toFileForceExists(outDir));
    }

    public static GeneratorOutput create(File outDirFile) {
        return new GeneratorOutput(null, outDirFile);
    }

    public static GeneratorOutput create(Filer filer) {
        return new GeneratorOutput(filer, null);
    }

    private GeneratorOutput(Filer filer, File outDirFile) {
        this.filer = filer;
        this.outDirFile = outDirFile;
    }

    protected Writer createWriter(String javaPackage, String fileOrJavaClassName, String fileExtension) throws IOException {
        if (this.outDirFile != null) {
            return new FileWriter(this.getFileOrNull(javaPackage, fileOrJavaClassName, fileExtension));
        }
        if (this.filer != null && ".java".equals(fileExtension)) {
            String fileName = javaPackage != null && javaPackage.length() != 0 ? javaPackage + "." + fileOrJavaClassName : fileOrJavaClassName;
            JavaFileObject sourceFile = this.filer.createSourceFile(fileName, new Element[0]);
            return sourceFile.openWriter();
        }
        throw new IllegalStateException("Info missing");
    }

    protected File getFileOrNull(String javaPackage, String fileName, String fileExtension) {
        if (this.outDirFile != null) {
            File file = this.toFile(this.outDirFile, javaPackage, fileName, fileExtension);
            file.getParentFile().mkdirs();
            return file;
        }
        return null;
    }

    private static File toFileForceExists(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException(String.format("%s does not exist. This check is to prevent accidental file generation into a wrong path. (resolved path=%s)", filename, file.getAbsolutePath()));
        }
        return file;
    }

    private File toFile(File outDirFile, String javaPackage, String fileName, String fileExtension) {
        String packageSubPath = javaPackage.replace('.', '/');
        File packagePath = new File(outDirFile, packageSubPath);
        return new File(packagePath, fileName + fileExtension);
    }
}

