/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator;

import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.Property;
import io.objectbox.generator.model.PropertyType;
import java.util.List;
import org.greenrobot.essentials.collections.Multimap;

class PropertyCollector {
    private static final String INDENT = "        ";
    private static final String INDENT_EX = "                ";
    private static final String BR_INDENT_EX = "\n                ";
    private static final String SEP_BR = ",\n                ";
    private final Entity entity;
    private final Multimap<PropertyType, Property> propertiesByType;
    private final Property idProperty;

    public PropertyCollector(Entity entity) {
        this.entity = entity;
        this.propertiesByType = Multimap.create();
        for (Property property : entity.getProperties()) {
            if (property.isPrimaryKey()) continue;
            this.propertiesByType.putElement((Object)property.getPropertyType(), (Object)property);
        }
        this.idProperty = entity.getPkProperty();
        if (this.idProperty == null) {
            throw new IllegalStateException("No ID property found for \"" + entity + "\" (use @Id on a property of type long)");
        }
    }

    String createPropertyCollector() {
        boolean last;
        StringBuilder preCall = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder all = new StringBuilder();
        boolean first = true;
        int previousPropertyCount = this.propertiesByType.countElements();
        boolean bl = last = previousPropertyCount == 0;
        while (first || !last) {
            int countByteArrays = this.propertiesByType.countElements((Object)PropertyType.ByteArray);
            int countScalarsNonFP = this.countScalarsNonFP();
            int countFloats = this.propertiesByType.countElements((Object)PropertyType.Float);
            int countDoubles = this.propertiesByType.countElements((Object)PropertyType.Double);
            int maxCountFP = Math.max(countFloats, countDoubles);
            int countStrings = this.propertiesByType.countElements((Object)PropertyType.String);
            String collectSignature = countStrings > 3 || countByteArrays > 1 ? (countByteArrays > 0 ? this.appendProperties430000(properties, preCall) : this.appendProperties400000(properties, preCall)) : (countStrings == 0 && countByteArrays == 0 && maxCountFP > 1 && maxCountFP > (countScalarsNonFP + 1) / 2 ? this.appendProperties002033(properties, preCall) : (this.propertiesByType.countElements() == countScalarsNonFP && (countScalarsNonFP <= 4 || countScalarsNonFP > 6 && countScalarsNonFP < 9) ? this.appendProperties004000(properties, preCall) : this.appendProperties313311(properties, preCall)));
            int propertyCount = this.propertiesByType.countElements();
            if (!first && propertyCount == previousPropertyCount) {
                throw new RuntimeException("Could not collect properties: " + this.propertiesByType.valuesElements());
            }
            last = propertyCount == 0;
            this.appendCollectCall(collectSignature, all, preCall, properties, first, last);
            first = false;
            previousPropertyCount = propertyCount;
            properties.setLength(0);
            preCall.setLength(0);
        }
        return all.toString();
    }

    private int countScalarsNonFP() {
        return this.propertiesByType.countElements((Object)PropertyType.Date) + this.propertiesByType.countElements((Object)PropertyType.Long) + this.propertiesByType.countElements((Object)PropertyType.Int) + this.propertiesByType.countElements((Object)PropertyType.Short) + this.propertiesByType.countElements((Object)PropertyType.Char) + this.propertiesByType.countElements((Object)PropertyType.Byte) + this.propertiesByType.countElements((Object)PropertyType.Boolean);
    }

    private String appendProperties313311(StringBuilder properties, StringBuilder preCall) {
        this.appendProperty(preCall, properties, PropertyType.String, false).append(", ");
        this.appendProperty(preCall, properties, PropertyType.String, false).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.String, false).append(", ");
        this.appendProperty(preCall, properties, PropertyType.ByteArray, false).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Int, true).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Int, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Int, true).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Float, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Double, true).append(");\n\n");
        return "313311";
    }

    private String appendProperties430000(StringBuilder properties, StringBuilder preCall) {
        this.appendProperty(preCall, properties, PropertyType.String, false).append(", ");
        this.appendProperty(preCall, properties, PropertyType.String, false).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.String, false).append(", ");
        this.appendProperty(preCall, properties, PropertyType.String, false).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.ByteArray, false).append(", ");
        this.appendProperty(preCall, properties, PropertyType.ByteArray, false).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.ByteArray, false).append(");\n\n");
        return "430000";
    }

    private String appendProperties400000(StringBuilder properties, StringBuilder preCall) {
        this.appendProperty(preCall, properties, PropertyType.String, false).append(", ");
        this.appendProperty(preCall, properties, PropertyType.String, false).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.String, false).append(", ");
        this.appendProperty(preCall, properties, PropertyType.String, false).append(");\n\n");
        return "400000";
    }

    private String appendProperties002033(StringBuilder properties, StringBuilder preCall) {
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Float, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Float, true).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Float, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Double, true).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Double, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Double, true).append(");\n\n");
        return "002033";
    }

    private String appendProperties004000(StringBuilder properties, StringBuilder preCall) {
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(SEP_BR);
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(", ");
        this.appendProperty(preCall, properties, PropertyType.Long, true).append(");\n\n");
        return "004000";
    }

    private StringBuilder appendProperty(StringBuilder preCall, StringBuilder sb, PropertyType type, boolean isScalar) {
        List properties = (List)this.propertiesByType.get((Object)type);
        if (properties == null || properties.isEmpty()) {
            if (type == PropertyType.Long) {
                return this.appendProperty(preCall, sb, PropertyType.RelationId, isScalar);
            }
            if (type == PropertyType.RelationId) {
                return this.appendProperty(preCall, sb, PropertyType.Date, isScalar);
            }
            if (type == PropertyType.Date) {
                return this.appendProperty(preCall, sb, PropertyType.Int, isScalar);
            }
            if (type == PropertyType.Int) {
                return this.appendProperty(preCall, sb, PropertyType.Short, isScalar);
            }
            if (type == PropertyType.Short) {
                return this.appendProperty(preCall, sb, PropertyType.Char, isScalar);
            }
            if (type == PropertyType.Char) {
                return this.appendProperty(preCall, sb, PropertyType.Byte, isScalar);
            }
            if (type == PropertyType.Byte) {
                return this.appendProperty(preCall, sb, PropertyType.Boolean, isScalar);
            }
            if (isScalar) {
                sb.append("0, 0");
            } else {
                sb.append("0, null");
            }
        } else {
            Property property = (Property)properties.remove(0);
            String name = property.getPropertyName();
            String propertyId = "__ID_" + name;
            String propertyIdLocal = "__id" + property.getOrdinal();
            if (property.isNonPrimitiveType()) {
                preCall.append(INDENT).append(property.getJavaTypeInEntity()).append(' ').append(name).append(" = ").append(this.getValue(property)).append(";\n");
                preCall.append(INDENT).append("int ").append(propertyIdLocal).append(" = ").append(name).append(" != null ? ").append(propertyId).append(" : 0;\n");
                sb.append(propertyIdLocal).append(", ");
                if (isScalar || property.getCustomType() != null) {
                    sb.append(propertyIdLocal).append(" != 0 ? ").append(property.getDatabaseValueExpression(name)).append(isScalar ? " : 0" : " : null");
                } else {
                    sb.append(property.getDatabaseValueExpression(name));
                }
            } else {
                sb.append(propertyId).append(", ").append("entity.");
                if (property.isVirtual()) {
                    if (property.getVirtualTargetValueExpression() != null) {
                        sb.append(property.getVirtualTargetValueExpression());
                    } else {
                        sb.append(property.getVirtualTargetName());
                    }
                    sb.append(".getTargetId()");
                } else {
                    sb.append(property.getDatabaseValueExpression());
                }
            }
        }
        return sb;
    }

    private void appendCollectCall(String collectSignature, StringBuilder all, StringBuilder preCall, StringBuilder call, boolean first, boolean last) {
        if (last && this.idProperty.isNonPrimitiveType()) {
            all.append(INDENT).append(this.idProperty.getJavaTypeInEntity()).append(' ').append(this.idProperty.getPropertyName()).append(" = ").append(this.getValue(this.idProperty)).append(";\n");
        }
        if (preCall.length() > 0) {
            all.append((CharSequence)preCall).append('\n');
        }
        all.append(INDENT);
        if (last) {
            all.append("long __assignedId = ");
        }
        all.append("collect").append(collectSignature).append("(cursor, ");
        if (last) {
            if (this.idProperty.isNonPrimitiveType()) {
                all.append(this.idProperty.getPropertyName()).append(" != null ? ").append(this.idProperty.getPropertyName()).append(": 0");
            } else {
                all.append(this.getValue(this.idProperty));
            }
            all.append(", ");
        } else {
            all.append("0, ");
        }
        String flags = first && last ? "PUT_FLAG_FIRST | PUT_FLAG_COMPLETE" : (first ? "PUT_FLAG_FIRST" : (last ? "PUT_FLAG_COMPLETE" : "0"));
        all.append(flags).append(',').append(BR_INDENT_EX);
        all.append((CharSequence)call);
        if (last) {
            all.append(INDENT).append(this.setValue(this.idProperty, "__assignedId")).append(";\n");
        }
    }

    private String getValue(Property property) {
        return "entity." + property.getValueExpression();
    }

    private String setValue(Property property, String value) {
        return "entity." + property.getSetValueExpression(value);
    }

    private String nameCapFirst(Property property) {
        return TextUtil.capFirst(property.getPropertyName());
    }
}

