<#--

Copyright (C) 2017-2018 ObjectBox Ltd.

This file is part of ObjectBox Build Tools.

ObjectBox Build Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
ObjectBox Build Tools is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ObjectBox Build Tools.  If not, see <http://www.gnu.org/licenses/>.

-->
<#-- @ftlvariable name="schema" type="io.objectbox.generator.model.Schema" -->
<#-- @ftlvariable name="imports" type="java.util.Set<String>" -->

<#if schema.defaultJavaPackageDao?length != 0>package ${schema.defaultJavaPackageDao};</#if>

<#list imports as import>
import ${import};
</#list>

// THIS CODE IS GENERATED BY ObjectBox, DO NOT EDIT.
/**
 * Starting point for working with your ObjectBox. All boxes are set up for your objects here.
 * <p>
 * First steps (Android): get a builder using {@link #builder()}, call {@link BoxStoreBuilder#androidContext(Object)},
 * and {@link BoxStoreBuilder#build()} to get a {@link BoxStore} to work with.
 */
public class MyObjectBox {

    public static BoxStoreBuilder builder() {
        BoxStoreBuilder builder = new BoxStoreBuilder(getModel());
<#list schema.entities as entity>
        builder.entity(${entity.className}_.__INSTANCE);
</#list>
        return builder;
    }

    private static byte[] getModel() {
        ModelBuilder modelBuilder = new ModelBuilder();
<#if schema.lastEntityId??>
        modelBuilder.lastEntityId(${schema.lastEntityId.id?c}, ${schema.lastEntityId.uid?c}L);
</#if>
<#if schema.lastIndexId??>
        modelBuilder.lastIndexId(${schema.lastIndexId.id?c}, ${schema.lastIndexId.uid?c}L);
</#if>
<#if schema.lastRelationId??>
        modelBuilder.lastRelationId(${schema.lastRelationId.id?c}, ${schema.lastRelationId.uid?c}L);
</#if>

<#-- To avoid reaching Java method size limit of 65534 bytes add separate method for each entity. -->
<#list schema.entities as entity>
        buildEntity${entity.className}(modelBuilder);
</#list>

        return modelBuilder.build();
    }

<#list schema.entities as entity>
    private static void buildEntity${entity.className}(ModelBuilder modelBuilder) {
        EntityBuilder entityBuilder = modelBuilder.entity("${entity.dbName}");
    <#if entity.modelId??>
        entityBuilder.id(${entity.modelId?c}, ${entity.modelUid?c}L)<#if
        entity.lastPropertyId??>.lastPropertyId(${entity.lastPropertyId.id?c}, ${entity.lastPropertyId.uid?c}L)</#if>;
    </#if>
    <#assign entityFlags = entity.entityFlagsNames>
    <#if (entityFlags?size > 0)>
        entityBuilder.flags(${entityFlags?join(" | ")});
    </#if>

    <#list entity.propertiesColumns as property>
        <#assign propertyFlags = property.propertyFlagsNames>
        entityBuilder.property("${property.dbName}", <#--
        --><#if property.targetEntity??>"${property.targetEntity.dbName}", <#--
            --><#if property.virtualTargetName??>"${property.virtualTargetName}", </#if></#if><#--
        -->PropertyType.${property.dbType})<#--
        --><#if property.propertyName != property.dbName>.secondaryName("${property.propertyName}")</#if><#--
        --><#if property.modelId??>.id(${property.modelId.id?c}, ${property.modelId.uid?c}L)</#if><#--
        --><#if (propertyFlags?size > 0)>

                .flags(${propertyFlags?join(" | ")})</#if><#--
        --><#if property.index?? && (property.index.maxValueLength > 0)>.indexMaxValueLength(${property.index.maxValueLength?c})</#if><#--
        --><#if property.modelIndexId??>.indexId(${property.modelIndexId.id?c}, ${property.modelIndexId.uid?c}L)</#if>;
    </#list>

    <#list entity.toManyRelations as toMany>
        <#if toMany.modelId??>
        entityBuilder.relation("${toMany.dbName}", ${toMany.modelId.id?c}, ${toMany.modelId.uid?c}L, ${toMany.targetEntity.modelId?c}, ${toMany.targetEntity.modelUid?c}L);
        </#if>
    </#list>

        entityBuilder.entityDone();
    }

</#list>

}
