/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.DuplicateMetricStorageException;

public final class DebugUtils {
    private DebugUtils() {
    }

    static String duplicateMetricErrorMessage(DuplicateMetricStorageException ex) {
        return DebugUtils.duplicateMetricErrorMessage(ex.getExisting(), ex.getConflict());
    }

    public static String duplicateMetricErrorMessage(MetricDescriptor existing, MetricDescriptor conflict) {
        StringBuilder result = new StringBuilder("Found duplicate metric definition: ");
        result.append(existing.getName()).append("\n");
        if (!conflict.getName().equals(conflict.getSourceInstrument().getName())) {
            result.append("\tVIEW defined\n");
            conflict.getSourceView().ifPresent(v -> result.append(v.getSourceInfo().multiLineDebugString()));
            result.append("\tFROM instrument ").append(conflict.getSourceInstrument().getName()).append("\n").append(conflict.getSourceInstrument().getSourceInfo().multiLineDebugString());
        } else {
            result.append(conflict.getSourceInstrument().getSourceInfo().multiLineDebugString()).append("\n");
        }
        result.append("Causes\n");
        if (!existing.getDescription().equals(conflict.getDescription())) {
            result.append("- Description [").append(conflict.getDescription()).append("] does not match [").append(existing.getDescription()).append("]\n");
        }
        if (!existing.getUnit().equals(conflict.getUnit())) {
            result.append("- Unit [").append(conflict.getUnit()).append("] does not match [").append(existing.getUnit()).append("]\n");
        }
        if (!existing.getSourceInstrument().getType().equals((Object)conflict.getSourceInstrument().getType())) {
            result.append("- InstrumentType [").append((Object)conflict.getSourceInstrument().getType()).append("] does not match [").append((Object)existing.getSourceInstrument().getType()).append("]\n");
        }
        if (!existing.getSourceInstrument().getValueType().equals((Object)conflict.getSourceInstrument().getValueType())) {
            result.append("- InstrumentValueType [").append((Object)conflict.getSourceInstrument().getValueType()).append("] does not match [").append((Object)existing.getSourceInstrument().getValueType()).append("]\n");
        }
        if (existing.getName().equals(existing.getSourceInstrument().getName())) {
            result.append("Original instrument registered with same name but is incompatible.\n").append(existing.getSourceInstrument().getSourceInfo().multiLineDebugString()).append("\n");
        } else {
            result.append("Conflicting view registered.\n");
            existing.getSourceView().ifPresent(view -> result.append(view.getSourceInfo().multiLineDebugString()));
            result.append("FROM instrument ").append(existing.getSourceInstrument().getName()).append("\n").append(existing.getSourceInstrument().getSourceInfo().multiLineDebugString()).append("\n");
        }
        return result.toString();
    }
}

