/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.view.Aggregation;

final class LastValueAggregation
extends Aggregation
implements AggregatorFactory {
    static final Aggregation INSTANCE = new LastValueAggregation();

    private LastValueAggregation() {
    }

    @Override
    public <T> Aggregator<T> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(ExemplarReservoir::noSamples);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(ExemplarReservoir::noSamples);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

