/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\tH\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/realm/processor/RealmVersionChecker;", "", "processingEnvironment", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "CONNECT_TIMEOUT", "", "READ_TIMEOUT", "REALM_ANDROID_DOWNLOAD_URL", "", "REALM_VERSION", "REALM_VERSION_PATTERN", "VERSION_URL", "checkLatestVersion", "executeRealmVersionUpdate", "", "launchRealmCheck", "printMessage", "message", "Companion", "realm-annotations-processor"})
public final class RealmVersionChecker {
    private final String REALM_ANDROID_DOWNLOAD_URL = "https://static.realm.io/downloads/java/latest";
    private final String VERSION_URL = "https://static.realm.io/update/java?";
    private final String REALM_VERSION = "5.14.0";
    private final String REALM_VERSION_PATTERN = "\\d+\\.\\d+\\.\\d+";
    private final int READ_TIMEOUT = 2000;
    private final int CONNECT_TIMEOUT = 4000;
    private final ProcessingEnvironment processingEnvironment;
    private static RealmVersionChecker instance;
    public static final Companion Companion;

    public final void executeRealmVersionUpdate() {
        Thread backgroundThread2 = new Thread(new Runnable(this){
            final /* synthetic */ RealmVersionChecker this$0;

            public final void run() {
                RealmVersionChecker.access$launchRealmCheck(this.this$0);
            }
            {
                this.this$0 = realmVersionChecker;
            }
        });
        backgroundThread2.start();
        try {
            backgroundThread2.join(this.CONNECT_TIMEOUT + this.READ_TIMEOUT);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final void launchRealmCheck() {
        String latestVersionStr = this.checkLatestVersion();
        if (Intrinsics.areEqual((Object)latestVersionStr, (Object)this.REALM_VERSION) ^ true) {
            this.printMessage("Version " + latestVersionStr + " of Realm is now available: " + this.REALM_ANDROID_DOWNLOAD_URL);
        }
    }

    private final String checkLatestVersion() {
        String result = this.REALM_VERSION;
        try {
            String latestVersion;
            URL url = new URL(this.VERSION_URL + this.REALM_VERSION);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            conn.setConnectTimeout(this.CONNECT_TIMEOUT);
            conn.setReadTimeout(this.READ_TIMEOUT);
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String string = latestVersion = rd.readLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"latestVersion");
            CharSequence charSequence = string;
            String string2 = this.REALM_VERSION_PATTERN;
            boolean bl = false;
            string2 = new Regex(string2);
            bl = false;
            if (string2.matches(charSequence)) {
                result = latestVersion;
            }
            rd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private final void printMessage(String message) {
        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.OTHER, message);
    }

    private RealmVersionChecker(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.REALM_ANDROID_DOWNLOAD_URL = "https://static.realm.io/downloads/java/latest";
        this.VERSION_URL = "https://static.realm.io/update/java?";
        this.REALM_VERSION = "5.14.0";
        this.REALM_VERSION_PATTERN = "\\d+\\.\\d+\\.\\d+";
        this.READ_TIMEOUT = 2000;
        this.CONNECT_TIMEOUT = 4000;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$launchRealmCheck(RealmVersionChecker $this) {
        $this.launchRealmCheck();
    }

    public /* synthetic */ RealmVersionChecker(ProcessingEnvironment processingEnvironment, DefaultConstructorMarker $constructor_marker) {
        this(processingEnvironment);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/realm/processor/RealmVersionChecker$Companion;", "", "()V", "instance", "Lio/realm/processor/RealmVersionChecker;", "getInstance", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "realm-annotations-processor"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final RealmVersionChecker getInstance(@NotNull ProcessingEnvironment env) {
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            if (instance == null) {
                Class<RealmVersionChecker> clazz = RealmVersionChecker.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (instance == null) {
                        instance = new RealmVersionChecker(env, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            RealmVersionChecker realmVersionChecker = instance;
            if (realmVersionChecker == null) {
                Intrinsics.throwNpe();
            }
            return realmVersionChecker;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

