/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import istat.android.data.access.sqlite.SQLiteDataAccess;
import istat.android.data.access.sqlite.SQLiteDelete;
import istat.android.data.access.sqlite.SQLiteInsert;
import istat.android.data.access.sqlite.SQLiteMerge;
import istat.android.data.access.sqlite.SQLiteModel;
import istat.android.data.access.sqlite.SQLitePersist;
import istat.android.data.access.sqlite.SQLiteSelect;
import istat.android.data.access.sqlite.SQLiteUpdate;
import istat.android.data.access.sqlite.utils.SQLiteParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class SQLite {
    static SQLiteDatabase lastOpenedDb;
    static final ConcurrentHashMap<String, SQLiteDataAccess> dbNameAccessPair;
    static final ConcurrentHashMap<String, SQLiteConnection> dbNameConnectionPair;

    private SQLite() {
    }

    public static SQLiteDatabase getLastOpenedDb() {
        return lastOpenedDb;
    }

    public static SQL from(SQLiteDatabase db) {
        lastOpenedDb = db;
        return new SQL(db);
    }

    public static SQL fromConnection(String dbName) throws Exception {
        return SQLite.fromConnection(dbName, false);
    }

    public static SQL fromOneShotConnection(String dbName) throws Exception {
        return SQLite.fromConnection(dbName, true);
    }

    public static SQL fromConnection(String dbName, boolean closeDataBaseOnExecute) throws Exception {
        SQLiteDataAccess access = SQLite.findOrCreateConnectionAccess(dbName);
        SQL sql = SQLite.from(access.open());
        sql.setAutoClose(closeDataBaseOnExecute);
        return sql;
    }

    public static void addConnection(SQLiteConnection ... connections) {
        for (SQLiteConnection launcher : connections) {
            SQLite.addConnection(launcher, false);
        }
    }

    public static SQLiteDataAccess getAccess(String dbName) {
        try {
            return SQLite.findOrCreateConnectionAccess(dbName);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SQLiteDatabase getDataBase(String dbName) {
        try {
            SQLiteDataAccess access = SQLite.findOrCreateConnectionAccess(dbName);
            if (access != null) {
                return access.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void addConnection(SQLiteConnection connection, boolean connectInstantly) {
        if (connectInstantly) {
            SQLite.connect(connection);
        } else {
            dbNameConnectionPair.put(connection.dbName, connection);
        }
    }

    public static boolean removeConnection(String dbName) {
        boolean contain = dbNameAccessPair.containsKey(dbName);
        if (contain) {
            dbNameAccessPair.remove(dbName);
        }
        return contain;
    }

    public static boolean removeConnection(SQLiteConnection connection) {
        return SQLite.removeConnection(connection.dbName);
    }

    public static void prepareSQL(String dbName, PrepareHandler handler) {
        SQLite.prepareSQL(dbName, handler, false);
    }

    public static void prepareTransactionalSQL(String dbName, PrepareHandler handler) {
        SQLite.prepareSQL(dbName, handler, true);
    }

    private static SQLiteDataAccess findOrCreateConnectionAccess(String dbName) throws IllegalAccessException {
        SQLiteDataAccess access = dbNameAccessPair.get(dbName);
        if (access != null && access.isOpened()) {
            try {
                access = access.cloneAccess();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean hasLauncher = dbNameConnectionPair.containsKey(dbName);
        if (access != null) {
            return access;
        }
        if (access != null || !hasLauncher) {
            throw new IllegalAccessException("Oups, no launcher is currently added dor Data base with name: " + dbName);
        }
        access = SQLite.connect(dbNameConnectionPair.get(dbName));
        dbNameConnectionPair.remove(dbName);
        return access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareSQL(String dbName, PrepareHandler handler, boolean transactional) {
        SQLiteDatabase db = null;
        try {
            SQLiteDataAccess access = SQLite.findOrCreateConnectionAccess(dbName);
            db = access.open();
            if (transactional) {
                db.beginTransaction();
            }
            SQL sql = SQLite.from(db);
            handler.onSQLReady(sql);
            if (transactional) {
                db.setTransactionSuccessful();
            }
        }
        catch (Exception e) {
            handler.onSQLPrepareFail(e);
        }
        finally {
            if (transactional && db != null) {
                db.endTransaction();
                if (db.isOpen()) {
                    db.close();
                }
            }
        }
    }

    public static void prepareSQL(SQLiteConnection connection, PrepareHandler handler) {
        SQLite.prepareSQL(connection, false, handler);
    }

    public static void prepareTransactionalSQL(SQLiteConnection connection, PrepareHandler handler) {
        SQLite.prepareSQL(connection, true, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareSQL(SQLiteConnection connection, boolean transactional, PrepareHandler handler) {
        SQLiteDatabase db = null;
        try {
            SQLiteDataAccess access = SQLite.connect(connection);
            db = access.open();
            if (transactional) {
                db.beginTransaction();
            }
            SQL sql = SQLite.from(db);
            handler.onSQLReady(sql);
            if (db.isOpen()) {
                db.close();
            }
            if (transactional) {
                db.setTransactionSuccessful();
            }
        }
        catch (Exception e) {
            handler.onSQLPrepareFail(e);
        }
        finally {
            if (transactional && db != null) {
                db.endTransaction();
                if (db.isOpen()) {
                    db.close();
                }
            }
        }
    }

    public static void prepareSQL(SQLiteDatabase db, PrepareHandler handler) {
        SQLite.prepareSQL(db, false, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareSQL(SQLiteDatabase db, boolean transactional, PrepareHandler handler) {
        try {
            if (transactional) {
                db.beginTransaction();
            }
            SQL sql = SQLite.from(db);
            handler.onSQLReady(sql);
            if (transactional) {
                db.setTransactionSuccessful();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (transactional && db != null) {
                db.endTransaction();
                if (db.isOpen()) {
                    db.close();
                }
            }
        }
    }

    public static void addConnection(Context context, File file, boolean connectInstantly) {
        SQLiteConnection connection = SQLiteConnection.create(context, file, -1, null);
        if (connectInstantly) {
            SQLite.connect(connection);
        } else {
            dbNameConnectionPair.put(connection.dbName, connection);
        }
    }

    public static SQL fromFile(File dbFile) throws Exception {
        return SQLite.fromFile(dbFile, false);
    }

    public static SQL fromFile(File dbFile, boolean autoCloseAble) throws Exception {
        SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((File)dbFile, null);
        SQL sql = new SQL(db);
        sql.setAutoClose(autoCloseAble);
        return sql;
    }

    public static SQL fromUri(Uri dbUri) throws Exception {
        return SQLite.fromUri(dbUri, false);
    }

    public static SQL fromUri(Uri dbUri, boolean autoCloseAble) throws Exception {
        File file = new File(dbUri.getPath());
        return SQLite.fromFile(file, autoCloseAble);
    }

    public static void addConnection(Context context, File ... file) {
        for (File f : file) {
            SQLite.addConnection(context, f, false);
        }
    }

    public static SQLiteDataAccess connect(Context context, File file) {
        return SQLite.connect(context, file, -1, null);
    }

    public static SQLiteDataAccess connect(Context context, File file, int version, BootDescription bootDescription) {
        SQLiteConnection connection = SQLiteConnection.create(context, file, version, bootDescription);
        return SQLite.connect(connection);
    }

    public static SQLiteDataAccess connect(SQLiteConnection connection) {
        return SQLite.connect(connection.context, connection.dbName, connection.dbVersion, (BootDescription)connection);
    }

    public static void close(String connectionName) {
        SQLiteDataAccess access = dbNameAccessPair.get(connectionName);
        if (access != null) {
            access.close();
        }
    }

    public static void desconnect(String dbName) {
        SQLiteDataAccess access = dbNameAccessPair.get(dbName);
        if (access != null) {
            access.close();
            dbNameAccessPair.remove(dbName);
            dbNameConnectionPair.remove(dbName);
        }
    }

    public static void release() {
        for (String accessName : dbNameAccessPair.keySet()) {
            SQLiteDataAccess access = dbNameAccessPair.get(accessName);
            access.close();
        }
        dbNameAccessPair.clear();
        dbNameConnectionPair.clear();
    }

    public static SQLiteDataAccess connect(Context context, String dbName, int dbVersion, final BootDescription description) {
        SQLiteDataAccess access = new SQLiteDataAccess(context, dbName, dbVersion){

            @Override
            public void onUpgradeDb(SQLiteDatabase db, int oldVersion, int newVersion) {
                if (description != null) {
                    description.onUpgradeDb(db, oldVersion, newVersion);
                }
            }

            @Override
            public void onCreateDb(SQLiteDatabase db) {
                if (description != null) {
                    description.onCreateDb(db);
                }
            }
        };
        dbNameAccessPair.put(dbName, access);
        return access;
    }

    public static void executeSQLScript(SQLiteDatabase db, InputStream sqlFileInputStream) throws IOException {
        List<String> statements = SQLiteParser.parseSqlStream(sqlFileInputStream);
        for (String statement : statements) {
            db.execSQL(statement);
        }
    }

    public static void executeStatements(SQLiteDatabase db, List<String> statements) {
        for (String ask : statements) {
            db.execSQL(ask);
        }
    }

    public static void executeStatements(SQLiteDatabase db, String ... statements) {
        for (String ask : statements) {
            db.execSQL(ask);
        }
    }

    static {
        dbNameAccessPair = new ConcurrentHashMap();
        dbNameConnectionPair = new ConcurrentHashMap();
    }

    public static abstract class SQLReadyHandler
    implements PrepareHandler {
        @Override
        public void onSQLPrepareFail(Exception e) {
            e.printStackTrace();
        }
    }

    public static interface PrepareHandler {
        public void onSQLReady(SQL var1) throws Exception;

        public void onSQLPrepareFail(Exception var1);
    }

    public static interface BootDescription {
        public void onCreateDb(SQLiteDatabase var1);

        public void onUpgradeDb(SQLiteDatabase var1, int var2, int var3);
    }

    public static abstract class SQLiteConnection
    implements BootDescription {
        String dbName;
        int dbVersion = 1;
        Context context;

        public static SQLiteConnection create(Context context, File file) {
            return SQLiteConnection.create(context, file, -1, null);
        }

        public static SQLiteConnection create(Context context, File file, int version, BootDescription description) {
            if (version < 0) {
                SQLiteDatabase db = SQLiteDatabase.openOrCreateDatabase((File)file, null);
                db.getVersion();
                db.close();
            }
            return SQLiteConnection.create(context, file.getAbsolutePath(), version, description);
        }

        public static SQLiteConnection create(Context context, String dbName, int dbVersion, final BootDescription description) {
            SQLiteConnection connection = new SQLiteConnection(context, dbName, dbVersion){

                @Override
                public void onCreateDb(SQLiteDatabase db) {
                    if (description != null) {
                        description.onCreateDb(db);
                    }
                }

                @Override
                public void onUpgradeDb(SQLiteDatabase db, int oldVersion, int newVersion) {
                    if (description != null) {
                        description.onUpgradeDb(db, oldVersion, newVersion);
                    }
                }
            };
            return connection;
        }

        public SQLiteConnection(Context context, String dbName, int dbVersion) {
            this.dbName = dbName;
            this.dbVersion = dbVersion;
            this.context = context;
        }

        public static final void executeScripts(SQLiteDatabase db, List<String> scripts) {
            for (String script : scripts) {
                db.execSQL(script);
            }
        }
    }

    public static class SQL {
        SQLiteDatabase db;
        boolean autoClose = false;

        public void setAutoClose(boolean autoClose) {
            this.autoClose = autoClose;
        }

        SQL(SQLiteDatabase db) {
            this.db = db;
        }

        public SQLiteSelect select(Class<?> clazz) {
            return new SQLiteSelect(this, clazz);
        }

        public SQLiteSelect select(boolean distinct, Class<?> clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            return select.distinct(distinct);
        }

        public SQLiteSelect select(boolean distinct, Class<?> ... clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            return select.distinct(distinct);
        }

        public SQLiteSelect select(Class<?> ... clazz) {
            return new SQLiteSelect(this, clazz);
        }

        public SQLiteSelect select(String uniqueColumn, Class<?> clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.columns = new String[]{uniqueColumn};
            return select;
        }

        public SQLiteSelect select(boolean distinct, String uniqueColumn, Class<?> clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.distinct(distinct);
            select.columns = new String[]{uniqueColumn};
            return select;
        }

        public SQLiteSelect select(boolean distinct, String uniqueColumn, Class<?> ... clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.distinct(distinct);
            select.columns = new String[]{uniqueColumn};
            return select;
        }

        public SQLiteSelect select(String uniqueColumn, Class<?> ... clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.columns = new String[]{uniqueColumn};
            return select;
        }

        public SQLiteSelect select(String[] columns, Class<?> clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.columns = columns;
            return select;
        }

        public SQLiteSelect select(boolean distinct, String[] columns, Class<?> clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.distinct(distinct);
            select.columns = columns;
            return select;
        }

        public SQLiteSelect select(boolean distinct, String[] columns, Class<?> ... clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.distinct(distinct);
            select.columns = columns;
            return select;
        }

        public SQLiteSelect select(String[] columns, Class<?> ... clazz) {
            SQLiteSelect select = new SQLiteSelect(this, clazz);
            select.columns = columns;
            return select;
        }

        public SQLiteUpdate update(Class<?> clazz) {
            return new SQLiteUpdate(clazz, this);
        }

        public SQLiteDelete delete(Class<?> clazz) {
            return new SQLiteDelete(clazz, this);
        }

        public int delete(Object ... object) {
            int count = 0;
            for (Object obj : object) {
                if (!this.delete(obj)) continue;
                ++count;
            }
            return count;
        }

        public boolean delete(Object object) {
            try {
                Class<?> cLass = object.getClass();
                SQLiteModel model = SQLiteModel.fromClass(cLass);
                return ((SQLiteDelete)this.delete(cLass).where(model.getPrimaryFieldName()).equalTo(model.getPrimaryKey())).execute() > 0;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return false;
        }

        public boolean deleteById(Class<?> cLass, Object id) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(cLass);
                return ((SQLiteDelete)this.delete(cLass).where(model.getPrimaryFieldName()).equalTo(id)).execute() > 0;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return false;
        }

        public <T> T findById(Class<T> cLass, Object id) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(cLass);
                if (!model.isPrimaryFieldDefined()) {
                    throw new RuntimeException("Oups, class:" + cLass + " mapped by table:" + model.getName() + " doesn't has primary field defined.");
                }
                return ((SQLiteSelect)this.select((Class<?>)cLass).where(model.getPrimaryFieldName()).equalTo(id)).executeLimitOne();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }

        public <T> List<T> findAll(Class<T> classTable) {
            return this.findAll(classTable, false);
        }

        public <T> List<T> findAll(Class<T> classTable, boolean distinct) {
            return this.findAll(classTable, distinct, null, null, null, null, null, null);
        }

        public <T> List<T> findAll(Class<T> classTable, boolean distinct, String whereClause, String[] whereParams, String groupBy, String having, String orderBy, String limit) {
            SQLiteSelect select = this.select(distinct, (Class<?>)classTable);
            select.distinct = distinct;
            select.whereClause = new StringBuilder(whereClause);
            select.whereParams = whereParams != null ? Arrays.asList(whereParams) : null;
            select.limit = limit;
            select.orderBy = orderBy;
            select.groupBy = groupBy;
            select.having = new StringBuilder(having);
            return select.execute();
        }

        public <T> List<T> findAll(Class<T> classTable, String rawQuery, String[] selectionArgs) {
            return this.findAll(classTable, rawQuery, selectionArgs, null);
        }

        public <T> List<T> findAll(Class<T> classTable, final String rawQuery, final String[] selectionArgs, final CancellationSignal signal) {
            SQLiteSelect select = new SQLiteSelect(this, new Class[]{classTable}){

                @Override
                protected Cursor onExecute(SQLiteDatabase db) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        return db.rawQuery(rawQuery, selectionArgs, signal);
                    }
                    return db.rawQuery(rawQuery, selectionArgs);
                }
            };
            return select.execute();
        }

        public <T> int update(Class<T> classTable, ContentValues contentValues, String whereClause, String[] whereParams, String having, String limit) {
            SQLiteUpdate.Updater update = this.update(classTable).updater;
            update.model.fillFromContentValues(contentValues);
            update.whereClause = new StringBuilder(whereClause);
            update.whereParams = whereParams != null ? Arrays.asList(whereParams) : null;
            update.limit = limit;
            update.having = new StringBuilder(having);
            return update.execute();
        }

        public SQLiteInsert insert(Object entity) {
            SQLiteInsert insert = new SQLiteInsert(this);
            return insert.insert(entity);
        }

        public SQLiteInsert insert(Object ... entity) {
            SQLiteInsert insert = new SQLiteInsert(this);
            return insert.insert(entity);
        }

        public <T> SQLiteInsert insert(List<T> entity) {
            SQLiteInsert insert = new SQLiteInsert(this);
            return insert.insert(entity);
        }

        public SQLitePersist persist(Object entity) {
            SQLitePersist persist = new SQLitePersist(this);
            return persist.persist(entity);
        }

        public SQLitePersist persist(Object ... entity) {
            SQLitePersist persist = new SQLitePersist(this);
            return persist.persist(entity);
        }

        public <T> SQLitePersist persist(List<T> entity) {
            SQLitePersist persist = new SQLitePersist(this);
            return persist.persist(entity);
        }

        public <T> void replaces(List<T> entity) {
            try {
                if (entity != null && !entity.isEmpty()) {
                    this.delete(entity.get(0).getClass()).execute();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SQLitePersist insert = new SQLitePersist(this);
            insert.persist(entity).execute();
        }

        public SQLiteMerge merge(Object entity) {
            SQLiteMerge merge = new SQLiteMerge(this);
            return merge.merge(entity);
        }

        public SQLiteMerge merge(Object ... entity) {
            SQLiteMerge merge = new SQLiteMerge(this);
            return merge.merge(entity);
        }

        public <T> SQLiteMerge merge(List<T> entity) {
            SQLiteMerge merge = new SQLiteMerge(this);
            return merge.merge(entity);
        }

        public void executeStatements(List<String> statements) {
            for (String ask : statements) {
                this.db.execSQL(ask);
            }
            if (this.autoClose) {
                this.db.close();
            }
        }

        public void executeStatements(String ... statements) {
            for (String ask : statements) {
                this.db.execSQL(ask);
            }
            if (this.autoClose) {
                this.db.close();
            }
        }

        public void executeSQLScript(InputStream sqlFileInputStream) throws IOException {
            List<String> statements = SQLiteParser.parseSqlStream(sqlFileInputStream);
            this.executeStatements(statements);
        }

        public boolean isTableExist(Class<?> cLass) {
            try {
                this.select(cLass).count();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public final void close() {
            this.db.close();
        }

        public final void beginTransaction() {
            this.db.beginTransaction();
        }

        public final void setTransactionSuccessful() {
            this.db.setTransactionSuccessful();
        }

        public final void endTransaction() {
            this.db.endTransaction();
        }

        public boolean isReady() {
            return this.db != null && this.db.isOpen();
        }

        public Cursor query(String table, String[] column, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
            return this.db.query(table, column, selection, selectionArgs, groupBy, having, orderBy, limit);
        }

        public Cursor query(boolean distinct, String table, String[] column, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
            return this.db.query(distinct, table, column, selection, selectionArgs, groupBy, having, orderBy, limit);
        }

        @SuppressLint(value={"NewApi"})
        public Cursor query(boolean distinct, String table, String[] column, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
            return this.db.query(distinct, table, column, selection, selectionArgs, groupBy, having, orderBy, limit, cancellationSignal);
        }

        public Cursor queryWithFactory(SQLiteDatabase.CursorFactory factory, boolean distinct, String table, String[] column, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
            return this.db.queryWithFactory(factory, distinct, table, column, selection, selectionArgs, groupBy, having, orderBy, limit);
        }

        @SuppressLint(value={"NewApi"})
        public Cursor queryWithFactory(SQLiteDatabase.CursorFactory factory, boolean distinct, String table, String[] column, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, CancellationSignal cancellationSignal) {
            return this.db.queryWithFactory(factory, distinct, table, column, selection, selectionArgs, groupBy, having, orderBy, limit, cancellationSignal);
        }

        public Cursor rawQuery(String sql, String[] selectionArgs) {
            return this.db.rawQuery(sql, selectionArgs);
        }

        @SuppressLint(value={"NewApi"})
        public Cursor rawQuery(String sql, String[] selectionArgs, CancellationSignal cancellationSignal) {
            return this.db.rawQuery(sql, selectionArgs, cancellationSignal);
        }

        public Cursor rawQueryWithFactory(SQLiteDatabase.CursorFactory cursorFactory, String sql, String[] selectionArgs, String ediTable) {
            return this.db.rawQueryWithFactory(cursorFactory, sql, selectionArgs, ediTable);
        }

        @SuppressLint(value={"NewApi"})
        public Cursor rawQueryWithFactory(SQLiteDatabase.CursorFactory cursorFactory, String sql, String[] selectionArgs, String ediTable, CancellationSignal cancellationSignal) {
            return this.db.rawQueryWithFactory(cursorFactory, sql, selectionArgs, ediTable, cancellationSignal);
        }

        public SQLiteDatabase getDb() {
            return this.db;
        }
    }
}

