/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.SQLiteModel;
import istat.android.data.access.sqlite.SQLiteSelect;
import istat.android.data.access.sqlite.interfaces.QueryAble;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

abstract class SQLiteClause<Clause extends SQLiteClause<?>> {
    protected SQLite.SQL sql;
    protected StringBuilder whereClause = null;
    protected List<String> whereParams = new ArrayList<String>();
    List<String> havingWhereParams = new ArrayList<String>();
    protected String orderBy = null;
    protected String groupBy = null;
    protected StringBuilder having = null;
    protected String limit = null;
    protected String[] columns;
    protected String table;
    static final int TYPE_CLAUSE_WHERE = 0;
    static final int TYPE_CLAUSE_AND = 1;
    static final int TYPE_CLAUSE_OR = 2;
    static final int TYPE_CLAUSE_LIKE = 3;
    static final int TYPE_CLAUSE_AND_HAVING = 4;
    static final int TYPE_CLAUSE_OR_HAVING = 5;

    protected String getWhereClause() {
        return this.whereClause != null ? this.whereClause.toString() : null;
    }

    protected String getOrderBy() {
        return this.orderBy;
    }

    protected String getHaving() {
        if (this.having == null) {
            return null;
        }
        String out = this.compute(this.having.toString(), this.havingWhereParams);
        return out;
    }

    protected String getLimit() {
        return this.limit;
    }

    protected String getGroupBy() {
        return this.groupBy;
    }

    protected String[] getWhereParams() {
        if (this.whereParams.size() == 0) {
            return null;
        }
        String[] tmp = new String[this.whereParams.size()];
        int i = 0;
        Iterator<String> iterator = this.whereParams.iterator();
        while (iterator.hasNext()) {
            String tmpS;
            tmp[i] = tmpS = iterator.next();
            ++i;
        }
        return tmp;
    }

    SQLiteClause(String table, String[] projection, SQLite.SQL sql) {
        this.table = table;
        this.columns = projection;
        this.sql = sql;
    }

    SQLiteClause(Class<?> clazz, SQLite.SQL sql) {
        this.sql = sql;
        SQLiteModel entity = null;
        try {
            entity = SQLiteModel.fromClass(clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (entity != null) {
            this.table = entity.getName();
            this.columns = entity.getColumns();
        }
    }

    public Clause orderBy(String column, String value) {
        this.orderBy = TextUtils.isEmpty((CharSequence)this.orderBy) ? this.buildRealColumnName(column) + " " + value : this.orderBy + this.buildRealColumnName(column) + " " + value;
        return (Clause)this;
    }

    public Clause groupBy(String ... column) {
        for (String cl : column) {
            this.groupBy(cl);
        }
        return (Clause)this;
    }

    public Clause groupBy(String column) {
        this.groupBy = TextUtils.isEmpty((CharSequence)this.groupBy) ? this.buildRealColumnName(column) : this.groupBy + ", " + this.buildRealColumnName(column);
        return (Clause)this;
    }

    public Clause orderBy(String ... columns) {
        String[] stringArray = columns;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String column;
            boolean endWithDescOrAsc = (column = stringArray[i]).toLowerCase().matches(".+\\s(desc|asc)$");
            this.orderBy(column, endWithDescOrAsc ? "" : "ASC");
        }
        return (Clause)this;
    }

    protected static String buildRealColumnName(String tableName, String column) {
        if (column.matches(".*\\..*")) {
            return column;
        }
        Pattern pattern = Pattern.compile("(\\()(\\w*)(\\))");
        Matcher matcher = pattern.matcher(column);
        while (matcher.find()) {
            String columnNameOnly = matcher.group(2);
            if (TextUtils.isEmpty((CharSequence)columnNameOnly)) continue;
            column = column.replace(columnNameOnly, tableName + "." + columnNameOnly);
        }
        return column;
    }

    protected String buildRealColumnName(String column) {
        return SQLiteClause.buildRealColumnName(this.table, column);
    }

    public ClauseBuilder where(String column) {
        if (this.whereClause == null) {
            this.whereClause = new StringBuilder(this.buildRealColumnName(column));
        } else {
            this.whereClause.append(" AND " + this.buildRealColumnName(column));
        }
        return new ClauseBuilder(this.whereClause, this.whereParams, 1);
    }

    public ClauseBuilder or(String column) {
        if (this.whereClause == null) {
            this.whereClause = new StringBuilder(this.buildRealColumnName(column));
        } else {
            this.whereClause.append(" OR " + this.buildRealColumnName(column));
        }
        return new ClauseBuilder(this.whereClause, this.whereParams, 2);
    }

    public ClauseBuilder and(String column) {
        if (this.whereClause == null) {
            this.whereClause = new StringBuilder(this.buildRealColumnName(column));
        } else {
            this.whereClause.append(" AND " + this.buildRealColumnName(column));
        }
        return new ClauseBuilder(this.whereClause, this.whereParams, 1);
    }

    public Clause WHERE(SQLiteSelect close) {
        if (this.whereClause == null) {
            this.whereClause = close.whereClause;
            this.whereParams = close.whereParams;
        } else {
            this.whereClause.append(" AND " + close.whereClause);
            this.whereParams.addAll(close.whereParams);
        }
        return (Clause)this;
    }

    public Clause WHERE(HashMap<String, String> filter) {
        this.applyFilter(filter);
        return (Clause)this;
    }

    public Clause OR(SQLiteSelect close) {
        this.whereClause.append("(" + this.whereClause + ") OR (" + close.whereClause + ")");
        this.whereParams.addAll(close.whereParams);
        return (Clause)this;
    }

    public Clause AND(SQLiteSelect close) {
        this.whereClause.append("(" + this.whereClause + ") AND (" + close.whereClause + ")");
        this.whereParams.addAll(close.whereParams);
        return (Clause)this;
    }

    protected abstract Object onExecute(SQLiteDatabase var1);

    protected static QueryAble createFromCursor(Class<? extends QueryAble> clazz, Cursor c) {
        QueryAble instance = SQLiteClause.createModelFromClass(clazz);
        if (instance != null) {
            instance.fillFromCursor(c);
        }
        return instance;
    }

    protected static QueryAble createModelFromClass(Class<? extends QueryAble> clazz) {
        Object obj;
        String className = clazz + "";
        className = className.substring(6, className.length()).trim();
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Class<?> cLass = Class.forName(className);
                obj = cLass.getConstructor(JSONObject.class).newInstance(new JSONObject());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (obj != null) {
            try {
                if (obj instanceof QueryAble) {
                    QueryAble jsonEntity = (QueryAble)obj;
                    return jsonEntity;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void applyFilter(HashMap<String, String> filter) {
        for (String tmp : filter.keySet()) {
            String obj = filter.get(tmp);
            if (obj == null) continue;
            String value = obj.toString();
            this.where(tmp).equalTo(value);
        }
    }

    public abstract String getStatement();

    protected void notifyExecuting() {
    }

    protected void notifyExecutionSucceed(int type, Object clause, Object result) {
    }

    protected void notifyExecutionFail(Exception e) {
    }

    protected void notifyExecuted() {
        if (this.sql.autoClose) {
            this.sql.close();
        }
    }

    String compute(String out, List<String> whereParams) {
        String[] splits = out.split("\\?");
        String sql = "";
        for (int i = 0; i < (!out.endsWith("?") ? splits.length - 1 : splits.length); ++i) {
            sql = sql + splits[i];
            sql = sql + whereParams.get(i);
        }
        if (!out.endsWith("?")) {
            sql = sql + splits[splits.length - 1];
        }
        return sql;
    }

    public class HavingBuilder {
        int type = 0;
        String having;

        public HavingBuilder(String having, int type) {
            this.having = having;
            this.type = type;
        }

        public Clause greatThan(Object value) {
            return this.greatThan(value, false);
        }

        public Clause lessThan(Object value) {
            return this.lessThan(value, false);
        }

        public Clause greatThan(Object value, boolean acceptEqual) {
            this.prepare(value);
            SQLiteClause.this.whereClause.append(" >" + (acceptEqual ? "=" : "") + " ? ");
            return SQLiteClause.this;
        }

        public Clause lessThan(Object value, boolean acceptEqual) {
            this.prepare(value);
            SQLiteClause.this.whereClause.append(" <" + (acceptEqual ? "=" : "") + " ? ");
            return SQLiteClause.this;
        }

        private void prepare(Object value) {
            SQLiteClause.this.whereParams.add(value + "");
            switch (this.type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public class ClauseBuilder {
        int type = 0;
        StringBuilder whereClause;
        List<String> whereParams;

        public ClauseBuilder(StringBuilder whereClause, List<String> whereParams, int type) {
            this.type = type;
            this.whereClause = whereClause;
            this.whereParams = whereParams;
        }

        public Clause isNULL() {
            this.whereClause.append(" IS NULL ");
            return SQLiteClause.this;
        }

        public Clause isNOTNULL() {
            this.whereClause.append(" IS NOT NULL ");
            return SQLiteClause.this;
        }

        public Clause equalTo(Object value) {
            this.prepare(value);
            this.whereClause.append(" = ? ");
            return SQLiteClause.this;
        }

        public Clause notEqualTo(Object value) {
            this.prepare(value);
            this.whereClause.append(" != ? ");
            return SQLiteClause.this;
        }

        public Clause notIn(Object ... value) {
            return this.in(false, value);
        }

        public Clause in(Object ... value) {
            return this.in(false, value);
        }

        private Clause in(boolean truth, Object[] value) {
            String valueIn = "";
            for (int i = 0; i < value.length; ++i) {
                valueIn = value[i] instanceof Number ? valueIn + value[i] : valueIn + "'" + value[i] + "'";
                if (i >= value.length - 1) continue;
                valueIn = valueIn + ", ";
            }
            if (!valueIn.startsWith("(") && !valueIn.endsWith(")")) {
                valueIn = "(" + valueIn + ")";
            }
            this.whereClause.append((truth ? "" : " NOT ") + " IN " + valueIn);
            return SQLiteClause.this;
        }

        public Clause greatThan(Object value) {
            return this.greatThan(value, false);
        }

        public Clause lessThan(Object value) {
            return this.lessThan(value, false);
        }

        public Clause greatThan(Object value, boolean acceptEqual) {
            this.prepare(value);
            this.whereClause.append(" >" + (acceptEqual ? "=" : "") + " ? ");
            return SQLiteClause.this;
        }

        public Clause lessThan(Object value, boolean acceptEqual) {
            this.prepare(value);
            this.whereClause.append(" <" + (acceptEqual ? "=" : "") + " ? ");
            return SQLiteClause.this;
        }

        public Clause like(Object value) {
            this.prepare(value);
            this.whereClause.append(" like ? ");
            return SQLiteClause.this;
        }

        public Clause notLike(Object value) {
            this.prepare(value);
            this.whereClause.append(" NOT like ? ");
            return SQLiteClause.this;
        }

        public Clause between(Object value, Object value2) {
            this.prepare(value);
            this.prepare(value2);
            this.whereClause.append(" BETWEEN ? AND ? ");
            return SQLiteClause.this;
        }

        public Clause notBetween(Object value, Object value2) {
            this.prepare(value);
            this.prepare(value2);
            this.whereClause.append(" NOT BETWEEN ? AND ? ");
            return SQLiteClause.this;
        }

        public Clause equalTo(SQLiteSelect value) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" = (" + value + ") ");
            return SQLiteClause.this;
        }

        public Clause notEqualTo(SQLiteSelect value) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" != (" + value + ") ");
            return SQLiteClause.this;
        }

        public Clause notIn(SQLiteSelect value) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" NOT IN (" + value.getSql() + ") ");
            return SQLiteClause.this;
        }

        public Clause in(SQLiteSelect value) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" IN (" + value.getSql() + ") ");
            return SQLiteClause.this;
        }

        public Clause greatThan(SQLiteSelect value) {
            return this.greatThan(value, false);
        }

        public Clause lessThan(SQLiteSelect value) {
            return this.lessThan(value, false);
        }

        public Clause greatThan(SQLiteSelect value, boolean acceptEqual) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" >" + (acceptEqual ? "=" : "") + " (" + value.getSql() + ") ");
            return SQLiteClause.this;
        }

        public Clause lessThan(SQLiteSelect value, boolean acceptEqual) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" <" + (acceptEqual ? "=" : "") + " (" + value.getSql() + ") ");
            return SQLiteClause.this;
        }

        public Clause like(SQLiteSelect value) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" like (" + value.getSql() + ")");
            return SQLiteClause.this;
        }

        public Clause notLike(SQLiteSelect value) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" NOT like (" + value.getSql() + ")");
            return SQLiteClause.this;
        }

        public Clause between(SQLiteSelect value, SQLiteSelect value2) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" BETWEEN (" + value.getSql() + ") AND (" + value2.getSql() + ")");
            return SQLiteClause.this;
        }

        public Clause notBetween(SQLiteSelect value, SQLiteSelect value2) {
            this.whereParams.addAll(value.whereParams);
            this.whereClause.append(" BETWEEN (" + value.getSql() + ") AND (" + value2.getSql() + ")");
            return SQLiteClause.this;
        }

        private void prepare(Object value) {
            this.whereParams.add(value + "");
            switch (this.type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }
}

