/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.utils.SQLiteParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public abstract class SQLiteDataAccess
implements Closeable,
SQLite.BootDescription,
Cloneable {
    protected SQLiteDatabase db;
    private DbOpenHelper dbOpenHelper;
    public Context context;
    protected static String SHARED_PREF_FILE = "db_file";
    protected static String DB_CREATION_TIME = "creation_time";
    protected static String DB_UPDATE_TIME = "creation_time";

    protected SQLiteDataAccess(Context ctx, String dbName, int dbVersion) {
        this.dbOpenHelper = new DbOpenHelper(ctx, dbName, null, dbVersion);
        this.context = ctx;
    }

    public Context getContext() {
        return this.context;
    }

    public SQLiteDatabase open() {
        this.db = this.dbOpenHelper.getWritableDatabase();
        Log.i((String)"openhelper", (String)"BDD open");
        return this.db;
    }

    public boolean isOpened() {
        return this.db != null;
    }

    @Override
    public void close() {
        if (this.db != null) {
            if (this.db.isOpen()) {
                try {
                    this.db.close();
                    Log.i((String)"openhelper", (String)"BDD close");
                }
                catch (Exception e) {
                    Log.i((String)"openhelper", (String)"BDD can't be close because it is not already Open");
                }
            } else {
                Log.i((String)"openhelper", (String)"BDD can't be close because it is not already Open");
            }
        }
        this.db = null;
    }

    public final void beginTransaction() {
        this.db.beginTransaction();
    }

    public final void endTransaction() {
        this.db.endTransaction();
    }

    public final void setTransactionSuccessful() {
        this.db.setTransactionSuccessful();
    }

    public final void commit() {
        this.setTransactionSuccessful();
        this.endTransaction();
    }

    public final SQLite.SQL getStatement() {
        return SQLite.from(this.open());
    }

    public int truncateTable(String table) {
        return this.db.delete(table, null, null);
    }

    public SQLiteDatabase getDataBase() {
        return this.db;
    }

    public DbOpenHelper getDbOpenHelper() {
        return this.dbOpenHelper;
    }

    public boolean doesTableExist(SQLiteDatabase db, String tableName) {
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = '" + tableName + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }

    public String getDbUpdateTime() {
        return this.context.getSharedPreferences(SHARED_PREF_FILE, 0).getString(DB_UPDATE_TIME, SQLiteDataAccess.simpleDateTime());
    }

    public String getDbCreationTime() {
        return this.context.getSharedPreferences(SHARED_PREF_FILE, 0).getString(DB_CREATION_TIME, SQLiteDataAccess.simpleDateTime());
    }

    public Date getDbUpdateTimeAsDate() {
        return new Date(this.context.getSharedPreferences(SHARED_PREF_FILE, 0).getString(DB_UPDATE_TIME, SQLiteDataAccess.simpleDateTime()));
    }

    public Date getDbCreationTimeAsDate() {
        return new Date(this.context.getSharedPreferences(SHARED_PREF_FILE, 0).getString(DB_CREATION_TIME, SQLiteDataAccess.simpleDateTime()));
    }

    protected boolean isTableExist(String table) {
        return SQLiteDataAccess.isTableExist(this.db, table);
    }

    protected boolean executeRawResource(SQLiteDatabase db, int resid) {
        try {
            Resources res = this.getContext().getResources();
            InputStream resStream = res.openRawResource(resid);
            SQLiteDataAccess.executeDbScript(db, resStream);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void executeRawRessources(SQLiteDatabase db, int ... resourceIds) {
        for (int index : resourceIds) {
            this.executeRawResource(db, index);
        }
    }

    protected void executeStatements(SQLiteDatabase db, int[] statements) {
        for (int ask : statements) {
            db.execSQL(this.context.getResources().getString(ask));
        }
    }

    protected static void executeStatements(SQLiteDatabase db, List<String> statements) {
        for (String ask : statements) {
            db.execSQL(ask);
        }
    }

    protected static void executeStatements(SQLiteDatabase db, String[] statements) {
        for (String statement : statements) {
            db.execSQL(statement);
        }
    }

    private void registerDbCreationTime() {
        SharedPreferences p = this.context.getSharedPreferences(SHARED_PREF_FILE, 0);
        p.edit().putString(DB_CREATION_TIME, SQLiteDataAccess.simpleDateTime());
    }

    private void registerDbUpdateTime() {
        SharedPreferences p = this.context.getSharedPreferences(SHARED_PREF_FILE, 0);
        p.edit().putString(DB_UPDATE_TIME, SQLiteDataAccess.simpleDateTime());
    }

    public static void executeDbScript(SQLiteDatabase db, InputStream sqlFileInputStream) throws IOException {
        List<String> statements = SQLiteParser.parseSqlStream(sqlFileInputStream);
        for (String statement : statements) {
            db.execSQL(statement);
        }
    }

    public static boolean isTableExist(SQLiteDatabase db, String table) {
        try {
            db.query(table, null, null, null, null, null, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String simpleDateTime() {
        Date date = new Date();
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return f.format(date);
    }

    protected Object clone() throws CloneNotSupportedException {
        Object obj = super.clone();
        return obj;
    }

    protected SQLiteDataAccess cloneAccess() throws CloneNotSupportedException {
        Object obj = super.clone();
        return (SQLiteDataAccess)obj;
    }

    public class DbOpenHelper
    extends SQLiteOpenHelper {
        Context context;

        public DbOpenHelper(Context context, String nom, SQLiteDatabase.CursorFactory cursorfactory, int version) {
            super(context, nom, cursorfactory, version);
            this.context = context;
        }

        public void onCreate(SQLiteDatabase db) {
            SQLiteDataAccess.this.onCreateDb(db);
            SQLiteDataAccess.this.registerDbCreationTime();
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            SQLiteDataAccess.this.onUpgradeDb(db, oldVersion, newVersion);
            SQLiteDataAccess.this.registerDbUpdateTime();
        }
    }
}

