/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.SQLiteModel;
import istat.android.data.access.sqlite.interfaces.QueryAble;
import istat.android.data.access.sqlite.utils.SQLiteAsyncExecutor;
import istat.android.data.access.sqlite.utils.SQLiteThread;
import java.util.ArrayList;
import java.util.List;

public final class SQLiteInsert {
    List<QueryAble> modelInsertions = new ArrayList<QueryAble>();
    List<Object> insertions = new ArrayList<Object>();
    SQLite.SQL sql;

    SQLiteInsert(SQLite.SQL sql) {
        this.sql = sql;
    }

    public SQLiteInsert insert(Object insert) {
        try {
            SQLiteModel model = SQLiteModel.fromObject(insert);
            this.modelInsertions.add(model);
            this.insertions.add(insert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public SQLiteInsert insert(List<?> insert) {
        if (insert == null || insert.isEmpty()) {
            return this;
        }
        for (Object obj : insert) {
            try {
                SQLiteModel model = SQLiteModel.fromObject(obj);
                this.modelInsertions.add(model);
                this.insertions.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public SQLiteInsert insert(Object ... insert) {
        if (insert == null || insert.length == 0) {
            return this;
        }
        for (Object obj : insert) {
            try {
                SQLiteModel model = SQLiteModel.fromObject(obj);
                this.modelInsertions.add(model);
                this.insertions.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public long[] execute(boolean ignoreOnDuplicate) {
        ArrayList<Long> tmp;
        block6: {
            tmp = new ArrayList<Long>();
            try {
                if (this.modelInsertions == null || this.modelInsertions.size() == 0) {
                    return new long[]{0L};
                }
                for (QueryAble insertion : this.modelInsertions) {
                    if (insertion.exist(this.sql.db)) {
                        throw new IllegalAccessException("entity :0" + insertion + " already exist inside table " + insertion.getName());
                    }
                    tmp.add(insertion.persist(this.sql.db));
                }
                this.modelInsertions.clear();
                this.notifyExecuted();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                if (ignoreOnDuplicate) break block6;
                throw new RuntimeException(e);
            }
        }
        long[] out = new long[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            out[i] = (Long)tmp.get(i);
        }
        return out;
    }

    public long[] execute() throws IllegalAccessException {
        if (this.modelInsertions == null || this.modelInsertions.size() == 0) {
            return new long[]{0L};
        }
        long[] out = new long[this.modelInsertions.size()];
        int index = 0;
        for (QueryAble insertion : this.modelInsertions) {
            if (insertion.exist(this.sql.db)) {
                throw new IllegalAccessException("entity :0" + insertion + " already exist inside table " + insertion.getName());
            }
            out[index] = insertion.persist(this.sql.db);
            ++index;
        }
        this.modelInsertions.clear();
        this.notifyExecuted();
        return out;
    }

    public SQLiteThread executeAsync() {
        return this.executeAsync(null);
    }

    public SQLiteThread executeAsync(SQLiteAsyncExecutor.ExecutionCallback<long[]> callback) {
        SQLiteAsyncExecutor asyncExecutor = new SQLiteAsyncExecutor();
        return asyncExecutor.execute(this, callback);
    }

    private void notifyExecuted() {
        if (this.sql.autoClose) {
            this.sql.close();
        }
    }

    public List<Object> getInsertions() {
        return this.insertions;
    }
}

