/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.SQLiteModel;
import java.util.ArrayList;
import java.util.List;

public final class SQLiteMerge {
    List<SQLiteModel> modelMerges = new ArrayList<SQLiteModel>();
    List<Object> merges = new ArrayList<Object>();
    SQLite.SQL sql;

    SQLiteMerge(SQLite.SQL sql) {
        this.sql = sql;
    }

    public SQLiteMerge merge(Object merge) {
        try {
            SQLiteModel model = SQLiteModel.fromObject(merge);
            this.modelMerges.add(model);
            this.merges.add(merge);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public SQLiteMerge merge(List<?> entities) {
        for (Object obj : entities) {
            try {
                SQLiteModel model = SQLiteModel.fromObject(obj);
                this.modelMerges.add(model);
                this.merges.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public SQLiteMerge merge(Object ... merge) {
        for (Object obj : merge) {
            try {
                SQLiteModel model = SQLiteModel.fromObject(obj);
                this.modelMerges.add(model);
                this.merges.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public long[] execute() {
        if (this.modelMerges == null || this.modelMerges.isEmpty()) {
            return new long[]{0L};
        }
        long[] out = new long[this.modelMerges.size()];
        int index = 0;
        for (SQLiteModel merge : this.modelMerges) {
            out[index] = merge.merge(this.sql.db);
            ++index;
        }
        this.modelMerges.clear();
        this.notifyExecuted();
        return out;
    }

    private void notifyExecuted() {
        if (this.sql.autoClose) {
            this.sql.close();
        }
    }

    public List<Object> getMerges() {
        return this.merges;
    }
}

