/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import istat.android.data.access.sqlite.interfaces.JSONable;
import istat.android.data.access.sqlite.interfaces.QueryAble;
import istat.android.data.access.sqlite.utils.Toolkit;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class SQLiteModel
implements JSONable,
QueryAble,
Cloneable {
    Class<?> modelClass = Object.class;
    HashMap<String, Object> fieldNameValuePair = new HashMap();
    HashMap<String, Field> nameFieldPair = new HashMap();
    HashMap<String, Field> nestedTableFieldPair = new HashMap();
    public static final String TAG_CLASS = SQLiteModel.class.getCanonicalName();
    private Object instance;
    Serializer serializer = DEFAULT_SERIALIZER;
    CursorReader cursorReader = DEFAULT_CURSOR_READER;
    private static final CursorReader DEFAULT_CURSOR_READER = new CursorReader(){

        @Override
        public void onReadCursor(SQLiteModel model, Cursor c) {
            for (String projection : model.getColumns()) {
                String values;
                int columnIndex;
                if (projection == null || (columnIndex = c.getColumnIndex(projection)) < 0 || TextUtils.isEmpty((CharSequence)(values = c.getString(columnIndex)))) continue;
                model.set(projection, values);
            }
        }
    };
    private static final Serializer DEFAULT_SERIALIZER = new Serializer(){

        @Override
        public String onSerialize(Object value, String fieldName) {
            if (value.getClass().isAssignableFrom(CharSequence.class) || value.getClass().isAssignableFrom(String.class) || value.getClass().isAssignableFrom(Double.class) || value.getClass().isAssignableFrom(Double.TYPE) || value.getClass().isAssignableFrom(Float.class) || value.getClass().isAssignableFrom(Float.TYPE) || value.getClass().isAssignableFrom(Long.class) || value.getClass().isAssignableFrom(Long.TYPE) || value.getClass().isAssignableFrom(Boolean.class) || value.getClass().isAssignableFrom(Boolean.TYPE) || value.getClass().isAssignableFrom(Integer.class) || value.getClass().isAssignableFrom(Integer.TYPE)) {
                return value.toString();
            }
            Gson gson = new Gson();
            Type type = value.getClass().getGenericSuperclass();
            String out = gson.toJson(value, type);
            return out;
        }

        @Override
        public Object onDeSerialize(String serialized, Field field) {
            try {
                Class<?> type;
                if (field.getType().isAssignableFrom(CharSequence.class) || field.getType().isAssignableFrom(String.class)) {
                    return serialized;
                }
                if (field.getType().isAssignableFrom(Double.class) || field.getType().isAssignableFrom(Double.TYPE)) {
                    return Double.valueOf(serialized);
                }
                if (field.getType().isAssignableFrom(Float.class) || field.getType().isAssignableFrom(Float.TYPE)) {
                    return Float.valueOf(serialized);
                }
                if (field.getType().isAssignableFrom(Long.class) || field.getType().isAssignableFrom(Long.TYPE)) {
                    return Long.valueOf(serialized);
                }
                if (field.getType().isAssignableFrom(Boolean.class) || field.getType().isAssignableFrom(Boolean.TYPE)) {
                    return Boolean.valueOf(serialized);
                }
                if (field.getType().isAssignableFrom(Integer.class) || field.getType().isAssignableFrom(Integer.TYPE)) {
                    return Integer.valueOf(serialized);
                }
                Gson gson = new Gson();
                try {
                    type = field.getGenericType();
                    Log.d((String)"asClass", (String)("onTRY=" + type));
                }
                catch (Exception e) {
                    type = field.getType();
                    Log.d((String)"asClass", (String)("onCatch=" + type));
                }
                Log.d((String)"asClass", (String)("stringularProperty=" + serialized));
                Object obj = gson.fromJson(serialized, type);
                return obj;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    };

    SQLiteModel() {
        this.instance = this;
    }

    public final void set(String name, Object value) {
        this.fieldNameValuePair.put(name, value);
    }

    public final Object get(String name) {
        return this.fieldNameValuePair.get(name);
    }

    public final String getString(String name) {
        Object value = this.get(name);
        return value == null ? "" : value.toString();
    }

    public final boolean getBoolean(String name) {
        return Boolean.valueOf(this.getString(name));
    }

    public final double getDouble(String name) {
        try {
            return Double.valueOf(this.getString(name));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public final float getFloat(String name) {
        try {
            String value = this.getString(name);
            return Float.valueOf(value).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public final long getLong(String name) {
        try {
            return Long.valueOf(this.getString(name));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public final int getInteger(String name) {
        try {
            return Integer.valueOf(this.getString(name));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getPrimaryKey() {
        return this.getString(this.getPrimaryFieldName());
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    protected String getSerializedValue(String name) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return this.serializer.onSerialize(value, name);
    }

    public HashMap<String, Object> toHashMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(map);
        return map;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = SQLiteModel.createJsonFromHashMap(this.fieldNameValuePair);
        try {
            String className = this.instance.getClass() + "";
            className = className.substring(6, className.length()).trim();
            json.put(TAG_CLASS, (Object)className);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public JSONObject toJson(boolean addClassName) {
        JSONObject json = this.toJson();
        if (!addClassName) {
            json.remove(TAG_CLASS);
        }
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public String toString(int indentSpaces) {
        try {
            return this.toJson().toString(indentSpaces);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return this.toString();
        }
    }

    @Override
    public ContentValues toContentValues() {
        String[] columns;
        ContentValues pairs = new ContentValues();
        for (String column : columns = this.getColumns()) {
            if (column == null || this.get(column) == null) continue;
            String values = this.getSerializedValue(column);
            if (column.equals(this.getPrimaryFieldName())) {
                if (this.getPrimaryKeyPolicy() == 1 && "0".equals(values)) {
                    Log.d((String)"SQLiteModel", (String)("toContentValues:" + column + " is primary key should be autoIncremented."));
                    continue;
                }
                if (this.getPrimaryKeyPolicy() == 2) {
                    if (TextUtils.isEmpty((CharSequence)values)) {
                        values = UUID.randomUUID().toString();
                    } else if ("0".equals(values)) {
                        values = "" + (System.currentTimeMillis() + (long)((int)(Math.random() * 100.0)));
                    }
                    pairs.put(column, values);
                    continue;
                }
                pairs.put(column, values);
                continue;
            }
            pairs.put(column, values);
        }
        return pairs;
    }

    public boolean isPrimaryFieldDefined() {
        return !TextUtils.isEmpty((CharSequence)this.getPrimaryFieldName());
    }

    @Override
    public final void fillFromJson(JSONObject json) {
        try {
            List<String> keySet = SQLiteModel.JSONArrayToStringList(json.names());
            if (keySet.size() > 0) {
                for (String tmp : keySet) {
                    Object value;
                    if (tmp.equals(TAG_CLASS) || (value = this.createObject(tmp, json.optString(tmp))) == null) continue;
                    this.set(tmp, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void fillFromCursor(Cursor c) {
        this.fillFromCursor(c, DEFAULT_CURSOR_READER);
    }

    public final void fillFromCursor(Cursor cursor, CursorReader reader) {
        if (reader == null) {
            reader = DEFAULT_CURSOR_READER;
        }
        if (cursor != null) {
            reader.onReadCursor(this, cursor);
        }
    }

    public final void fillFromPrimaryKey(String primaryKey, SQLiteDatabase db) {
        String tb_name = this.getName();
        String[] tb_projection = this.getColumns();
        String primary_key_name = this.getPrimaryFieldName();
        Cursor c = db.query(tb_name, tb_projection, primary_key_name + "=?", new String[]{primaryKey}, null, null, null);
        if (c.getCount() > 0) {
            c.moveToNext();
            this.fillFromCursor(c);
        }
        c.close();
    }

    public void refresh(SQLiteDatabase db) {
        this.fillFromPrimaryKey(this.getPrimaryKey(), db);
    }

    public long merge(SQLiteDatabase db) {
        long out;
        if (this.exist(db)) {
            out = this.update(db);
            this.refresh(db);
        } else {
            out = this.insert(db);
        }
        return out;
    }

    @Override
    public long persist(SQLiteDatabase db) {
        if (this.exist(db)) {
            this.update(db);
            return 0L;
        }
        return this.insert(db);
    }

    protected void onPersistEmbeddedDbEntity(SQLiteDatabase db, Class cLass, QueryAble embeddedModel) {
        embeddedModel.persist(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(SQLiteDatabase db) {
        long out = 0L;
        try {
            out = db.insert(this.getName(), null, this.toContentValues());
            this.persistEmbeddedDbEntity(db);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(SQLiteDatabase db) {
        int out = 0;
        try {
            out = this.update(db, this.getPrimaryFieldName() + "= ?", new String[]{this.getPrimaryKey()});
            this.persistEmbeddedDbEntity(db);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    public void merge(SQLiteModel entity) {
        this.merge(entity, true, true);
    }

    public void merge(SQLiteModel entity, boolean override, boolean mergeEmptyValue) {
        HashMap<String, Object> bundle = entity.fieldNameValuePair;
        for (String tmp : bundle.keySet()) {
            Object obj = bundle.get(tmp);
            if (obj == null) continue;
            if (this.fieldNameValuePair.containsValue(obj) && override) {
                if (!mergeEmptyValue && obj == null || TextUtils.isEmpty((CharSequence)obj.toString())) continue;
                this.fieldNameValuePair.put(tmp, obj);
                continue;
            }
            this.fieldNameValuePair.put(tmp, obj);
        }
    }

    @Override
    public boolean exist(SQLiteDatabase db) {
        String primary_key = this.getPrimaryFieldName();
        String tb_name = this.getName();
        if (TextUtils.isEmpty((CharSequence)primary_key)) {
            return false;
        }
        Cursor c = db.query(tb_name, new String[]{primary_key}, primary_key + "= ?", new String[]{this.getPrimaryKey()}, null, null, null);
        int count = c.getCount();
        c.close();
        return count > 0;
    }

    @Override
    public int delete(SQLiteDatabase db) {
        return this.delete(db, this.getPrimaryFieldName() + "= ?", new String[]{this.getPrimaryKey()});
    }

    public static SQLiteModel fromObject(Object obj) throws InstantiationException, IllegalAccessException {
        return SQLiteModel.fromObject(obj, DEFAULT_SERIALIZER);
    }

    public static SQLiteModel fromObject(Object obj, Serializer serializer) throws InstantiationException, IllegalAccessException {
        if (serializer == null) {
            serializer = DEFAULT_SERIALIZER;
        }
        try {
            if (obj instanceof SQLiteModel) {
                SQLiteModel model = (SQLiteModel)obj;
                return (SQLiteModel)model.clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Builder builder = new Builder();
        Class<?> cLass = obj.getClass();
        ArrayList<String> tmp = new ArrayList<String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Field> nameFieldPair = new HashMap<String, Field>();
        HashMap<String, Field> nestedTableField = new HashMap<String, Field>();
        boolean hasColumnAnnotation = false;
        String primaryKey = null;
        String eligiblePrimaryName = null;
        try {
            List<Field> fields = Toolkit.getAllFieldFields(cLass, true, false);
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                field.setAccessible(true);
                if (field.isAnnotationPresent(Ignore.class)) continue;
                String columnName = null;
                if (field.isAnnotationPresent(PrimaryKey.class) && primaryKey == null) {
                    primaryKey = field.getName();
                } else if (field.getName().equalsIgnoreCase("id")) {
                    eligiblePrimaryName = field.getName();
                }
                if (field.isAnnotationPresent(Column.class)) {
                    Column column = field.getAnnotation(Column.class);
                    columnName = column.name();
                    if (!hasColumnAnnotation) {
                        tmp.clear();
                    }
                    hasColumnAnnotation = true;
                }
                if (columnName == null && !hasColumnAnnotation) {
                    columnName = field.getName();
                }
                if (columnName == null || tmp.contains(columnName)) continue;
                tmp.add(columnName);
                Object value = field.get(obj);
                map.put(columnName, value);
                nameFieldPair.put(columnName, field);
                if (!SQLiteModel.isNestedTableProperty(field)) continue;
                nestedTableField.put(columnName, field);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (primaryKey == null) {
            primaryKey = eligiblePrimaryName;
        }
        if (!tmp.contains(primaryKey) && primaryKey != null) {
            tmp.add(primaryKey);
        }
        String[] projections = tmp.toArray(new String[tmp.size()]);
        String primary = primaryKey;
        String tableName = null;
        if (cLass.isAnnotationPresent(Table.class)) {
            Table table = cLass.getAnnotation(Table.class);
            tableName = table.name();
        }
        if (tableName == null) {
            tableName = cLass.getSimpleName();
        }
        builder.setName(tableName).setColumns(projections).setPrimaryFieldName(primary).setFieldNameValuePair(map).setNameFieldPair(nameFieldPair).setNestedTableNameFieldPair(nestedTableField).setModelClass(cLass).setSerializer(serializer);
        return builder.create();
    }

    public static <T> List<T> buildAsArrays(Class<T> cLass, Cursor c, CursorReader reader) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        ArrayList<T> list = new ArrayList<T>();
        while (c.moveToNext()) {
            list.add(SQLiteModel.buildAs(cLass, c, reader));
        }
        return list;
    }

    public static <T> T buildAs(Class<T> cLass, Cursor c, CursorReader reader) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        SQLiteModel model = SQLiteModel.fromClass(cLass);
        model.fillFromCursor(c, reader);
        return model.asClass(cLass);
    }

    public static SQLiteModel fromClass(Class cLass) throws InstantiationException, IllegalAccessException {
        return SQLiteModel.fromClass(cLass, DEFAULT_SERIALIZER);
    }

    public static SQLiteModel fromClass(Class cLass, Serializer serializer) throws InstantiationException, IllegalAccessException {
        if (serializer == null) {
            serializer = DEFAULT_SERIALIZER;
        }
        Builder builder = new Builder();
        ArrayList<String> projectionAdder = new ArrayList<String>();
        HashMap<String, Field> nameFieldPair = new HashMap<String, Field>();
        HashMap<String, Field> nestedTableField = new HashMap<String, Field>();
        boolean hasColumnAnnotation = false;
        String primaryKey = null;
        String eligiblePrimaryName = null;
        try {
            List<Field> fields = Toolkit.getAllFieldFields(cLass, true, false);
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                if (field.isAnnotationPresent(Ignore.class)) continue;
                String columnName = null;
                if (field.isAnnotationPresent(PrimaryKey.class) && primaryKey == null) {
                    primaryKey = field.getName();
                } else if (field.getName().equalsIgnoreCase("id")) {
                    eligiblePrimaryName = field.getName();
                }
                if (field.isAnnotationPresent(Column.class)) {
                    Column columnAnnotation;
                    Column column = columnAnnotation = field.getAnnotation(Column.class);
                    columnName = column.name();
                    if (!hasColumnAnnotation) {
                        projectionAdder.clear();
                    }
                    hasColumnAnnotation = true;
                }
                if (columnName == null && !hasColumnAnnotation) {
                    columnName = field.getName();
                }
                if (columnName == null || projectionAdder.contains(columnName)) continue;
                projectionAdder.add(columnName);
                nameFieldPair.put(columnName, field);
                if (!SQLiteModel.isNestedTableProperty(field)) continue;
                nestedTableField.put(columnName, field);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (primaryKey == null) {
            primaryKey = eligiblePrimaryName;
        }
        if (!projectionAdder.contains(primaryKey) && primaryKey != null) {
            projectionAdder.add(primaryKey);
        }
        String[] projections = projectionAdder.toArray(new String[projectionAdder.size()]);
        String primary = primaryKey;
        String tableName = null;
        if (cLass.isAnnotationPresent(Table.class)) {
            Table table = cLass.getAnnotation(Table.class);
            tableName = table.name();
        }
        if (tableName == null) {
            tableName = cLass.getSimpleName();
        }
        builder.setName(tableName).setColumns(projections).setPrimaryFieldName(primary).setNameFieldPair(nameFieldPair).setNestedTableNameFieldPair(nestedTableField).setModelClass(cLass).setSerializer(serializer);
        return builder.create();
    }

    private void persistEmbeddedDbEntity(SQLiteDatabase db) {
        try {
            for (String tmp : this.fieldNameValuePair.keySet()) {
                Class<?> cLass;
                Object obj = this.fieldNameValuePair.get(tmp);
                if (obj == null || !(cLass = obj.getClass()).isAnnotationPresent(Table.class)) continue;
                SQLiteModel model = SQLiteModel.fromObject(obj);
                this.onPersistEmbeddedDbEntity(db, cLass, model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JSONObject createJsonFromHashMap(HashMap<String, Object> bundle) {
        return SQLiteModel.createJsonFromHashMap(bundle, false);
    }

    private static JSONObject createJsonFromHashMap(HashMap<String, Object> bundle, boolean acceptEmpty) {
        try {
            JSONObject json = new JSONObject();
            for (String tmp : bundle.keySet()) {
                Object obj = bundle.get(tmp);
                if (obj == null && !acceptEmpty) {
                    if (!acceptEmpty) continue;
                    json.put(tmp, null);
                    continue;
                }
                if (obj == null) continue;
                if (obj instanceof JSONable) {
                    JSONable jsonModel = (JSONable)obj;
                    json.put(tmp, (Object)jsonModel.toJson());
                    continue;
                }
                String value = obj.toString();
                if (TextUtils.isEmpty((CharSequence)value) || value.equals(TAG_CLASS)) continue;
                json.put(tmp, (Object)value);
            }
            return json;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object createObject(String name, String objToString) {
        if (TextUtils.isEmpty((CharSequence)objToString)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(objToString);
            String clazz = json.optString(TAG_CLASS);
            if (TextUtils.isEmpty((CharSequence)clazz)) {
                clazz = this.getFieldTypeClass(name).getCanonicalName();
            }
            if (TextUtils.isEmpty((CharSequence)clazz)) {
                return objToString;
            }
            {
                catch (Exception e) {
                    e.printStackTrace();
                    return objToString;
                }
                try {
                    Class<?> cLass = Class.forName(clazz);
                    return cLass.getConstructor(JSONObject.class).newInstance(json);
                }
                catch (Exception e) {}
                {
                    e.printStackTrace();
                    Object obj = Class.forName(clazz).newInstance();
                    if (!(obj instanceof JSONable)) return objToString;
                    JSONable jsonModel = (JSONable)obj;
                    jsonModel.fillFromJson(json);
                    return jsonModel;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return objToString;
        }
    }

    public Field getField(String field) {
        if (this.nameFieldPair.containsKey(field)) {
            return this.nameFieldPair.get(field);
        }
        return null;
    }

    public Class<?> getFieldTypeClass(String fieldName) {
        if (this.fieldNameValuePair.containsKey(fieldName)) {
            Object obj = this.get(fieldName);
            if (obj != null) {
                return obj.getClass();
            }
        } else {
            Field field = this.getField(fieldName);
            if (field != null) {
                return field.getType();
            }
        }
        return Object.class;
    }

    public <T> T asClass(Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        return this.asClass(clazz, this.serializer);
    }

    public <T> T asClass(Class<T> clazz, Serializer serializer) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        T instance = Toolkit.newInstance(clazz);
        List<Field> fields = Toolkit.getAllFieldFields(clazz, true, false);
        for (Field field : fields) {
            if (field.isAnnotationPresent(Ignore.class)) continue;
            try {
                field.setAccessible(true);
                Object obj = serializer.onDeSerialize(this.getString(field.getName()), field);
                field.set(instance, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    private static boolean isNestedTableProperty(Field field) {
        return field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ManyToMany.class) || field.isAnnotationPresent(ManyToOne.class);
    }

    public static String getFieldColumnName(Field field) {
        if (field.isAnnotationPresent(Column.class)) {
            Column columnAnnotation;
            Column column = columnAnnotation = field.getAnnotation(Column.class);
            return column.name();
        }
        return null;
    }

    public static String getFieldNestedMappingName(Field field) {
        String mappedBy = null;
        if (field.isAnnotationPresent(OneToOne.class)) {
            OneToOne columnAnnotation;
            OneToOne column = columnAnnotation = field.getAnnotation(OneToOne.class);
            mappedBy = column.mappedBy();
        } else if (field.isAnnotationPresent(OneToMany.class)) {
            OneToMany columnAnnotation;
            OneToMany column = columnAnnotation = field.getAnnotation(OneToMany.class);
            mappedBy = column.mappedBy();
        } else if (field.isAnnotationPresent(ManyToMany.class)) {
            ManyToMany columnAnnotation;
            ManyToMany column = columnAnnotation = field.getAnnotation(ManyToMany.class);
            mappedBy = column.mappedBy();
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            ManyToOne columnAnnotation;
            ManyToOne column = columnAnnotation = field.getAnnotation(ManyToOne.class);
            mappedBy = column.mappedBy();
        }
        if (TextUtils.isEmpty((CharSequence)mappedBy)) {
            mappedBy = field.getType().getSimpleName() + "_id";
        }
        return mappedBy;
    }

    public void fillFromContentValues(ContentValues contentValue) {
        for (Map.Entry name : contentValue.valueSet()) {
            this.set((String)name.getKey(), name.getValue());
        }
    }

    private boolean hasPrimaryKey() {
        return !TextUtils.isEmpty((CharSequence)this.getPrimaryKey());
    }

    protected void clear() {
        String[] projections;
        for (String name : projections = this.getColumns()) {
            this.set(name, null);
        }
    }

    public void fillJson(Class<?> clazz, JSONObject json) throws IllegalAccessException, IllegalArgumentException, JSONException {
        List<Field> fields = Toolkit.getAllFieldIncludingPrivateAndSuper(clazz);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(PrimaryKey.class) && !field.isAnnotationPresent(Column.class)) continue;
            field.setAccessible(true);
            Object obj = field.get(this.instance);
            if (obj instanceof JSONable) {
                JSONable jsonEntity = (JSONable)obj;
                json.put(field.getName(), (Object)jsonEntity.toJson());
                continue;
            }
            json.put(field.getName(), field.get(this.instance));
        }
    }

    protected int update(SQLiteDatabase db, String whereClause, String[] whereArgs) {
        return db.update(this.getName(), this.toContentValues(), whereClause, whereArgs);
    }

    protected int delete(SQLiteDatabase db, String whereClause, String[] whereArgs) {
        return db.delete(this.getName(), whereClause, whereArgs);
    }

    public static ContentValues createContentValuesFromJSONObject(JSONObject json) throws JSONException {
        ContentValues pair = new ContentValues();
        List<String> keySet = SQLiteModel.JSONArrayToStringList(json.names());
        if (keySet.size() > 0) {
            for (String tmp : keySet) {
                String value = json.optString(tmp);
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                pair.put(tmp, value);
            }
        }
        return pair;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static List<String> JSONArrayToStringList(JSONArray array) throws JSONException {
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            out.add(array.getString(i));
        }
        return out;
    }

    public int getPrimaryKeyPolicy() {
        Field field = this.getField(this.getPrimaryFieldName());
        if (field != null && field.isAnnotationPresent(PrimaryKey.class)) {
            PrimaryKey primary = field.getAnnotation(PrimaryKey.class);
            return primary.policy();
        }
        return 0;
    }

    String[] getNestedTableColumnNames() {
        String[] out = new String[this.nestedTableFieldPair.size()];
        Iterator<String> iterator = this.nestedTableFieldPair.keySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            out[index] = iterator.next();
            ++index;
        }
        return out;
    }

    Field[] getNestedTableFields() {
        Field[] out = new Field[this.nestedTableFieldPair.size()];
        Iterator<String> iterator = this.nestedTableFieldPair.keySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            String name = iterator.next();
            out[index] = this.nestedTableFieldPair.get(name);
            ++index;
        }
        return out;
    }

    static final SQLiteModel createFromManyToMany(Class<?> parentTableClass, Class<?> childTableClass) throws InstantiationException, IllegalAccessException {
        SQLiteModel parentModel = SQLiteModel.getSQLiteModel(parentTableClass);
        SQLiteModel childModel = SQLiteModel.getSQLiteModel(childTableClass);
        String parentTable = parentModel.getName();
        String childTable = childModel.getName();
        Builder builder = new Builder();
        builder.setName(parentTable + "_" + childTable).addColumn("id_" + parentTable).addColumn("id_" + childTable);
        return builder.create();
    }

    private static SQLiteModel getSQLiteModel(Class<?> childTableClass) throws IllegalAccessException, InstantiationException {
        return SQLiteModel.fromClass(childTableClass);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public void setCursorReader(CursorReader cursorReader) {
        this.cursorReader = cursorReader;
    }

    static /* synthetic */ Serializer access$000() {
        return DEFAULT_SERIALIZER;
    }

    public static interface CursorReader {
        public void onReadCursor(SQLiteModel var1, Cursor var2);
    }

    public static interface Serializer {
        public String onSerialize(Object var1, String var2);

        public Object onDeSerialize(String var1, Field var2);
    }

    public static final class Builder {
        Serializer serializer = SQLiteModel.access$000();
        Class<?> modelClass = Object.class;
        String name;
        String primaryFieldName;
        List<String> projections = new ArrayList<String>();
        HashMap<String, Object> FieldNameValuePair = new HashMap();
        HashMap<String, Field> nameFieldPair = new HashMap();
        HashMap<String, Field> nestedTableNameFieldPair = new HashMap();

        public Builder setSerializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder setPrimaryFieldName(String name) {
            this.primaryFieldName = name;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addColumn(String ... name) {
            for (String n : name) {
                this.projections.add(n);
            }
            return this;
        }

        public Builder setColumns(String[] projections) {
            this.projections = new ArrayList<String>();
            Collections.addAll(this.projections, projections);
            return this;
        }

        public void setColumns(List<String> projections) {
            this.projections = projections;
        }

        public Builder setFieldNameValuePair(HashMap<String, Object> fieldNameValuePair) {
            this.FieldNameValuePair = fieldNameValuePair;
            return this;
        }

        public Builder setNameFieldPair(HashMap<String, Field> nameFieldPair) {
            this.nameFieldPair = nameFieldPair;
            return this;
        }

        public Builder setModelClass(Class<?> cLass) {
            this.modelClass = cLass;
            return this;
        }

        public Builder setNestedTableNameFieldPair(HashMap<String, Field> nestedTableNameFieldPair) {
            this.nestedTableNameFieldPair = nestedTableNameFieldPair;
            return this;
        }

        public SQLiteModel create() {
            SQLiteModel model = new SQLiteModel(){

                @Override
                public String getName() {
                    return Builder.this.name;
                }

                @Override
                public String[] getColumns() {
                    return Builder.this.projections.toArray(new String[Builder.this.projections.size()]);
                }

                @Override
                public String getPrimaryFieldName() {
                    return Builder.this.primaryFieldName;
                }
            };
            model.fieldNameValuePair = this.FieldNameValuePair;
            model.nameFieldPair = this.nameFieldPair;
            model.nestedTableFieldPair = this.nestedTableNameFieldPair;
            model.modelClass = this.modelClass;
            if (this.serializer != null) {
                model.serializer = this.serializer;
            }
            return model;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ManyToMany {
        public String mappedBy() default "";
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ManyToOne {
        public String mappedBy();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OneToMany {
        public String mappedBy();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OneToOne {
        public String mappedBy();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NotNull {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Ignore {
        public int when() default 0;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PrimaryKey {
        public static final int POLICY_AUTO_GENERATE = 2;
        public static final int POLICY_AUTO_INCREMENT = 1;
        public static final int POLICY_SYSTEM = 3;
        public static final int POLICY_NONE = 0;

        public int policy() default 0;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Column {
        public String name() default "";

        public boolean nullable() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Table {
        public String name() default "";
    }
}

