/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.SQLiteModel;
import istat.android.data.access.sqlite.interfaces.QueryAble;
import java.util.ArrayList;
import java.util.List;

public final class SQLitePersist {
    List<SQLiteModel> modelPersist = new ArrayList<SQLiteModel>();
    List<Object> persists = new ArrayList<Object>();
    SQLite.SQL sql;

    SQLitePersist(SQLite.SQL sql) {
        this.sql = sql;
    }

    public SQLitePersist persist(Object insert) {
        try {
            SQLiteModel model = SQLiteModel.fromObject(insert);
            this.modelPersist.add(model);
            this.persists.add(insert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public SQLitePersist persist(List<?> insert) {
        for (Object obj : insert) {
            try {
                SQLiteModel model = SQLiteModel.fromObject(obj);
                this.modelPersist.add(model);
                this.persists.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public SQLitePersist persist(Object ... insert) {
        for (Object obj : insert) {
            try {
                SQLiteModel model = SQLiteModel.fromObject(obj);
                this.modelPersist.add(model);
                this.persists.add(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public long[] execute() {
        if (this.modelPersist == null || this.modelPersist.size() == 0) {
            return new long[]{0L};
        }
        long[] out = new long[this.modelPersist.size()];
        int index = 0;
        for (QueryAble queryAble : this.modelPersist) {
            out[index] = queryAble.persist(this.sql.db);
            ++index;
        }
        this.modelPersist.clear();
        this.notifyExecuted();
        return out;
    }

    private void notifyExecuted() {
        if (this.sql.autoClose) {
            this.sql.close();
        }
    }

    public List<Object> getPersists() {
        return this.persists;
    }
}

