/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.SQLiteClause;
import istat.android.data.access.sqlite.SQLiteFunction;
import istat.android.data.access.sqlite.SQLiteModel;
import istat.android.data.access.sqlite.interfaces.QueryAble;
import istat.android.data.access.sqlite.utils.SQLiteAsyncExecutor;
import istat.android.data.access.sqlite.utils.SQLiteThread;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class SQLiteSelect
extends SQLiteClause<SQLiteSelect> {
    public static final String ORDER_BY_DESC = "DESC";
    public static final String ORDER_BY_ASC = "ASC";
    public static final int TYPE = 0;
    Class<?> clazz;
    String selectionTable;
    boolean distinct = false;
    public static final String TYPE_JOIN_INNER = " INNER ";
    public static final String TYPE_JOIN_LEFT = " LEFT ";
    public static final String TYPE_JOIN_RIGHT = " RIGHT ";
    public static final String TYPE_JOIN_FULL = " FULL ";

    SQLiteSelect(SQLite.SQL db, Class<?> ... clazz) {
        super(clazz[0], db);
        this.clazz = clazz[0];
        this.selectionTable = this.table;
    }

    public SQLiteJoinSelect joinOn(Class<?> clazz, String on) {
        try {
            QueryAble entity = this.createQueryAble(clazz);
            String join = entity.getName();
            this.selectionTable = this.selectionTable + " INNER JOIN " + join;
            if (!TextUtils.isEmpty((CharSequence)on)) {
                this.selectionTable = this.selectionTable + " ON (" + on + ") ";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SQLiteJoinSelect(this.sql, this.clazz);
    }

    public SQLiteJoinSelect joinOn(String joinTable, String on) {
        try {
            String join = joinTable;
            this.selectionTable = this.selectionTable + " INNER JOIN " + join;
            if (!TextUtils.isEmpty((CharSequence)on)) {
                this.selectionTable = this.selectionTable + " ON (" + on + ") ";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SQLiteJoinSelect(this.sql, this.clazz);
    }

    protected SQLiteSelect distinct(boolean enable) {
        this.distinct = enable;
        return this;
    }

    private QueryAble createQueryAble(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        return SQLiteModel.fromClass(clazz);
    }

    protected Cursor onExecute(SQLiteDatabase db) {
        this.notifyExecuting();
        String[] smartColumns = new String[this.columns.length];
        String tableName = this.table;
        for (int i = 0; i < this.columns.length; ++i) {
            smartColumns[i] = SQLiteSelect.buildRealColumnName(tableName, this.columns[i]);
        }
        return db.query(this.distinct, this.selectionTable, smartColumns, this.getWhereClause(), this.getWhereParams(), this.getGroupBy(), this.getHaving(), this.getOrderBy(), this.getLimit());
    }

    public int count() {
        Cursor c = this.onExecute(this.sql.db);
        int count = c.getCount();
        c.close();
        this.notifyExecuted();
        return count;
    }

    public <T> List<T> execute(int offset, int limit) {
        String limitS;
        if (limit < 0) {
            limitS = null;
        } else {
            if (offset < 0) {
                offset = 0;
            }
            limitS = offset + ", " + limit;
        }
        return this.execute(limitS);
    }

    public <T> void execute(List<T> list, int offset, int limit) {
        String limitS;
        if (limit < 0) {
            limitS = null;
        } else {
            if (offset < 0) {
                offset = 0;
            }
            limitS = offset + ", " + limit;
        }
        this.execute(list, limitS);
    }

    public <T> List<T> execute(int limit) {
        return this.execute(limit > 0 ? "" + limit : null);
    }

    public <T> void execute(List<T> list, int limit) {
        this.execute(list, limit > 0 ? "" + limit : null);
    }

    public <T> List<T> execute(String limit) {
        this.limit = limit;
        return this.execute();
    }

    public <T> void execute(List<T> list, String limit) {
        this.limit = limit;
        this.execute(list);
    }

    public <T> List<T> execute() {
        ArrayList list = new ArrayList();
        this.execute(list);
        return list;
    }

    public <T> T executeLimitOne() {
        List<T> results = this.execute(1);
        return results.isEmpty() ? null : (T)results.get(0);
    }

    public Cursor getCursor() {
        return this.onExecute(this.sql.db);
    }

    public List<SQLiteModel> getResults() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Cursor c = this.getCursor();
        ArrayList<SQLiteModel> list = new ArrayList<SQLiteModel>();
        while (c.moveToNext()) {
            SQLiteModel model = SQLiteModel.fromClass(this.clazz);
            model.fillFromCursor(c);
            list.add(model);
        }
        return list;
    }

    public <T> void execute(List<T> list) {
        if (list == null) {
            return;
        }
        try {
            Cursor c = this.onExecute(this.sql.db);
            if (c.getCount() > 0) {
                while (c.moveToNext()) {
                    Object model = this.createObjectFromCursor(this.clazz, c);
                    list.add(model);
                }
            }
            c.close();
            this.notifyExecutionSucceed(0, this, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyExecutionFail(e);
        }
        this.notifyExecuted();
    }

    public <T> List<T> execute(Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            Cursor c = this.onExecute(this.sql.db);
            if (c.getCount() > 0) {
                while (c.moveToNext()) {
                    T model = this.createObjectFromCursor(clazz, c);
                    list.add(model);
                }
            }
            c.close();
            this.notifyExecutionSucceed(0, this, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyExecutionFail(e);
        }
        this.notifyExecuted();
        return list;
    }

    public <T> SQLiteThread<List<T>> executeAsync() {
        return this.executeAsync(-1, -1, null);
    }

    public <T> SQLiteThread<List<T>> executeAsync(SQLiteAsyncExecutor.ExecutionCallback<List<T>> callback) {
        return this.executeAsync(-1, -1, callback);
    }

    public <T> SQLiteThread<List<T>> executeAsync(int limit, SQLiteAsyncExecutor.ExecutionCallback<List<T>> callback) {
        return this.executeAsync(-1, limit, callback);
    }

    public <T> SQLiteThread<List<T>> executeAsync(int offset, int limit, SQLiteAsyncExecutor.ExecutionCallback<List<T>> callback) {
        SQLiteAsyncExecutor asyncExecutor = new SQLiteAsyncExecutor();
        return asyncExecutor.execute(this, offset, limit, callback);
    }

    private <T> T createObjectFromCursor(Class<T> clazz, Cursor c) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        SQLiteModel model = SQLiteModel.fromClass(clazz);
        model.fillFromCursor(c);
        T obj = model.asClass(clazz);
        return obj;
    }

    final String getSql() {
        String columns = "";
        for (int i = 0; i < this.columns.length; ++i) {
            columns = columns + this.columns[i];
            if (i >= this.columns.length - 1) continue;
            columns = columns + ",";
        }
        String out = "SELECT " + columns + " FROM " + this.selectionTable;
        String whereClause = this.getWhereClause();
        String having = this.getHaving();
        String orderBy = this.getOrderBy();
        String groupBy = this.getGroupBy();
        String limit = this.getLimit();
        if (!TextUtils.isEmpty((CharSequence)whereClause)) {
            out = out + " WHERE " + whereClause.trim();
        }
        if (!TextUtils.isEmpty((CharSequence)orderBy)) {
            out = out + " ORDER BY " + orderBy;
        }
        if (!TextUtils.isEmpty((CharSequence)groupBy)) {
            out = out + " GROUP BY " + groupBy;
        }
        if (!TextUtils.isEmpty((CharSequence)having)) {
            out = out + " HAVING " + having;
        }
        if (!TextUtils.isEmpty((CharSequence)limit)) {
            out = out + " LIMIT " + limit;
        }
        return out;
    }

    public String toString() {
        return this.getStatement();
    }

    public String toString(boolean details) {
        return details ? this.getSql() : this.getStatement();
    }

    @Override
    public final String getStatement() {
        String columnParam = "*";
        try {
            SQLiteModel entity = SQLiteModel.fromClass(this.clazz);
            if (entity.getColumns().length != this.columns.length) {
                columnParam = "";
                for (int i = 0; i < this.columns.length; ++i) {
                    columnParam = columnParam + this.columns[i];
                    if (i >= this.columns.length - 1) continue;
                    columnParam = columnParam + ",";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String out = "SELECT " + columnParam + " FROM " + this.selectionTable;
        String whereClause = this.getWhereClause();
        String having = this.getHaving();
        String orderBy = this.getOrderBy();
        String groupBy = this.getGroupBy();
        String limit = this.getLimit();
        if (!TextUtils.isEmpty((CharSequence)whereClause)) {
            out = out + " WHERE " + whereClause.trim();
        }
        String sql = this.compute(out, this.whereParams);
        if (!TextUtils.isEmpty((CharSequence)orderBy)) {
            sql = sql + " ORDER BY " + orderBy;
        }
        if (!TextUtils.isEmpty((CharSequence)groupBy)) {
            sql = sql + " GROUP BY " + groupBy;
        }
        if (!TextUtils.isEmpty((CharSequence)having)) {
            sql = sql + " HAVING " + having;
        }
        if (!TextUtils.isEmpty((CharSequence)limit)) {
            sql = sql + " LIMIT " + limit;
        }
        return sql;
    }

    public ClauseJoinBuilder join(Class<?> clazz) {
        return this.join(clazz, TYPE_JOIN_INNER);
    }

    public ClauseJoinBuilder innerJoin(Class<?> clazz) {
        return this.join(clazz, TYPE_JOIN_INNER);
    }

    public ClauseJoinBuilder leftJoin(Class<?> clazz) {
        return this.join(clazz, TYPE_JOIN_LEFT);
    }

    public ClauseJoinBuilder rightJoin(Class<?> clazz) {
        return this.join(clazz, TYPE_JOIN_RIGHT);
    }

    public ClauseJoinBuilder fullJoin(Class<?> clazz) {
        return this.join(clazz, TYPE_JOIN_FULL);
    }

    public ClauseJoinBuilder join(Class<?> clazz, String joinType) {
        try {
            QueryAble entity = this.createQueryAble(clazz);
            String join = entity.getName();
            this.selectionTable = this.selectionTable + joinType + "JOIN " + join;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SQLiteJoinSelect joinSelection = new SQLiteJoinSelect(this.sql, this.clazz);
        return new ClauseJoinBuilder(clazz, joinSelection);
    }

    public SQLiteSelectLimit limit(int limit) {
        return this.limit(-1, limit);
    }

    public SQLiteSelectLimit limit(int offset, int limit) {
        String limitS;
        if (limit < 0) {
            limitS = null;
        } else {
            if (offset < 0) {
                offset = 0;
            }
            limitS = offset + ", " + limit;
        }
        return new SQLiteSelectLimit(limitS);
    }

    SQLiteClause.ClauseBuilder internalHaving(String or_and, String having) {
        if (this.having == null) {
            this.having = new StringBuilder(this.buildRealColumnName(having));
        } else {
            this.having.append(" " + or_and + " " + this.buildRealColumnName(having));
        }
        SQLiteClause.ClauseBuilder builder = new SQLiteClause.ClauseBuilder(this, this.having, this.havingWhereParams, 4);
        return builder;
    }

    SQLiteClause.ClauseBuilder internalHaving(String or_and, String function, String having) {
        String value = function + "(" + this.buildRealColumnName(having) + ")";
        if (this.having == null) {
            this.having = new StringBuilder(value);
        } else {
            this.having.append(" " + or_and + " " + value);
        }
        SQLiteClause.ClauseBuilder builder = new SQLiteClause.ClauseBuilder(this, this.having, this.havingWhereParams, 4);
        return builder;
    }

    SQLiteClause.ClauseBuilder internalHaving(String or_and, SQLiteFunction function) {
        throw new RuntimeException("Not yet implemented");
    }

    public SQLiteClause.ClauseBuilder having(String having) {
        return this.internalHaving("AND", having);
    }

    public SQLiteClause.ClauseBuilder andHaving(String having) {
        return this.internalHaving("AND", having);
    }

    public SQLiteClause.ClauseBuilder orHaving(String having) {
        return this.internalHaving("OR", having);
    }

    public SQLiteClause.ClauseBuilder having(String function, String having) {
        return this.internalHaving("AND", function, having);
    }

    public SQLiteClause.ClauseBuilder andHaving(String function, String having) {
        return this.internalHaving("AND", function, having);
    }

    public SQLiteClause.ClauseBuilder orHaving(String function, String having) {
        return this.internalHaving("OR", function, having);
    }

    public SQLiteClause.ClauseBuilder having(SQLiteFunction function) {
        return this.internalHaving("AND", function);
    }

    public SQLiteClause.ClauseBuilder andHaving(SQLiteFunction function) {
        return this.internalHaving("AND", function);
    }

    public SQLiteClause.ClauseBuilder orHaving(SQLiteFunction function) {
        return this.internalHaving("OR", function);
    }

    public class SQLiteSelectLimit {
        SQLiteSelectLimit(String limitS) {
            SQLiteSelect.this.limit = limitS;
        }

        public List<SQLiteModel> getResults() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            return SQLiteSelect.this.getResults();
        }

        public Cursor getCursor() {
            return SQLiteSelect.this.getCursor();
        }

        public <T> void execute(List<T> list) {
            SQLiteSelect.this.execute(list);
        }

        public <T> List<T> execute() {
            return SQLiteSelect.this.execute();
        }

        public <T> List<T> execute(Class<T> clazz) {
            return SQLiteSelect.this.execute(clazz);
        }

        public <T> SQLiteThread<List<T>> executeAsync() {
            return SQLiteSelect.this.executeAsync(-1, -1, null);
        }

        public <T> SQLiteThread<List<T>> executeAsync(SQLiteAsyncExecutor.ExecutionCallback<List<T>> callback) {
            return SQLiteSelect.this.executeAsync(-1, -1, callback);
        }

        public <T> SQLiteThread<List<T>> executeAsync(int limit, SQLiteAsyncExecutor.ExecutionCallback<List<T>> callback) {
            return SQLiteSelect.this.executeAsync(-1, limit, callback);
        }

        public <T> SQLiteThread<List<T>> executeAsync(int offset, int limit, SQLiteAsyncExecutor.ExecutionCallback<List<T>> callback) {
            return SQLiteSelect.this.executeAsync(offset, limit, callback);
        }

        public String getStatement() {
            return SQLiteSelect.this.getStatement();
        }
    }

    public final class SQLiteJoinSelect
    extends SQLiteSelect {
        SQLiteJoinSelect(SQLite.SQL db, Class<?> ... clazz) {
            super(db, clazz);
            this.whereClause = SQLiteSelect.this.whereClause;
            this.whereParams = SQLiteSelect.this.whereParams;
            this.selectionTable = SQLiteSelect.this.selectionTable;
            this.table = SQLiteSelect.this.table;
        }

        public ClauseJoinSelectBuilder where(Class<?> clazz, String column) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(clazz);
                if (this.whereClause == null) {
                    this.whereClause = new StringBuilder(SQLiteJoinSelect.buildRealColumnName(model.getName(), column));
                } else {
                    this.whereClause.append(" AND " + SQLiteJoinSelect.buildRealColumnName(model.getName(), column));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new ClauseJoinSelectBuilder(1, this);
        }

        public ClauseJoinSelectBuilder or(Class<?> clazz, String column) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(clazz);
                if (this.whereClause == null) {
                    this.whereClause = new StringBuilder(SQLiteJoinSelect.buildRealColumnName(model.getName(), column));
                } else {
                    this.whereClause.append(" OR " + SQLiteJoinSelect.buildRealColumnName(model.getName(), column));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new ClauseJoinSelectBuilder(1, this);
        }

        public ClauseJoinSelectBuilder and(Class<?> clazz, String column) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(clazz);
                if (this.whereClause == null) {
                    this.whereClause = new StringBuilder(SQLiteJoinSelect.buildRealColumnName(model.getName(), column));
                } else {
                    this.whereClause.append(" AND " + SQLiteJoinSelect.buildRealColumnName(model.getName(), column));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new ClauseJoinSelectBuilder(1, this);
        }

        SQLiteClause.ClauseBuilder internalHaving(String or_and, Class cLass, String having) {
            String table = this.selectionTable;
            try {
                SQLiteModel model = SQLiteModel.fromClass(cLass);
                table = model.getName();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (this.having == null) {
                this.having = new StringBuilder(SQLiteJoinSelect.buildRealColumnName(table, having));
            } else {
                this.having.append(" " + or_and + " " + SQLiteJoinSelect.buildRealColumnName(table, having));
            }
            SQLiteClause.ClauseBuilder builder = new SQLiteClause.ClauseBuilder(this, this.having, this.havingWhereParams, 4);
            return builder;
        }

        SQLiteClause.ClauseBuilder internalHaving(String or_and, Class cLass, String function, String having) {
            String table = this.selectionTable;
            try {
                SQLiteModel model = SQLiteModel.fromClass(cLass);
                table = model.getName();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            String value = function + "(" + SQLiteJoinSelect.buildRealColumnName(table, having) + ")";
            if (this.having == null) {
                this.having = new StringBuilder(value);
            } else {
                this.having.append(" " + or_and + " " + value);
            }
            SQLiteClause.ClauseBuilder builder = new SQLiteClause.ClauseBuilder(this, this.having, this.havingWhereParams, 4);
            return builder;
        }

        @Override
        SQLiteClause.ClauseBuilder internalHaving(String or_and, SQLiteFunction function) {
            throw new RuntimeException("Not yet implemented");
        }

        public SQLiteClause.ClauseBuilder having(Class cLass, String having) {
            return this.internalHaving("AND", cLass, having);
        }

        public SQLiteClause.ClauseBuilder andHaving(Class cLass, String having) {
            return this.internalHaving("AND", cLass, having);
        }

        public SQLiteClause.ClauseBuilder orHaving(Class cLass, String having) {
            return this.internalHaving("OR", cLass, having);
        }

        public SQLiteClause.ClauseBuilder having(Class cLass, String function, String having) {
            return this.internalHaving("AND", cLass, function, having);
        }

        public SQLiteClause.ClauseBuilder andHaving(Class cLass, String function, String having) {
            return this.internalHaving("AND", cLass, function, having);
        }

        public SQLiteClause.ClauseBuilder orHaving(Class cLass, String function, String having) {
            return this.internalHaving("OR", cLass, function, having);
        }

        @Override
        public SQLiteClause.ClauseBuilder having(SQLiteFunction function) {
            return this.internalHaving("AND", function);
        }

        @Override
        public SQLiteClause.ClauseBuilder andHaving(SQLiteFunction function) {
            return this.internalHaving("AND", function);
        }

        @Override
        public SQLiteClause.ClauseBuilder orHaving(SQLiteFunction function) {
            return this.internalHaving("OR", function);
        }

        @Override
        protected String buildRealColumnName(String column) {
            return column;
        }
    }

    public class ClauseSubJoinBuilder {
        SQLiteJoinSelect joinSelect;
        String columnJoinName;

        ClauseSubJoinBuilder(SQLiteJoinSelect joinSelect, String name) {
            this.joinSelect = joinSelect;
            this.columnJoinName = name;
        }

        public SQLiteJoinSelect equalTo(Class<?> clazz, String name) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(clazz);
                name = SQLiteClause.buildRealColumnName(model.getName(), name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.joinSelect.selectionTable = SQLiteSelect.this.selectionTable = SQLiteSelect.this.selectionTable + " ON (" + this.columnJoinName + "=" + name + ") ";
            return this.joinSelect;
        }
    }

    public class ClauseJoinBuilder {
        SQLiteJoinSelect joinSelect;
        Class<?> clazz;

        ClauseJoinBuilder(Class<?> clazz, SQLiteJoinSelect selection) {
            this.clazz = clazz;
            this.joinSelect = selection;
        }

        public ClauseSubJoinBuilder on(Class<?> clazz, String name) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(clazz);
                name = SQLiteClause.buildRealColumnName(model.getName(), name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new ClauseSubJoinBuilder(this.joinSelect, name);
        }

        private SQLiteJoinSelect buildSubJoin() throws IllegalAccessException, InstantiationException {
            Class selectionClass = this.joinSelect.clazz;
            Class<?> joinClass = this.clazz;
            SQLiteModel selectionModel = SQLiteModel.fromClass(selectionClass);
            SQLiteModel joinModel = SQLiteModel.fromClass(selectionClass);
            Field[] fields = selectionModel.getNestedTableFields();
            String nestedPrimaryKey = joinModel.getPrimaryFieldName();
            String foreignKey = selectionModel.getPrimaryFieldName();
            for (Field field : fields) {
                if (!field.getType().isAssignableFrom(joinClass)) continue;
                foreignKey = SQLiteModel.getFieldNestedMappingName(field);
            }
            return this.on(selectionClass, foreignKey).equalTo(joinClass, nestedPrimaryKey);
        }

        public ClauseJoinSelectBuilder where(Class<?> clazz, String column) {
            try {
                return this.buildSubJoin().where(clazz, column);
            }
            catch (Exception e) {
                return this.defaultWhere(clazz, column);
            }
        }

        private ClauseJoinSelectBuilder defaultWhere(Class<?> clazz, String column) {
            try {
                SQLiteModel model = SQLiteModel.fromClass(clazz);
                if (SQLiteSelect.this.whereClause == null) {
                    SQLiteSelect.this.whereClause = new StringBuilder(SQLiteClause.buildRealColumnName(model.getName(), column));
                } else {
                    SQLiteSelect.this.whereClause.append(" AND " + SQLiteClause.buildRealColumnName(model.getName(), column));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new ClauseJoinSelectBuilder(1, this.joinSelect);
        }

        public ClauseJoinBuilder innerJoin(Class<?> clazz) {
            try {
                return this.buildSubJoin().innerJoin(clazz);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }

        public ClauseJoinBuilder leftJoin(Class<?> clazz) {
            try {
                return this.buildSubJoin().leftJoin(clazz);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }

        public ClauseJoinBuilder rightJoin(Class<?> clazz) {
            try {
                return this.buildSubJoin().rightJoin(clazz);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }

        public ClauseJoinBuilder fullJoin(Class<?> clazz) {
            try {
                return this.buildSubJoin().fullJoin(clazz);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public class ClauseJoinSelectBuilder {
        int type = 0;
        SQLiteJoinSelect selectClause;

        public ClauseJoinSelectBuilder(int type, SQLiteJoinSelect selectClause) {
            this.type = type;
            this.selectClause = selectClause;
        }

        public SQLiteJoinSelect equalTo(Object value) {
            this.prepare(value);
            SQLiteSelect.this.whereClause.append(" = ? ");
            return this.selectClause;
        }

        public SQLiteJoinSelect notEqualTo(Object value) {
            this.prepare(value);
            SQLiteSelect.this.whereClause.append(" = ? ");
            return this.selectClause;
        }

        public <T> SQLiteJoinSelect notIn(T ... value) {
            return this.in(false, value);
        }

        public <T> SQLiteJoinSelect in(T ... value) {
            return this.in(true, value);
        }

        private <T> SQLiteJoinSelect in(boolean truth, T[] value) {
            String valueIn = "";
            for (int i = 0; i < value.length; ++i) {
                valueIn = value[i] instanceof Number ? valueIn + value[i] : valueIn + "'" + value[i] + "'";
                if (i >= value.length - 1) continue;
                valueIn = valueIn + ", ";
            }
            if (!valueIn.startsWith("(") && !valueIn.endsWith(")")) {
                valueIn = "(" + valueIn + ")";
            }
            SQLiteSelect.this.whereClause.append((truth ? "" : " NOT ") + " IN " + valueIn);
            return this.selectClause;
        }

        public SQLiteJoinSelect greatThan(Object value) {
            return this.greatThan(value, false);
        }

        public SQLiteJoinSelect lessThan(Object value) {
            return this.lessThan(value, false);
        }

        public SQLiteJoinSelect greatThan(Object value, boolean acceptEqual) {
            this.prepare(value);
            SQLiteSelect.this.whereClause.append(" >" + (acceptEqual ? "=" : "") + " ? ");
            return this.selectClause;
        }

        public SQLiteJoinSelect lessThan(Object value, boolean acceptEqual) {
            this.prepare(value);
            SQLiteSelect.this.whereClause.append(" <" + (acceptEqual ? "=" : "") + " ? ");
            return this.selectClause;
        }

        public SQLiteJoinSelect like(Object value) {
            this.prepare(value);
            SQLiteSelect.this.whereClause.append(" like ? ");
            return this.selectClause;
        }

        public SQLiteJoinSelect notLike(Object value) {
            this.prepare(value);
            SQLiteSelect.this.whereClause.append(" NOT like ? ");
            return this.selectClause;
        }

        public SQLiteJoinSelect equalTo(SQLiteSelect value) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" = (" + value + ") ");
            return this.selectClause;
        }

        public SQLiteJoinSelect notEqualTo(SQLiteSelect value) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" = (" + value + ") ");
            return this.selectClause;
        }

        public SQLiteJoinSelect in(SQLiteSelect value) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" IN (" + value.getSql() + ") ");
            return this.selectClause;
        }

        public SQLiteJoinSelect notIn(SQLiteSelect value) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" NOT IN (" + value.getSql() + ") ");
            return this.selectClause;
        }

        public SQLiteJoinSelect greatThan(SQLiteSelect value) {
            return this.greatThan(value, false);
        }

        public SQLiteJoinSelect lessThan(SQLiteSelect value) {
            return this.lessThan(value, false);
        }

        public SQLiteJoinSelect greatThan(SQLiteSelect value, boolean acceptEqual) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" >" + (acceptEqual ? "=" : "") + " (" + value.getSql() + ") ");
            return this.selectClause;
        }

        public SQLiteJoinSelect lessThan(SQLiteSelect value, boolean acceptEqual) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" <" + (acceptEqual ? "=" : "") + " (" + value.getSql() + ") ");
            return this.selectClause;
        }

        public SQLiteJoinSelect like(SQLiteSelect value) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" like (" + value.getSql() + ")");
            return this.selectClause;
        }

        public SQLiteJoinSelect notLike(SQLiteSelect value) {
            SQLiteSelect.this.whereParams.addAll(value.whereParams);
            SQLiteSelect.this.whereClause.append(" NOT like (" + value.getSql() + ")");
            return this.selectClause;
        }

        private void prepare(Object value) {
            SQLiteSelect.this.whereParams.add(value + "");
            switch (this.type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }
}

