/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.SQLiteClause;
import istat.android.data.access.sqlite.SQLiteModel;
import istat.android.data.access.sqlite.utils.SQLiteAsyncExecutor;
import istat.android.data.access.sqlite.utils.SQLiteThread;

public final class SQLiteUpdate {
    Updater updater;

    SQLiteUpdate(Class<?> clazz, SQLite.SQL sql) {
        this.updater = new Updater(clazz, sql);
    }

    public Updater setAs(Object entity) {
        String tbName = entity.getClass().getName();
        try {
            SQLiteModel model = SQLiteModel.fromObject(entity);
            this.updater.model.fieldNameValuePair.putAll(model.fieldNameValuePair);
            tbName = model.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Updater(tbName, this.updater.sql);
    }

    public Updater set(String name, Object value) {
        this.updater.model.set(name, value);
        return this.updater;
    }

    public SQLiteClause.ClauseBuilder where(String column) {
        return this.updater.where(column);
    }

    public class SQLiteUpdateLimit {
        Updater updater;

        SQLiteUpdateLimit(Updater updater, String limitS) {
            this.updater.limit = limitS;
            this.updater = updater;
        }

        public int execute() {
            return this.updater.execute();
        }

        public int execute(int limit) {
            return this.updater.execute(limit);
        }

        public SQLiteThread<Integer> executeAsync() {
            return this.updater.executeAsync();
        }

        public SQLiteThread<Integer> executeAsync(SQLiteAsyncExecutor.ExecutionCallback<Integer> callback) {
            return this.updater.executeAsync(callback);
        }

        public SQLiteThread<Integer> executeAsync(int limit, SQLiteAsyncExecutor.ExecutionCallback<Integer> callback) {
            return this.updater.executeAsync(limit, callback);
        }

        public String getStatement() {
            return this.updater.getStatement();
        }
    }

    public class Updater
    extends SQLiteClause<Updater> {
        protected SQLiteModel model;

        private void setModel(SQLiteModel model) {
            this.model = model;
        }

        protected Updater(Class<?> clazz, SQLite.SQL sql) {
            super(clazz, sql);
            try {
                this.model = SQLiteModel.fromClass(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected Updater(String clazz, SQLite.SQL sql) {
            super(clazz, null, sql);
        }

        public Updater set(String name, Object value) {
            this.model.set(name, value);
            return this;
        }

        @Override
        protected Object onExecute(SQLiteDatabase db) {
            this.notifyExecuting();
            String whereClause = this.getWhereClause();
            String[] whereParams = this.getWhereParams();
            if (!TextUtils.isEmpty((CharSequence)this.limit)) {
                this.whereClause.append(" LIMIT " + this.limit);
            }
            return db.update(this.model.getName(), this.model.toContentValues(), whereClause, whereParams);
        }

        public int execute() {
            int out = Integer.valueOf(this.onExecute(this.sql.db) + "");
            this.notifyExecuted();
            return out;
        }

        public SQLiteThread<Integer> executeAsync() {
            return this.executeAsync(-1, null);
        }

        public SQLiteThread<Integer> executeAsync(SQLiteAsyncExecutor.ExecutionCallback<Integer> callback) {
            return this.executeAsync(-1, callback);
        }

        public SQLiteThread<Integer> executeAsync(int limit, SQLiteAsyncExecutor.ExecutionCallback<Integer> callback) {
            SQLiteAsyncExecutor asyncExecutor = new SQLiteAsyncExecutor();
            return asyncExecutor.execute(this, limit, callback);
        }

        public int execute(int limit) {
            String limitS = limit < 0 ? null : "" + limit;
            return this.execute(limitS);
        }

        private int execute(String limit) {
            this.limit = limit;
            return this.execute();
        }

        @Override
        public String getStatement() {
            String out = "UPDATE FROM " + this.table;
            if (!TextUtils.isEmpty((CharSequence)this.whereClause)) {
                out = out + " WHERE '" + this.whereClause.toString().trim() + "'";
            }
            String[] splits = out.split("\\?");
            String sql = "";
            for (int i = 0; i < (!out.endsWith("?") ? splits.length - 1 : splits.length); ++i) {
                sql = sql + splits[i];
                sql = sql + "'" + (String)this.whereParams.get(i) + "'";
            }
            if (!out.endsWith("?")) {
                sql = sql + splits[splits.length - 1];
            }
            return sql;
        }

        public SQLiteUpdateLimit limit(int limit) {
            return this.limit(-1, limit);
        }

        public SQLiteUpdateLimit limit(int offset, int limit) {
            String limitS;
            if (limit < 0) {
                limitS = null;
            } else {
                if (offset < 0) {
                    offset = 0;
                }
                limitS = offset + ", " + limit;
            }
            return new SQLiteUpdateLimit(this, limitS);
        }
    }
}

