/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite.utils;

import android.app.Application;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import istat.android.data.access.sqlite.SQLite;
import istat.android.data.access.sqlite.SQLiteDelete;
import istat.android.data.access.sqlite.SQLiteInsert;
import istat.android.data.access.sqlite.SQLiteMerge;
import istat.android.data.access.sqlite.SQLitePersist;
import istat.android.data.access.sqlite.SQLiteSelect;
import istat.android.data.access.sqlite.SQLiteUpdate;
import java.util.List;

public abstract class SQLiteAccessApplication
extends Application
implements SQLite.BootDescription {
    static String applicationDbName;

    public void onCreate() {
        super.onCreate();
        applicationDbName = this.getDbName();
        SQLite.connect((Context)this, applicationDbName, this.getDbVersion(), (SQLite.BootDescription)this);
    }

    protected abstract String getDbName();

    protected abstract int getDbVersion();

    protected static final void executeScripts(SQLiteDatabase db, List<String> scripts) {
        for (String script : scripts) {
            db.execSQL(script);
        }
    }

    public static SQLiteSelect select(Class<?> cLass) throws Exception {
        return SQLite.fromConnection(applicationDbName, true).select(cLass);
    }

    public static SQLiteInsert insert(Object ... obj) throws Exception {
        return SQLite.fromConnection(applicationDbName, true).insert(obj);
    }

    public static SQLiteMerge merge(Object ... obj) throws Exception {
        return SQLite.fromConnection(applicationDbName, true).merge(obj);
    }

    public static SQLitePersist persist(Object ... obj) throws Exception {
        return SQLite.fromConnection(applicationDbName, true).persist(obj);
    }

    public static SQLiteUpdate update(Class<?> cLass) throws Exception {
        return SQLite.fromConnection(applicationDbName, true).update(cLass);
    }

    public static SQLiteDelete delete(Class<?> cLass) throws Exception {
        return SQLite.fromConnection(applicationDbName, true).delete(cLass);
    }
}

