/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite.utils;

import android.os.Handler;
import android.os.Looper;
import istat.android.data.access.sqlite.SQLiteDelete;
import istat.android.data.access.sqlite.SQLiteInsert;
import istat.android.data.access.sqlite.SQLiteMerge;
import istat.android.data.access.sqlite.SQLitePersist;
import istat.android.data.access.sqlite.SQLiteSelect;
import istat.android.data.access.sqlite.SQLiteUpdate;
import istat.android.data.access.sqlite.utils.SQLiteThread;
import java.util.List;

public class SQLiteAsyncExecutor {
    private Handler handler = new Handler(Looper.getMainLooper());

    public SQLiteAsyncExecutor(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public SQLiteAsyncExecutor() {
    }

    public <T> SQLiteThread execute(SQLiteSelect clause, int limit, ExecutionCallback<List<T>> callback) {
        return this.execute(clause, -1, limit, callback);
    }

    public <T> SQLiteThread execute(SQLiteSelect clause, ExecutionCallback<List<T>> callback) {
        return this.execute(clause, -1, -1, callback);
    }

    public <T> SQLiteThread execute(final SQLiteSelect clause, final int offset, final int limit, ExecutionCallback<List<T>> callback) {
        SQLiteThread thread = new SQLiteThread<List<T>>(callback){

            @Override
            protected List<T> onExecute() {
                return clause.execute(offset, limit);
            }
        };
        thread.start();
        return thread;
    }

    public SQLiteThread execute(SQLiteUpdate.Updater clause, ExecutionCallback<Integer> callback) {
        return this.execute(clause, -1, callback);
    }

    public SQLiteThread execute(final SQLiteUpdate.Updater clause, final int limit, ExecutionCallback<Integer> callback) {
        SQLiteThread<Integer> thread = new SQLiteThread<Integer>(callback){

            @Override
            protected Integer onExecute() {
                return clause.execute(limit);
            }
        };
        thread.start();
        return thread;
    }

    public SQLiteThread execute(final SQLiteInsert clause, ExecutionCallback<long[]> callback) {
        SQLiteThread<long[]> thread = new SQLiteThread<long[]>(callback){

            @Override
            protected long[] onExecute() {
                try {
                    return clause.execute();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
        thread.start();
        return thread;
    }

    public SQLiteThread execute(final SQLiteMerge clause, ExecutionCallback<long[]> callback) {
        SQLiteThread<long[]> thread = new SQLiteThread<long[]>(callback){

            @Override
            protected long[] onExecute() {
                return clause.execute();
            }
        };
        thread.start();
        return thread;
    }

    public SQLiteThread execute(final SQLitePersist clause, ExecutionCallback<long[]> callback) {
        SQLiteThread<long[]> thread = new SQLiteThread<long[]>(callback){

            @Override
            protected long[] onExecute() {
                return clause.execute();
            }
        };
        thread.start();
        return thread;
    }

    public SQLiteThread execute(final SQLiteDelete clause, ExecutionCallback<Integer> callback) {
        SQLiteThread<Integer> thread = new SQLiteThread<Integer>(callback){

            @Override
            protected Integer onExecute() {
                return clause.execute();
            }
        };
        thread.start();
        return thread;
    }

    public static interface ExecutionCallback<T> {
        public void onStart(SQLiteThread var1);

        public void onComplete(boolean var1);

        public void onSuccess(T var1);

        public void onError(Throwable var1);

        public void onAborted();
    }
}

