/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite.utils;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SQLiteParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> parseSqlAssetFile(String sqlFile, AssetManager assetManager) throws IOException {
        List<String> sqlIns = null;
        InputStream is = assetManager.open(sqlFile);
        try {
            sqlIns = SQLiteParser.parseSqlStream(is);
        }
        finally {
            is.close();
        }
        return sqlIns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> parseSqlResourceFile(Context context, int resSqlFile) throws IOException {
        List<String> sqlIns = null;
        InputStream is = context.getResources().openRawResource(resSqlFile);
        try {
            sqlIns = SQLiteParser.parseSqlStream(is);
        }
        finally {
            is.close();
        }
        return sqlIns;
    }

    public static List<String> parseSqlStream(InputStream is) throws IOException {
        String script = SQLiteParser.removeComments(is);
        return SQLiteParser.verifyStatements(SQLiteParser.splitSqlScript(script));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String removeComments(InputStream is) throws IOException {
        StringBuilder sql = new StringBuilder();
        InputStreamReader isReader = new InputStreamReader(is, "UTF-8");
        try {
            BufferedReader buffReader = new BufferedReader(isReader);
            try {
                String line;
                String multiLineComment = null;
                while ((line = buffReader.readLine()) != null) {
                    line = line.trim();
                    if (multiLineComment == null) {
                        if (line.startsWith("/*")) {
                            if (line.endsWith("}")) continue;
                            multiLineComment = "/*";
                            continue;
                        }
                        if (line.startsWith("{")) {
                            if (line.endsWith("}")) continue;
                            multiLineComment = "{";
                            continue;
                        }
                        if (line.startsWith("--") || line.equals("")) continue;
                        sql.append(line);
                        continue;
                    }
                    if (multiLineComment.equals("/*")) {
                        if (!line.endsWith("*/")) continue;
                        multiLineComment = null;
                        continue;
                    }
                    if (!multiLineComment.equals("{") || !line.endsWith("}")) continue;
                    multiLineComment = null;
                }
            }
            finally {
                buffReader.close();
            }
        }
        finally {
            isReader.close();
        }
        return sql.toString();
    }

    private static List<String> splitInsertion(String statement) {
        ArrayList<String> out = new ArrayList<String>();
        String INSERT = statement.substring(statement.indexOf("VALUES") + 6);
        int index = 0;
        while (true) {
            int lastIndex = ++index;
            index = INSERT.indexOf(",(", lastIndex);
            try {
                out.add(INSERT.substring(lastIndex, index));
            }
            catch (Exception e) {
                return out;
            }
        }
    }

    private static List<String> makeInsertBundle(String header, List<String> insertions, int size) {
        ArrayList<String> out = new ArrayList<String>();
        for (String insert : insertions) {
            out.add(header + insert);
        }
        return out;
    }

    private static List<String> verifyStatements(List<String> statements) {
        ArrayList<String> out = new ArrayList<String>();
        for (String statement : statements) {
            if (statement.length() <= 7) continue;
            String beginStatement = statement.substring(0, 6).toLowerCase();
            if (beginStatement.equals("persist")) {
                String insertHeader = statement.substring(0, statement.indexOf("VALUES") + 6);
                out.addAll(SQLiteParser.makeInsertBundle(insertHeader, SQLiteParser.splitInsertion(statement), 0));
                continue;
            }
            out.add(statement);
        }
        return out;
    }

    private static List<String> splitSqlScript(String script) {
        String[] statementsTable;
        ArrayList<String> statements = new ArrayList<String>();
        for (String tmp : statementsTable = script.split(";")) {
            statements.add(tmp.trim() + ";");
        }
        return statements;
    }
}

