/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite.utils;

import istat.android.data.access.sqlite.utils.SQLiteAsyncExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class SQLiteThread<T>
extends Thread {
    boolean running = false;
    SQLiteAsyncExecutor.ExecutionCallback<T> callback;
    T result;
    public static final int WHEN_BEGIN = -1;
    public static final int WHEN_ANYWAY = 0;
    public static final int WHEN_SUCCEED = 1;
    public static final int WHEN_ABORTION = 3;
    public static final int WHEN_FAILED = 4;
    final ConcurrentHashMap<Runnable, Integer> executedRunnable = new ConcurrentHashMap();
    final ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Runnable>> runnableTask = new ConcurrentHashMap();

    public SQLiteThread(SQLiteAsyncExecutor.ExecutionCallback<T> callback) {
        this.callback = callback;
    }

    @Override
    public final void run() {
        try {
            this.notifySuccess(this.onExecute());
        }
        catch (Exception e) {
            this.notifyError(e);
        }
    }

    protected abstract T onExecute();

    @Override
    public synchronized void start() {
        this.running = true;
        super.start();
        this.notifyStarted(this);
    }

    @Override
    public void interrupt() {
        this.running = false;
        if (this.callback != null) {
            this.callback.onAborted();
        }
        super.interrupt();
    }

    public void cancel() {
        this.interrupt();
    }

    protected void notifySuccess(T result) {
        this.result = result;
        if (this.callback != null) {
            this.notifyCompleted(true);
            this.callback.onSuccess(result);
        }
    }

    protected void notifyError(Throwable e) {
        if (this.callback != null) {
            this.notifyCompleted(false);
            this.callback.onError(e);
        }
        int when = 4;
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, when);
    }

    private void notifyCompleted(boolean state) {
        int when = 0;
        this.callback.onComplete(state);
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, 0);
    }

    private void notifyStarted(SQLiteThread thread) {
        int when = -1;
        if (this.callback != null) {
            this.callback.onStart(thread);
        }
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, when);
    }

    public SQLiteThread runWhen(final WhenCallback<T> callback, int ... when) {
        if (callback == null) {
            return this;
        }
        return this.runWhen(new Runnable(){

            @Override
            public void run() {
                Object resp = SQLiteThread.this.getResult();
                int when = SQLiteThread.this.executedRunnable.get(this);
                callback.onWhen(resp, when);
            }
        }, when);
    }

    public SQLiteThread runWhen(Runnable runnable, int ... when) {
        if (runnable == null) {
            return this;
        }
        for (int value : when) {
            this.addWhen(runnable, value);
        }
        return this;
    }

    private void addWhen(Runnable runnable, int conditionTime) {
        if (!this.isWhenContain(runnable, conditionTime)) {
            ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(conditionTime);
            if (runnableList == null) {
                runnableList = new ConcurrentLinkedQueue();
            }
            runnableList.add(runnable);
            this.runnableTask.put(conditionTime, runnableList);
        }
    }

    private boolean isWhenContain(Runnable run, int conditionTime) {
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(conditionTime);
        if (runnableList == null || runnableList.isEmpty()) {
            return false;
        }
        return runnableList.contains(run);
    }

    private void executeWhen(ConcurrentLinkedQueue<Runnable> runnableList, int when) {
        if (runnableList != null && runnableList.size() > 0) {
            for (Runnable runnable : runnableList) {
                if (this.executedRunnable.contains(runnable)) continue;
                runnable.run();
                this.executedRunnable.put(runnable, when);
            }
        }
    }

    public boolean dismissAllRunWhen() {
        boolean isEmpty = this.runnableTask.isEmpty();
        this.runnableTask.clear();
        return !isEmpty;
    }

    public boolean dismissRunWhen(int ... when) {
        boolean isEmpty = false;
        for (int i : when) {
            ConcurrentLinkedQueue<Runnable> runnables = this.runnableTask.get(i);
            if (runnables == null) continue;
            isEmpty &= runnables.isEmpty();
            runnables.clear();
        }
        return !isEmpty;
    }

    public boolean dismissCallback() {
        boolean dismiss = this.callback != null;
        this.callback = null;
        return dismiss;
    }

    public SQLitePromise<T> then(Runnable runnable) {
        SQLitePromise promise = new SQLitePromise(this);
        promise.then(runnable);
        return promise;
    }

    public SQLitePromise<T> then(PromiseCallback<T> callback) {
        SQLitePromise<T> promise = new SQLitePromise<T>(this);
        promise.then(callback);
        return promise;
    }

    public SQLitePromise<T> error(Runnable runnable) {
        SQLitePromise promise = new SQLitePromise(this);
        promise.error(runnable);
        return promise;
    }

    public SQLitePromise<T> error(WhenCallback<Throwable> callback) {
        SQLitePromise promise = new SQLitePromise(this);
        promise.error(callback);
        return promise;
    }

    public SQLitePromise<T> error(PromiseCallback<Throwable> callback, int when) {
        SQLitePromise promise = new SQLitePromise(this);
        promise.error(callback, when);
        return promise;
    }

    public T getResult() {
        return this.result;
    }

    public static final class SQLitePromise<T> {
        SQLiteThread query;

        public SQLiteThread getQuery() {
            return this.query;
        }

        SQLitePromise(SQLiteThread query) {
            this.query = query;
        }

        public SQLitePromise then(final PromiseCallback<T> callback) {
            if (callback == null) {
                return this;
            }
            this.query.runWhen(new WhenCallback<T>(){

                @Override
                public void onWhen(T result, int when) {
                    callback.onPromise(result);
                }
            }, 1);
            return this;
        }

        public SQLitePromise then(Runnable runnable) {
            if (runnable == null) {
                return this;
            }
            this.query.runWhen(runnable, 1);
            return this;
        }

        public SQLitePromise error(PromiseCallback<Throwable> pCallback, int when) {
            if (pCallback == null) {
                return this;
            }
            return this;
        }

        public void error(WhenCallback<Throwable> callback) {
            if (callback == null) {
                return;
            }
            this.query.runWhen(callback, 4, 3);
        }

        public SQLitePromise error(Runnable runnable) {
            if (runnable == null) {
                return this;
            }
            this.query.runWhen(runnable, 4, 3);
            return this;
        }
    }

    public static interface PromiseCallback<T> {
        public void onPromise(T var1);
    }

    public static interface WhenCallback<T> {
        public void onWhen(T var1, int var2);
    }
}

