/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite.utils;

import android.text.TextUtils;
import istat.android.data.access.sqlite.SQLiteModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TableScriptFactory {
    Class<?> cLass;
    HashMap<Class, FieldAdapter> adapterQueue = new HashMap(){
        {
            this.put(String.class, STRING_ADAPTER);
            this.put(Float.class, FLOAT_ADAPTER);
            this.put(Double.class, DOUBLE_ADAPTER);
            this.put(Integer.class, INTEGER_ADAPTER);
            this.put(Date.class, DATETIME_ADAPTER);
            this.put(Float.TYPE, FLOAT_ADAPTER);
            this.put(Double.TYPE, DOUBLE_ADAPTER);
            this.put(Integer.TYPE, INTEGER_ADAPTER);
        }
    };
    static FieldAdapter INTEGER_ADAPTER = new FieldAdapter(){

        @Override
        String onCreateLine(String columnName, Field field) {
            return "`" + columnName + "` INTEGER ";
        }
    };
    static FieldAdapter FLOAT_ADAPTER = new FieldAdapter(){

        @Override
        String onCreateLine(String columnName, Field field) {
            return "`" + columnName + "` FLOAT ";
        }
    };
    static FieldAdapter DOUBLE_ADAPTER = new FieldAdapter(){

        @Override
        String onCreateLine(String columnName, Field field) {
            return "`" + columnName + "` DOUBLE ";
        }
    };
    static FieldAdapter STRING_ADAPTER = new FieldAdapter(){

        @Override
        String onCreateLine(String columnName, Field field) {
            return "`" + columnName + "` VARCHAR ";
        }
    };
    static FieldAdapter DATETIME_ADAPTER = new FieldAdapter(){

        @Override
        String onCreateLine(String columnName, Field field) {
            return "`" + columnName + "` DATETIME ";
        }
    };

    TableScriptFactory(Class<?> cLass) {
        this.cLass = cLass;
    }

    public static List<String> drop(Class<?> ... cLassS) throws IllegalAccessException, InstantiationException {
        ArrayList<String> out = new ArrayList<String>();
        for (Class<?> cLass : cLassS) {
            SQLiteModel model = SQLiteModel.fromClass(cLass);
            out.add("DROP TABLE " + model.getName() + ";");
        }
        return out;
    }

    public static List<String> truncate(Class<?> ... cLassS) throws IllegalAccessException, InstantiationException {
        ArrayList<String> out = new ArrayList<String>();
        for (Class<?> cLass : cLassS) {
            SQLiteModel model = SQLiteModel.fromClass(cLass);
            out.add("TRUNCATE TABLE " + model.getName() + ";");
        }
        return out;
    }

    public static List<String> create(Class<?> ... cLassS) throws InstantiationException, IllegalAccessException {
        return TableScriptFactory.create(null, cLassS);
    }

    public static List<String> alter(Class<?> ... cLassS) throws InstantiationException, IllegalAccessException {
        return TableScriptFactory.create(null, cLassS);
    }

    public static List<String> create(HashMap<Class, FieldAdapter> classAdapterPair, Class<?> ... cLassS) throws InstantiationException, IllegalAccessException {
        ArrayList<String> out = new ArrayList<String>();
        for (Class<?> cLass : cLassS) {
            Class<?>[] nestedClasses;
            TableScriptFactory factory = new TableScriptFactory(cLass);
            if (classAdapterPair != null && !classAdapterPair.isEmpty()) {
                factory.adapterQueue.putAll(classAdapterPair);
            }
            if ((nestedClasses = cLass.getClasses()) != null && nestedClasses.length > 0) {
                for (Class<?> nestedClass : nestedClasses) {
                    if (!nestedClass.isAnnotationPresent(SQLiteModel.Table.class)) continue;
                    out.addAll(TableScriptFactory.create(classAdapterPair, nestedClass));
                }
            }
            out.add(factory.create());
        }
        return out;
    }

    public String create() throws IllegalAccessException, InstantiationException {
        SQLiteModel model = SQLiteModel.fromClass(this.cLass);
        String sql = "CREATE TABLE IF NOT EXISTS `" + model.getName() + "` (";
        int index = 0;
        for (String columnName : model.getColumns()) {
            String line;
            Field field = model.getField(columnName);
            if (field == null || TextUtils.isEmpty((CharSequence)(line = this.createStatementLine(model, columnName, field)))) continue;
            if (index > 0) {
                line = "," + line;
            }
            sql = sql + line;
            ++index;
        }
        sql = sql + ");";
        return sql;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createStatementLine(SQLiteModel model, String columnName, Field field) {
        Class<?> type = field.getType();
        FieldAdapter adapter = this.adapterQueue.get(type);
        String out = adapter != null ? adapter.createLine(columnName, field) : this.adapterQueue.get(String.class).createLine(columnName, field);
        if (!columnName.equals(model.getPrimaryFieldName())) return out;
        int policy = model.getPrimaryKeyPolicy();
        out = out + " PRIMARY KEY ";
        if (policy == 1) {
            if (field.getType().isAssignableFrom(Integer.class)) return out + " AUTOINCREMENT ";
            if (!field.getType().isAssignableFrom(Integer.TYPE)) throw new RuntimeException(field.getName() + " is not eligible to be autoincrement. Only integer colum can be AutoIncrement.");
            return out + " AUTOINCREMENT ";
        }
        if (policy == 2 || policy == 0) return out;
        if (field.getType().isAssignableFrom(Integer.class)) return out + " AUTOINCREMENT ";
        if (!field.getType().isAssignableFrom(Integer.TYPE)) return out;
        return out + " AUTOINCREMENT ";
    }

    public static abstract class FieldAdapter {
        abstract String onCreateLine(String var1, Field var2);

        public final String createLine(String columnName, Field field) {
            return this.onCreateLine(columnName, field);
        }
    }
}

