/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite.utils;

import android.database.sqlite.SQLiteDatabase;
import istat.android.data.access.sqlite.SQLiteModel;
import istat.android.data.access.sqlite.utils.TableScriptFactory;
import java.util.List;

public class TableUtils {
    public static final boolean exist(SQLiteDatabase db, Class cLass) {
        try {
            SQLiteModel model = SQLiteModel.fromClass(cLass);
            db.query(model.getName(), null, null, null, null, null, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void drop(SQLiteDatabase db, Class ... tables) throws InstantiationException, IllegalAccessException {
        List<String> scripts = TableScriptFactory.drop(tables);
        for (String sql : scripts) {
            db.execSQL(sql);
        }
    }

    public static void truncate(SQLiteDatabase db, Class ... tables) throws InstantiationException, IllegalAccessException {
        List<String> scripts = TableScriptFactory.truncate(tables);
        for (String sql : scripts) {
            db.execSQL(sql);
        }
    }

    public static void create(SQLiteDatabase db, Class ... tables) throws InstantiationException, IllegalAccessException {
        List<String> scripts = TableScriptFactory.create(tables);
        for (String sql : scripts) {
            db.execSQL(sql);
        }
    }

    public static boolean alter(SQLiteDatabase db, Class tables) throws InstantiationException, IllegalAccessException {
        List<String> scripts = TableScriptFactory.alter(tables);
        TableUtils.execute(db, scripts);
        return false;
    }

    public static boolean execute(SQLiteDatabase db, String ... scripts) {
        try {
            for (String sql : scripts) {
                db.execSQL(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean execute(SQLiteDatabase db, List<String> scripts) {
        for (String sql : scripts) {
            db.execSQL(sql);
        }
        return false;
    }
}

