/*
 * Decompiled with CFR 0.152.
 */
package istat.android.data.access.sqlite.utils;

import android.text.TextUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

public class Toolkit {
    public static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().length() == 0;
    }

    public static final Class<?> getGenericTypeClass(Class<?> baseClass, int genericIndex) {
        try {
            String className = ((ParameterizedType)baseClass.getGenericSuperclass()).getActualTypeArguments()[genericIndex].toString().replaceFirst("class", "").trim();
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (Exception e) {
            throw new IllegalStateException("Class is not parametrized with generic type!!! Please use extends <> ");
        }
    }

    public static List<Field> getAllFieldFields(Class<?> klass, boolean includingPrivateAndSuper, boolean acceptStatic) {
        Field[] tmp;
        if (includingPrivateAndSuper) {
            return Toolkit.getAllFieldIncludingPrivateAndSuper(klass, acceptStatic);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field f : tmp = klass.getDeclaredFields()) {
            if (f != null && f.toString().contains("static") && !acceptStatic) continue;
            fields.add(f);
        }
        return fields;
    }

    public static List<Field> getAllFieldIncludingPrivateAndSuper(Class<?> klassc) {
        return Toolkit.getAllFieldIncludingPrivateAndSuper(klassc, false);
    }

    public static List<Field> getAllFieldIncludingPrivateAndSuper(Class<?> klass, boolean acceptStatic) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!klass.equals(Object.class)) {
            for (Field field : klass.getDeclaredFields()) {
                if (field != null && field.toString().contains("static") && !acceptStatic) continue;
                fields.add(field);
            }
            klass = klass.getSuperclass();
        }
        return fields;
    }

    public static boolean isJson(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return false;
        }
        return json.matches("(^\\{.*\\}$)|(^\\[.*\\]$)");
    }

    public static boolean isJArray(String json) {
        return json.matches("(^\\[.*\\]$)");
    }

    public static boolean isJsonObject(String json) {
        return json.matches("(^\\{.*\\}$)");
    }

    public static <T> T newInstance(Class<T> cLass) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        try {
            return cLass.newInstance();
        }
        catch (Exception e) {
            Constructor<T> constructor = cLass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
    }
}

