/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.http;

import istat.android.network.http.HttpAsyncQuery;
import istat.android.network.http.HttpQuery;
import istat.android.network.http.MultipartHttpQuery;
import istat.android.network.http.SimpleHttpQuery;
import istat.android.network.http.interfaces.DownloadHandler;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.Executor;

public final class AsyncHttp {
    HttpAsyncQuery mAsyncQuery;
    String encoding;
    HttpAsyncQuery.HttpUploadHandler<?> mUploader;

    public static final AsyncHttp from(HttpQuery http) {
        HttpAsyncQuery asycQ = new HttpAsyncQuery(http);
        return new AsyncHttp(asycQ);
    }

    @Deprecated
    public static final AsyncHttp fromDefaultHttp() {
        return AsyncHttp.fromSimpleHttp();
    }

    public static final AsyncHttp fromSimpleHttp() {
        SimpleHttpQuery http = new SimpleHttpQuery();
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    public static final AsyncHttp fromMultipartHttp() {
        MultipartHttpQuery http = new MultipartHttpQuery();
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    AsyncHttp(HttpAsyncQuery asycQuery) {
        this.mAsyncQuery = asycQuery;
    }

    public AsyncHttp useEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public AsyncHttp addHttpParam(String name, String value) {
        this.mAsyncQuery.mHttp.addParam(name, value);
        return this;
    }

    public AsyncHttp addHttpHeader(String name, String value) {
        this.mAsyncQuery.mHttp.addHeader(name, value);
        return this;
    }

    public HttpQuery<?> getHttpQuery() {
        return this.mAsyncQuery.mHttp;
    }

    public AsyncHttp useExecutor(Executor executor) {
        this.mAsyncQuery.mExecutor = executor;
        return this;
    }

    public AsyncHttp useDownloader(HttpAsyncQuery.HttpDownloadHandler downloader) {
        this.mAsyncQuery.downloadHandler = downloader;
        return this;
    }

    public AsyncHttp useUploader(HttpAsyncQuery.HttpUploadHandler<?> uploader) {
        this.mUploader = uploader;
        this.mAsyncQuery.setUploadHandler(uploader);
        return this;
    }

    public AsyncHttp useDownloader(final DownloadHandler downloader) {
        this.mAsyncQuery.downloadHandler = new HttpAsyncQuery.HttpDownloadHandler<Integer>(){

            public void onDownloadProgress(HttpAsyncQuery query, Integer ... integers) {
            }

            @Override
            public Object onBuildResponseBody(HttpURLConnection connexion, InputStream stream, HttpAsyncQuery query) throws Exception {
                return downloader.onBuildResponseBody(connexion, stream, query);
            }

            @Override
            protected void onProcessFail(Exception e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    public AsyncHttp useBufferSize(int bufferSize) {
        this.mAsyncQuery.bufferSize = bufferSize;
        return this;
    }

    public HttpAsyncQuery doDelete(String url) {
        return this.doDelete(this.mAsyncQuery.mHttpCallBack, url);
    }

    public HttpAsyncQuery doDelete(HttpAsyncQuery.HttpQueryCallback callback, String url) {
        this.mAsyncQuery.type = 5;
        this.mAsyncQuery.mHttpCallBack = callback;
        this.mAsyncQuery.executeURLs(url);
        return this.mAsyncQuery;
    }

    public HttpAsyncQuery doGet(String url) {
        return this.doGet(this.mAsyncQuery.mHttpCallBack, url);
    }

    public HttpAsyncQuery doGet(HttpAsyncQuery.HttpQueryCallback callback, String url) {
        this.mAsyncQuery.type = 1;
        this.mAsyncQuery.mHttpCallBack = callback;
        this.mAsyncQuery.executeURLs(url);
        return this.mAsyncQuery;
    }

    public HttpAsyncQuery doPost(String url) {
        return this.doPost(this.mUploader, this.mAsyncQuery.mHttpCallBack, url);
    }

    public HttpAsyncQuery doPost(HttpAsyncQuery.HttpQueryCallback callback, String url) {
        return this.doPost(this.mUploader, callback, url);
    }

    public HttpAsyncQuery doPost(HttpAsyncQuery.HttpUploadHandler<?> uploader, HttpAsyncQuery.HttpQueryCallback callback, String url) {
        this.mAsyncQuery.type = 2;
        this.mAsyncQuery.setUploadHandler(uploader);
        this.mAsyncQuery.mHttpCallBack = callback;
        this.mAsyncQuery.executeURLs(url);
        return this.mAsyncQuery;
    }

    public HttpAsyncQuery doHead(String url) {
        return this.doHead(this.mAsyncQuery.mHttpCallBack, url);
    }

    public HttpAsyncQuery doHead(HttpAsyncQuery.HttpQueryCallback callback, String url) {
        this.mAsyncQuery.type = 4;
        this.mAsyncQuery.mHttpCallBack = callback;
        this.mAsyncQuery.executeURLs(url);
        return this.mAsyncQuery;
    }

    public HttpAsyncQuery doPatch(String url) {
        return this.doPatch(this.mAsyncQuery.mHttpCallBack, url);
    }

    public HttpAsyncQuery doPatch(HttpAsyncQuery.HttpQueryCallback callback, String url) {
        this.mAsyncQuery.type = 7;
        this.mAsyncQuery.mHttpCallBack = callback;
        this.mAsyncQuery.executeURLs(url);
        return this.mAsyncQuery;
    }

    public HttpAsyncQuery doPush(HttpAsyncQuery.HttpUploadHandler<?> uploader, String url) {
        return this.doPush(uploader, this.mAsyncQuery.mHttpCallBack, url);
    }

    public HttpAsyncQuery doPush(HttpAsyncQuery.HttpQueryCallback callback, String url) {
        return this.doPush(this.mUploader, callback, url);
    }

    public HttpAsyncQuery doPush(HttpAsyncQuery.HttpUploadHandler<?> uploader, HttpAsyncQuery.HttpQueryCallback callback, String url) {
        this.mAsyncQuery.type = 2;
        this.mAsyncQuery.setUploadHandler(uploader);
        this.mAsyncQuery.mHttpCallBack = callback;
        this.mAsyncQuery.executeURLs(url);
        return this.mAsyncQuery;
    }

    @Deprecated
    public HttpAsyncQuery doQuery(int method, HttpAsyncQuery.HttpUploadHandler<?> uploader, HttpAsyncQuery.HttpQueryCallback callback, String url) {
        this.mAsyncQuery.type = method;
        this.mAsyncQuery.mHttpCallBack = callback;
        this.mAsyncQuery.setUploadHandler(uploader);
        this.mAsyncQuery.executeURLs(url);
        return this.mAsyncQuery;
    }

    public AsyncHttp setCancelListener(HttpAsyncQuery.CancelListener listener) {
        this.mAsyncQuery.mCancelListener = listener;
        return this;
    }

    public AsyncHttp setQueryCallBack(HttpAsyncQuery.HttpQueryCallback callback) {
        this.mAsyncQuery.mHttpCallBack = callback;
        return this;
    }
}

