/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.http;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import istat.android.network.http.AsyncHttp;
import istat.android.network.http.BodyPartHttpQuery;
import istat.android.network.http.HttpQuery;
import istat.android.network.http.HttpQueryError;
import istat.android.network.http.MultipartHttpQuery;
import istat.android.network.http.SimpleHttpQuery;
import istat.android.network.http.interfaces.DownloadHandler;
import istat.android.network.http.interfaces.UpLoadHandler;
import istat.android.network.utils.StreamOperationTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public final class HttpAsyncQuery
extends AsyncTask<String, HttpQueryResponse, Void> {
    public static final int TYPE_GET = 1;
    public static final int TYPE_POST = 2;
    public static final int TYPE_PUT = 3;
    public static final int TYPE_HEAD = 4;
    public static final int TYPE_DELETE = 5;
    public static final int TYPE_COPY = 6;
    public static final int TYPE_PATCH = 7;
    public static final int TYPE_RENAME = 8;
    public static final int TYPE_MOVE = 9;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final String DEFAULT_ENCODING = "UTF-8";
    HttpQueryCallback mHttpCallBack;
    CancelListener mCancelListener;
    HttpQuery<?> mHttp;
    int type = 1;
    int bufferSize = 16384;
    String encoding = "UTF-8";
    private long startTimeStamp = 0L;
    private long endTimeStamp = 0L;
    static final ConcurrentHashMap<Object, HttpAsyncQuery> taskQueue = new ConcurrentHashMap();
    private Runnable httpAbortRunnable = new Runnable(){

        @Override
        public void run() {
            HttpAsyncQuery.this.mHttp.abortRequest();
        }
    };
    Executor mExecutor;
    HttpDownloadHandler<?> downloadHandler = new HttpDownloadHandler<Integer>(){
        {
            this.query = HttpAsyncQuery.this;
        }

        @Override
        public String onBuildResponseBody(HttpURLConnection currentConnexion, InputStream stream, HttpAsyncQuery query) {
            try {
                return StreamOperationTools.streamToString(HttpAsyncQuery.this.executionController, stream, HttpAsyncQuery.this.bufferSize, HttpAsyncQuery.this.encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        public void onDownloadProgress(HttpAsyncQuery query, Integer ... vars) {
        }
    };
    public final StreamOperationTools.OperationController executionController = new StreamOperationTools.OperationController(){

        @Override
        public boolean isStopped() {
            return !HttpAsyncQuery.this.isRunning();
        }
    };

    HttpAsyncQuery(HttpQuery<?> http) {
        this.mHttp = http;
    }

    private HttpAsyncQuery(HttpQuery<?> http, HttpQueryCallback callBack) {
        this.mHttpCallBack = callBack;
        this.mHttp = http;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.startTimeStamp = System.currentTimeMillis();
        taskQueue.put(this.mHttpCallBack != null ? this.mHttpCallBack : Math.random() + "", this);
    }

    protected Void doInBackground(String ... urls) {
        for (String url : urls) {
            if (this.isCancelled()) break;
            InputStream stream = null;
            Exception error = null;
            Log.d((String)"HttpAsyncQuery", (String)("doInBackground::type=" + this.type));
            try {
                switch (this.type) {
                    case 1: {
                        stream = this.mHttp.doGet(url);
                        break;
                    }
                    case 2: {
                        stream = this.mHttp.doPost(url);
                        break;
                    }
                    case 3: {
                        stream = this.mHttp.doPut(url);
                        break;
                    }
                    case 4: {
                        stream = this.mHttp.doHead(url);
                        break;
                    }
                    case 6: {
                        stream = this.mHttp.doCopy(url);
                        break;
                    }
                    case 8: {
                        stream = this.mHttp.doQuery(url, "RENAME");
                        break;
                    }
                    case 9: {
                        stream = this.mHttp.doQuery(url, "MOVE", true, true);
                        break;
                    }
                    case 5: {
                        stream = this.mHttp.doDelete(url);
                        break;
                    }
                    case 7: {
                        stream = this.mHttp.doPatch(url);
                        break;
                    }
                    default: {
                        stream = this.mHttp.doGet(url);
                        break;
                    }
                }
            }
            catch (Exception e) {
                error = e;
                e.printStackTrace();
            }
            HttpQueryResponse response = new HttpQueryResponse(stream, error, this.encoding, this.bufferSize, this);
            if (!this.mHttp.isAborted() && !this.isCancelled()) {
                Log.i((String)"HttpAsycQ", (String)"doInBackground::publish_response");
                this.publishProgress(new HttpQueryResponse[]{response});
                continue;
            }
            Log.i((String)"HttpAsycQ", (String)"doInBackground::was aborded");
        }
        return null;
    }

    protected void onProgressUpdate(HttpQueryResponse ... values) {
        HttpQueryResponse response;
        HttpQueryResponse httpQueryResponse = response = values.length > 0 ? values[0] : null;
        if (this.mHttpCallBack != null && !this.mHttp.isAborted() && !this.isCancelled()) {
            this.dispatchQueryResponse(response);
        }
    }

    private void dispatchQueryResponse(HttpQueryResponse resp) {
        try {
            if (resp.isAccepted()) {
                if (resp.isSuccess()) {
                    this.mHttpCallBack.onHttpSuccess(resp);
                } else {
                    HttpQueryError error = new HttpQueryError(resp.getError());
                    resp.error = error;
                    this.mHttpCallBack.onHttpError(resp, error);
                }
            } else {
                this.mHttpCallBack.onHttpFail(resp.getError());
            }
            this.mHttpCallBack.onHttComplete(resp);
        }
        catch (Exception e) {
            this.mHttpCallBack.onHttpFail(e);
        }
    }

    protected void onPostExecute(Void result) {
        super.onPostExecute((Object)result);
        taskQueue.values().removeAll(Collections.singletonList(this));
    }

    protected void onCancelled() {
        Log.i((String)"HttpAsyncQuery", (String)("onCancelled::canceListener::" + this.mCancelListener));
        Log.i((String)"HttpAsyncQuery", (String)("onCancelled::httpCallback::" + this.mHttpCallBack));
        try {
            this.mHttpCallBack.onHttpAborted();
            Log.i((String)"HttpAsyncQuery", (String)("onCancelled::abort-callaed::" + this.mHttpCallBack));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.endTimeStamp = System.currentTimeMillis();
        if (this.mCancelListener != null) {
            this.mCancelListener.onCancelled(this);
        }
        taskQueue.values().removeAll(Collections.singletonList(this));
        super.onCancelled();
    }

    public static HttpAsyncQuery doAsyncGet(HttpQuery<?> http, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 1, 16384, http.mOptions.encoding, null, url);
    }

    public static HttpAsyncQuery doAsyncGet(HttpQuery<?> http, HttpQueryCallback callBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 1, 16384, http.mOptions.encoding, callBack, url);
    }

    public static HttpAsyncQuery doAsyncQuery(HttpQuery<?> http, int queryType, int bufferSize, String encoding, HttpQueryCallback callBack, HttpDownloadHandler<?> processCallBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, queryType, bufferSize, encoding, callBack, processCallBack, null, url);
    }

    public static HttpAsyncQuery doAsyncQuery(HttpQuery<?> http, int queryType, int bufferSize, String encoding, HttpQueryCallback callBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, queryType, bufferSize, encoding, callBack, null, null, url);
    }

    public static HttpAsyncQuery doAsyncPost(HttpQuery<?> http, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 2, 16384, http.mOptions.encoding, null, url);
    }

    public static HttpAsyncQuery doAsyncPost(HttpQuery<?> http, HttpQueryCallback callBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 2, 16384, http.mOptions.encoding, callBack, url);
    }

    public static HttpAsyncQuery doAsyncPost(HttpQuery<?> http, HttpQueryCallback callBack, HttpUploadHandler<?> uploadCallback, String url) {
        HttpAsyncQuery query = HttpAsyncQuery.doAsyncQuery(http, 2, 16384, http.mOptions.encoding, callBack, url);
        query.setUploadHandler(uploadCallback);
        return query;
    }

    public static HttpAsyncQuery doAsyncPost(MultipartHttpQuery http, int bufferSize, String encoding, HttpQueryCallback callBack, HttpDownloadHandler<?> processCallBack, CancelListener cancelCallback, HttpUploadHandler<?> uploadCallBack, String ... urls) {
        HttpAsyncQuery query = new HttpAsyncQuery(http, callBack);
        query.setDownloadHandler(processCallBack);
        query.setCancelListener(cancelCallback);
        query.setUploadHandler(uploadCallBack);
        query.type = 2;
        query.encoding = encoding;
        query.bufferSize = bufferSize;
        query.executeURLs(urls);
        return query;
    }

    boolean setUploadHandler(HttpUploadHandler<?> uploader) {
        if (uploader != null) {
            if (this.mHttp instanceof MultipartHttpQuery) {
                uploader.query = this;
                MultipartHttpQuery http = (MultipartHttpQuery)this.mHttp;
                http.setUploadHandler(uploader);
                return true;
            }
            if (this.mHttp instanceof BodyPartHttpQuery) {
                uploader.query = this;
                BodyPartHttpQuery http = (BodyPartHttpQuery)this.mHttp;
                http.setUploadHandler(uploader);
            }
        }
        return false;
    }

    public static HttpAsyncQuery doAsyncQuery(HttpQuery<?> http, int queryType, int bufferSize, String encoding, HttpQueryCallback callBack, HttpDownloadHandler<?> processCallBack, CancelListener cancelListener, String ... urls) {
        HttpAsyncQuery query = new HttpAsyncQuery(http, callBack);
        query.setDownloadHandler(processCallBack);
        query.setCancelListener(cancelListener);
        query.type = queryType;
        query.encoding = encoding;
        query.bufferSize = bufferSize;
        query.executeURLs(urls);
        return query;
    }

    @TargetApi(value=11)
    void executeURLs(String ... urls) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (this.mExecutor == null) {
                this.mExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
            }
            this.executeOnExecutor(this.mExecutor, urls);
        } else {
            this.execute(urls);
        }
    }

    public boolean isCompleted() {
        if (this.isCancelled()) {
            return false;
        }
        return this.getStatus().equals((Object)AsyncTask.Status.FINISHED);
    }

    public boolean isRunning() {
        return this.getStatus().equals((Object)AsyncTask.Status.RUNNING) || this.mHttp.hasRunningRequest() && !this.getStatus().equals((Object)AsyncTask.Status.FINISHED);
    }

    public boolean isPending() {
        return this.getStatus().equals((Object)AsyncTask.Status.PENDING);
    }

    public long getExecutionTime() {
        if (this.endTimeStamp <= this.startTimeStamp) {
            return this.getDuration();
        }
        return this.endTimeStamp - this.startTimeStamp;
    }

    public final boolean cancel() {
        Log.i((String)"HttAsyncQuery", (String)("cancel_start, running=" + this.mHttp.hasRunningRequest() + ", aborted=" + this.mHttp.isAborted()));
        if (this.mHttp.hasRunningRequest()) {
            Log.i((String)"HttQuery", (String)"cancel_has_running");
            new Thread(this.httpAbortRunnable).start();
        }
        return this.cancel(true);
    }

    private long getDuration() {
        return System.currentTimeMillis() - this.startTimeStamp;
    }

    public boolean setDownloadHandler(final DownloadHandler downloader) {
        HttpDownloadHandler<Integer> downloadHandler = new HttpDownloadHandler<Integer>(){

            public void onDownloadProgress(HttpAsyncQuery query, Integer ... integers) {
            }

            @Override
            public Object onBuildResponseBody(HttpURLConnection connexion, InputStream stream, HttpAsyncQuery query) throws Exception {
                return downloader.onBuildResponseBody(connexion, stream, query);
            }

            @Override
            protected void onProcessFail(Exception e) {
                throw new RuntimeException(e);
            }
        };
        return this.setDownloadHandler(downloadHandler);
    }

    public boolean setDownloadHandler(HttpDownloadHandler<?> downloader) {
        if (downloader == null || this.downloadHandler == downloader) {
            return false;
        }
        this.downloadHandler = downloader;
        this.downloadHandler.query = this;
        return true;
    }

    public boolean isPaused() {
        return this.executionController.isPaused();
    }

    public void resume() {
        this.executionController.resume();
    }

    public void pause() {
        this.executionController.pause();
    }

    public boolean setCancelListener(CancelListener listener) {
        if (listener != null) {
            this.mCancelListener = listener;
            return true;
        }
        return false;
    }

    public void addTocken(String uniqueToken) {
        taskQueue.put(uniqueToken, this);
    }

    public static HttpAsyncQuery getTask(HttpQueryCallback callback) {
        return taskQueue.get(callback);
    }

    public static HttpAsyncQuery getTask(Object token) {
        return taskQueue.get(token);
    }

    public static List<HttpAsyncQuery> getTaskQueue() {
        return new ArrayList<HttpAsyncQuery>(taskQueue.values());
    }

    public static void cancelAll() {
        for (HttpAsyncQuery http : HttpAsyncQuery.getTaskQueue()) {
            http.cancel(true);
        }
    }

    public static void cancel(Object token) {
        HttpAsyncQuery http = HttpAsyncQuery.getTask(token);
        if (http != null) {
            http.cancel(true);
        }
    }

    <K, V> K getKeyByValue(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Deprecated
    public static final AsyncHttp from(HttpQuery<?> http) {
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    @Deprecated
    public static final AsyncHttp fromDefaultHttp() {
        SimpleHttpQuery http = new SimpleHttpQuery();
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    @Deprecated
    public static final AsyncHttp fromMultipartHttp() {
        MultipartHttpQuery http = new MultipartHttpQuery();
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    public boolean dismissCallback() {
        boolean dismiss = this.mHttpCallBack != null;
        this.mHttpCallBack = null;
        return dismiss;
    }

    public class HttpPromise {
        public static final int WHEN_ANAWAY = 0;
        public static final int WHEN_SUCCED = 0;
        public static final int WHEN_ERROR = 0;
        public static final int WHEN_FAILED = 0;

        public HttpPromise runWhen(Runnable runnable, int ... when) {
            return this;
        }
    }

    public static abstract class HttpDownloadHandler<ProgressVar>
    implements DownloadHandler {
        Handler handler;
        HttpAsyncQuery query;

        public HttpDownloadHandler(Handler handler) {
            this.handler = handler;
        }

        public HttpDownloadHandler() {
            try {
                this.handler = this.getHandler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getConnetionContentLenght() {
            return this.query != null && this.query.mHttp != null && this.query.mHttp.currentConnection != null ? this.query.mHttp.currentConnection.getContentLength() : 0;
        }

        public String getConnetionContentType() {
            return this.query != null && this.query.mHttp != null && this.query.mHttp.currentConnection != null ? this.query.mHttp.currentConnection.getContentType() : null;
        }

        public HttpAsyncQuery getAsyncQuery() {
            return this.query;
        }

        public HttpQuery<?> getQuery() {
            return this.getAsyncQuery().mHttp;
        }

        private Handler getHandler() {
            if (this.handler == null) {
                this.handler = new Handler(Looper.getMainLooper());
            }
            return this.handler;
        }

        protected void onProcessFail(Exception e) {
        }

        Object buildResponseBody(HttpURLConnection connexion, InputStream stream) throws Exception {
            try {
                return this.onBuildResponseBody(connexion, stream, this.query);
            }
            catch (Exception e) {
                e.printStackTrace();
                Handler tmpHandler = this.getHandler();
                if (tmpHandler != null) {
                    this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            HttpDownloadHandler.this.onProcessFail(e);
                        }
                    });
                }
                throw new RuntimeException(e);
            }
        }

        public void publishProgression(final ProgressVar ... vars) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    HttpDownloadHandler.this.onDownloadProgress(HttpDownloadHandler.this.query, vars);
                }
            });
        }

        public abstract void onDownloadProgress(HttpAsyncQuery var1, ProgressVar ... var2);
    }

    public static abstract class HttpUploadHandler<ProgressVar>
    implements UpLoadHandler {
        Handler handler;
        HttpAsyncQuery query;
        Runnable publishRunner = new Runnable(){

            @Override
            public void run() {
                HttpUploadHandler.this.onUploadProgress(HttpUploadHandler.this.query, HttpUploadHandler.this.processVars);
            }
        };
        ProgressVar[] processVars;

        public HttpUploadHandler(Handler handler) {
            if (handler == null) {
                try {
                    this.handler = this.getHandler();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.handler = handler;
            }
        }

        public HttpUploadHandler() {
            this(null);
        }

        private Handler getHandler() {
            if (this.handler == null) {
                this.handler = new Handler(Looper.getMainLooper());
            }
            return this.handler;
        }

        protected void onProcessFail(Exception e) {
        }

        public void publishProgression(ProgressVar ... vars) {
            Handler tmpHandler = this.getHandler();
            if (tmpHandler != null) {
                this.processVars = vars;
                tmpHandler.post(this.publishRunner);
            }
        }

        @Override
        public final void onUploadStream(HttpQuery httpQuery, InputStream stream, OutputStream request) throws IOException {
            block2: {
                try {
                    this.onProceedStreamUpload(httpQuery, request, stream, this.query);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Handler tmpHandler = this.getHandler();
                    if (tmpHandler == null) break block2;
                    this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            HttpUploadHandler.this.onProcessFail(e);
                        }
                    });
                }
            }
        }

        public abstract void onProceedStreamUpload(HttpQuery var1, OutputStream var2, InputStream var3, HttpAsyncQuery var4) throws IOException;

        public abstract void onUploadProgress(HttpAsyncQuery var1, ProgressVar ... var2);
    }

    public static interface HttpQueryCallback {
        public void onHttpSuccess(HttpQueryResponse var1);

        public void onHttpError(HttpQueryResponse var1, HttpQueryError var2);

        public void onHttpFail(Exception var1);

        public void onHttComplete(HttpQueryResponse var1);

        public void onHttpAborted();
    }

    public static interface CancelListener {
        public void onCancelled(HttpAsyncQuery var1);
    }

    public static class HttpQueryResponse {
        Object body;
        Exception error;
        HttpAsyncQuery mAsyncQ;
        int code = -1;
        String message;
        HttpURLConnection connexion;
        Map<String, List<String>> headers = new HashMap<String, List<String>>();

        public static HttpQueryResponse getErrorInstance(Exception e) {
            return new HttpQueryResponse(null, e, null);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        HttpQueryResponse(InputStream stream, Exception e, HttpAsyncQuery asyncQ) {
            this.mAsyncQ = asyncQ;
            this.init(stream, HttpAsyncQuery.DEFAULT_ENCODING, 16384, e);
        }

        HttpQueryResponse(InputStream stream, Exception e, String encoding, int bufferSize, HttpAsyncQuery asyncQ) {
            this.mAsyncQ = asyncQ;
            this.init(stream, encoding, bufferSize, e);
        }

        private void init(InputStream stream, String encoding, int buffersize, Exception e) {
            HttpQuery<?> http = this.mAsyncQ.mHttp;
            this.connexion = http.getCurrentConnection();
            this.error = e;
            this.code = http.getCurrentResponseCode();
            this.message = http.getCurrentResponseMessage();
            if (this.connexion != null) {
                try {
                    this.body = null;
                    if (stream != null) {
                        this.body = this.mAsyncQ.downloadHandler.buildResponseBody(this.connexion, stream);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.code = 0;
                    this.error = ex;
                }
                this.headers = this.connexion.getHeaderFields();
            }
            if (e == null && !this.isSuccess() && !TextUtils.isEmpty((CharSequence)this.message) && this.code > 0) {
                this.error = new HttpQueryError(this.code, this.message, this.body);
            }
        }

        public boolean containHeader(String name) {
            return this.getHeaders() != null && this.getHeaders().containsKey(name);
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getHeader(String name) {
            if (this.connexion != null) {
                return this.connexion.getHeaderField(name);
            }
            return "";
        }

        public long getHeaderAsLong(String name) {
            return this.getHeaderAsLong(name, 0L);
        }

        public long getHeaderAsLong(String name, long deflt) {
            if (this.connexion != null) {
                return this.connexion.getHeaderFieldDate(name, deflt);
            }
            return deflt;
        }

        public int getHeaderAsInt(String name) {
            return this.getHeaderAsInt(name, 0);
        }

        public int getHeaderAsInt(String name, int deflt) {
            if (this.connexion != null) {
                return this.connexion.getHeaderFieldInt(name, deflt);
            }
            return deflt;
        }

        public boolean hasError() {
            return this.error != null || !HttpQueryResponse.isSuccessCode(this.code);
        }

        public boolean isSuccess() {
            return !this.hasError();
        }

        public boolean isAccepted() {
            return this.code > 0;
        }

        public <T> T getBody() {
            if (this.body == null) {
                return null;
            }
            try {
                return (T)this.body;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T optBody() {
            if (this.body == null) {
                return null;
            }
            try {
                return (T)this.body;
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getBodyAsString() {
            if (this.body == null) {
                return null;
            }
            return this.body.toString();
        }

        public Exception getError() {
            return this.error;
        }

        public static boolean isSuccessCode(int code) {
            return code > 0 && code >= 200 && code <= 299;
        }

        public static boolean isErrorCode(int code) {
            return !HttpQueryResponse.isSuccessCode(code);
        }

        public static boolean isClientErrorCode(int code) {
            return code > 0 && code >= 400 && code <= 499;
        }

        public static boolean isServerErrorCode(int code) {
            return code > 0 && code >= 500 && code <= 599;
        }
    }
}

