/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.http;

import android.text.TextUtils;
import istat.android.network.http.HttpQuery;
import istat.android.network.http.interfaces.UpLoadHandler;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;

public class MultipartHttpQuery
extends HttpQuery<MultipartHttpQuery> {
    HashMap<String, File> fileParts = new HashMap();
    protected HashMap<String, String> URLParameters = new HashMap();
    int uploadBufferSize = 16384;
    private static final String LINE_FEED = "\n";
    UpLoadHandler uploadHandler = new UpLoadHandler(){

        @Override
        public void onUploadStream(HttpQuery httpQuery, InputStream stream, OutputStream request) throws IOException {
            int read;
            byte[] b = new byte[MultipartHttpQuery.this.uploadBufferSize];
            while ((read = stream.read(b)) > -1) {
                boolean isAborted = httpQuery.isAborted();
                boolean running = httpQuery.hasRunningRequest();
                if (isAborted || !running) {
                    stream.close();
                    return;
                }
                request.write(b, 0, read);
            }
            stream.close();
        }
    };

    @Override
    public MultipartHttpQuery addURLParam(String Name, String Value) {
        this.URLParameters.put(Name, Value);
        return this;
    }

    public MultipartHttpQuery addURLParam(String Name, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addURLParam(Name + "[" + i + "]", values[i]);
        }
        return this;
    }

    public MultipartHttpQuery addURLParams(HashMap<String, Object> nameValues) {
        if (!nameValues.keySet().isEmpty()) {
            String[] table = new String[nameValues.size()];
            for (String tmp : table = nameValues.keySet().toArray(table)) {
                if (tmp == null) continue;
                this.addURLParam(tmp, nameValues.get(tmp).toString());
            }
        }
        return this;
    }

    @Override
    public void removeParam(String name) {
        super.removeParam(name);
        if (this.URLParameters != null && this.URLParameters.containsKey(name)) {
            this.URLParameters.clear();
        }
    }

    @Override
    public InputStream doPost(String url) throws IOException {
        return this.POST(url, true);
    }

    public InputStream doPost(String url, boolean holdError) throws IOException {
        return this.POST(url, holdError);
    }

    @Override
    public MultipartHttpQuery addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    public MultipartHttpQuery addFilePart(String name, File file) {
        this.fileParts.put(name, file);
        return this;
    }

    public MultipartHttpQuery addFilePart(String name, String file) {
        this.addFilePart(name, new File(file));
        return this;
    }

    @Override
    public MultipartHttpQuery clearParams() {
        super.clearParams();
        this.clearParts();
        this.URLParameters.clear();
        return this;
    }

    public MultipartHttpQuery clearParts() {
        this.fileParts.clear();
        return this;
    }

    public void setUploadBufferSize(int uploadBufferSize) {
        this.uploadBufferSize = uploadBufferSize;
    }

    @Override
    public void setParameterHandler(HttpQuery.ParameterHandler parameterHandler) {
        super.setParameterHandler(parameterHandler);
    }

    private HttpURLConnection sendMultipartData(String url) throws IOException {
        String method = "POST";
        HttpURLConnection conn = this.prepareConnexion(url, method);
        conn.setDoOutput(true);
        conn.setRequestMethod(method);
        if (!this.fileParts.isEmpty()) {
            conn.setChunkedStreamingMode(this.mOptions.chunkedStreamingMode);
        }
        if (!this.parameters.isEmpty() || !this.fileParts.isEmpty()) {
            String boundary = MultipartHttpQuery.createBoundary();
            conn.addRequestProperty("Content-Type", "multipart/form-data, boundary=" + boundary);
            if (TextUtils.isEmpty((CharSequence)conn.getRequestProperty("User-Agent"))) {
                conn.addRequestProperty("User-Agent", "istat.android.network.V2.4.0");
            }
            OutputStream os = conn.getOutputStream();
            DataOutputStream request = new DataOutputStream(os);
            this.currentOutputStream = request;
            if (!this.parameters.isEmpty()) {
                String data = this.createBoundaryParamsCanvas(boundary, this.parameters);
                request.writeBytes(data);
            }
            if (!this.fileParts.isEmpty()) {
                this.handleFileParts(boundary, request, this.fileParts);
            }
            boundary = "--" + boundary + "--" + LINE_FEED;
            request.writeBytes(boundary);
            this.addToOutputHistoric(request.size());
            try {
                request.flush();
                request.close();
                os.flush();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return conn;
    }

    private String createBoundaryParamsCanvas(String boundary, HashMap<String, String> params) {
        String data = "";
        if (!params.keySet().isEmpty()) {
            String[] table = new String[params.size()];
            for (String name : table = params.keySet().toArray(table)) {
                if (this.isAborted()) {
                    this.currentConnection.disconnect();
                    break;
                }
                if (name == null) continue;
                String value = params.get(name);
                data = data + "--" + boundary + LINE_FEED;
                data = data + "content-disposition: form-data; name=\"" + name + "\"" + LINE_FEED;
                data = data + "Content-Type: text/plain; charset=" + this.mOptions.encoding + LINE_FEED;
                data = data + LINE_FEED;
                data = data + value + LINE_FEED;
            }
        }
        System.out.println(data);
        return data;
    }

    private void handleFileParts(String boundary, DataOutputStream request, HashMap<String, File> params) throws IOException {
        boundary = "--" + boundary + LINE_FEED;
        if (!params.keySet().isEmpty()) {
            String[] table = new String[params.size()];
            table = params.keySet().toArray(table);
            for (int i = 0; i < table.length; ++i) {
                String tmp = table[i];
                if (this.isAborted()) {
                    this.currentConnection.disconnect();
                    break;
                }
                if (tmp == null) continue;
                File file = params.get(tmp);
                String data = boundary;
                String contentType = URLConnection.guessContentTypeFromName(file.getAbsolutePath());
                if (TextUtils.isEmpty((CharSequence)contentType)) {
                    contentType = "application/octets-stream";
                }
                data = data + "Content-Disposition: form-data; name=\"" + tmp + "\"; filename=\"" + file.getName() + "\"\n";
                data = data + "Content-Type: " + contentType + LINE_FEED;
                data = data + "Content-Transfer-Encoding: binary\n\n";
                request.writeBytes(data);
                FileInputStream stream = new FileInputStream(file);
                UpLoadHandler uHandler = this.getUploadHandler();
                if (uHandler != null) {
                    this.currentInputStream = stream;
                    uHandler.onUploadStream(this, stream, request);
                }
                request.writeBytes(LINE_FEED);
                if (i >= table.length - 1) continue;
                request.writeBytes(boundary);
            }
        }
    }

    protected synchronized InputStream POST(String url, boolean holdError) throws IOException {
        HttpURLConnection conn = this.sendMultipartData(url);
        InputStream stream = this.eval(conn, holdError);
        this.onQueryComplete();
        return stream;
    }

    private static String createBoundary() {
        return "===" + System.currentTimeMillis() + "===";
    }

    @Override
    public final MultipartHttpQuery addParams(HashMap<?, ?> nameValues) {
        if (!nameValues.keySet().isEmpty()) {
            String[] table = new String[nameValues.size()];
            for (String tmp : table = nameValues.keySet().toArray(table)) {
                if (tmp == null) continue;
                Object value = nameValues.get(tmp);
                if (value instanceof File) {
                    this.addFilePart(tmp, (File)value);
                    continue;
                }
                this.addParam(tmp, nameValues.get(tmp).toString());
            }
        }
        return this;
    }

    public void setUploadHandler(UpLoadHandler uploadHandler) {
        if (uploadHandler != null) {
            this.uploadHandler = uploadHandler;
        }
    }

    protected UpLoadHandler getUploadHandler() {
        return this.uploadHandler;
    }

    @Override
    public boolean hasRunningRequest() {
        super.hasRunningRequest();
        return true;
    }
}

