/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.http.tools;

import istat.android.network.http.HttpAsyncQuery;
import java.io.InputStream;
import java.net.HttpURLConnection;

public abstract class ReadByteDownloadHandler
extends HttpAsyncQuery.HttpDownloadHandler<Integer> {
    int buffer = 16384;
    String encoding = "UTF-8";

    public ReadByteDownloadHandler() {
    }

    public ReadByteDownloadHandler(String encoding, int bufferSize) {
        this.encoding = encoding;
        this.buffer = bufferSize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public int getBuffer() {
        return this.buffer;
    }

    @Override
    public String onBuildResponseBody(HttpURLConnection currentConnexion, InputStream inp, HttpAsyncQuery query) {
        String out = "";
        byte[] b = new byte[this.buffer];
        int totalReade = 0;
        int streamSize = currentConnexion == null ? 0 : currentConnexion.getContentLength();
        try {
            int read;
            int n = streamSize = streamSize == 0 ? inp.available() : streamSize;
            while ((read = inp.read(b)) > -1) {
                if (query.isCancelled() || !query.isRunning()) {
                    return null;
                }
                out = out + (this.encoding != null ? new String(b, 0, read, this.encoding) : new String(b, 0, read));
                this.publishProgression(totalReade += read, streamSize, streamSize > 0 ? 100 * totalReade / streamSize : -1);
            }
            inp.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }
}

