/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.http.tools;

import android.util.Log;
import istat.android.network.http.HttpAsyncQuery;
import istat.android.network.http.HttpQuery;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class WrittenByteUploadHandler
extends HttpAsyncQuery.HttpUploadHandler<Integer> {
    int buffer = 16384;

    public WrittenByteUploadHandler() {
    }

    public WrittenByteUploadHandler(int bufferSize) {
        this.buffer = bufferSize;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public int getBuffer() {
        return this.buffer;
    }

    @Override
    public void onProceedStreamUpload(HttpQuery httpQuery, OutputStream request, InputStream stream, HttpAsyncQuery asyc) throws IOException {
        byte[] b = new byte[this.buffer];
        int write = 0;
        int totalWrite = 0;
        int uploadSize = stream.available();
        while ((write = stream.read(b)) > -1) {
            if (httpQuery.isAborted() || !httpQuery.hasRunningRequest()) {
                Log.i((String)"Uploader", (String)"onUploadStream::Aborted");
                stream.close();
                return;
            }
            request.write(b, 0, write);
            request.flush();
            int writePercentage = uploadSize > 0 ? 100 * (totalWrite += write) / uploadSize : 0;
            this.publishProgression(totalWrite, uploadSize, writePercentage);
        }
        stream.close();
        request.close();
    }
}

