/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;

public final class Connectivity {
    public static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo();
    }

    public static boolean isConnected(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected();
    }

    public static boolean isConnectedWifi(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 1;
    }

    public static boolean isConnectedMobile(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && info.getType() == 0;
    }

    public static boolean isConnectedFast(Context context) {
        NetworkInfo info = Connectivity.getNetworkInfo(context);
        return info != null && info.isConnected() && Connectivity.isConnectionFast(info.getType(), info.getSubtype());
    }

    public static boolean isConnectionFast(int type, int subType) {
        if (type == 1) {
            return true;
        }
        if (type == 0) {
            switch (subType) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean hasMobileInternetAccess(Context c) {
        TelephonyManager tm = (TelephonyManager)c.getSystemService("phone");
        return Connectivity.isConnected(c) && tm.getDataState() == 2;
    }

    public String getConnectedWifiName(Context context) {
        NetworkInfo.DetailedState state;
        WifiInfo wifiInfo;
        WifiManager manager = (WifiManager)context.getSystemService("wifi");
        if (manager.isWifiEnabled() && (wifiInfo = manager.getConnectionInfo()) != null && ((state = WifiInfo.getDetailedStateOf((SupplicantState)wifiInfo.getSupplicantState())) == NetworkInfo.DetailedState.CONNECTED || state == NetworkInfo.DetailedState.OBTAINING_IPADDR)) {
            return wifiInfo.getSSID();
        }
        return null;
    }
}

