/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.http;

import android.text.TextUtils;
import android.util.Log;
import istat.android.network.http.HttpAsyncQuery;
import istat.android.network.http.HttpQueryOptions;
import istat.android.network.http.interfaces.HttpSendable;
import istat.android.network.http.interfaces.UpLoadHandler;
import istat.android.network.utils.ToolKits;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.message.BasicNameValuePair;

public abstract class HttpQuery<HttpQ extends HttpQuery<?>> {
    protected HttpQueryOptions mOptions = new HttpQueryOptions();
    protected List<String> urlPramNames = new ArrayList<String>();
    protected HashMap<String, String> parameters = new HashMap();
    protected HashMap<String, String> headers = new HashMap();
    private volatile boolean aborted = false;
    static String TAG_INPUT = "input";
    static String TAG_OUTPUT = "output";
    volatile HttpURLConnection currentConnection;
    long lastConnectionTime = System.currentTimeMillis();
    protected HashMap<String, List<Long>> historic = new HashMap<String, List<Long>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(TAG_INPUT, new ArrayList());
            this.put(TAG_OUTPUT, new ArrayList());
        }
    };
    static HashMap<String, List<Long>> histories = new HashMap<String, List<Long>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(TAG_INPUT, new ArrayList());
            this.put(TAG_OUTPUT, new ArrayList());
        }
    };
    protected HashMap<String, List<Long>> timeHistoric = new HashMap<String, List<Long>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(TAG_INPUT, new ArrayList());
            this.put(TAG_OUTPUT, new ArrayList());
        }
    };
    static HashMap<String, List<Long>> timeHistories = new HashMap<String, List<Long>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(TAG_INPUT, new ArrayList());
            this.put(TAG_OUTPUT, new ArrayList());
        }
    };
    int uploadBufferSize = 16384;
    UpLoadHandler uploadHandler = new UpLoadHandler(){

        @Override
        public void onUploadStream(OutputStream request, InputStream stream) throws IOException {
            int read;
            byte[] b = new byte[HttpQuery.this.uploadBufferSize];
            while ((read = stream.read(b)) > -1) {
                request.write(b, 0, read);
            }
            stream.close();
        }
    };
    ParameterHandler parameterHandler = ParameterHandler.DEFAULT_HANDLER;
    protected volatile InputStream currentInputStream;
    protected volatile OutputStream currentOutputStream;

    public HttpQ addHeader(String name, String value) {
        this.headers.put(name, value);
        return (HttpQ)this;
    }

    public HttpQ addParam(String Name, String Value) {
        this.parameters.put(Name, Value);
        return (HttpQ)this;
    }

    public HttpQ addParam(String Name, String Value, boolean urlParam) {
        this.addParam(Name, Value);
        if (urlParam) {
            this.urlPramNames.add(Name);
        }
        return (HttpQ)this;
    }

    private HashMap<String, String> getUrlParameters() {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        for (String tmp : this.urlPramNames) {
            if (!this.parameters.containsKey(tmp)) continue;
            urlParameters.put(tmp, this.parameters.get(tmp));
        }
        return urlParameters;
    }

    public HttpQ addURLParam(String Name, String Value) {
        return this.addParam(Name, Value, true);
    }

    public HttpQ addURLParam(String Name, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addURLParam(Name + "[" + i + "]", values[i]);
        }
        return (HttpQ)this;
    }

    public HttpQ addURLParams(HashMap<String, Object> nameValues) {
        if (!nameValues.keySet().isEmpty()) {
            String[] table = new String[nameValues.size()];
            for (String tmp : table = nameValues.keySet().toArray(table)) {
                if (tmp == null) continue;
                this.addURLParam(tmp, nameValues.get(tmp).toString());
            }
        }
        return (HttpQ)this;
    }

    public HttpQ addParam(String Name, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.addParam(Name + "[" + i + "]", values[i]);
        }
        return (HttpQ)this;
    }

    public HttpQ addParam(String Name, HashMap<?, ?> values) {
        for (Object name : values.keySet()) {
            Object value = values.get(name);
            this.addParam(Name + "[" + name + "]", value + "");
        }
        return (HttpQ)this;
    }

    public HttpQ setContentType(String name) {
        this.addHeader("Content-Type", name);
        return (HttpQ)this;
    }

    public HttpQ setAccept(String name) {
        this.addHeader("Accept", name);
        return (HttpQ)this;
    }

    public HttpQ setUserAgent(String name) {
        this.addHeader("User-Agent", name);
        return (HttpQ)this;
    }

    public HttpQ addSendable(HttpSendable sendable) {
        sendable.onFillHttpQuery(this);
        return (HttpQ)this;
    }

    public HttpQ addSendable(HttpSendable ... sendableArray) {
        for (HttpSendable sendable : sendableArray) {
            sendable.onFillHttpQuery(this);
        }
        return (HttpQ)this;
    }

    public HttpQ addParams(List<BasicNameValuePair> nameValues) {
        for (BasicNameValuePair pair : nameValues) {
            this.addParam(pair.getName(), pair.getValue());
        }
        return (HttpQ)this;
    }

    public HttpQ addParams(HashMap<?, ?> nameValues) {
        if (!nameValues.keySet().isEmpty()) {
            String[] table = new String[nameValues.size()];
            for (String tmp : table = nameValues.keySet().toArray(table)) {
                Object obj;
                if (tmp == null || (obj = nameValues.get(tmp)) == null) continue;
                this.addParam(tmp, obj.toString());
            }
        }
        return (HttpQ)this;
    }

    public HttpQ addParams(Object container) {
        return this.addParams(ToolKits.toHashMap(container, true, false, false));
    }

    public HttpQ addParams(Object container, boolean privateAndSuper) {
        return this.addParams(ToolKits.toHashMap(container, false, privateAndSuper, false));
    }

    public HttpQ addParams(Object container, String ... ignoredFields) {
        return this.addParams(ToolKits.toHashMap(container, true, false, false, ignoredFields));
    }

    public HttpQ addParams(Object container, boolean privateAndSuper, String ... ignoredFields) {
        return this.addParams(ToolKits.toHashMap(container, privateAndSuper, false, false, ignoredFields));
    }

    public void removeParam(String name) {
        this.parameters.remove(name);
        this.urlPramNames.remove(name);
    }

    public void removeHeder(String name) {
        this.headers.remove(name);
    }

    public HttpQ clearParams() {
        this.parameters.clear();
        this.urlPramNames.clear();
        return (HttpQ)this;
    }

    public HttpQ clearHeaders() {
        this.headers.clear();
        return (HttpQ)this;
    }

    public HttpQ clearExtraData() {
        this.clearHeaders();
        this.clearParams();
        return (HttpQ)this;
    }

    public void setUploadHandler(UpLoadHandler uploadHandler) {
        if (uploadHandler != null) {
            this.uploadHandler = uploadHandler;
        }
    }

    public void setUploadBufferSize(int uploadBufferSize) {
        this.uploadBufferSize = uploadBufferSize;
    }

    protected UpLoadHandler getUploadHandler() {
        return this.uploadHandler;
    }

    public InputStream doPost(String url) throws IOException {
        return this.doQuery(url, "POST", true, true);
    }

    public InputStream doGet(String url) throws IOException {
        return this.doGet(url, true);
    }

    public InputStream doPut(String url) throws IOException {
        String method = "PUT";
        return this.doQuery(url, method, true, true);
    }

    public InputStream doHead(String url) throws IOException {
        return this.doQuery(url, "HEAD");
    }

    public InputStream doDelete(String url) throws IOException {
        return this.doQuery(url, "DELETE", true, true);
    }

    public InputStream doCopy(String url) throws IOException {
        return this.doQuery(url, "COPY", true, true);
    }

    public InputStream doPatch(String url) throws IOException {
        return this.doQuery(url, "PATCH", true, true);
    }

    public InputStream doGet(String url, boolean handleError) throws IOException {
        String method = "GET";
        return this.doQuery(url, method, false, handleError);
    }

    public InputStream doQuery(String url, String method) throws IOException {
        return this.doQuery(url, method, true);
    }

    public InputStream doQuery(String url, String method, boolean holdError) throws IOException {
        return this.doQuery(url, method, false, holdError);
    }

    protected synchronized InputStream doQuery(String url, String method, boolean bodyData, boolean holdError) throws IOException {
        Log.d((String)"HttpQuery", (String)("Method=" + method + ", bodyData=" + bodyData + ", holdError=" + holdError + ", url=" + this.getURL(url)));
        long length = 0L;
        String data = "";
        if (!bodyData || !this.urlPramNames.isEmpty()) {
            HashMap<String, String> urlParameters = this.getUrlParameters();
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (!bodyData) {
                parameters.putAll(this.parameters);
            } else if (!urlParameters.isEmpty()) {
                parameters.putAll(urlParameters);
            }
            if (this.parameterHandler != null) {
                data = this.parameterHandler.onStringifyQueryParams(method, parameters, this.mOptions.encoding);
            }
            if (!ToolKits.Text.isEmpty(data)) {
                url = url + (url.contains("?") ? "" : "?") + data;
                length = data.length();
            }
        }
        try {
            HttpURLConnection connection = this.prepareConnection(url, method);
            if (bodyData) {
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                length = this.writeDataToOutputStream(method, os);
                os.close();
            }
            InputStream stream = this.eval(connection, holdError);
            this.addToOutputHistoric(length);
            this.onQueryComplete();
            return stream;
        }
        catch (IOException e) {
            if (this.isAborted()) {
                throw new AbortionException(this, (Throwable)e);
            }
            throw e;
        }
    }

    protected HttpURLConnection prepareConnection(String url, String method) throws IOException {
        this.onQueryStarting();
        URL Url = new URL(url);
        URLConnection urlConnexion = Url.openConnection();
        HttpURLConnection conn = (HttpURLConnection)urlConnexion;
        if (this.mOptions != null) {
            this.applyOptions(conn);
        }
        this.fillHeader(conn);
        try {
            conn.setRequestMethod(method);
        }
        catch (Exception ex) {
            try {
                Class<?> httpURLConnectionClass = conn.getClass();
                Class<?> parentClass = httpURLConnectionClass.getSuperclass();
                Field methodField = parentClass == HttpsURLConnection.class ? parentClass.getSuperclass().getDeclaredField("method") : parentClass.getDeclaredField("method");
                methodField.setAccessible(true);
                methodField.set(conn, method);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.currentConnection = conn;
        return conn;
    }

    public void setParameterHandler(ParameterHandler parameterHandler) {
        if (parameterHandler != null) {
            this.parameterHandler = parameterHandler;
        }
    }

    private void applyOptions(HttpURLConnection conn) {
        if (this.mOptions.chunkedStreamingMode > 0) {
            conn.setChunkedStreamingMode(this.mOptions.chunkedStreamingMode);
        }
        if (this.mOptions.fixedLengthStreamingMode > 0) {
            conn.setFixedLengthStreamingMode(this.mOptions.fixedLengthStreamingMode);
        }
        if (this.mOptions.followRedirects) {
            HttpURLConnection.setFollowRedirects(this.mOptions.followRedirects);
        }
        if (this.mOptions.instanceFollowRedirects) {
            conn.setInstanceFollowRedirects(this.mOptions.instanceFollowRedirects);
        }
        if (this.mOptions.useCaches) {
            conn.setUseCaches(this.mOptions.useCaches);
        }
        if (this.mOptions.soTimeOut > 0) {
            conn.setReadTimeout(this.mOptions.soTimeOut);
        }
        if (this.mOptions.connexionTimeOut > 0) {
            conn.setConnectTimeout(this.mOptions.connexionTimeOut);
        }
    }

    private void fillHeader(HttpURLConnection conn) {
        if (!this.headers.keySet().isEmpty()) {
            String[] table = new String[this.headers.size()];
            for (String tmp : table = this.headers.keySet().toArray(table)) {
                if (tmp == null) continue;
                conn.addRequestProperty(tmp, this.headers.get(tmp));
            }
        }
    }

    protected final long writeDataToOutputStream(String method, OutputStream os) throws IOException {
        this.currentOutputStream = os;
        long length = this.onWriteDataToOutputStream(method, this.currentOutputStream);
        if (length > 0L) {
            this.currentOutputStream.flush();
        }
        return length;
    }

    protected long onWriteDataToOutputStream(String method, OutputStream dataOutputStream) throws IOException {
        String encoding = this.getOptions().encoding;
        OutputStreamWriter writer = new OutputStreamWriter(dataOutputStream, encoding);
        String data = "";
        if (this.parameterHandler != null) {
            data = this.parameterHandler.onStringifyQueryParams(method, this.parameters, encoding);
        }
        if (!TextUtils.isEmpty((CharSequence)data)) {
            writer.write(data);
            writer.flush();
            return data.length();
        }
        return 0L;
    }

    public String getURL(String address) throws IOException {
        String paramString = HttpQuery.createStringularQueryAbleData(this.parameters, this.mOptions.encoding);
        return address + (paramString == null || paramString.equals("") ? "" : "?" + paramString);
    }

    public void shutDownConnection() {
        this.currentConnection.disconnect();
        this.currentConnection = null;
        this.onQueryComplete();
        this.aborted = true;
    }

    public boolean isAutoClearParamsEnable() {
        return this.mOptions.autoClearRequestParams;
    }

    public HttpURLConnection getCurrentConnection() {
        return this.currentConnection;
    }

    public boolean hasPendingRequest() {
        return this.currentConnection != null;
    }

    public boolean hasRunningRequest() {
        return this.hasPendingRequest() && (this.currentInputStream != null || this.currentOutputStream != null);
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setConnectionTimeOut(int milliSec) {
        this.mOptions.connexionTimeOut = milliSec;
    }

    public void setSoTimeOut(int milliSec) {
        this.mOptions.connexionTimeOut = milliSec;
    }

    public int getConnectionTimeOut() {
        return this.mOptions.connexionTimeOut;
    }

    public int getSoTimeOut() {
        return this.mOptions.soTimeOut;
    }

    public void setEncoding(String encoding) {
        this.mOptions.encoding = encoding;
    }

    public void setClearParamsAfterEachQueryEnable(boolean autoClearParams) {
        this.mOptions.autoClearRequestParams = autoClearParams;
    }

    public static String createStringularQueryAbleData(HashMap<String, String> params, String encoding) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(name, encoding));
            result.append("=");
            result.append(URLEncoder.encode(value, encoding));
        }
        return result.toString();
    }

    void onQueryStarting() {
        this.lastConnectionTime = System.currentTimeMillis();
        this.aborted = false;
    }

    void onQueryComplete() {
        if (this.mOptions != null && this.mOptions.autoClearRequestParams) {
            this.clearParams();
        }
        this.currentInputStream = null;
        this.currentOutputStream = null;
    }

    void addToInputHistoric(long input) {
        this.historic.get(TAG_INPUT).add(input);
        histories.get(TAG_INPUT).add(input);
        Long elapsed = System.currentTimeMillis() - this.lastConnectionTime;
        this.timeHistoric.get(TAG_INPUT).add(elapsed);
        timeHistories.get(TAG_INPUT).add(elapsed);
    }

    void addToOutputHistoric(long input) {
        this.historic.get(TAG_OUTPUT).add(input);
        histories.get(TAG_OUTPUT).add(input);
        Long elapsed = System.currentTimeMillis() - this.lastConnectionTime;
        this.timeHistoric.get(TAG_OUTPUT).add(elapsed);
        timeHistories.get(TAG_OUTPUT).add(elapsed);
    }

    InputStream eval(HttpURLConnection conn, boolean handleError) throws IOException {
        int eval = 0;
        InputStream stream = null;
        int responseCode = 500;
        if (conn != null) {
            responseCode = conn.getResponseCode();
            eval = conn.getContentLength();
        }
        if (HttpAsyncQuery.HttpQueryResponse.isSuccessCode(responseCode)) {
            stream = conn.getInputStream();
        } else if (handleError) {
            stream = conn.getErrorStream();
        }
        if (stream != null) {
            eval = stream.available();
        }
        this.currentInputStream = stream;
        this.addToInputHistoric(eval);
        return stream;
    }

    int getCurrentResponseCode() {
        try {
            if (this.getCurrentConnection() != null) {
                return this.getCurrentConnection().getResponseCode();
            }
            Log.d((String)"HttpQuery", (String)("getCurrentResponseCode::connexion::" + this.getCurrentConnection()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    String getCurrentResponseMessage() {
        try {
            if (this.getCurrentConnection() != null) {
                return this.getCurrentConnection().getResponseMessage();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public boolean abortRequest() {
        this.aborted = true;
        boolean out = this.hasPendingRequest();
        Log.e((String)"HttQuery", (String)("abortRequest_start::runningRequest=" + out));
        if (out) {
            try {
                this.currentConnection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.currentOutputStream != null) {
                try {
                    this.currentOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.currentInputStream != null) {
                try {
                    this.currentInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.onQueryComplete();
        }
        return out;
    }

    public List<Long> getCurrentOutputContentLegthHistoric() {
        return this.historic.get(TAG_OUTPUT);
    }

    public List<Long> getCurrentInputContentLegthHistoric() {
        return this.historic.get(TAG_INPUT);
    }

    public long getCurrentOutputContentLegth() {
        long out = 0L;
        for (long i : this.historic.get(TAG_OUTPUT)) {
            out += i;
        }
        return out;
    }

    public long getCurrentInputContentLegth() {
        long out = 0L;
        for (long i : this.historic.get(TAG_INPUT)) {
            out += i;
        }
        return out;
    }

    public List<Long> getCurrentOutputTimeHistoric() {
        return this.timeHistoric.get(TAG_OUTPUT);
    }

    public List<Long> getCurrentInputTimeHistoric() {
        return this.timeHistoric.get(TAG_INPUT);
    }

    public long getCurrentOutputTime() {
        long out = 0L;
        for (long i : this.timeHistoric.get(TAG_OUTPUT)) {
            out += i;
        }
        return out;
    }

    public long getCurrentInputTime() {
        long out = 0L;
        for (long i : this.timeHistoric.get(TAG_INPUT)) {
            out += i;
        }
        return out;
    }

    public void setOptions(HttpQueryOptions option) {
        this.mOptions = option;
        if (this.mOptions == null) {
            this.mOptions = new HttpQueryOptions();
        }
    }

    public HttpQueryOptions getOptions() {
        return this.mOptions;
    }

    public static List<Long> getOutputContentLegthHistoric() {
        return histories.get(TAG_OUTPUT);
    }

    public static List<Long> getInputContentLegthHistoric() {
        return histories.get(TAG_INPUT);
    }

    public static long getOutputContentLegth() {
        long out = 0L;
        for (long i : histories.get(TAG_OUTPUT)) {
            out += i;
        }
        return out;
    }

    public static long getInputContentLegth() {
        long out = 0L;
        for (long i : histories.get(TAG_INPUT)) {
            out += i;
        }
        return out;
    }

    public static List<Long> getOutputTimeHistoric() {
        return timeHistories.get(TAG_OUTPUT);
    }

    public static List<Long> getInputTimeHistoric() {
        return timeHistories.get(TAG_INPUT);
    }

    public static long getOutputTime() {
        long out = 0L;
        for (long i : timeHistories.get(TAG_OUTPUT)) {
            out += i;
        }
        return out;
    }

    public static long getInputTime() {
        long out = 0L;
        for (long i : timeHistories.get(TAG_INPUT)) {
            out += i;
        }
        return out;
    }

    public boolean disconnect() {
        boolean out = this.hasPendingRequest();
        if (this.getCurrentConnection() != null) {
            this.getCurrentConnection().disconnect();
        }
        return out;
    }

    public static class AbortionException
    extends IOException {
        HttpQuery httpQuery;

        AbortionException(HttpQuery http) {
            super("HttpQuery defined by: " + http + ", has been aborted. None IO action can be done anymore.");
            this.httpQuery = http;
        }

        AbortionException(HttpQuery http, Throwable cause) {
            this(http);
            this.initCause(cause);
        }

        public HttpQuery getHttpQuery() {
            return this.httpQuery;
        }
    }

    public static interface ParameterHandler {
        public static final ParameterHandler DEFAULT_HANDLER = new ParameterHandler(){

            @Override
            public String onStringifyQueryParams(String method, HashMap<String, String> params, String encoding) {
                try {
                    return HttpQuery.createStringularQueryAbleData(params, encoding);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };

        public String onStringifyQueryParams(String var1, HashMap<String, String> var2, String var3);
    }
}

