/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.utils;

import android.annotation.SuppressLint;
import android.util.Base64;
import android.util.Log;
import istat.android.network.utils.SHA1;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;

public class Security {
    static final String[] PASSWORD_PROPOSITION_CHAR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    @SuppressLint(value={"SimpleDateFormat"})
    public static String generateXWSSEToken(String userName, String secret) {
        return Security.generateXWSSEToken(userName, secret, System.currentTimeMillis());
    }

    public static String generateXWSSEToken(String userName, String secret, long time) {
        String nonce = "";
        Random random = new Random();
        for (int i = 0; i < 16; ++i) {
            int index = random.nextInt(PASSWORD_PROPOSITION_CHAR.length - 1);
            nonce = nonce + PASSWORD_PROPOSITION_CHAR[index];
        }
        return Security.generateXWSSEToken(userName, secret, nonce, time);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String generateXWSSEToken(String userName, String secret, String nonce, long time) {
        try {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss+00:00");
            df.setTimeZone(tz);
            String nowAsISO = df.format(new Date(time));
            Log.i((String)"Security", (String)("generateXWSSEToken::nonce=" + nonce));
            String createAt = nowAsISO;
            String password = nonce + createAt + secret;
            String sha1 = SHA1.toSHA1(password.getBytes());
            String passwordDigest = Base64.encodeToString((byte[])SHA1.toByte(sha1), (int)2);
            String header = "UsernameToken Username=\"" + userName + "\", PasswordDigest=\"" + passwordDigest + "\", Nonce=\"" + Base64.encodeToString((byte[])nonce.getBytes(), (int)2) + "\", Created=\"" + createAt + "\"";
            return header;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

