/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.utils;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class StreamOperationTools {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String streamToLinearisedString(OperationController controller, InputStream inp, String encoding) throws IOException {
        String line;
        StringBuilder total = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(inp, encoding));
        while ((line = r.readLine()) != null) {
            StreamOperationTools.pauseControl(controller);
            total.append(line);
        }
        String out = total.toString();
        inp.close();
        return out;
    }

    public static String streamToString(OperationController controller, InputStream inp) throws IOException {
        return StreamOperationTools.streamToString(controller, inp, DEFAULT_ENCODING);
    }

    public static String streamToString(OperationController controller, InputStream inp, int buffer) throws IOException {
        return StreamOperationTools.streamToString(controller, inp, buffer, null);
    }

    public static String streamToString(OperationController controller, InputStream inp, String encoding) throws IOException {
        return StreamOperationTools.streamToString(controller, inp, 16384, encoding);
    }

    public static String streamToString(OperationController controller, InputStream inp, int buffer, String encoding) throws IOException {
        int read;
        String out = "";
        byte[] b = new byte[buffer];
        while ((read = inp.read(b)) > -1) {
            StreamOperationTools.pauseControl(controller);
            if (controller.isStopped()) {
                Log.i((String)"HttpQuery", (String)"streamToString::aborted");
                break;
            }
            out = out + (encoding != null ? new String(b, 0, read, encoding) : new String(b, 0, read));
        }
        inp.close();
        return out;
    }

    public static void pauseControl(OperationController controller) {
        if (controller.isPaused()) {
            while (controller.isPaused()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static OperationController copyStream(InputStream is, OutputStream os) throws IOException {
        return StreamOperationTools.copyStream(is, os, 16384, 0);
    }

    public static OperationController copyStream(byte[] prefix, byte[] suffix, InputStream is, OutputStream os) throws IOException {
        OperationController controller = new OperationController();
        StreamOperationTools.copyStream(controller, prefix, suffix, is, os, 16384, 0);
        return controller;
    }

    public static OperationController copyStream(InputStream is, OutputStream os, int buffer_size) throws IOException {
        return StreamOperationTools.copyStream(is, os, buffer_size, 0);
    }

    public static OperationController copyStream(InputStream is, OutputStream os, int buffer_size, int startByte) throws IOException {
        OperationController controller = new OperationController();
        StreamOperationTools.copyStream(controller, null, null, is, os, buffer_size, startByte);
        return controller;
    }

    public static OutputStream copyStream(OperationController controller, InputStream is, OutputStream os) throws IOException {
        return StreamOperationTools.copyStream(controller, is, os, 16384, 0);
    }

    public static OutputStream copyStream(OperationController controller, byte[] prefix, byte[] suffix, InputStream is, OutputStream os) throws IOException {
        return StreamOperationTools.copyStream(controller, prefix, suffix, is, os, 16384, 0);
    }

    public static OutputStream copyStream(OperationController controller, InputStream is, OutputStream os, int buffer_size) throws IOException {
        return StreamOperationTools.copyStream(controller, is, os, buffer_size, 0);
    }

    public static OutputStream copyStream(OperationController controller, InputStream is, OutputStream os, int buffer_size, int startByte) throws IOException {
        return StreamOperationTools.copyStream(controller, null, null, is, os, buffer_size, startByte);
    }

    public static OutputStream copyStream(OperationController controller, byte[] prefix, byte[] suffix, InputStream inp, OutputStream os, int buffer, int startByte) throws IOException {
        int read;
        byte[] b = new byte[buffer];
        inp.skip(startByte);
        if (prefix != null && prefix.length > 0) {
            os.write(prefix);
        }
        while ((read = inp.read(b)) > -1) {
            StreamOperationTools.pauseControl(controller);
            if (controller.isStopped()) {
                Log.i((String)"HttpQuery", (String)"streamToString::aborted");
                break;
            }
            os.write(b, 0, read);
        }
        if (suffix != null && suffix.length > 0) {
            os.write(suffix);
        }
        os.close();
        return os;
    }

    public static RandomAccessFile copyStream(OperationController controller, byte[] prefix, byte[] suffix, InputStream inp, RandomAccessFile os, int buffer_size, int startByte) throws IOException {
        int read;
        byte[] bytes = new byte[buffer_size];
        inp.skip(startByte);
        os.seek(startByte);
        if (prefix != null && prefix.length > 0) {
            os.write(prefix);
        }
        while ((read = inp.read(bytes)) > -1) {
            StreamOperationTools.pauseControl(controller);
            if (controller.isStopped()) {
                Log.i((String)"HttpQuery", (String)"streamToString::aborted");
                break;
            }
            os.write(bytes, 0, read);
        }
        if (suffix != null && suffix.length > 0) {
            os.write(suffix);
        }
        os.close();
        return os;
    }

    public static OutputStream[] dispatch(OperationController controller, int buffer_size, InputStream is, OutputStream ... oss) throws IOException {
        int count;
        byte[] bytes = new byte[buffer_size];
        while ((count = is.read(bytes, 0, buffer_size)) != -1) {
            for (OutputStream os : oss) {
                os.write(bytes, 0, count);
            }
        }
        return oss;
    }

    public static class OperationController {
        boolean paused = false;
        boolean stopped = false;

        public void pause() {
            this.paused = true;
        }

        public void resume() {
            this.paused = false;
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

