/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.http;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import istat.android.network.http.AsyncHttp;
import istat.android.network.http.HttpQuery;
import istat.android.network.http.HttpQueryError;
import istat.android.network.http.MultipartHttpQuery;
import istat.android.network.http.SimpleHttpQuery;
import istat.android.network.http.interfaces.DownloadHandler;
import istat.android.network.http.interfaces.ProgressionListener;
import istat.android.network.http.interfaces.UpLoadHandler;
import istat.android.network.utils.StreamOperationTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

public final class HttpAsyncQuery
extends AsyncTask<String, HttpQueryResponse, HttpQueryResponse> {
    public static final int TYPE_GET = 1;
    public static final int TYPE_POST = 2;
    public static final int TYPE_PUT = 3;
    public static final int TYPE_HEAD = 4;
    public static final int TYPE_DELETE = 5;
    public static final int TYPE_COPY = 6;
    public static final int TYPE_PATCH = 7;
    public static final int TYPE_RENAME = 8;
    public static final int TYPE_MOVE = 9;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final HashMap<Integer, String> METHOD_TYPE_NAME_MAP = new HashMap<Integer, String>(){
        {
            this.put(6, "COPY");
            this.put(9, "MOVE");
            this.put(1, "GET");
            this.put(2, "POST");
            this.put(7, "PATCH");
            this.put(4, "HEAD");
            this.put(3, "PUT");
            this.put(5, "DELETE");
        }
    };
    public static final String DEFAULT_ENCODING = "UTF-8";
    UpLoadHandler uploadHandler;
    HttpQueryCallback mHttpCallBack;
    CancelListener mCancelListener;
    final HttpQuery<?> mHttp;
    int type = 1;
    int bufferSize = 16384;
    String encoding = "UTF-8";
    private long startTimeStamp = 0L;
    private long endTimeStamp = 0L;
    static final ConcurrentHashMap<Object, HttpAsyncQuery> taskQueue = new ConcurrentHashMap();
    Executor mExecutor;
    HttpQueryResponse result;
    private Runnable httpAbortRunnable = new Runnable(){

        @Override
        public void run() {
            HttpAsyncQuery.this.mHttp.abortRequest();
        }
    };
    HttpDownloadHandler<?> downloadHandler = this.getDefaultDownloader();
    public final StreamOperationTools.OperationController executionController = new StreamOperationTools.OperationController(){

        @Override
        public boolean isStopped() {
            return !HttpAsyncQuery.this.isRunning();
        }
    };
    public static final int WHEN_BEGIN = -1;
    public static final int WHEN_ANYWAY = 0;
    public static final int WHEN_SUCCEED = 1;
    public static final int WHEN_ERROR = 2;
    public static final int WHEN_ABORTION = 3;
    public static final int WHEN_FAILED = 4;
    final ConcurrentHashMap<Runnable, Integer> executedRunnable = new ConcurrentHashMap();
    final ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Runnable>> runnableTask = new ConcurrentHashMap();
    String id;

    HttpAsyncQuery(HttpQuery<?> http) {
        this.mHttp = http;
    }

    private HttpAsyncQuery(HttpQuery<?> http, HttpQueryCallback callBack) {
        this.mHttpCallBack = callBack;
        this.mHttp = http;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.notifyStarting();
        this.startTimeStamp = System.currentTimeMillis();
        this.id = HttpAsyncQuery.createQueryId();
        taskQueue.put(this.id, this);
    }

    protected HttpQueryResponse doInBackground(String ... urls) {
        for (String url : urls) {
            if (this.isCancelled()) break;
            InputStream stream = null;
            Exception error = null;
            Log.d((String)"HttpAsyncQuery", (String)("doInBackground::type=" + this.type));
            try {
                switch (this.type) {
                    case 1: {
                        stream = this.mHttp.doGet(url);
                        break;
                    }
                    case 2: {
                        stream = this.mHttp.doPost(url);
                        break;
                    }
                    case 3: {
                        stream = this.mHttp.doPut(url);
                        break;
                    }
                    case 4: {
                        stream = this.mHttp.doHead(url);
                        break;
                    }
                    case 6: {
                        stream = this.mHttp.doCopy(url);
                        break;
                    }
                    case 8: {
                        stream = this.mHttp.doQuery(url, "RENAME");
                        break;
                    }
                    case 9: {
                        stream = this.mHttp.doQuery(url, "MOVE", true, true);
                        break;
                    }
                    case 5: {
                        stream = this.mHttp.doDelete(url);
                        break;
                    }
                    case 7: {
                        stream = this.mHttp.doPatch(url);
                        break;
                    }
                    default: {
                        stream = this.mHttp.doGet(url);
                    }
                }
                HttpQueryResponse response = new HttpQueryResponse(stream, error, this);
                return response;
            }
            catch (HttpQuery.AbortionException e) {
                e.printStackTrace();
                Log.i((String)"HttpAsycQ", (String)"doInBackground::was aborded");
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                HttpQueryResponse errorResponse = HttpQueryResponse.getErrorInstance(e, this);
                return errorResponse;
            }
        }
        return null;
    }

    protected void onProgressUpdate(HttpQueryResponse ... values) {
    }

    public HttpQueryResponse getResult() throws IllegalAccessException {
        if (this.result != null) {
            return this.result;
        }
        if (!this.isPending()) {
            throw new IllegalAccessException("Current query can't has result for now. it is still pending.");
        }
        throw new IllegalAccessException("Current query has not response for now.");
    }

    private void dispatchQueryResponse(HttpQueryResponse resp) {
        this.result = resp;
        this.executedRunnable.clear();
        try {
            boolean aborted = this.isAborted();
            if (resp.isAccepted() && !aborted) {
                if (resp.isSuccess()) {
                    this.notifySuccess(resp);
                } else {
                    HttpQueryError error = resp.hasError() && resp.getError() instanceof HttpQueryError ? (HttpQueryError)resp.getError() : new HttpQueryError(resp.getError());
                    resp.error = error;
                    this.notifyError(resp, error);
                }
            }
        }
        catch (Exception e) {
            this.notifyFail(e);
        }
    }

    private void notifyStarting() {
        int when = -1;
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, when);
    }

    private void notifySuccess(HttpQueryResponse resp) {
        int when = -1;
        if (this.mHttpCallBack != null) {
            this.mHttpCallBack.onHttpSuccess(resp);
        }
        this.notifyCompleted(resp);
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, when);
    }

    private void notifyError(HttpQueryResponse resp, HttpQueryError error) {
        int when = -1;
        if (this.mHttpCallBack != null) {
            this.mHttpCallBack.onHttpError(resp, error);
        }
        this.notifyCompleted(resp);
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, when);
    }

    private void notifyCompleted(HttpQueryResponse resp) {
        int when = -1;
        if (this.mHttpCallBack != null) {
            this.mHttpCallBack.onHttComplete(resp);
        }
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, when);
    }

    private void notifyFail(Exception e) {
        int when = 4;
        if (this.mHttpCallBack != null) {
            this.mHttpCallBack.onHttpFail(e);
        }
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        this.executeWhen(runnableList, when);
    }

    private void notifyAborted() {
        int when = 3;
        if (this.mHttpCallBack != null) {
            this.mHttpCallBack.onHttpAborted();
        }
        if (this.mCancelListener != null) {
            this.mCancelListener.onCanceling(this);
        }
        this.result = HttpQueryResponse.getErrorInstance(new HttpQuery.AbortionException(this.mHttp), this);
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(when);
        ConcurrentLinkedQueue<Runnable> runnableAnywayList = this.runnableTask.get(0);
        runnableList.addAll(runnableAnywayList);
        this.executeWhen(runnableList, when);
    }

    public boolean isAborted() {
        return this.isCancelled() || this.mHttp.isAborted();
    }

    protected void onPostExecute(HttpQueryResponse result) {
        super.onPostExecute((Object)result);
        if (result == null) {
            return;
        }
        if (this.mHttpCallBack != null && !this.mHttp.isAborted() && !this.isCancelled()) {
            this.dispatchQueryResponse(result);
        }
        taskQueue.values().removeAll(Collections.singletonList(this));
    }

    protected void onCancelled() {
        Log.i((String)"HttpAsyncQuery", (String)("onCancelled::canceListener::" + this.mCancelListener));
        Log.i((String)"HttpAsyncQuery", (String)("onCancelled::httpCallback::" + this.mHttpCallBack));
        this.endTimeStamp = System.currentTimeMillis();
        if (this.mCancelListener != null) {
            this.mCancelListener.onCancelled(this);
        }
        taskQueue.values().removeAll(Collections.singletonList(this));
        super.onCancelled();
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncGet(HttpQuery<?> http, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 1, 16384, http.mOptions.encoding, null, url);
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncGet(HttpQuery<?> http, HttpQueryCallback callBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 1, 16384, http.mOptions.encoding, callBack, url);
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncQuery(HttpQuery<?> http, int queryType, int bufferSize, String encoding, HttpQueryCallback callBack, HttpDownloadHandler<?> processCallBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, queryType, bufferSize, encoding, callBack, processCallBack, null, url);
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncQuery(HttpQuery<?> http, int queryType, int bufferSize, String encoding, HttpQueryCallback callBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, queryType, bufferSize, encoding, callBack, null, null, url);
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncPost(HttpQuery<?> http, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 2, 16384, http.mOptions.encoding, null, url);
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncPost(HttpQuery<?> http, HttpQueryCallback callBack, String url) {
        return HttpAsyncQuery.doAsyncQuery(http, 2, 16384, http.mOptions.encoding, callBack, url);
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncPost(HttpQuery<?> http, HttpQueryCallback callBack, HttpUploadHandler<?> uploadCallback, String url) {
        HttpAsyncQuery query = HttpAsyncQuery.doAsyncQuery(http, 2, 16384, http.mOptions.encoding, callBack, url);
        query.setUploadHandler(uploadCallback);
        return query;
    }

    @Deprecated
    public static HttpAsyncQuery doAsyncPost(MultipartHttpQuery http, int bufferSize, String encoding, HttpQueryCallback callBack, HttpDownloadHandler<?> processCallBack, CancelListener cancelCallback, HttpUploadHandler<?> uploadCallBack, String ... urls) {
        HttpAsyncQuery query = new HttpAsyncQuery(http, callBack);
        query.setDownloadHandler(processCallBack);
        query.setCancelListener(cancelCallback);
        query.setUploadHandler(uploadCallBack);
        query.type = 2;
        query.encoding = encoding;
        query.bufferSize = bufferSize;
        query.executeURLs(urls);
        return query;
    }

    boolean prepareQuery() {
        if (this.uploadHandler != null) {
            this.mHttp.setUploadHandler(this.uploadHandler);
            if (this.uploadHandler instanceof HttpUploadHandler) {
                ((HttpUploadHandler)this.uploadHandler).query = this;
            }
            return true;
        }
        return false;
    }

    void setUploadHandler(UpLoadHandler uploader) {
        this.uploadHandler = uploader;
    }

    public static HttpAsyncQuery doAsyncQuery(HttpQuery<?> http, int queryType, int bufferSize, String encoding, HttpQueryCallback callBack, HttpDownloadHandler<?> processCallBack, CancelListener cancelListener, String ... urls) {
        HttpAsyncQuery query = new HttpAsyncQuery(http, callBack);
        query.setDownloadHandler(processCallBack);
        query.setCancelListener(cancelListener);
        query.type = queryType;
        query.encoding = encoding;
        query.bufferSize = bufferSize;
        query.executeURLs(urls);
        return query;
    }

    @TargetApi(value=11)
    void executeURLs(String ... urls) {
        this.prepareQuery();
        if (Build.VERSION.SDK_INT >= 11) {
            if (this.mExecutor == null) {
                this.mExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
            }
            this.executeOnExecutor(this.mExecutor, urls);
        } else {
            this.execute(urls);
        }
    }

    public boolean isCompleted() {
        if (this.isCancelled()) {
            return false;
        }
        return this.getStatus().equals((Object)AsyncTask.Status.FINISHED);
    }

    public boolean isRunning() {
        return this.getStatus().equals((Object)AsyncTask.Status.RUNNING) || this.mHttp.hasRunningRequest() && !this.getStatus().equals((Object)AsyncTask.Status.FINISHED);
    }

    public boolean isPending() {
        return this.getStatus().equals((Object)AsyncTask.Status.PENDING) || this.mHttp.hasPendingRequest();
    }

    public long getExecutionTime() {
        if (this.endTimeStamp <= this.startTimeStamp) {
            return this.getDuration();
        }
        return this.endTimeStamp - this.startTimeStamp;
    }

    public final boolean cancel() {
        Log.i((String)"HttAsyncQuery", (String)("cancel_start, running=" + this.mHttp.hasRunningRequest() + ", pending=\" + mHttp.hasPendingRequest() +, aborted=" + this.mHttp.isAborted()));
        if (this.mHttp.hasPendingRequest()) {
            Log.i((String)"HttQuery", (String)"cancel_has_running");
            new Thread(this.httpAbortRunnable).start();
        }
        this.notifyAborted();
        return this.cancel(true);
    }

    private long getDuration() {
        return System.currentTimeMillis() - this.startTimeStamp;
    }

    public HttpAsyncQuery setDownloadHandler(final DownloadHandler downloader) {
        HttpDownloadHandler<Integer> downloadHandler = new HttpDownloadHandler<Integer>(){

            public void onProgress(HttpAsyncQuery query, Integer ... integers) {
            }

            @Override
            public Object onBuildResponseBody(HttpURLConnection connexion, InputStream stream) throws Exception {
                HttpDownloadHandler<?> handler = downloader != null ? downloader : HttpAsyncQuery.this.getDefaultDownloader();
                return handler.onBuildResponseBody(connexion, stream);
            }
        };
        return this.setDownloadHandler(downloadHandler);
    }

    public HttpAsyncQuery setDownloadHandler(HttpDownloadHandler<?> downloader) {
        if (downloader == null) {
            downloader = this.getDefaultDownloader();
        }
        downloader.query = this;
        this.downloadHandler = downloader;
        return this;
    }

    public boolean isPaused() {
        return this.executionController.isPaused();
    }

    public void resume() {
        this.executionController.resume();
    }

    public void pause() {
        this.executionController.pause();
    }

    public boolean isSuccess() {
        try {
            HttpQueryResponse result = this.getResult();
            return result != null && result.isSuccess();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    HttpDownloadHandler<?> getDefaultDownloader() {
        return new HttpDownloadHandler<Integer>(){
            {
                this.query = HttpAsyncQuery.this;
            }

            @Override
            public String onBuildResponseBody(HttpURLConnection currentConnexion, InputStream stream) {
                try {
                    return StreamOperationTools.streamToString(HttpAsyncQuery.this.executionController, stream, HttpAsyncQuery.this.bufferSize, HttpAsyncQuery.this.encoding);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "";
                }
            }

            public void onProgress(HttpAsyncQuery query, Integer ... vars) {
            }
        };
    }

    public boolean setCancelListener(CancelListener listener) {
        if (listener != null) {
            this.mCancelListener = listener;
            return true;
        }
        return false;
    }

    public void addTocken(String uniqueToken) {
        taskQueue.put(uniqueToken, this);
    }

    public static HttpAsyncQuery getTask(HttpQueryCallback callback) {
        return taskQueue.get(callback);
    }

    public static HttpAsyncQuery getTask(Object token) {
        return taskQueue.get(token);
    }

    public static List<HttpAsyncQuery> getTaskQueue() {
        return new ArrayList<HttpAsyncQuery>(taskQueue.values());
    }

    public static void cancelAll() {
        for (HttpAsyncQuery http : HttpAsyncQuery.getTaskQueue()) {
            http.cancel(true);
        }
    }

    public static void cancel(Object token) {
        HttpAsyncQuery http = HttpAsyncQuery.getTask(token);
        if (http != null) {
            http.cancel(true);
        }
    }

    @Deprecated
    public static final AsyncHttp from(HttpQuery<?> http) {
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    @Deprecated
    public static final AsyncHttp fromDefaultHttp() {
        SimpleHttpQuery http = new SimpleHttpQuery();
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    @Deprecated
    public static final AsyncHttp fromMultipartHttp() {
        MultipartHttpQuery http = new MultipartHttpQuery();
        return new AsyncHttp(new HttpAsyncQuery(http));
    }

    public HttpPromise then(Runnable runnable) {
        HttpPromise promise = new HttpPromise(this);
        promise.then(runnable);
        return promise;
    }

    public HttpPromise then(PromiseCallback callback) {
        HttpPromise promise = new HttpPromise(this);
        promise.then(callback);
        return promise;
    }

    public HttpPromise error(Runnable runnable) {
        HttpPromise promise = new HttpPromise(this);
        promise.error(runnable);
        return promise;
    }

    public HttpPromise error(WhenCallback callback) {
        HttpPromise promise = new HttpPromise(this);
        promise.error(callback);
        return promise;
    }

    public HttpPromise error(PromiseCallback callback, int when) {
        HttpPromise promise = new HttpPromise(this);
        promise.error(callback, when);
        return promise;
    }

    public HttpAsyncQuery runWhen(final WhenCallback callback, int ... when) {
        if (callback == null) {
            return this;
        }
        return this.runWhen(new Runnable(){

            @Override
            public void run() {
                HttpQueryResponse resp = null;
                int when = 0;
                try {
                    resp = HttpAsyncQuery.this.getResult();
                    when = HttpAsyncQuery.this.executedRunnable.get(this);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                callback.onWhen(resp, HttpAsyncQuery.this, when);
            }
        }, when);
    }

    public HttpAsyncQuery runWhen(Runnable runnable, int ... when) {
        if (runnable == null) {
            return this;
        }
        for (int value : when) {
            this.addWhen(runnable, value);
        }
        return this;
    }

    private void addWhen(Runnable runnable, int conditionTime) {
        if (!this.isWhenContain(runnable, conditionTime)) {
            ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(conditionTime);
            if (runnableList == null) {
                runnableList = new ConcurrentLinkedQueue();
            }
            runnableList.add(runnable);
            this.runnableTask.put(conditionTime, runnableList);
        }
    }

    private boolean isWhenContain(Runnable run, int conditionTime) {
        ConcurrentLinkedQueue<Runnable> runnableList = this.runnableTask.get(conditionTime);
        if (runnableList == null || runnableList.isEmpty()) {
            return false;
        }
        return runnableList.contains(run);
    }

    private void executeWhen(ConcurrentLinkedQueue<Runnable> runnableList, int when) {
        if (runnableList != null && runnableList.size() > 0) {
            for (Runnable runnable : runnableList) {
                if (this.executedRunnable.contains(runnable)) continue;
                runnable.run();
                this.executedRunnable.put(runnable, when);
            }
        }
    }

    public boolean dismissAllRunWhen() {
        boolean isEmpty = this.runnableTask.isEmpty();
        this.runnableTask.clear();
        return !isEmpty;
    }

    public boolean dismissRunWhen(int ... when) {
        boolean isEmpty = false;
        for (int i : when) {
            ConcurrentLinkedQueue<Runnable> runnables = this.runnableTask.get(i);
            if (runnables == null) continue;
            isEmpty &= runnables.isEmpty();
            runnables.clear();
        }
        return !isEmpty;
    }

    public boolean dismissCallback() {
        boolean dismiss = this.mHttpCallBack != null;
        this.mHttpCallBack = null;
        return dismiss;
    }

    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    public long getEndTimeStamp() {
        return this.endTimeStamp;
    }

    static String createQueryId() {
        long time = System.currentTimeMillis();
        while (taskQueue.contains(time + "")) {
            if (!taskQueue.contains(time)) continue;
            ++time;
        }
        return time + "";
    }

    public String getID() {
        return this.id;
    }

    public HttpQuery<?> getHttpQuery() {
        return this.mHttp;
    }

    public static final class HttpPromise {
        HttpAsyncQuery query;

        public HttpAsyncQuery getQuery() {
            return this.query;
        }

        HttpPromise(HttpAsyncQuery query) {
            this.query = query;
        }

        public HttpPromise then(final PromiseCallback callback) {
            if (callback == null) {
                return this;
            }
            this.query.runWhen(new WhenCallback(){

                @Override
                public void onWhen(HttpQueryResponse resp, HttpAsyncQuery query, int when) {
                    callback.onPromise(resp, query);
                }
            }, 1);
            return this;
        }

        public HttpPromise then(Runnable runnable) {
            if (runnable == null) {
                return this;
            }
            this.query.runWhen(runnable, 1);
            return this;
        }

        public HttpPromise error(final PromiseCallback pCallback, int when) {
            if (pCallback == null) {
                return this;
            }
            WhenCallback callback = new WhenCallback(){

                @Override
                public void onWhen(HttpQueryResponse resp, HttpAsyncQuery query, int when) {
                    pCallback.onPromise(resp, query);
                }
            };
            if (when != 4 && when != 2 && when != 3) {
                this.query.runWhen(callback, 4, 2, 3);
            } else {
                this.query.runWhen(callback, when);
            }
            return this;
        }

        public void error(WhenCallback callback) {
            if (callback == null) {
                return;
            }
            this.query.runWhen(callback, 4, 2, 3);
        }

        public HttpPromise error(Runnable runnable) {
            if (runnable == null) {
                return this;
            }
            this.query.runWhen(runnable, 4, 2, 3);
            return this;
        }
    }

    public static interface PromiseCallback {
        public void onPromise(HttpQueryResponse var1, HttpAsyncQuery var2);
    }

    public static interface WhenCallback {
        public void onWhen(HttpQueryResponse var1, HttpAsyncQuery var2, int var3);
    }

    public static abstract class HttpDownloadHandler<ProgressVar>
    implements DownloadHandler,
    ProgressionListener<ProgressVar> {
        Handler handler;
        HttpAsyncQuery query;

        public HttpDownloadHandler(Handler handler) {
            this.handler = handler;
        }

        public HttpDownloadHandler() {
            try {
                this.handler = this.getHandler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getConnetionContentLenght() {
            return this.query != null && this.query.mHttp != null && this.query.mHttp.currentConnection != null ? this.query.mHttp.currentConnection.getContentLength() : 0;
        }

        public String getConnetionContentType() {
            return this.query != null && this.query.mHttp != null && this.query.mHttp.currentConnection != null ? this.query.mHttp.currentConnection.getContentType() : null;
        }

        public HttpAsyncQuery getAsyncQuery() {
            return this.query;
        }

        public HttpQuery<?> getQuery() {
            return this.getAsyncQuery().mHttp;
        }

        private Handler getHandler() {
            if (this.handler == null) {
                this.handler = new Handler(Looper.getMainLooper());
            }
            return this.handler;
        }

        void notifyProcessFail(final Exception e) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    HttpDownloadHandler.this.onFail(e);
                }
            });
            throw new RuntimeException(e);
        }

        protected boolean onFail(Exception e) {
            return !this.query.isCancelled() && !this.query.mHttp.isAborted();
        }

        Object buildResponseBody(HttpURLConnection connexion, InputStream stream) throws Exception {
            try {
                return this.onBuildResponseBody(connexion, stream);
            }
            catch (Exception e) {
                e.printStackTrace();
                Handler tmpHandler = this.getHandler();
                if (tmpHandler != null) {
                    this.notifyProcessFail(e);
                }
                throw new RuntimeException(e);
            }
        }

        public void publishProgression(final ProgressVar ... vars) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    HttpDownloadHandler.this.onProgress(HttpDownloadHandler.this.query, vars);
                }
            });
        }

        @Override
        public abstract void onProgress(HttpAsyncQuery var1, ProgressVar ... var2);
    }

    public static abstract class HttpUploadHandler<ProgressVar>
    implements UpLoadHandler,
    ProgressionListener<ProgressVar> {
        Handler handler;
        HttpAsyncQuery query;
        Runnable publishRunner = new Runnable(){

            @Override
            public void run() {
                HttpUploadHandler.this.onProgress(HttpUploadHandler.this.query, HttpUploadHandler.this.processVars);
            }
        };
        ProgressVar[] processVars;

        public HttpUploadHandler(Handler handler) {
            if (handler == null) {
                try {
                    this.handler = this.getHandler();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.handler = handler;
            }
        }

        public HttpUploadHandler() {
            this(null);
        }

        private Handler getHandler() {
            if (this.handler == null) {
                this.handler = new Handler(Looper.getMainLooper());
            }
            return this.handler;
        }

        void notifyProcessFail(Exception e) {
            if (this.onFail(e)) {
                throw new RuntimeException(e);
            }
        }

        protected boolean onFail(Exception e) {
            return !this.query.isCancelled() && !this.query.mHttp.isAborted();
        }

        public void publishProgression(ProgressVar ... vars) {
            Handler tmpHandler = this.getHandler();
            if (tmpHandler != null) {
                this.processVars = vars;
                tmpHandler.post(this.publishRunner);
            }
        }

        @Override
        public final void onUploadStream(OutputStream request, InputStream stream) throws IOException {
            block2: {
                try {
                    this.onProceedStreamUpload(request, stream, this.query);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Handler tmpHandler = this.getHandler();
                    if (tmpHandler == null) break block2;
                    this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            HttpUploadHandler.this.notifyProcessFail(e);
                        }
                    });
                }
            }
        }

        public abstract void onProceedStreamUpload(OutputStream var1, InputStream var2, HttpAsyncQuery var3) throws IOException;

        @Override
        public abstract void onProgress(HttpAsyncQuery var1, ProgressVar ... var2);
    }

    public static interface HttpQueryCallback {
        public void onHttpSuccess(HttpQueryResponse var1);

        public void onHttpError(HttpQueryResponse var1, HttpQueryError var2);

        public void onHttpFail(Exception var1);

        public void onHttComplete(HttpQueryResponse var1);

        public void onHttpAborted();
    }

    public static interface CancelListener {
        public void onCanceling(HttpAsyncQuery var1);

        public void onCancelled(HttpAsyncQuery var1);
    }

    public static class HttpQueryResponse {
        Object body;
        Exception error;
        HttpAsyncQuery mAsyncQ;
        int code = -1;
        String message;
        HttpURLConnection connexion;
        Map<String, List<String>> headers = new HashMap<String, List<String>>();

        static HttpQueryResponse getErrorInstance(Exception e, HttpAsyncQuery asycQ) {
            try {
                return new HttpQueryResponse(null, e, asycQ);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        HttpQueryResponse(InputStream stream, Exception e, HttpAsyncQuery asyncQ) throws HttpQuery.AbortionException {
            this.mAsyncQ = asyncQ;
            this.init(stream, e);
        }

        private void init(InputStream stream, Exception e) throws HttpQuery.AbortionException {
            HttpQuery<?> http = this.mAsyncQ.mHttp;
            this.connexion = http.getCurrentConnection();
            this.error = e;
            this.code = http.getCurrentResponseCode();
            this.message = http.getCurrentResponseMessage();
            if (this.connexion != null) {
                try {
                    this.body = null;
                    if (stream != null) {
                        this.body = this.mAsyncQ.downloadHandler.buildResponseBody(this.connexion, stream);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (ex instanceof IOException && this.mAsyncQ.isAborted()) {
                        throw new HttpQuery.AbortionException(this.mAsyncQ.mHttp, (Throwable)e);
                    }
                    this.code = 0;
                    this.error = ex;
                }
                this.headers = this.connexion.getHeaderFields();
            }
            if (e == null && !this.isSuccess() && !TextUtils.isEmpty((CharSequence)this.message) && this.code > 0) {
                this.error = new HttpQueryError(this.code, this.message, this.body);
            }
        }

        public boolean containHeader(String name) {
            return this.getHeaders() != null && this.getHeaders().containsKey(name);
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public String getHeader(String name) {
            if (this.connexion != null) {
                return this.connexion.getHeaderField(name);
            }
            return "";
        }

        public long getHeaderAsLong(String name) {
            return this.getHeaderAsLong(name, 0L);
        }

        public long getHeaderAsLong(String name, long deflt) {
            if (this.connexion != null) {
                return this.connexion.getHeaderFieldDate(name, deflt);
            }
            return deflt;
        }

        public int getHeaderAsInt(String name) {
            return this.getHeaderAsInt(name, 0);
        }

        public int getHeaderAsInt(String name, int deflt) {
            if (this.connexion != null) {
                return this.connexion.getHeaderFieldInt(name, deflt);
            }
            return deflt;
        }

        public boolean hasError() {
            return this.error != null || !HttpQueryResponse.isSuccessCode(this.code);
        }

        public boolean isSuccess() {
            return !this.hasError();
        }

        public boolean isAccepted() {
            return this.code > 0;
        }

        public <T> T getBody() {
            if (this.body == null) {
                return null;
            }
            try {
                return (T)this.body;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T getBodyAs(Class<T> cLass) {
            if (this.body == null) {
                return null;
            }
            try {
                return (T)this.body;
            }
            catch (Exception e) {
                return null;
            }
        }

        public <T> T optBody() {
            if (this.body == null) {
                return null;
            }
            try {
                return (T)this.body;
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getBodyAsString() {
            if (this.body == null) {
                return null;
            }
            return this.body.toString();
        }

        public Exception getError() {
            return this.error;
        }

        public static boolean isSuccessCode(int code) {
            return code > 0 && code >= 200 && code <= 299;
        }

        public static boolean isErrorCode(int code) {
            return !HttpQueryResponse.isSuccessCode(code);
        }

        public static boolean isClientErrorCode(int code) {
            return code > 0 && code >= 400 && code <= 499;
        }

        public static boolean isServerErrorCode(int code) {
            return code > 0 && code >= 500 && code <= 599;
        }
    }
}

