/*
 * Decompiled with CFR 0.152.
 */
package istat.android.network.utils;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.provider.Settings;
import android.util.Log;
import istat.android.network.http.HttpAsyncQuery;
import istat.android.network.http.HttpQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class ToolKits {
    public static final <T> HashMap<String, Object> toHashMap(T obj, boolean privateAndSuper, boolean acceptStatic, boolean nullable) {
        return ToolKits.toHashMap(obj, privateAndSuper, acceptStatic, nullable, new String[0]);
    }

    public static final <T> void filterPut(T obj, HashMap<Object, Object> map, String fieldName) {
        ToolKits.filterPut(obj, map, fieldName, false);
    }

    public static final <T> void filterPut(T obj, HashMap<Object, Object> map, String fieldName, boolean nullable) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(obj);
            if (nullable || value != null) {
                map.put(fieldName, value);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final <T> HashMap<String, Object> toHashMap(T obj, boolean privateAndSuper, boolean acceptStatic, boolean nullable, String ... ignores) {
        List<String> ignoreList = Arrays.asList(ignores);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> clazz = obj.getClass();
        if (privateAndSuper) {
            fields.addAll(ToolKits.getAllFieldIncludingPrivateAndSuper(clazz, acceptStatic));
        } else {
            Collections.addAll(fields, clazz.getDeclaredFields());
        }
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            String name = field.getName();
            if (ignoreList.contains(name)) continue;
            try {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (!nullable && value == null) continue;
                map.put(name, value);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static List<Field> getAllFieldIncludingPrivateAndSuper(Class<?> cLass, boolean acceptStatic) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!cLass.equals(Object.class)) {
            for (Field field : cLass.getDeclaredFields()) {
                if (field != null && field.toString().contains("static") && !acceptStatic) continue;
                fields.add(field);
            }
            cLass = cLass.getSuperclass();
        }
        return fields;
    }

    public static class Stream {
        public static final int DEFAULT_BUFFER_SIZE = 16384;
        public static final String DEFAULT_ENCODING = "UTF-8";

        public static String streamToLinearisedString(InputStream inp, String encoding) {
            String out = "";
            StringBuilder total = new StringBuilder();
            try {
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader(inp, encoding));
                while ((line = r.readLine()) != null) {
                    total.append(line);
                }
                out = total.toString();
                inp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return out;
        }

        public static String streamToString(InputStream inp) {
            String out = "";
            byte[] b = new byte[16384];
            int read = 0;
            try {
                while ((read = inp.read(b)) > -1) {
                    out = out + new String(b, 0, read);
                }
                inp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        public static String streamToString(InputStream inp, int buffer) {
            return Stream.streamToString(inp, buffer, null);
        }

        public static String streamToString(InputStream inp, String encoding) {
            return Stream.streamToString(inp, 16384, encoding);
        }

        public static String streamToString(InputStream inp, int buffer, String encoding) {
            String out = "";
            byte[] b = new byte[buffer];
            int read = 0;
            try {
                while ((read = inp.read(b)) > -1) {
                    out = out + (encoding != null ? new String(b, 0, read, encoding) : new String(b, 0, read));
                }
                inp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        public static String streamToString(InputStream inp, int buffer, String encoding, HttpAsyncQuery asyc) {
            String out = "";
            byte[] b = new byte[buffer];
            try {
                int read;
                while ((read = inp.read(b)) > -1) {
                    if (asyc.isPaused()) {
                        while (asyc.isPaused()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (!asyc.isRunning()) {
                        Log.i((String)"HttpQuery", (String)"streamToString::aborted");
                        break;
                    }
                    out = out + (encoding != null ? new String(b, 0, read, encoding) : new String(b, 0, read));
                }
                inp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        public static String streamToString(InputStream inp, int buffer, String encoding, HttpQuery<?> mHttp) {
            String out = "";
            byte[] b = new byte[buffer];
            int read = 0;
            try {
                while ((read = inp.read(b)) > -1) {
                    if (mHttp.isAborted()) {
                        Log.i((String)"HttpQuery", (String)"streamToString::aborted");
                        break;
                    }
                    out = out + (encoding != null ? new String(b, 0, read, encoding) : new String(b, 0, read));
                }
                inp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        public static OutputStream copyStream(InputStream is, OutputStream os) {
            return Stream.copyStream(is, os, 16384, 0);
        }

        public static OutputStream copyStream(byte[] prefix, byte[] suffix, InputStream is, OutputStream os) {
            return Stream.copyStream(prefix, suffix, is, os, 16384, 0);
        }

        public static OutputStream copyStream(InputStream is, OutputStream os, int buffer_size) {
            return Stream.copyStream(is, os, buffer_size, 0);
        }

        public static OutputStream copyStream(InputStream is, OutputStream os, int buffer_size, int startByte) {
            return Stream.copyStream(null, null, is, os, buffer_size, startByte);
        }

        public static OutputStream copyStream(byte[] prefix, byte[] suffix, InputStream is, OutputStream os, int buffer_size, int startByte) {
            try {
                int count;
                byte[] bytes = new byte[buffer_size];
                is.skip(startByte);
                if (prefix != null && prefix.length > 0) {
                    os.write(prefix);
                }
                while ((count = is.read(bytes, 0, buffer_size)) != -1) {
                    os.write(bytes, 0, count);
                }
                if (suffix != null && suffix.length > 0) {
                    os.write(suffix);
                }
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return os;
        }

        public static RandomAccessFile copyStream(byte[] prefix, byte[] suffix, InputStream is, RandomAccessFile os, int buffer_size, int startByte) {
            try {
                int count;
                byte[] bytes = new byte[buffer_size];
                is.skip(startByte);
                os.seek(startByte);
                if (prefix != null && prefix.length > 0) {
                    os.write(prefix);
                }
                while ((count = is.read(bytes, 0, buffer_size)) != -1) {
                    os.write(bytes, 0, count);
                }
                if (suffix != null && suffix.length > 0) {
                    os.write(suffix);
                }
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return os;
        }

        public static OutputStream[] breakStream(int buffer_size, int bundleSize, InputStream is, OutputStream ... os) {
            try {
                byte[] bytes = new byte[buffer_size];
                int indexCurrentOutput = 0;
                int bytesReadCurrentOutput = 0;
                while (true) {
                    int count = is.read(bytes, 0, buffer_size);
                    bytesReadCurrentOutput += count;
                    if (count == -1) break;
                    os[indexCurrentOutput].write(bytes, 0, count);
                    if (bytesReadCurrentOutput < bundleSize) continue;
                    ++indexCurrentOutput;
                    bytesReadCurrentOutput = 0;
                }
                os.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return os;
        }

        public static OutputStream[] dispatch(int buffer_size, InputStream is, OutputStream ... oss) throws IOException {
            int count;
            byte[] bytes = new byte[buffer_size];
            while ((count = is.read(bytes, 0, buffer_size)) != -1) {
                for (OutputStream os : oss) {
                    os.write(bytes, 0, count);
                }
            }
            return oss;
        }
    }

    public static class Network {
        public static boolean isNetworkConnected(Context context) {
            ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeNetwork = conMgr.getActiveNetworkInfo();
            return activeNetwork != null && activeNetwork.isConnected();
        }
    }

    public static class Software {
        public static void installApk(Context context, String apkFile) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.fromFile((File)new File(apkFile)), "application/vnd.android.package-archive");
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }

        public static Boolean isActivityRunning(Context context, Class<?> activityClass) {
            try {
                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                List tasks = activityManager.getRunningTasks(Integer.MAX_VALUE);
                for (ActivityManager.RunningTaskInfo task : tasks) {
                    if (!activityClass.getCanonicalName().equalsIgnoreCase(task.baseActivity.getClassName())) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public static Boolean isActivityTop(Context context, Class<?> activityClass) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (((ActivityManager.RunningTaskInfo)activityManager.getRunningTasks((int)1).get((int)0)).topActivity.getClassName().equals(activityClass.getCanonicalName())) {
                return true;
            }
            return false;
        }

        public static Boolean isProcessRunning(Context context, String processName) {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo process : manager.getRunningAppProcesses()) {
                if (!processName.equals(process.processName)) continue;
                return true;
            }
            return false;
        }

        public static boolean hasPermission(Context context, String permission) {
            int res = context.checkCallingOrSelfPermission(permission);
            return res == 0;
        }

        public static boolean isServiceRunning(Context context, Class<?> serviceClass) {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
                if (!serviceClass.getName().equals(service.service.getClassName())) continue;
                return true;
            }
            return false;
        }

        public static boolean isUnknowAppEnable(Context context) {
            try {
                return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"install_non_market_apps") == 1;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class Text {
        public static boolean isEmpty(String txt) {
            return txt == null || txt.equals("");
        }

        public static String urlEncode(String url) throws UnsupportedEncodingException {
            return URLEncoder.encode(url, "UTF-8").replace("+", "%20").replaceAll("%2F", "/");
        }
    }
}

