/*
 * Decompiled with CFR 0.152.
 */
package kt.mobius.runners;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kt.mobius.runners.ExecutorServiceWorkRunner;
import kt.mobius.runners.ImmediateWorkRunner;
import kt.mobius.runners.WorkRunner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0007\u00a8\u0006\r"}, d2={"Lkt/mobius/runners/WorkRunners;", "", "()V", "cachedThreadPool", "Lkt/mobius/runners/WorkRunner;", "fixedThreadPool", "n", "", "from", "service", "Ljava/util/concurrent/ExecutorService;", "immediate", "singleThread", "mobius-core"})
public final class WorkRunners {
    public static final WorkRunners INSTANCE;

    @JvmStatic
    @NotNull
    public static final WorkRunner immediate() {
        return new ImmediateWorkRunner();
    }

    @JvmStatic
    @NotNull
    public static final WorkRunner singleThread() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        return WorkRunners.from(executorService);
    }

    @JvmStatic
    @NotNull
    public static final WorkRunner fixedThreadPool(int n) {
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThreadPool(n)");
        return WorkRunners.from(executorService);
    }

    @JvmStatic
    @NotNull
    public static final WorkRunner cachedThreadPool() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThreadPool()");
        return WorkRunners.from(executorService);
    }

    @JvmStatic
    @NotNull
    public static final WorkRunner from(@NotNull ExecutorService service) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        return new ExecutorServiceWorkRunner(service);
    }

    private WorkRunners() {
    }

    static {
        WorkRunners workRunners;
        INSTANCE = workRunners = new WorkRunners();
    }
}

