/*
 * Decompiled with CFR 0.152.
 */
package kt.mobius.runners;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kt.mobius.runners.WorkRunner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\u00062\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkt/mobius/runners/ExecutorServiceWorkRunner;", "Lkt/mobius/runners/WorkRunner;", "service", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ExecutorService;)V", "dispose", "", "post", "runnable", "Ljava/lang/Runnable;", "Lkt/mobius/runners/Runnable;", "mobius-core"})
public final class ExecutorServiceWorkRunner
implements WorkRunner {
    private final ExecutorService service;

    @Override
    public void post(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        this.service.submit(runnable);
    }

    @Override
    public void dispose() {
        try {
            boolean bl;
            String string;
            List<Runnable> runnables = this.service.shutdownNow();
            if (!runnables.isEmpty()) {
                string = "Disposing ExecutorServiceWorkRunner with " + runnables.size() + " outstanding tasks.";
                bl = false;
                System.out.println((Object)string);
            }
            if (!this.service.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                string = "ExecutorService shutdown timed out; there are still tasks executing";
                bl = false;
                System.out.println((Object)string);
            }
        }
        catch (InterruptedException e) {
            String string = "Timeout when disposing work runner";
            boolean bl = false;
            System.out.println((Object)string);
            boolean bl2 = false;
            System.out.println(e);
        }
    }

    public ExecutorServiceWorkRunner(@NotNull ExecutorService service) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        this.service = service;
    }
}

